/*
 * Decompiled with CFR 0.152.
 */
package io.joern.fuzzyc2cpg.antlrparsers.moduleparser;

import io.joern.fuzzyc2cpg.ModuleParser;
import io.joern.fuzzyc2cpg.antlrparsers.moduleparser.ModuleParserTest;
import org.antlr.v4.runtime.Token;
import org.junit.Assert;
import org.junit.Test;

public class ModuleCommentTests
extends ModuleParserTest {
    private void assertTokenEqualsString(Token tok, String expected) {
        Assert.assertEquals((Object)expected, (Object)tok.getText());
    }

    @Test
    public void shouldParseSingleLineComments() {
        String input = "// This is a comment!";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), input);
    }

    @Test
    public void shouldParseSingleLineCommentInFunction() {
        String input = "static int altgid(void){\n// This is a comment!\nreturn 1;\n}";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "// This is a comment!\n");
    }

    @Test
    public void shouldParseSingleLineCommentWithEmojiInFunction() {
        String input = "static int altgid(void){\n// This is the peach emoji: \ud83c\udf51\nreturn 1;\n}";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "// This is the peach emoji: \ud83c\udf51\n");
    }

    @Test
    public void shouldParseSingleLineCommentInStruct() {
        String input = "struct foo {\nint x;\nint y; // This is a comment!\n};";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "// This is a comment!\n");
    }

    @Test
    public void shouldParseSingleLineCommentInline() {
        String input = "static int altgid(void){} // This is a comment!";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "// This is a comment!");
    }

    @Test
    public void shouldParseBlockComments() {
        String input = "/* This is a block comment! */";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is a block comment! */");
    }

    @Test
    public void shouldParseNestedBlockComments() {
        String input = "/* This is a /* nested */ block comment! */";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is a /* nested */ block comment! */");
    }

    @Test
    public void shouldParseBlockCommentsInFunction() {
        String input = "static int altgid(void){\n/* This is a block comment! */\nreturn 1;\n}";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is a block comment! */");
    }

    @Test
    public void shouldParseBlockCommentsInFunctionDefinition() {
        String input = "static /* A weird comment! */ int altgid(void){\nreturn 1;}";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* A weird comment! */");
    }

    @Test
    public void shouldParseBlockCommentsInStruct() {
        String input = "struct foo {\nint x\n;int y; /* This is a block comment! */\n};";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is a block comment! */");
    }

    @Test
    public void shouldParseBlockCommentsInStructDefinition() {
        String input = "struct /* A weird comment! */ foo {\nint x;\nint y;\n};";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* A weird comment! */");
    }

    @Test
    public void shouldParseMultilineBlockComments() {
        String input = "/*\n This is a block comment!\n*/\n";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), input.substring(0, input.length() - 1));
    }

    @Test
    public void shouldParseMultilineBlockCommentsInFunction() {
        String input = "static int altgid(void){\n/* This is\na block comment!\n*/\nreturn 1;\n}";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is\na block comment!\n*/");
    }

    @Test
    public void shouldParseMultilineBlockCommentsInFunctionDefinition() {
        String input = "static int \n/* This is\na block comment!\n*/\naltgid(void){\nreturn 1;\n}";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is\na block comment!\n*/");
    }

    @Test
    public void shouldParseMultilineBlockCommentsInStruct() {
        String input = "struct foo {\nint x;\n/* This is\na block comment!\n*/\nint y;\n};";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is\na block comment!\n*/");
    }

    @Test
    public void shouldParseMultilineBlockCommentsInStructDefinition() {
        String input = "struct/* This is\na block comment!\n*/\nfoo {\nint x;\nint y;\n};";
        ModuleParser parser = this.createHiddenParser(input);
        this.assertTokenEqualsString(parser.getCurrentToken(), "/* This is\na block comment!\n*/");
    }
}

