/*
 * Decompiled with CFR 0.152.
 */
package io.joern.fuzzyc2cpg.antlrparsers.functionparser;

import io.joern.fuzzyc2cpg.antlrparsers.functionparser.FunctionParserTestBase;
import io.joern.fuzzyc2cpg.passes.astcreation.AntlrParserDriver;
import org.antlr.v4.runtime.tree.ParseTree;
import org.junit.Assert;
import org.junit.Test;

public class AssignmentTests
extends FunctionParserTestBase {
    @Test
    public void testAssignmentExpr() {
        String input = "x = y + 1;";
        AntlrParserDriver functionParser = this.createFunctionDriver();
        ParseTree tree = functionParser.parseString(input);
        String output = tree.toStringTree(functionParser.getAntlrParser());
        Assert.assertTrue((boolean)output.contains("assign_expr"));
    }

    @Test
    public void testComplexAssignment() {
        String input = "k += ((c = text[k]) >= sBMHCharSetSize) ? patlen : skip[c];";
        AntlrParserDriver functionParser = this.createFunctionDriver();
        ParseTree tree = functionParser.parseString(input);
        String output = tree.toStringTree(functionParser.getAntlrParser());
        Assert.assertTrue((boolean)output.contains("assign_expr"));
    }

    @Test
    public void testPrivateInName() {
        String input = "struct acpi_battery *battery = m->private;";
        AntlrParserDriver functionParser = this.createFunctionDriver();
        ParseTree tree = functionParser.parseString(input);
        String output = tree.toStringTree(functionParser.getAntlrParser());
        Assert.assertTrue((boolean)output.contains("simple_decl"));
    }
}

