/*
 * Decompiled with CFR 0.152.
 */
package io.joern.fuzzyc2cpg.parsetreetoast;

import io.joern.fuzzyc2cpg.ModuleLexer;
import io.joern.fuzzyc2cpg.ast.AstNode;
import io.joern.fuzzyc2cpg.ast.declarations.ClassDefStatement;
import io.joern.fuzzyc2cpg.ast.declarations.IdentifierDecl;
import io.joern.fuzzyc2cpg.ast.functionDef.FunctionDefBase;
import io.joern.fuzzyc2cpg.ast.functionDef.ParameterBase;
import io.joern.fuzzyc2cpg.ast.functionDef.ParameterList;
import io.joern.fuzzyc2cpg.ast.functionDef.Template;
import io.joern.fuzzyc2cpg.ast.functionDef.TemplateParameterList;
import io.joern.fuzzyc2cpg.ast.langc.functiondef.FunctionDef;
import io.joern.fuzzyc2cpg.ast.langc.functiondef.Parameter;
import io.joern.fuzzyc2cpg.ast.langc.functiondef.ParameterType;
import io.joern.fuzzyc2cpg.ast.statements.IdentifierDeclStatement;
import io.joern.fuzzyc2cpg.parser.AntlrParserDriverObserver;
import io.joern.fuzzyc2cpg.parser.TokenSubStream;
import io.joern.fuzzyc2cpg.passes.astcreation.AntlrCModuleParserDriver;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.TokenSource;
import org.junit.Assert;
import org.junit.Test;
import tests.languages.c.parseTreeToAST.TestAntlrParserDriverObserver;

public class ModuleBuildersTest {
    @Test
    public void testNestedStructs() {
        String input = "struct x{ struct y { struct z{}; }; }; abc";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement classDef = (ClassDefStatement)codeItems.get(0);
        ClassDefStatement yClass = (ClassDefStatement)classDef.content.getStatements().get(0);
        ClassDefStatement zClass = (ClassDefStatement)yClass.content.getStatements().get(0);
        Assert.assertTrue((codeItems.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)yClass.getIdentifier().getEscapedCodeStr().equals("y"));
        Assert.assertTrue((boolean)zClass.getIdentifier().getEscapedCodeStr().equals("z"));
    }

    @Test
    public void testStructName() {
        String input = "struct foo{};";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement codeItem = (ClassDefStatement)codeItems.get(0);
        Assert.assertTrue((boolean)codeItem.identifier.getEscapedCodeStr().equals("foo"));
    }

    @Test
    public void testUnnamedStruct() {
        String input = "struct {int x; } a;";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement codeItem = (ClassDefStatement)codeItems.get(0);
        Assert.assertTrue((boolean)codeItem.identifier.getEscapedCodeStr().equals("<unnamed>"));
    }

    @Test
    public void testStructContent() {
        String input = "struct foo{};";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement codeItem = (ClassDefStatement)codeItems.get(0);
        Assert.assertTrue((codeItem.content != null ? 1 : 0) != 0);
    }

    @Test
    public void testStructFunctionPointer() {
        String input = "struct foo{ int*** (**bar)(long*); };";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement codeItem = (ClassDefStatement)codeItems.get(0);
        IdentifierDeclStatement ptrStatement = (IdentifierDeclStatement)codeItem.content.getStatements().get(0);
        IdentifierDecl ptrItem = (IdentifierDecl)ptrStatement.getIdentifierDeclList().get(0);
        Assert.assertEquals((Object)ptrItem.getType().completeType, (Object)"int * * * ( * * ) ( long * )");
    }

    @Test
    public void testFunctionInClass() {
        String input = "class foo{ bar(){} };";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement codeItem = (ClassDefStatement)codeItems.get(0);
        FunctionDefBase funcItem = (FunctionDefBase)codeItem.content.getStatements().get(0);
        Assert.assertTrue((boolean)funcItem.getName().equals("bar"));
    }

    @Test
    public void testDecl() {
        String input = "int foo;";
        List<AstNode> codeItems = this.parseInput(input);
        IdentifierDeclStatement codeItem = (IdentifierDeclStatement)codeItems.get(0);
        IdentifierDecl decl = (IdentifierDecl)codeItem.getIdentifierDeclList().get(0);
        Assert.assertTrue((boolean)decl.getName().getEscapedCodeStr().equals("foo"));
    }

    @Test
    public void testDeclListAfterClass() {
        String input = "class foo{int x;} y;";
        List<AstNode> codeItems = this.parseInput(input);
        IdentifierDeclStatement codeItem = (IdentifierDeclStatement)codeItems.get(codeItems.size() - 1);
        IdentifierDecl decl = (IdentifierDecl)codeItem.getIdentifierDeclList().get(0);
        Assert.assertTrue((boolean)decl.getName().getEscapedCodeStr().equals("y"));
    }

    @Test
    public void testClassDefBeforeContent() {
        String input = "class foo{int x;}";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement classCodeItem = (ClassDefStatement)codeItems.get(0);
        IdentifierDeclStatement identifierCodeItem = (IdentifierDeclStatement)classCodeItem.content.getStatements().get(0);
        IdentifierDecl decl = (IdentifierDecl)identifierCodeItem.getIdentifierDeclList().get(0);
        Assert.assertTrue((boolean)classCodeItem.identifier.getEscapedCodeStr().equals("foo"));
        Assert.assertTrue((boolean)decl.getName().getEscapedCodeStr().equals("x"));
    }

    @Test
    public void testFuncName() {
        String input = "void foo(){};";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        Assert.assertTrue((boolean)codeItem.getName().equals("foo"));
    }

    @Test
    public void testFuncSignature() {
        String input = "void foo(int x, char **ptr){};";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        Assert.assertTrue((boolean)codeItem.getEscapedCodeStr().equals("foo (int x,char **ptr)"));
    }

    @Test
    public void testSimpleParamList() {
        String input = "int foo(int x){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        Assert.assertTrue((codeItem.getChildCount() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testParamListGetCodeStr() {
        String input = "int foo(char *myParam, myType x){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        String codeStr = codeItem.getParameterList().getEscapedCodeStr();
        Assert.assertTrue((boolean)codeStr.equals("char *myParam,myType x"));
    }

    @Test
    public void testParamGetCodeStr() {
        String input = "int foo(char *myParam, myType x){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        ParameterBase parameter = codeItem.getParameterList().getParameter(0);
        String codeStr = parameter.getEscapedCodeStr();
        Assert.assertTrue((boolean)codeStr.equals("char *myParam"));
    }

    @Test
    public void testParamName() {
        String input = "int foo(myType myParam){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        String name = codeItem.getParameterList().getParameter(0).getName();
        Assert.assertTrue((boolean)name.equals("myParam"));
    }

    @Test
    public void testParamType() {
        String input = "int foo(char *myParam){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        ParameterType type = (ParameterType)codeItem.getParameterList().getParameter(0).getType();
        Assert.assertTrue((boolean)type.getEscapedCodeStr().equals("char *"));
    }

    @Test
    public void testFunctionPtrParam() {
        String input = "int foo(void (*ptr)(char *)){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        Assert.assertTrue((boolean)codeItem.getName().equals("foo"));
    }

    @Test
    public void testEmptyParamList() {
        String input = "int foo(){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        Assert.assertTrue((codeItem.getChildCount() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)codeItem.getParameterList().getEscapedCodeStr().equals(""));
    }

    @Test
    public void testEmptyParamListLocation() {
        String input = "int foo(){}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDefBase codeItem = (FunctionDefBase)codeItems.get(0);
        Assert.assertTrue((codeItem.getParameterList().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTemplateAssociationWithClass() {
        String input = "template <typename T> class Foo { T t; };";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement classDef = (ClassDefStatement)codeItems.get(0);
        TemplateParameterList templates = (TemplateParameterList)classDef.getChild(0);
        Assert.assertEquals((Object)"Foo", (Object)classDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)1L, (long)templates.getChildCount());
        Assert.assertEquals((long)1L, (long)templates.size());
        Template template = (Template)templates.getChild(0);
        Assert.assertEquals((long)1L, (long)template.getChildCount());
        Assert.assertEquals((Object)"T", (Object)template.getName());
    }

    @Test
    public void testTemplateTemplateAssociationWithClass() {
        String input = "template <template<typename> typename T, typename Z> class Foo { T<Z> t; };";
        List<AstNode> codeItems = this.parseInput(input);
        ClassDefStatement classDef = (ClassDefStatement)codeItems.get(0);
        TemplateParameterList templates = (TemplateParameterList)classDef.getChild(0);
        Assert.assertEquals((Object)"Foo", (Object)classDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)2L, (long)templates.size());
        Assert.assertEquals((long)2L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Template secondTemplate = (Template)templates.getChild(1);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((long)1L, (long)secondTemplate.getChildCount());
        Assert.assertEquals((Object)"T", (Object)firstTemplate.getName());
        Assert.assertEquals((Object)"Z", (Object)secondTemplate.getName());
    }

    @Test
    public void testTemplateAssociationWithFunction() {
        String input = "template <typename T, typename Z> T foo(T x) { }";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        TemplateParameterList templates = (TemplateParameterList)functionDef.getChild(1);
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)2L, (long)templates.size());
        Assert.assertEquals((long)2L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Template secondTemplate = (Template)templates.getChild(1);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((long)1L, (long)secondTemplate.getChildCount());
        Assert.assertEquals((Object)"T", (Object)firstTemplate.getName());
        Assert.assertEquals((Object)"Z", (Object)secondTemplate.getName());
    }

    @Test
    public void testTemplateTemplateAssociationWithFunction() {
        String input = "template <template<typename> typename T, typename Z> T<Z> foo(T<Z> x) { }";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        TemplateParameterList templates = (TemplateParameterList)functionDef.getChild(1);
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)2L, (long)templates.size());
        Assert.assertEquals((long)2L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Template secondTemplate = (Template)templates.getChild(1);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((long)1L, (long)secondTemplate.getChildCount());
        Assert.assertEquals((Object)"T", (Object)firstTemplate.getName());
        Assert.assertEquals((Object)"Z", (Object)secondTemplate.getName());
    }

    @Test
    public void testFunctionWithAnonParameter() {
        String input = "template <class C> C foo(C) {}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        ParameterList parameters = functionDef.getParameterList();
        TemplateParameterList templates = functionDef.getTemplateParameterList();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Parameter param = (Parameter)parameters.getChild(0);
        Assert.assertEquals((Object)"<anonymous>", (Object)param.getName());
        Assert.assertEquals((Object)"C", (Object)param.getType().getEscapedCodeStr());
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)1L, (long)templates.size());
        Assert.assertEquals((long)1L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((Object)"C", (Object)firstTemplate.getName());
    }

    @Test
    public void testFunctionWithAnonRefParameter() {
        String input = "template <class C> C foo(C&) {}";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        ParameterList parameters = functionDef.getParameterList();
        TemplateParameterList templates = functionDef.getTemplateParameterList();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Parameter param = (Parameter)parameters.getChild(0);
        Assert.assertEquals((Object)"<anonymous>", (Object)param.getName());
        Assert.assertEquals((Object)"C &", (Object)param.getType().getEscapedCodeStr());
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)1L, (long)templates.size());
        Assert.assertEquals((long)1L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((Object)"C", (Object)firstTemplate.getName());
    }

    @Test
    public void testFunctionDeclWithAnonParameter() {
        String input = "template <class C> C foo(C);";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        ParameterList parameters = functionDef.getParameterList();
        TemplateParameterList templates = functionDef.getTemplateParameterList();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Parameter param = (Parameter)parameters.getChild(0);
        Assert.assertEquals((Object)"<anonymous>", (Object)param.getName());
        Assert.assertEquals((Object)"C", (Object)param.getType().getEscapedCodeStr());
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)1L, (long)templates.size());
        Assert.assertEquals((long)1L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((Object)"C", (Object)firstTemplate.getName());
    }

    @Test
    public void testFunctionDeclWithAnonRefParameter() {
        String input = "template <class C> C foo(C&);";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        ParameterList parameters = functionDef.getParameterList();
        TemplateParameterList templates = functionDef.getTemplateParameterList();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Parameter param = (Parameter)parameters.getChild(0);
        Assert.assertEquals((Object)"<anonymous>", (Object)param.getName());
        Assert.assertEquals((Object)"C &", (Object)param.getType().getEscapedCodeStr());
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)1L, (long)templates.size());
        Assert.assertEquals((long)1L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((Object)"C", (Object)firstTemplate.getName());
    }

    @Test
    public void testTemplateAssociationWithFunctionDecl() {
        String input = "template <typename T, typename Z> T foo(T x);";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        ParameterList parameters = functionDef.getParameterList();
        TemplateParameterList templates = functionDef.getTemplateParameterList();
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)1L, (long)parameters.size());
        Parameter param = (Parameter)parameters.getChild(0);
        Assert.assertEquals((Object)"x", (Object)param.getName());
        Assert.assertEquals((Object)"T", (Object)param.getType().getEscapedCodeStr());
        Assert.assertEquals((long)2L, (long)templates.size());
        Assert.assertEquals((long)2L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Template secondTemplate = (Template)templates.getChild(1);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((long)1L, (long)secondTemplate.getChildCount());
        Assert.assertEquals((Object)"T", (Object)firstTemplate.getName());
        Assert.assertEquals((Object)"Z", (Object)secondTemplate.getName());
    }

    @Test
    public void testTemplateTemplateAssociationWithFunctionDecl() {
        String input = "template <template<typename> typename T, typename Z> T<Z> foo(T<Z> x);";
        List<AstNode> codeItems = this.parseInput(input);
        FunctionDef functionDef = (FunctionDef)codeItems.get(0);
        TemplateParameterList templates = (TemplateParameterList)functionDef.getChild(1);
        Assert.assertEquals((Object)"foo", (Object)functionDef.getIdentifier().getEscapedCodeStr());
        Assert.assertEquals((long)2L, (long)templates.size());
        Assert.assertEquals((long)2L, (long)templates.getChildCount());
        Template firstTemplate = (Template)templates.getChild(0);
        Template secondTemplate = (Template)templates.getChild(1);
        Assert.assertEquals((long)1L, (long)firstTemplate.getChildCount());
        Assert.assertEquals((long)1L, (long)secondTemplate.getChildCount());
        Assert.assertEquals((Object)"T", (Object)firstTemplate.getName());
        Assert.assertEquals((Object)"Z", (Object)secondTemplate.getName());
    }

    private List<AstNode> parseInput(String input) {
        AntlrCModuleParserDriver parser = new AntlrCModuleParserDriver();
        TestAntlrParserDriverObserver testProcessor = new TestAntlrParserDriverObserver();
        parser.addObserver((AntlrParserDriverObserver)testProcessor);
        CodePointCharStream inputStream = CharStreams.fromString((String)input);
        ModuleLexer lex = new ModuleLexer((CharStream)inputStream);
        TokenSubStream tokens = new TokenSubStream((TokenSource)lex);
        parser.parseAndWalkTokenStream(tokens);
        return testProcessor.codeItems;
    }
}

