/*
 * Decompiled with CFR 0.152.
 */
package io.joern.jssrc2cpg.utils;

import better.files.File$;
import io.joern.jssrc2cpg.Config;
import io.joern.jssrc2cpg.preprocessing.EjsPreprocessor;
import io.joern.jssrc2cpg.utils.AstGenRunner;
import io.joern.jssrc2cpg.utils.AstGenRunner$AstGenRunnerResult$;
import io.joern.jssrc2cpg.utils.Environment$;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.utils.ExternalCommand$;
import io.shiftleft.utils.IOUtils$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.Value$;

public final class AstGenRunner$ {
    public static final AstGenRunner$ MODULE$;
    private static final Logger io$joern$jssrc2cpg$utils$AstGenRunner$$logger;
    private static final int LINE_LENGTH_THRESHOLD;
    private static final List<String> TYPE_DEFINITION_FILE_EXTENSIONS;
    private static final Regex MINIFIED_PATH_REGEX;
    private static final Seq<Regex> IGNORED_TESTS_REGEX;
    private static final Seq<Regex> IGNORED_FILES_REGEX;
    private static final String EXECUTABLE_NAME;
    private static final String EXECUTABLE_DIR;
    private static volatile int bitmap$init$0;

    static {
        int indexOfTarget;
        MODULE$ = new AstGenRunner$();
        io$joern$jssrc2cpg$utils$AstGenRunner$$logger = LoggerFactory.getLogger(MODULE$.getClass());
        bitmap$init$0 |= 1;
        LINE_LENGTH_THRESHOLD = 10000;
        bitmap$init$0 |= 2;
        TYPE_DEFINITION_FILE_EXTENSIONS = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".t.ts.json", ".d.ts.json"}));
        bitmap$init$0 |= 4;
        MINIFIED_PATH_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*([.-]min\\..*js|bundle\\.js)"));
        bitmap$init$0 |= 8;
        IGNORED_TESTS_REGEX = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Regex[]{StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]spec\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]mock\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]e2e\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]test\\.js"))}));
        bitmap$init$0 |= 0x10;
        IGNORED_FILES_REGEX = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Regex[]{StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*jest\\.config.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*webpack\\..*\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*vue\\.config\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*babel\\.config\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*chunk-vendors.*\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*app~.*\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.chunk\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.babelrc.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.eslint.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.tslint.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.stylelintrc\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*rollup\\.config.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.types\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.cjs\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*eslint-local-rules\\.js"))}));
        bitmap$init$0 |= 0x20;
        EXECUTABLE_NAME = Environment$.MODULE$.IS_MAC() ? "astgen-macos" : (Environment$.MODULE$.IS_LINUX() ? "astgen-linux" : "astgen-win.exe");
        bitmap$init$0 |= 0x40;
        String dir = MODULE$.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        int indexOfLib = dir.lastIndexOf("lib");
        String fixedDir = indexOfLib != -1 ? new File(dir.substring("file:".length(), indexOfLib)).toString() : ((indexOfTarget = dir.lastIndexOf("target")) != -1 ? new File(dir.substring("file:".length(), indexOfTarget)).toString() : ".");
        EXECUTABLE_DIR = ((Object)Paths.get(fixedDir, "/bin/astgen").toAbsolutePath()).toString();
        bitmap$init$0 |= 0x80;
    }

    public Logger io$joern$jssrc2cpg$utils$AstGenRunner$$logger() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 19");
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$logger;
    }

    private int LINE_LENGTH_THRESHOLD() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 21");
        }
        return LINE_LENGTH_THRESHOLD;
    }

    private List<String> TYPE_DEFINITION_FILE_EXTENSIONS() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 23");
        }
        return TYPE_DEFINITION_FILE_EXTENSIONS;
    }

    private Regex MINIFIED_PATH_REGEX() {
        if ((bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 25");
        }
        return MINIFIED_PATH_REGEX;
    }

    private Seq<Regex> IGNORED_TESTS_REGEX() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 27");
        }
        return IGNORED_TESTS_REGEX;
    }

    private Seq<Regex> IGNORED_FILES_REGEX() {
        if ((bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 30");
        }
        return IGNORED_FILES_REGEX;
    }

    private String EXECUTABLE_NAME() {
        if ((bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 48");
        }
        return EXECUTABLE_NAME;
    }

    private String EXECUTABLE_DIR() {
        if ((bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 56");
        }
        return EXECUTABLE_DIR;
    }

    private List<String> skippedFiles(better.files.File in, List<String> astgenOut) {
        List skipped = astgenOut.collect((PartialFunction)new Serializable(in){
            private static final long serialVersionUID = 0L;
            private final better.files.File in$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                None$ none$;
                A1 A1 = x1;
                switch (A1 == null ? 0 : A1.hashCode()) {
                    default: 
                }
                if (!A1.startsWith("Converted")) {
                    String filename = A1.substring(0, A1.indexOf(" "));
                    String reason = A1.substring(A1.indexOf(" ") + 1);
                    AstGenRunner$.MODULE$.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().warn(new StringBuilder(25).append("\t- failed to parse '").append(this.in$1.$div(filename)).append("': '").append(reason).append("'").toString());
                    none$ = new Some((Object)filename);
                } else {
                    AstGenRunner$.MODULE$.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().debug(new StringBuilder(3).append("\t+ ").append(A1).toString());
                    none$ = None$.MODULE$;
                }
                None$ none$2 = none$;
                return (B1)none$2;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                boolean bl = !string.startsWith("Converted") ? true : true;
                return bl;
            }
            {
                this.in$1 = in$1;
            }
        });
        return (List)skipped.flatten(Predef$.MODULE$.$conforms());
    }

    private boolean ignoredByUserConfig(String filePath, Config config, better.files.File out) {
        boolean bl;
        LazyBoolean isInIgnoredFiles$lzy = new LazyBoolean();
        LazyBoolean isInIgnoredFileRegex$lzy = new LazyBoolean();
        String resolvedFilePath = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(filePath), ".json").replace(out.pathAsString(), config.inputPath());
        if (AstGenRunner$.isInIgnoredFiles$1(isInIgnoredFiles$lzy, config, resolvedFilePath) || AstGenRunner$.isInIgnoredFileRegex$1(isInIgnoredFileRegex$lzy, config, resolvedFilePath)) {
            this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().debug(new StringBuilder(32).append("'").append(resolvedFilePath).append("' ignored by user configuration").toString());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isMinifiedFile(String filePath) {
        boolean bl;
        String string = filePath;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (this.MINIFIED_PATH_REGEX().matches((CharSequence)string)) {
            bl = true;
        } else {
            Seq x$12;
            better.files.File qual$1 = File$.MODULE$.apply(string, (Seq)Nil$.MODULE$);
            if (qual$1.exists(x$12 = qual$1.exists$default$1()) && string.endsWith(".js")) {
                int longestLineLength;
                Seq lines = IOUtils$.MODULE$.readLinesInFile(File$.MODULE$.apply(filePath, (Seq)Nil$.MODULE$).path());
                int linesOfCode = lines.size();
                int n = longestLineLength = lines.isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)((IterableOnceOps)lines.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.length()))).max((Ordering)Ordering.Int$.MODULE$));
                if (longestLineLength >= this.LINE_LENGTH_THRESHOLD() && linesOfCode <= 50) {
                    this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().debug(new StringBuilder(61).append("'").append(filePath).append("' seems to be a minified file (contains a line with length ").append(longestLineLength).append(")").toString());
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    private boolean ignoredByDefault(String filePath, Config config, better.files.File out) {
        boolean bl;
        LazyBoolean isIgnored$lzy = new LazyBoolean();
        LazyBoolean isIgnoredTest$lzy = new LazyBoolean();
        LazyBoolean isMinified$lzy = new LazyBoolean();
        String resolvedFilePath = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(filePath), ".json").replace(out.pathAsString(), config.inputPath());
        if (this.isIgnored$1(isIgnored$lzy, resolvedFilePath) || this.isIgnoredTest$1(isIgnoredTest$lzy, resolvedFilePath) || this.isMinified$1(isMinified$lzy, resolvedFilePath)) {
            this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().debug(new StringBuilder(21).append("'").append(resolvedFilePath).append("' ignored by default").toString());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private List<String> filterFiles(List<String> files, Config config, better.files.File out) {
        return files.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AstGenRunner$.$anonfun$filterFiles$1(config, out, x0$1)));
    }

    private Try<Seq<String>> processEjsFiles(better.files.File in, better.files.File out, List<String> ejsFiles) {
        List tmpJsFiles = ejsFiles.map((Function1 & Serializable)ejsFilePath -> {
            better.files.File ejsFile = File$.MODULE$.apply(ejsFilePath, (Seq)Nil$.MODULE$);
            String ls = SourceFiles$.MODULE$.retrieveLineSeparator(ejsFilePath);
            String sourceFileContent = IOUtils$.MODULE$.readLinesInFile(ejsFile.path()).mkString("", ls, ls);
            String preprocessContent = new EjsPreprocessor().preprocess(sourceFileContent);
            better.files.File qual$1 = out.$div(((Object)in.relativize(ejsFile)).toString()).parent();
            boolean x$1 = true;
            Seq x$2 = qual$1.createDirectoryIfNotExists$default$2(true);
            Seq x$3 = qual$1.createDirectoryIfNotExists$default$3(true);
            qual$1.createDirectoryIfNotExists(true, x$2, x$3);
            better.files.File x$4 = out.$div(((Object)in.relativize(ejsFile)).toString());
            boolean x$5 = ejsFile.copyTo$default$2();
            Seq x$6 = ejsFile.copyTo$default$3(x$4, x$5);
            better.files.File newEjsFile = ejsFile.copyTo(x$4, x$5, x$6);
            better.files.File qual$2 = newEjsFile.changeExtensionTo(".js");
            String x$7 = preprocessContent;
            Seq x$8 = qual$2.writeText$default$2(x$7);
            Charset x$9 = qual$2.writeText$default$3(x$7);
            better.files.File jsFile = qual$2.writeText(x$7, x$8, x$9);
            better.files.File qual$3 = newEjsFile.createFile(newEjsFile.createFile$default$1());
            String x$10 = sourceFileContent;
            Seq x$11 = qual$3.writeText$default$2(x$10);
            Charset x$12 = qual$3.writeText$default$3(x$10);
            qual$3.writeText(x$10, x$11, x$12);
            return jsFile;
        });
        Try result = ExternalCommand$.MODULE$.run(new StringBuilder(11).append(this.EXECUTABLE_DIR()).append("/").append(this.EXECUTABLE_NAME()).append(" -t ts -o ").append(out).toString(), out.toString(), ExternalCommand$.MODULE$.run$default$3());
        List jsons = SourceFiles$.MODULE$.determine(out.toString(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"})));
        jsons.foreach((Function1 & Serializable)jsonPath -> {
            better.files.File jsonFile = File$.MODULE$.apply(jsonPath, (Seq)Nil$.MODULE$);
            String jsonContent = IOUtils$.MODULE$.readLinesInFile(jsonFile.path()).mkString();
            Value json = ujson.package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(jsonContent), ujson.package$.MODULE$.read$default$2());
            String fileName = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector("relativeName")).str();
            String newFileName = fileName.replace(".js", ".ejs");
            json.update((Value.Selector)Value.Selector$.MODULE$.StringSelector("relativeName"), (Value)Value$.MODULE$.JsonableString((CharSequence)newFileName));
            String x$13 = json.toString();
            Seq x$14 = jsonFile.writeText$default$2(x$13);
            Charset x$15 = jsonFile.writeText$default$3(x$13);
            return jsonFile.writeText(x$13, x$14, x$15);
        });
        tmpJsFiles.foreach((Function1 & Serializable)x$4 -> x$4.delete(x$4.delete$default$1(), x$4.delete$default$2()));
        return result;
    }

    private Try<Seq<String>> ejsFiles(better.files.File in, better.files.File out) {
        List files = SourceFiles$.MODULE$.determine(in.pathAsString(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".ejs"})));
        return files.nonEmpty() ? this.processEjsFiles(in, out, (List<String>)files) : new Success((Object)package$.MODULE$.Seq().empty());
    }

    private Try<Seq<String>> vueFiles(better.files.File in, better.files.File out) {
        List files = SourceFiles$.MODULE$.determine(in.pathAsString(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".vue"})));
        return files.nonEmpty() ? ExternalCommand$.MODULE$.run(new StringBuilder(12).append(this.EXECUTABLE_DIR()).append("/").append(this.EXECUTABLE_NAME()).append(" -t vue -o ").append(out).toString(), in.toString(), ExternalCommand$.MODULE$.run$default$3()) : new Success((Object)package$.MODULE$.Seq().empty());
    }

    private Try<Seq<String>> jsFiles(better.files.File in, better.files.File out) {
        return ExternalCommand$.MODULE$.run(new StringBuilder(11).append(this.EXECUTABLE_DIR()).append("/").append(this.EXECUTABLE_NAME()).append(" -t ts -o ").append(out).toString(), in.toString(), ExternalCommand$.MODULE$.run$default$3());
    }

    private Try<Seq<String>> runAstGenNative(better.files.File in, better.files.File out) {
        return this.ejsFiles(in, out).flatMap((Function1 & Serializable)ejsResult -> MODULE$.vueFiles(in, out).flatMap((Function1 & Serializable)vueResult -> MODULE$.jsFiles(in, out).map((Function1 & Serializable)jsResult -> (Seq)((IterableOps)jsResult.$plus$plus((IterableOnce)vueResult)).$plus$plus((IterableOnce)ejsResult))));
    }

    public AstGenRunner.AstGenRunnerResult execute(Config config, better.files.File out) {
        AstGenRunner.AstGenRunnerResult astGenRunnerResult;
        better.files.File in = File$.MODULE$.apply(config.inputPath(), (Seq)Nil$.MODULE$);
        this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().debug(new StringBuilder(27).append("\t+ Running astgen in '").append(in).append("' ...").toString());
        Try<Seq<String>> try_ = this.runAstGenNative(in, out);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq result = (Seq)success.value();
            List<String> parsed = this.filterFiles((List<String>)SourceFiles$.MODULE$.determine(out.toString(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}))), config, out);
            List<String> skipped = this.skippedFiles(in, (List<String>)result.toList());
            astGenRunnerResult = new AstGenRunner.AstGenRunnerResult((List<Tuple2<String, String>>)parsed.map((Function1 & Serializable)x$5 -> new Tuple2((Object)in.toString(), x$5)), (List<Tuple2<String, String>>)skipped.map((Function1 & Serializable)x$6 -> new Tuple2((Object)in.toString(), x$6)));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable f = failure.exception();
            this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().error("\t- running astgen failed!", f);
            astGenRunnerResult = new AstGenRunner.AstGenRunnerResult(AstGenRunner$AstGenRunnerResult$.MODULE$.apply$default$1(), AstGenRunner$AstGenRunnerResult$.MODULE$.apply$default$2());
        } else {
            throw new MatchError(try_);
        }
        return astGenRunnerResult;
    }

    public static final /* synthetic */ boolean $anonfun$ignoredByUserConfig$1(String resolvedFilePath$1, String x0$1) {
        boolean bl;
        String string = x0$1;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        better.files.File qual$1 = File$.MODULE$.apply(string, (Seq)Nil$.MODULE$);
        Seq x$1 = qual$1.isDirectory$default$1();
        if (qual$1.isDirectory(x$1)) {
            bl = resolvedFilePath$1.startsWith(string);
        } else {
            String string2 = resolvedFilePath$1;
            String string3 = string;
            bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    private static final /* synthetic */ boolean isInIgnoredFiles$lzycompute$1(LazyBoolean isInIgnoredFiles$lzy$1, Config config$1, String resolvedFilePath$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFiles$lzy$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFiles$lzy$1.initialized() ? isInIgnoredFiles$lzy$1.value() : isInIgnoredFiles$lzy$1.initialize(config$1.ignoredFiles().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AstGenRunner$.$anonfun$ignoredByUserConfig$1(resolvedFilePath$1, x0$1))));
        }
        return bl;
    }

    private static final boolean isInIgnoredFiles$1(LazyBoolean isInIgnoredFiles$lzy$1, Config config$1, String resolvedFilePath$1) {
        return isInIgnoredFiles$lzy$1.initialized() ? isInIgnoredFiles$lzy$1.value() : AstGenRunner$.isInIgnoredFiles$lzycompute$1(isInIgnoredFiles$lzy$1, config$1, resolvedFilePath$1);
    }

    private static final /* synthetic */ boolean isInIgnoredFileRegex$lzycompute$1(LazyBoolean isInIgnoredFileRegex$lzy$1, Config config$1, String resolvedFilePath$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFileRegex$lzy$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFileRegex$lzy$1.initialized() ? isInIgnoredFileRegex$lzy$1.value() : isInIgnoredFileRegex$lzy$1.initialize(config$1.ignoredFilesRegex().matches((CharSequence)resolvedFilePath$1));
        }
        return bl;
    }

    private static final boolean isInIgnoredFileRegex$1(LazyBoolean isInIgnoredFileRegex$lzy$1, Config config$1, String resolvedFilePath$1) {
        return isInIgnoredFileRegex$lzy$1.initialized() ? isInIgnoredFileRegex$lzy$1.value() : AstGenRunner$.isInIgnoredFileRegex$lzycompute$1(isInIgnoredFileRegex$lzy$1, config$1, resolvedFilePath$1);
    }

    private final /* synthetic */ boolean isIgnored$lzycompute$1(LazyBoolean isIgnored$lzy$1, String resolvedFilePath$2) {
        boolean bl;
        LazyBoolean lazyBoolean = isIgnored$lzy$1;
        synchronized (lazyBoolean) {
            bl = isIgnored$lzy$1.initialized() ? isIgnored$lzy$1.value() : isIgnored$lzy$1.initialize(this.IGNORED_FILES_REGEX().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.matches((CharSequence)resolvedFilePath$2))));
        }
        return bl;
    }

    private final boolean isIgnored$1(LazyBoolean isIgnored$lzy$1, String resolvedFilePath$2) {
        return isIgnored$lzy$1.initialized() ? isIgnored$lzy$1.value() : this.isIgnored$lzycompute$1(isIgnored$lzy$1, resolvedFilePath$2);
    }

    private final /* synthetic */ boolean isIgnoredTest$lzycompute$1(LazyBoolean isIgnoredTest$lzy$1, String resolvedFilePath$2) {
        boolean bl;
        LazyBoolean lazyBoolean = isIgnoredTest$lzy$1;
        synchronized (lazyBoolean) {
            bl = isIgnoredTest$lzy$1.initialized() ? isIgnoredTest$lzy$1.value() : isIgnoredTest$lzy$1.initialize(this.IGNORED_TESTS_REGEX().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.matches((CharSequence)resolvedFilePath$2))));
        }
        return bl;
    }

    private final boolean isIgnoredTest$1(LazyBoolean isIgnoredTest$lzy$1, String resolvedFilePath$2) {
        return isIgnoredTest$lzy$1.initialized() ? isIgnoredTest$lzy$1.value() : this.isIgnoredTest$lzycompute$1(isIgnoredTest$lzy$1, resolvedFilePath$2);
    }

    private final /* synthetic */ boolean isMinified$lzycompute$1(LazyBoolean isMinified$lzy$1, String resolvedFilePath$2) {
        boolean bl;
        LazyBoolean lazyBoolean = isMinified$lzy$1;
        synchronized (lazyBoolean) {
            bl = isMinified$lzy$1.initialized() ? isMinified$lzy$1.value() : isMinified$lzy$1.initialize(this.isMinifiedFile(resolvedFilePath$2));
        }
        return bl;
    }

    private final boolean isMinified$1(LazyBoolean isMinified$lzy$1, String resolvedFilePath$2) {
        return isMinified$lzy$1.initialized() ? isMinified$lzy$1.value() : this.isMinified$lzycompute$1(isMinified$lzy$1, resolvedFilePath$2);
    }

    public static final /* synthetic */ boolean $anonfun$filterFiles$1(Config config$2, better.files.File out$1, String x0$1) {
        String string = x0$1;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        boolean bl = MODULE$.TYPE_DEFINITION_FILE_EXTENSIONS().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.endsWith(x$1))) ? false : (MODULE$.ignoredByUserConfig(string, config$2, out$1) ? false : !MODULE$.ignoredByDefault(string, config$2, out$1));
        return bl;
    }

    private AstGenRunner$() {
    }
}

