/*
 * Decompiled with CFR 0.152.
 */
package io.joern.jssrc2cpg.utils;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.joern.jssrc2cpg.utils.Environment$;
import io.joern.jssrc2cpg.utils.Environment$ArchitectureType$;
import io.joern.jssrc2cpg.utils.Environment$OperatingSystemType$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.matching.Regex;
import versionsort.VersionHelper;

public final class AstGenRunner$ {
    public static final AstGenRunner$ MODULE$ = new AstGenRunner$();
    private static String executableName;
    private static String executableDir;
    private static String io$joern$jssrc2cpg$utils$AstGenRunner$$astGenCommand;
    private static final Logger io$joern$jssrc2cpg$utils$AstGenRunner$$logger;
    private static final int io$joern$jssrc2cpg$utils$AstGenRunner$$LineLengthThreshold;
    private static final List<String> io$joern$jssrc2cpg$utils$AstGenRunner$$TypeDefinitionFileExtensions;
    private static final Regex io$joern$jssrc2cpg$utils$AstGenRunner$$MinifiedPathRegex;
    private static final Seq<Regex> io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredTestsRegex;
    private static final Seq<Regex> io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredFilesRegex;
    private static volatile byte bitmap$0;
    private static volatile byte bitmap$init$0;

    static {
        io$joern$jssrc2cpg$utils$AstGenRunner$$logger = LoggerFactory.getLogger(MODULE$.getClass());
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        io$joern$jssrc2cpg$utils$AstGenRunner$$LineLengthThreshold = 10000;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        io$joern$jssrc2cpg$utils$AstGenRunner$$TypeDefinitionFileExtensions = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".t.ts", ".d.ts"}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        io$joern$jssrc2cpg$utils$AstGenRunner$$MinifiedPathRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*([.-]min\\..*js|bundle\\.js)"));
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredTestsRegex = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Regex[]{StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]spec\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]mock\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]e2e\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*[.-]test\\.js"))}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredFilesRegex = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Regex[]{StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*jest\\.config.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*webpack\\..*\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*vue\\.config\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*babel\\.config\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*chunk-vendors.*\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*app~.*\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.chunk\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.babelrc.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.eslint.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.tslint.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.stylelintrc\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*rollup\\.config.*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.types\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.cjs\\.js")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*eslint-local-rules\\.js"))}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public Logger io$joern$jssrc2cpg$utils$AstGenRunner$$logger() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 22");
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$logger;
    }

    public int io$joern$jssrc2cpg$utils$AstGenRunner$$LineLengthThreshold() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 24");
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$LineLengthThreshold;
    }

    public List<String> io$joern$jssrc2cpg$utils$AstGenRunner$$TypeDefinitionFileExtensions() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 26");
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$TypeDefinitionFileExtensions;
    }

    public Regex io$joern$jssrc2cpg$utils$AstGenRunner$$MinifiedPathRegex() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 28");
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$MinifiedPathRegex;
    }

    public Seq<Regex> io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredTestsRegex() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 30");
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredTestsRegex;
    }

    public Seq<Regex> io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredFilesRegex() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/jssrc2cpg/src/main/scala/io/joern/jssrc2cpg/utils/AstGenRunner.scala: 33");
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$IgnoredFilesRegex;
    }

    private String executableName$lzycompute() {
        AstGenRunner$ astGenRunner$ = this;
        synchronized (astGenRunner$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                String string;
                Enumeration.Value value = Environment$.MODULE$.operatingSystem();
                Enumeration.Value value2 = Environment$OperatingSystemType$.MODULE$.Windows();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    string = "astgen-win.exe";
                } else {
                    Enumeration.Value value4 = Environment$OperatingSystemType$.MODULE$.Linux();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        string = "astgen-linux";
                    } else {
                        Enumeration.Value value6 = Environment$OperatingSystemType$.MODULE$.Mac();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            String string2;
                            Enumeration.Value value8 = Environment$.MODULE$.architecture();
                            Enumeration.Value value9 = Environment$ArchitectureType$.MODULE$.X86();
                            Enumeration.Value value10 = value8;
                            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                                string2 = "astgen-macos";
                            } else {
                                Enumeration.Value value11 = Environment$ArchitectureType$.MODULE$.ARM();
                                Enumeration.Value value12 = value8;
                                if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                                    string2 = "astgen-macos-arm";
                                } else {
                                    throw new MatchError((Object)value8);
                                }
                            }
                            string = string2;
                        } else {
                            Enumeration.Value value13 = Environment$OperatingSystemType$.MODULE$.Unknown();
                            Enumeration.Value value14 = value;
                            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                                this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().warn("Could not detect OS version! Defaulting to 'Linux'.");
                                string = "astgen-linux";
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
                executableName = string;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return executableName;
    }

    private String executableName() {
        return (byte)(bitmap$0 & 1) == 0 ? this.executableName$lzycompute() : executableName;
    }

    private String executableDir$lzycompute() {
        AstGenRunner$ astGenRunner$ = this;
        synchronized (astGenRunner$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                int indexOfTarget;
                String dir = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
                int indexOfLib = dir.lastIndexOf("lib");
                String fixedDir = indexOfLib != -1 ? new File(dir.substring("file:".length(), indexOfLib)).toString() : ((indexOfTarget = dir.lastIndexOf("target")) != -1 ? new File(dir.substring("file:".length(), indexOfTarget)).toString() : ".");
                executableDir = ((Object)Paths.get(fixedDir, "/bin/astgen").toAbsolutePath()).toString();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return executableDir;
    }

    private String executableDir() {
        return (byte)(bitmap$0 & 2) == 0 ? this.executableDir$lzycompute() : executableDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasCompatibleAstGenVersion(String astGenVersion) {
        boolean bl = false;
        Some some = null;
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> scala.sys.process.package$.MODULE$.stringToProcess("astgen --version").$bang$bang()).toOption().map((Function1 & Serializable)x$1 -> x$1.strip());
        if (option instanceof Some) {
            String installedVersion;
            bl = true;
            some = (Some)option;
            String string = installedVersion = (String)some.value();
            String string2 = "unknown";
            if ((string == null ? string2 != null : !string.equals(string2)) && VersionHelper.compare((String)installedVersion, (String)astGenVersion) >= 0) {
                this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().debug(new StringBuilder(38).append("Using local astgen v").append(installedVersion).append(" from systems PATH").toString());
                return true;
            }
        }
        if (!bl) return false;
        String installedVersion = (String)some.value();
        this.io$joern$jssrc2cpg$utils$AstGenRunner$$logger().debug(new StringBuilder(70).append("Found local astgen v").append(installedVersion).append(" in systems PATH but jssrc2cpg requires at least v").append(astGenVersion).toString());
        return false;
    }

    private String astGenCommand$lzycompute() {
        AstGenRunner$ astGenRunner$ = this;
        synchronized (astGenRunner$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                Config conf = ConfigFactory.load();
                String astGenVersion = conf.getString("jssrc2cpg.astgen_version");
                io$joern$jssrc2cpg$utils$AstGenRunner$$astGenCommand = this.hasCompatibleAstGenVersion(astGenVersion) ? "astgen" : new StringBuilder(1).append(this.executableDir()).append("/").append(this.executableName()).toString();
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return io$joern$jssrc2cpg$utils$AstGenRunner$$astGenCommand;
    }

    public String io$joern$jssrc2cpg$utils$AstGenRunner$$astGenCommand() {
        return (byte)(bitmap$0 & 4) == 0 ? this.astGenCommand$lzycompute() : io$joern$jssrc2cpg$utils$AstGenRunner$$astGenCommand;
    }

    private AstGenRunner$() {
    }
}

