/*
 * Decompiled with CFR 0.152.
 */
package io.joern.scanners.android;

import io.joern.console.CodeSnippet;
import io.joern.console.Query;
import io.joern.kotlin2cpg.testfixtures.KotlinTestCpg;
import io.joern.scanners.android.Misconfigurations$;
import io.joern.suites.AndroidQueryTestSuite;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i1AAA\u0002\u0001\u0019!)q\u0003\u0001C\u00011\t1R*[:d_:4\u0017nZ;sCRLwN\\:UKN$8O\u0003\u0002\u0005\u000b\u00059\u0011M\u001c3s_&$'B\u0001\u0004\b\u0003!\u00198-\u00198oKJ\u001c(B\u0001\u0005\n\u0003\u0015Qw.\u001a:o\u0015\u0005Q\u0011AA5p\u0007\u0001\u0019\"\u0001A\u0007\u0011\u00079\t2#D\u0001\u0010\u0015\t\u0001r!\u0001\u0004tk&$Xm]\u0005\u0003%=\u0011Q#\u00118ee>LG-U;fef$Vm\u001d;Tk&$XM\u0004\u0002\u0015+5\t1!\u0003\u0002\u0017\u0007\u0005\tR*[:d_:4\u0017nZ;sCRLwN\\:\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000b\u0001\u0001")
public class MisconfigurationsTests
extends AndroidQueryTestSuite<Misconfigurations$> {
    public MisconfigurationsTests() {
        super(Misconfigurations$.MODULE$);
        this.convertToWordSpecStringWrapper("the `manifestXmlBackupEnabled` query").when((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.convertToWordSpecStringWrapper("should match a config file when `allowBackup` is set to `true`").in((Function0 & Serializable)() -> {
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeAndroidXml(true), "AndroidManifest.xml");
                Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 13), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AndroidManifest.xml"})));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 9));
            this.convertToWordSpecStringWrapper("should not match a config file when `allowBackup` is set to `false`").in((Function0 & Serializable)() -> {
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeAndroidXml(false), "AndroidManifest.xml");
                Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 20), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 16));
            this.convertToWordSpecStringWrapper("should not match anything when there is no file named `AndroidManifest.xml` in the cpg").in((Function0 & Serializable)() -> {
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeAndroidXml(false), "NOPNOPNOPNOPNOPNOP.xml");
                Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 23));
            this.convertToWordSpecStringWrapper("should not match anything when the file named `AndroidManifest.xml` is empty").in((Function0 & Serializable)() -> {
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode("", "AndroidManifest.xml");
                Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
            this.convertToWordSpecStringWrapper("should not match anything when the file named `AndroidManifest.xml` contains invalid XML").in((Function0 & Serializable)() -> {
                String invalidXml = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |<?xml version=\"1.0\"?>\n          |<!DOCTYPE lolz [\n          | <!ENTITY lol \"lol\">\n          | <!ELEMENT lolz (#PCDATA)>\n          | <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n          | <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\n          | <UNFINISHED_BILLION_LAUGHS\n          |<lolz>&lol2;</lolz>\n          |"));
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(invalidXml, "AndroidManifest.xml");
                Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 7));
        this.convertToWordSpecStringWrapper("the `tapJacking` query").when((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.convertToWordSpecStringWrapper("should match on all multi-file positive examples").in((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Query q = ((Misconfigurations$)this.queryBundle()).tapJacking();
                q.multiFileCodeExamples().positive().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).foreach((Function1 & Serializable)codeExample -> {
                    CodeSnippet first = (CodeSnippet)codeExample.head();
                    KotlinTestCpg cpg = (KotlinTestCpg)this.code(first.content(), first.filename());
                    KotlinTestCpg finalCpg = (KotlinTestCpg)codeExample.drop(1).foldLeft((Object)cpg, (Function2 & Serializable)(foldCpg, example) -> (KotlinTestCpg)foldCpg.moreCode(example.content(), example.filename()));
                    return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)finalCpg, q), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})));
                });
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            this.convertToWordSpecStringWrapper("should not on all multi-file negative examples").in((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Query q = ((Misconfigurations$)this.queryBundle()).tapJacking();
                q.multiFileCodeExamples().negative().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty())).foreach((Function1 & Serializable)codeExample -> {
                    CodeSnippet first = (CodeSnippet)codeExample.head();
                    KotlinTestCpg cpg = (KotlinTestCpg)this.code(first.content(), first.filename());
                    KotlinTestCpg finalCpg = (KotlinTestCpg)codeExample.drop(1).foldLeft((Object)cpg, (Function2 & Serializable)(foldCpg, example) -> (KotlinTestCpg)foldCpg.moreCode(example.content(), example.filename()));
                    return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)finalCpg, q), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                });
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            this.convertToWordSpecStringWrapper("should match a CONFIG_FILE node when `targetSdkVersion` is set to `22`").in((Function0 & Serializable)() -> {
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeBuildGradle(22, this.makeBuildGradle$default$2()), "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).tapJacking();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            this.convertToWordSpecStringWrapper("should not match a CONFIG_FILE when `targetSdkVersion` is set to `23`").in((Function0 & Serializable)() -> {
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeBuildGradle(this.makeBuildGradle$default$1(), this.makeBuildGradle$default$2()), "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).tapJacking();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            this.convertToWordSpecStringWrapper("should not match anything when the file named `build.gradle` is empty").in((Function0 & Serializable)() -> {
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode("", "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).tapJacking();
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.convertToWordSpecStringWrapper("the `vulnerablePRNGOnAndroidv16_18` query").when((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.convertToWordSpecStringWrapper("should match when the minSdk version is v16-18 and a call to SecureRandom default constructor is present").in((Function0 & Serializable)() -> {
                int x$1 = 16;
                int x$2 = this.makeBuildGradle$default$1();
                KotlinTestCpg cpg = (KotlinTestCpg)this.code(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("import java.security.SecureRandom\n          |\n          |fun main() {\n          |    SecureRandom random = new SecureRandom()\n          |}\n          |"))).moreCode(this.makeBuildGradle(x$2, 16), "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            this.convertToWordSpecStringWrapper("should match when the minSdk version is v16-18 and a call to SecureRandom.getInstance with a PRNG algorithm is set").in((Function0 & Serializable)() -> {
                int x$3 = 18;
                int x$4 = this.makeBuildGradle$default$1();
                KotlinTestCpg cpg = (KotlinTestCpg)this.code(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("import java.security.SecureRandom\n          |\n          |fun main() {\n          |    SecureRandom random = SecureRandom.getInstance(\"NativePRNG\")\n          |}\n          |"))).moreCode(this.makeBuildGradle(x$4, 18), "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            this.convertToWordSpecStringWrapper("should not match when the minSdk version is v16-18 and a call to SecureRandom.getInstance with a non-PRNG algorithm is set").in((Function0 & Serializable)() -> {
                int x$5 = 18;
                int x$6 = this.makeBuildGradle$default$1();
                KotlinTestCpg cpg = (KotlinTestCpg)this.code(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("import java.security.SecureRandom\n          |\n          |fun main() {\n          |    SecureRandom random = SecureRandom.getInstance(\"PKCS11\")\n          |}\n          |"))).moreCode(this.makeBuildGradle(x$6, 18), "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            this.convertToWordSpecStringWrapper("should not match when the minSdk version is v16-18 but no call to SecureRandom is present").in((Function0 & Serializable)() -> {
                int x$7 = 17;
                int x$8 = this.makeBuildGradle$default$1();
                KotlinTestCpg cpg = (KotlinTestCpg)this.code("import java.security.SecureRandom\nfun main() = println(\"I'm okay\")").moreCode(this.makeBuildGradle(x$8, 17), "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            this.convertToWordSpecStringWrapper("should not match when the minSdk version is 18 > and a call to SecureRandom is present").in((Function0 & Serializable)() -> {
                int x$9 = 19;
                int x$10 = this.makeBuildGradle$default$1();
                KotlinTestCpg cpg = (KotlinTestCpg)this.code(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("import java.security.SecureRandom\n          |\n          |fun main() {\n          |    SecureRandom random = new SecureRandom()\n          |}\n          |"))).moreCode(this.makeBuildGradle(x$10, 19), "build.gradle");
                Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
                return this.convertToAnyShouldWrapper(this.findMatchingConfigFiles((Cpg)cpg, query), new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159), Prettifier$.MODULE$.default()).shouldBe(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
    }
}

