/*
 * Decompiled with CFR 0.152.
 */
package io.joern.rubysrc2cpg.parser;

import io.joern.rubysrc2cpg.parser.AntlrParser;
import io.joern.rubysrc2cpg.parser.RubyParser;
import java.io.Serializable;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.dfa.DFA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

public class ResourceManagedParser
implements AutoCloseable {
    private final double clearLimit;
    private final Logger logger;
    private final Runtime runtime;
    private Option<DFA[]> maybeDecisionToDFA;
    private Option<ATN> maybeAtn;

    public ResourceManagedParser(double clearLimit) {
        this.clearLimit = clearLimit;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.runtime = Runtime.getRuntime();
        this.maybeDecisionToDFA = None$.MODULE$;
        this.maybeAtn = None$.MODULE$;
    }

    public Try<RubyParser.ProgramContext> parse(String filename) {
        Tuple2<Try<RubyParser.ProgramContext>, List<String>> tuple2;
        AntlrParser antlrParser = new AntlrParser(filename);
        ParserATNSimulator interp = (ParserATNSimulator)antlrParser.parser().getInterpreter();
        this.maybeDecisionToDFA = Option$.MODULE$.apply((Object)interp.decisionToDFA);
        this.maybeAtn = Option$.MODULE$.apply((Object)interp.atn);
        double usedMemory = (double)this.runtime.freeMemory() / (double)this.runtime.totalMemory();
        if (usedMemory >= this.clearLimit) {
            this.logger.info("Runtime memory consumption at " + usedMemory + ", clearing ANTLR DFA cache");
            this.clearDFA();
        }
        if ((tuple2 = antlrParser.parse()) == null) {
            throw new MatchError(tuple2);
        }
        Try programCtx = (Try)tuple2._1();
        List errors = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)programCtx, (Object)errors);
        Try programCtx2 = (Try)tuple22._1();
        List errors2 = (List)tuple22._2();
        errors2.foreach((Function1)(JProcedure1 & Serializable)x$0 -> this.logger.warn(x$0));
        return programCtx2;
    }

    private void clearDFA() {
        if (this.maybeDecisionToDFA.isDefined() && this.maybeAtn.isDefined()) {
            Object[] decisionToDFA = (DFA[])this.maybeDecisionToDFA.get();
            ATN atn = (ATN)this.maybeAtn.get();
            Object object = Predef$.MODULE$.refArrayOps(decisionToDFA);
            ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ResourceManagedParser.clearDFA$$anonfun$1((DFA[])decisionToDFA, atn, arg_0)));
            return;
        }
    }

    @Override
    public void close() {
        this.clearDFA();
    }

    private static final /* synthetic */ void clearDFA$$anonfun$1(DFA[] decisionToDFA$1, ATN atn$1, int d) {
        decisionToDFA$1[d] = new DFA(atn$1.getDecisionState(d), d);
    }
}

