package io.joern.swiftsrc2cpg.parser

// Automatically generated by 'SwiftAstGen --scalaAstOnly'.
// Do not edit directly!
// Generated: March 15, 2024 at 10:04:30 AM UTC

import scala.util.Try
import ujson.Value

object SwiftNodeSyntax {

  def createSwiftNode(json: Value): SwiftNode = {
    val nodeType  = json("nodeType").str
    val tokenKind = json("tokenKind").str

    if (nodeType.nonEmpty) {
      if (nodeType == "AccessorBlockSyntax") {
        return AccessorBlockSyntax(json)
      }
      if (nodeType == "AccessorDeclListSyntax") {
        return AccessorDeclListSyntax(json)
      }
      if (nodeType == "AccessorDeclSyntax") {
        return AccessorDeclSyntax(json)
      }
      if (nodeType == "AccessorEffectSpecifiersSyntax") {
        return AccessorEffectSpecifiersSyntax(json)
      }
      if (nodeType == "AccessorParametersSyntax") {
        return AccessorParametersSyntax(json)
      }
      if (nodeType == "ActorDeclSyntax") {
        return ActorDeclSyntax(json)
      }
      if (nodeType == "ArrayElementListSyntax") {
        return ArrayElementListSyntax(json)
      }
      if (nodeType == "ArrayElementSyntax") {
        return ArrayElementSyntax(json)
      }
      if (nodeType == "ArrayExprSyntax") {
        return ArrayExprSyntax(json)
      }
      if (nodeType == "ArrayTypeSyntax") {
        return ArrayTypeSyntax(json)
      }
      if (nodeType == "ArrowExprSyntax") {
        return ArrowExprSyntax(json)
      }
      if (nodeType == "AsExprSyntax") {
        return AsExprSyntax(json)
      }
      if (nodeType == "AssignmentExprSyntax") {
        return AssignmentExprSyntax(json)
      }
      if (nodeType == "AssociatedTypeDeclSyntax") {
        return AssociatedTypeDeclSyntax(json)
      }
      if (nodeType == "AttributeListSyntax") {
        return AttributeListSyntax(json)
      }
      if (nodeType == "AttributeSyntax") {
        return AttributeSyntax(json)
      }
      if (nodeType == "AttributedTypeSyntax") {
        return AttributedTypeSyntax(json)
      }
      if (nodeType == "AvailabilityArgumentListSyntax") {
        return AvailabilityArgumentListSyntax(json)
      }
      if (nodeType == "AvailabilityArgumentSyntax") {
        return AvailabilityArgumentSyntax(json)
      }
      if (nodeType == "AvailabilityConditionSyntax") {
        return AvailabilityConditionSyntax(json)
      }
      if (nodeType == "AvailabilityLabeledArgumentSyntax") {
        return AvailabilityLabeledArgumentSyntax(json)
      }
      if (nodeType == "AwaitExprSyntax") {
        return AwaitExprSyntax(json)
      }
      if (nodeType == "BackDeployedAttributeArgumentsSyntax") {
        return BackDeployedAttributeArgumentsSyntax(json)
      }
      if (nodeType == "BinaryOperatorExprSyntax") {
        return BinaryOperatorExprSyntax(json)
      }
      if (nodeType == "BooleanLiteralExprSyntax") {
        return BooleanLiteralExprSyntax(json)
      }
      if (nodeType == "BorrowExprSyntax") {
        return BorrowExprSyntax(json)
      }
      if (nodeType == "BreakStmtSyntax") {
        return BreakStmtSyntax(json)
      }
      if (nodeType == "CanImportExprSyntax") {
        return CanImportExprSyntax(json)
      }
      if (nodeType == "CanImportVersionInfoSyntax") {
        return CanImportVersionInfoSyntax(json)
      }
      if (nodeType == "CatchClauseListSyntax") {
        return CatchClauseListSyntax(json)
      }
      if (nodeType == "CatchClauseSyntax") {
        return CatchClauseSyntax(json)
      }
      if (nodeType == "CatchItemListSyntax") {
        return CatchItemListSyntax(json)
      }
      if (nodeType == "CatchItemSyntax") {
        return CatchItemSyntax(json)
      }
      if (nodeType == "ClassDeclSyntax") {
        return ClassDeclSyntax(json)
      }
      if (nodeType == "ClassRestrictionTypeSyntax") {
        return ClassRestrictionTypeSyntax(json)
      }
      if (nodeType == "ClosureCaptureClauseSyntax") {
        return ClosureCaptureClauseSyntax(json)
      }
      if (nodeType == "ClosureCaptureListSyntax") {
        return ClosureCaptureListSyntax(json)
      }
      if (nodeType == "ClosureCaptureSpecifierSyntax") {
        return ClosureCaptureSpecifierSyntax(json)
      }
      if (nodeType == "ClosureCaptureSyntax") {
        return ClosureCaptureSyntax(json)
      }
      if (nodeType == "ClosureExprSyntax") {
        return ClosureExprSyntax(json)
      }
      if (nodeType == "ClosureParameterClauseSyntax") {
        return ClosureParameterClauseSyntax(json)
      }
      if (nodeType == "ClosureParameterListSyntax") {
        return ClosureParameterListSyntax(json)
      }
      if (nodeType == "ClosureParameterSyntax") {
        return ClosureParameterSyntax(json)
      }
      if (nodeType == "ClosureShorthandParameterListSyntax") {
        return ClosureShorthandParameterListSyntax(json)
      }
      if (nodeType == "ClosureShorthandParameterSyntax") {
        return ClosureShorthandParameterSyntax(json)
      }
      if (nodeType == "ClosureSignatureSyntax") {
        return ClosureSignatureSyntax(json)
      }
      if (nodeType == "CodeBlockItemListSyntax") {
        return CodeBlockItemListSyntax(json)
      }
      if (nodeType == "CodeBlockItemSyntax") {
        return CodeBlockItemSyntax(json)
      }
      if (nodeType == "CodeBlockSyntax") {
        return CodeBlockSyntax(json)
      }
      if (nodeType == "CompositionTypeElementListSyntax") {
        return CompositionTypeElementListSyntax(json)
      }
      if (nodeType == "CompositionTypeElementSyntax") {
        return CompositionTypeElementSyntax(json)
      }
      if (nodeType == "CompositionTypeSyntax") {
        return CompositionTypeSyntax(json)
      }
      if (nodeType == "ConditionElementListSyntax") {
        return ConditionElementListSyntax(json)
      }
      if (nodeType == "ConditionElementSyntax") {
        return ConditionElementSyntax(json)
      }
      if (nodeType == "ConformanceRequirementSyntax") {
        return ConformanceRequirementSyntax(json)
      }
      if (nodeType == "ConsumeExprSyntax") {
        return ConsumeExprSyntax(json)
      }
      if (nodeType == "ContinueStmtSyntax") {
        return ContinueStmtSyntax(json)
      }
      if (nodeType == "ConventionAttributeArgumentsSyntax") {
        return ConventionAttributeArgumentsSyntax(json)
      }
      if (nodeType == "ConventionWitnessMethodAttributeArgumentsSyntax") {
        return ConventionWitnessMethodAttributeArgumentsSyntax(json)
      }
      if (nodeType == "CopyExprSyntax") {
        return CopyExprSyntax(json)
      }
      if (nodeType == "DeclModifierDetailSyntax") {
        return DeclModifierDetailSyntax(json)
      }
      if (nodeType == "DeclModifierListSyntax") {
        return DeclModifierListSyntax(json)
      }
      if (nodeType == "DeclModifierSyntax") {
        return DeclModifierSyntax(json)
      }
      if (nodeType == "DeclNameArgumentListSyntax") {
        return DeclNameArgumentListSyntax(json)
      }
      if (nodeType == "DeclNameArgumentSyntax") {
        return DeclNameArgumentSyntax(json)
      }
      if (nodeType == "DeclNameArgumentsSyntax") {
        return DeclNameArgumentsSyntax(json)
      }
      if (nodeType == "DeclReferenceExprSyntax") {
        return DeclReferenceExprSyntax(json)
      }
      if (nodeType == "DeferStmtSyntax") {
        return DeferStmtSyntax(json)
      }
      if (nodeType == "DeinitializerDeclSyntax") {
        return DeinitializerDeclSyntax(json)
      }
      if (nodeType == "DeinitializerEffectSpecifiersSyntax") {
        return DeinitializerEffectSpecifiersSyntax(json)
      }
      if (nodeType == "DerivativeAttributeArgumentsSyntax") {
        return DerivativeAttributeArgumentsSyntax(json)
      }
      if (nodeType == "DesignatedTypeListSyntax") {
        return DesignatedTypeListSyntax(json)
      }
      if (nodeType == "DesignatedTypeSyntax") {
        return DesignatedTypeSyntax(json)
      }
      if (nodeType == "DictionaryElementListSyntax") {
        return DictionaryElementListSyntax(json)
      }
      if (nodeType == "DictionaryElementSyntax") {
        return DictionaryElementSyntax(json)
      }
      if (nodeType == "DictionaryExprSyntax") {
        return DictionaryExprSyntax(json)
      }
      if (nodeType == "DictionaryTypeSyntax") {
        return DictionaryTypeSyntax(json)
      }
      if (nodeType == "DifferentiabilityArgumentListSyntax") {
        return DifferentiabilityArgumentListSyntax(json)
      }
      if (nodeType == "DifferentiabilityArgumentSyntax") {
        return DifferentiabilityArgumentSyntax(json)
      }
      if (nodeType == "DifferentiabilityArgumentsSyntax") {
        return DifferentiabilityArgumentsSyntax(json)
      }
      if (nodeType == "DifferentiabilityWithRespectToArgumentSyntax") {
        return DifferentiabilityWithRespectToArgumentSyntax(json)
      }
      if (nodeType == "DifferentiableAttributeArgumentsSyntax") {
        return DifferentiableAttributeArgumentsSyntax(json)
      }
      if (nodeType == "DiscardAssignmentExprSyntax") {
        return DiscardAssignmentExprSyntax(json)
      }
      if (nodeType == "DiscardStmtSyntax") {
        return DiscardStmtSyntax(json)
      }
      if (nodeType == "DoExprSyntax") {
        return DoExprSyntax(json)
      }
      if (nodeType == "DoStmtSyntax") {
        return DoStmtSyntax(json)
      }
      if (nodeType == "DocumentationAttributeArgumentListSyntax") {
        return DocumentationAttributeArgumentListSyntax(json)
      }
      if (nodeType == "DocumentationAttributeArgumentSyntax") {
        return DocumentationAttributeArgumentSyntax(json)
      }
      if (nodeType == "DynamicReplacementAttributeArgumentsSyntax") {
        return DynamicReplacementAttributeArgumentsSyntax(json)
      }
      if (nodeType == "EditorPlaceholderDeclSyntax") {
        return EditorPlaceholderDeclSyntax(json)
      }
      if (nodeType == "EditorPlaceholderExprSyntax") {
        return EditorPlaceholderExprSyntax(json)
      }
      if (nodeType == "EffectsAttributeArgumentListSyntax") {
        return EffectsAttributeArgumentListSyntax(json)
      }
      if (nodeType == "EnumCaseDeclSyntax") {
        return EnumCaseDeclSyntax(json)
      }
      if (nodeType == "EnumCaseElementListSyntax") {
        return EnumCaseElementListSyntax(json)
      }
      if (nodeType == "EnumCaseElementSyntax") {
        return EnumCaseElementSyntax(json)
      }
      if (nodeType == "EnumCaseParameterClauseSyntax") {
        return EnumCaseParameterClauseSyntax(json)
      }
      if (nodeType == "EnumCaseParameterListSyntax") {
        return EnumCaseParameterListSyntax(json)
      }
      if (nodeType == "EnumCaseParameterSyntax") {
        return EnumCaseParameterSyntax(json)
      }
      if (nodeType == "EnumDeclSyntax") {
        return EnumDeclSyntax(json)
      }
      if (nodeType == "ExposeAttributeArgumentsSyntax") {
        return ExposeAttributeArgumentsSyntax(json)
      }
      if (nodeType == "ExprListSyntax") {
        return ExprListSyntax(json)
      }
      if (nodeType == "ExpressionPatternSyntax") {
        return ExpressionPatternSyntax(json)
      }
      if (nodeType == "ExpressionSegmentSyntax") {
        return ExpressionSegmentSyntax(json)
      }
      if (nodeType == "ExpressionStmtSyntax") {
        return ExpressionStmtSyntax(json)
      }
      if (nodeType == "ExtensionDeclSyntax") {
        return ExtensionDeclSyntax(json)
      }
      if (nodeType == "FallThroughStmtSyntax") {
        return FallThroughStmtSyntax(json)
      }
      if (nodeType == "FloatLiteralExprSyntax") {
        return FloatLiteralExprSyntax(json)
      }
      if (nodeType == "ForStmtSyntax") {
        return ForStmtSyntax(json)
      }
      if (nodeType == "ForceUnwrapExprSyntax") {
        return ForceUnwrapExprSyntax(json)
      }
      if (nodeType == "FunctionCallExprSyntax") {
        return FunctionCallExprSyntax(json)
      }
      if (nodeType == "FunctionDeclSyntax") {
        return FunctionDeclSyntax(json)
      }
      if (nodeType == "FunctionEffectSpecifiersSyntax") {
        return FunctionEffectSpecifiersSyntax(json)
      }
      if (nodeType == "FunctionParameterClauseSyntax") {
        return FunctionParameterClauseSyntax(json)
      }
      if (nodeType == "FunctionParameterListSyntax") {
        return FunctionParameterListSyntax(json)
      }
      if (nodeType == "FunctionParameterSyntax") {
        return FunctionParameterSyntax(json)
      }
      if (nodeType == "FunctionSignatureSyntax") {
        return FunctionSignatureSyntax(json)
      }
      if (nodeType == "FunctionTypeSyntax") {
        return FunctionTypeSyntax(json)
      }
      if (nodeType == "GenericArgumentClauseSyntax") {
        return GenericArgumentClauseSyntax(json)
      }
      if (nodeType == "GenericArgumentListSyntax") {
        return GenericArgumentListSyntax(json)
      }
      if (nodeType == "GenericArgumentSyntax") {
        return GenericArgumentSyntax(json)
      }
      if (nodeType == "GenericParameterClauseSyntax") {
        return GenericParameterClauseSyntax(json)
      }
      if (nodeType == "GenericParameterListSyntax") {
        return GenericParameterListSyntax(json)
      }
      if (nodeType == "GenericParameterSyntax") {
        return GenericParameterSyntax(json)
      }
      if (nodeType == "GenericRequirementListSyntax") {
        return GenericRequirementListSyntax(json)
      }
      if (nodeType == "GenericRequirementSyntax") {
        return GenericRequirementSyntax(json)
      }
      if (nodeType == "GenericSpecializationExprSyntax") {
        return GenericSpecializationExprSyntax(json)
      }
      if (nodeType == "GenericWhereClauseSyntax") {
        return GenericWhereClauseSyntax(json)
      }
      if (nodeType == "GuardStmtSyntax") {
        return GuardStmtSyntax(json)
      }
      if (nodeType == "IdentifierPatternSyntax") {
        return IdentifierPatternSyntax(json)
      }
      if (nodeType == "IdentifierTypeSyntax") {
        return IdentifierTypeSyntax(json)
      }
      if (nodeType == "IfConfigClauseListSyntax") {
        return IfConfigClauseListSyntax(json)
      }
      if (nodeType == "IfConfigClauseSyntax") {
        return IfConfigClauseSyntax(json)
      }
      if (nodeType == "IfConfigDeclSyntax") {
        return IfConfigDeclSyntax(json)
      }
      if (nodeType == "IfExprSyntax") {
        return IfExprSyntax(json)
      }
      if (nodeType == "ImplementsAttributeArgumentsSyntax") {
        return ImplementsAttributeArgumentsSyntax(json)
      }
      if (nodeType == "ImplicitlyUnwrappedOptionalTypeSyntax") {
        return ImplicitlyUnwrappedOptionalTypeSyntax(json)
      }
      if (nodeType == "ImportDeclSyntax") {
        return ImportDeclSyntax(json)
      }
      if (nodeType == "ImportPathComponentListSyntax") {
        return ImportPathComponentListSyntax(json)
      }
      if (nodeType == "ImportPathComponentSyntax") {
        return ImportPathComponentSyntax(json)
      }
      if (nodeType == "InOutExprSyntax") {
        return InOutExprSyntax(json)
      }
      if (nodeType == "InfixOperatorExprSyntax") {
        return InfixOperatorExprSyntax(json)
      }
      if (nodeType == "InheritanceClauseSyntax") {
        return InheritanceClauseSyntax(json)
      }
      if (nodeType == "InheritedTypeListSyntax") {
        return InheritedTypeListSyntax(json)
      }
      if (nodeType == "InheritedTypeSyntax") {
        return InheritedTypeSyntax(json)
      }
      if (nodeType == "InitializerClauseSyntax") {
        return InitializerClauseSyntax(json)
      }
      if (nodeType == "InitializerDeclSyntax") {
        return InitializerDeclSyntax(json)
      }
      if (nodeType == "IntegerLiteralExprSyntax") {
        return IntegerLiteralExprSyntax(json)
      }
      if (nodeType == "IsExprSyntax") {
        return IsExprSyntax(json)
      }
      if (nodeType == "IsTypePatternSyntax") {
        return IsTypePatternSyntax(json)
      }
      if (nodeType == "KeyPathComponentListSyntax") {
        return KeyPathComponentListSyntax(json)
      }
      if (nodeType == "KeyPathComponentSyntax") {
        return KeyPathComponentSyntax(json)
      }
      if (nodeType == "KeyPathExprSyntax") {
        return KeyPathExprSyntax(json)
      }
      if (nodeType == "KeyPathOptionalComponentSyntax") {
        return KeyPathOptionalComponentSyntax(json)
      }
      if (nodeType == "KeyPathPropertyComponentSyntax") {
        return KeyPathPropertyComponentSyntax(json)
      }
      if (nodeType == "KeyPathSubscriptComponentSyntax") {
        return KeyPathSubscriptComponentSyntax(json)
      }
      if (nodeType == "LabeledExprListSyntax") {
        return LabeledExprListSyntax(json)
      }
      if (nodeType == "LabeledExprSyntax") {
        return LabeledExprSyntax(json)
      }
      if (nodeType == "LabeledSpecializeArgumentSyntax") {
        return LabeledSpecializeArgumentSyntax(json)
      }
      if (nodeType == "LabeledStmtSyntax") {
        return LabeledStmtSyntax(json)
      }
      if (nodeType == "LayoutRequirementSyntax") {
        return LayoutRequirementSyntax(json)
      }
      if (nodeType == "LifetimeSpecifierArgumentListSyntax") {
        return LifetimeSpecifierArgumentListSyntax(json)
      }
      if (nodeType == "LifetimeSpecifierArgumentSyntax") {
        return LifetimeSpecifierArgumentSyntax(json)
      }
      if (nodeType == "LifetimeSpecifierArgumentsSyntax") {
        return LifetimeSpecifierArgumentsSyntax(json)
      }
      if (nodeType == "LifetimeTypeSpecifierSyntax") {
        return LifetimeTypeSpecifierSyntax(json)
      }
      if (nodeType == "MacroDeclSyntax") {
        return MacroDeclSyntax(json)
      }
      if (nodeType == "MacroExpansionDeclSyntax") {
        return MacroExpansionDeclSyntax(json)
      }
      if (nodeType == "MacroExpansionExprSyntax") {
        return MacroExpansionExprSyntax(json)
      }
      if (nodeType == "MatchingPatternConditionSyntax") {
        return MatchingPatternConditionSyntax(json)
      }
      if (nodeType == "MemberAccessExprSyntax") {
        return MemberAccessExprSyntax(json)
      }
      if (nodeType == "MemberBlockItemListSyntax") {
        return MemberBlockItemListSyntax(json)
      }
      if (nodeType == "MemberBlockItemSyntax") {
        return MemberBlockItemSyntax(json)
      }
      if (nodeType == "MemberBlockSyntax") {
        return MemberBlockSyntax(json)
      }
      if (nodeType == "MemberTypeSyntax") {
        return MemberTypeSyntax(json)
      }
      if (nodeType == "MetatypeTypeSyntax") {
        return MetatypeTypeSyntax(json)
      }
      if (nodeType == "MissingDeclSyntax") {
        return MissingDeclSyntax(json)
      }
      if (nodeType == "MissingExprSyntax") {
        return MissingExprSyntax(json)
      }
      if (nodeType == "MissingPatternSyntax") {
        return MissingPatternSyntax(json)
      }
      if (nodeType == "MissingStmtSyntax") {
        return MissingStmtSyntax(json)
      }
      if (nodeType == "MissingSyntax") {
        return MissingSyntax(json)
      }
      if (nodeType == "MissingTypeSyntax") {
        return MissingTypeSyntax(json)
      }
      if (nodeType == "MultipleTrailingClosureElementListSyntax") {
        return MultipleTrailingClosureElementListSyntax(json)
      }
      if (nodeType == "MultipleTrailingClosureElementSyntax") {
        return MultipleTrailingClosureElementSyntax(json)
      }
      if (nodeType == "NamedOpaqueReturnTypeSyntax") {
        return NamedOpaqueReturnTypeSyntax(json)
      }
      if (nodeType == "NilLiteralExprSyntax") {
        return NilLiteralExprSyntax(json)
      }
      if (nodeType == "ObjCSelectorPieceListSyntax") {
        return ObjCSelectorPieceListSyntax(json)
      }
      if (nodeType == "ObjCSelectorPieceSyntax") {
        return ObjCSelectorPieceSyntax(json)
      }
      if (nodeType == "OpaqueReturnTypeOfAttributeArgumentsSyntax") {
        return OpaqueReturnTypeOfAttributeArgumentsSyntax(json)
      }
      if (nodeType == "OperatorDeclSyntax") {
        return OperatorDeclSyntax(json)
      }
      if (nodeType == "OperatorPrecedenceAndTypesSyntax") {
        return OperatorPrecedenceAndTypesSyntax(json)
      }
      if (nodeType == "OptionalBindingConditionSyntax") {
        return OptionalBindingConditionSyntax(json)
      }
      if (nodeType == "OptionalChainingExprSyntax") {
        return OptionalChainingExprSyntax(json)
      }
      if (nodeType == "OptionalTypeSyntax") {
        return OptionalTypeSyntax(json)
      }
      if (nodeType == "OriginallyDefinedInAttributeArgumentsSyntax") {
        return OriginallyDefinedInAttributeArgumentsSyntax(json)
      }
      if (nodeType == "PackElementExprSyntax") {
        return PackElementExprSyntax(json)
      }
      if (nodeType == "PackElementTypeSyntax") {
        return PackElementTypeSyntax(json)
      }
      if (nodeType == "PackExpansionExprSyntax") {
        return PackExpansionExprSyntax(json)
      }
      if (nodeType == "PackExpansionTypeSyntax") {
        return PackExpansionTypeSyntax(json)
      }
      if (nodeType == "PatternBindingListSyntax") {
        return PatternBindingListSyntax(json)
      }
      if (nodeType == "PatternBindingSyntax") {
        return PatternBindingSyntax(json)
      }
      if (nodeType == "PatternExprSyntax") {
        return PatternExprSyntax(json)
      }
      if (nodeType == "PlatformVersionItemListSyntax") {
        return PlatformVersionItemListSyntax(json)
      }
      if (nodeType == "PlatformVersionItemSyntax") {
        return PlatformVersionItemSyntax(json)
      }
      if (nodeType == "PlatformVersionSyntax") {
        return PlatformVersionSyntax(json)
      }
      if (nodeType == "PostfixIfConfigExprSyntax") {
        return PostfixIfConfigExprSyntax(json)
      }
      if (nodeType == "PostfixOperatorExprSyntax") {
        return PostfixOperatorExprSyntax(json)
      }
      if (nodeType == "PoundSourceLocationArgumentsSyntax") {
        return PoundSourceLocationArgumentsSyntax(json)
      }
      if (nodeType == "PoundSourceLocationSyntax") {
        return PoundSourceLocationSyntax(json)
      }
      if (nodeType == "PrecedenceGroupAssignmentSyntax") {
        return PrecedenceGroupAssignmentSyntax(json)
      }
      if (nodeType == "PrecedenceGroupAssociativitySyntax") {
        return PrecedenceGroupAssociativitySyntax(json)
      }
      if (nodeType == "PrecedenceGroupAttributeListSyntax") {
        return PrecedenceGroupAttributeListSyntax(json)
      }
      if (nodeType == "PrecedenceGroupDeclSyntax") {
        return PrecedenceGroupDeclSyntax(json)
      }
      if (nodeType == "PrecedenceGroupNameListSyntax") {
        return PrecedenceGroupNameListSyntax(json)
      }
      if (nodeType == "PrecedenceGroupNameSyntax") {
        return PrecedenceGroupNameSyntax(json)
      }
      if (nodeType == "PrecedenceGroupRelationSyntax") {
        return PrecedenceGroupRelationSyntax(json)
      }
      if (nodeType == "PrefixOperatorExprSyntax") {
        return PrefixOperatorExprSyntax(json)
      }
      if (nodeType == "PrimaryAssociatedTypeClauseSyntax") {
        return PrimaryAssociatedTypeClauseSyntax(json)
      }
      if (nodeType == "PrimaryAssociatedTypeListSyntax") {
        return PrimaryAssociatedTypeListSyntax(json)
      }
      if (nodeType == "PrimaryAssociatedTypeSyntax") {
        return PrimaryAssociatedTypeSyntax(json)
      }
      if (nodeType == "ProtocolDeclSyntax") {
        return ProtocolDeclSyntax(json)
      }
      if (nodeType == "RegexLiteralExprSyntax") {
        return RegexLiteralExprSyntax(json)
      }
      if (nodeType == "RepeatStmtSyntax") {
        return RepeatStmtSyntax(json)
      }
      if (nodeType == "ReturnClauseSyntax") {
        return ReturnClauseSyntax(json)
      }
      if (nodeType == "ReturnStmtSyntax") {
        return ReturnStmtSyntax(json)
      }
      if (nodeType == "SameTypeRequirementSyntax") {
        return SameTypeRequirementSyntax(json)
      }
      if (nodeType == "SequenceExprSyntax") {
        return SequenceExprSyntax(json)
      }
      if (nodeType == "SimpleStringLiteralExprSyntax") {
        return SimpleStringLiteralExprSyntax(json)
      }
      if (nodeType == "SimpleStringLiteralSegmentListSyntax") {
        return SimpleStringLiteralSegmentListSyntax(json)
      }
      if (nodeType == "SimpleTypeSpecifierSyntax") {
        return SimpleTypeSpecifierSyntax(json)
      }
      if (nodeType == "SomeOrAnyTypeSyntax") {
        return SomeOrAnyTypeSyntax(json)
      }
      if (nodeType == "SourceFileSyntax") {
        return SourceFileSyntax(json)
      }
      if (nodeType == "SpecializeAttributeArgumentListSyntax") {
        return SpecializeAttributeArgumentListSyntax(json)
      }
      if (nodeType == "SpecializeAvailabilityArgumentSyntax") {
        return SpecializeAvailabilityArgumentSyntax(json)
      }
      if (nodeType == "SpecializeTargetFunctionArgumentSyntax") {
        return SpecializeTargetFunctionArgumentSyntax(json)
      }
      if (nodeType == "StringLiteralExprSyntax") {
        return StringLiteralExprSyntax(json)
      }
      if (nodeType == "StringLiteralSegmentListSyntax") {
        return StringLiteralSegmentListSyntax(json)
      }
      if (nodeType == "StringSegmentSyntax") {
        return StringSegmentSyntax(json)
      }
      if (nodeType == "StructDeclSyntax") {
        return StructDeclSyntax(json)
      }
      if (nodeType == "SubscriptCallExprSyntax") {
        return SubscriptCallExprSyntax(json)
      }
      if (nodeType == "SubscriptDeclSyntax") {
        return SubscriptDeclSyntax(json)
      }
      if (nodeType == "SuperExprSyntax") {
        return SuperExprSyntax(json)
      }
      if (nodeType == "SuppressedTypeSyntax") {
        return SuppressedTypeSyntax(json)
      }
      if (nodeType == "SwitchCaseItemListSyntax") {
        return SwitchCaseItemListSyntax(json)
      }
      if (nodeType == "SwitchCaseItemSyntax") {
        return SwitchCaseItemSyntax(json)
      }
      if (nodeType == "SwitchCaseLabelSyntax") {
        return SwitchCaseLabelSyntax(json)
      }
      if (nodeType == "SwitchCaseListSyntax") {
        return SwitchCaseListSyntax(json)
      }
      if (nodeType == "SwitchCaseSyntax") {
        return SwitchCaseSyntax(json)
      }
      if (nodeType == "SwitchDefaultLabelSyntax") {
        return SwitchDefaultLabelSyntax(json)
      }
      if (nodeType == "SwitchExprSyntax") {
        return SwitchExprSyntax(json)
      }
      if (nodeType == "TernaryExprSyntax") {
        return TernaryExprSyntax(json)
      }
      if (nodeType == "ThenStmtSyntax") {
        return ThenStmtSyntax(json)
      }
      if (nodeType == "ThrowStmtSyntax") {
        return ThrowStmtSyntax(json)
      }
      if (nodeType == "ThrowsClauseSyntax") {
        return ThrowsClauseSyntax(json)
      }
      if (nodeType == "TryExprSyntax") {
        return TryExprSyntax(json)
      }
      if (nodeType == "TupleExprSyntax") {
        return TupleExprSyntax(json)
      }
      if (nodeType == "TuplePatternElementListSyntax") {
        return TuplePatternElementListSyntax(json)
      }
      if (nodeType == "TuplePatternElementSyntax") {
        return TuplePatternElementSyntax(json)
      }
      if (nodeType == "TuplePatternSyntax") {
        return TuplePatternSyntax(json)
      }
      if (nodeType == "TupleTypeElementListSyntax") {
        return TupleTypeElementListSyntax(json)
      }
      if (nodeType == "TupleTypeElementSyntax") {
        return TupleTypeElementSyntax(json)
      }
      if (nodeType == "TupleTypeSyntax") {
        return TupleTypeSyntax(json)
      }
      if (nodeType == "TypeAliasDeclSyntax") {
        return TypeAliasDeclSyntax(json)
      }
      if (nodeType == "TypeAnnotationSyntax") {
        return TypeAnnotationSyntax(json)
      }
      if (nodeType == "TypeEffectSpecifiersSyntax") {
        return TypeEffectSpecifiersSyntax(json)
      }
      if (nodeType == "TypeExprSyntax") {
        return TypeExprSyntax(json)
      }
      if (nodeType == "TypeInitializerClauseSyntax") {
        return TypeInitializerClauseSyntax(json)
      }
      if (nodeType == "TypeSpecifierListSyntax") {
        return TypeSpecifierListSyntax(json)
      }
      if (nodeType == "UnavailableFromAsyncAttributeArgumentsSyntax") {
        return UnavailableFromAsyncAttributeArgumentsSyntax(json)
      }
      if (nodeType == "UnderscorePrivateAttributeArgumentsSyntax") {
        return UnderscorePrivateAttributeArgumentsSyntax(json)
      }
      if (nodeType == "UnexpectedNodesSyntax") {
        return UnexpectedNodesSyntax(json)
      }
      if (nodeType == "UnresolvedAsExprSyntax") {
        return UnresolvedAsExprSyntax(json)
      }
      if (nodeType == "UnresolvedIsExprSyntax") {
        return UnresolvedIsExprSyntax(json)
      }
      if (nodeType == "UnresolvedTernaryExprSyntax") {
        return UnresolvedTernaryExprSyntax(json)
      }
      if (nodeType == "ValueBindingPatternSyntax") {
        return ValueBindingPatternSyntax(json)
      }
      if (nodeType == "VariableDeclSyntax") {
        return VariableDeclSyntax(json)
      }
      if (nodeType == "VersionComponentListSyntax") {
        return VersionComponentListSyntax(json)
      }
      if (nodeType == "VersionComponentSyntax") {
        return VersionComponentSyntax(json)
      }
      if (nodeType == "VersionTupleSyntax") {
        return VersionTupleSyntax(json)
      }
      if (nodeType == "WhereClauseSyntax") {
        return WhereClauseSyntax(json)
      }
      if (nodeType == "WhileStmtSyntax") {
        return WhileStmtSyntax(json)
      }
      if (nodeType == "WildcardPatternSyntax") {
        return WildcardPatternSyntax(json)
      }
      if (nodeType == "YieldStmtSyntax") {
        return YieldStmtSyntax(json)
      }
      if (nodeType == "YieldedExpressionListSyntax") {
        return YieldedExpressionListSyntax(json)
      }
      if (nodeType == "YieldedExpressionSyntax") {
        return YieldedExpressionSyntax(json)
      }
      if (nodeType == "YieldedExpressionsClauseSyntax") {
        return YieldedExpressionsClauseSyntax(json)
      }
      if (nodeType == "TokenSyntax") {
        return TokenSyntax(json)
      }
      throw new UnsupportedOperationException(s"NodeType '$nodeType' is not a known Swift NodeType!")
    }

    if (tokenKind.nonEmpty) {
      if (tokenKind.startsWith("arrow")) return {
        arrow(json)
      }
      if (tokenKind.startsWith("atSign")) return {
        atSign(json)
      }
      if (tokenKind.startsWith("backslash")) return {
        backslash(json)
      }
      if (tokenKind.startsWith("backtick")) return {
        backtick(json)
      }
      if (tokenKind.startsWith("binaryOperator")) return {
        binaryOperator(json)
      }
      if (tokenKind.startsWith("colon")) return {
        colon(json)
      }
      if (tokenKind.startsWith("comma")) return {
        comma(json)
      }
      if (tokenKind.startsWith("dollarIdentifier")) return {
        dollarIdentifier(json)
      }
      if (tokenKind.startsWith("ellipsis")) return {
        ellipsis(json)
      }
      if (tokenKind.startsWith("endOfFile")) return {
        endOfFile(json)
      }
      if (tokenKind.startsWith("equal")) return {
        equal(json)
      }
      if (tokenKind.startsWith("exclamationMark")) return {
        exclamationMark(json)
      }
      if (tokenKind.startsWith("floatLiteral")) return {
        floatLiteral(json)
      }
      if (tokenKind.startsWith("identifier")) return {
        identifier(json)
      }
      if (tokenKind.startsWith("infixQuestionMark")) return {
        infixQuestionMark(json)
      }
      if (tokenKind.startsWith("integerLiteral")) return {
        integerLiteral(json)
      }
      if (tokenKind.startsWith("keyword")) return {
        keyword(json)
      }
      if (tokenKind.startsWith("leftAngle")) return {
        leftAngle(json)
      }
      if (tokenKind.startsWith("leftBrace")) return {
        leftBrace(json)
      }
      if (tokenKind.startsWith("leftParen")) return {
        leftParen(json)
      }
      if (tokenKind.startsWith("leftSquare")) return {
        leftSquare(json)
      }
      if (tokenKind.startsWith("multilineStringQuote")) return {
        multilineStringQuote(json)
      }
      if (tokenKind.startsWith("period")) return {
        period(json)
      }
      if (tokenKind.startsWith("postfixOperator")) return {
        postfixOperator(json)
      }
      if (tokenKind.startsWith("postfixQuestionMark")) return {
        postfixQuestionMark(json)
      }
      if (tokenKind.startsWith("pound")) return {
        pound(json)
      }
      if (tokenKind.startsWith("poundAvailable")) return {
        poundAvailable(json)
      }
      if (tokenKind.startsWith("poundElse")) return {
        poundElse(json)
      }
      if (tokenKind.startsWith("poundElseif")) return {
        poundElseif(json)
      }
      if (tokenKind.startsWith("poundEndif")) return {
        poundEndif(json)
      }
      if (tokenKind.startsWith("poundIf")) return {
        poundIf(json)
      }
      if (tokenKind.startsWith("poundSourceLocation")) return {
        poundSourceLocation(json)
      }
      if (tokenKind.startsWith("poundUnavailable")) return {
        poundUnavailable(json)
      }
      if (tokenKind.startsWith("prefixAmpersand")) return {
        prefixAmpersand(json)
      }
      if (tokenKind.startsWith("prefixOperator")) return {
        prefixOperator(json)
      }
      if (tokenKind.startsWith("rawStringPoundDelimiter")) return {
        rawStringPoundDelimiter(json)
      }
      if (tokenKind.startsWith("regexLiteralPattern")) return {
        regexLiteralPattern(json)
      }
      if (tokenKind.startsWith("regexPoundDelimiter")) return {
        regexPoundDelimiter(json)
      }
      if (tokenKind.startsWith("regexSlash")) return {
        regexSlash(json)
      }
      if (tokenKind.startsWith("rightAngle")) return {
        rightAngle(json)
      }
      if (tokenKind.startsWith("rightBrace")) return {
        rightBrace(json)
      }
      if (tokenKind.startsWith("rightParen")) return {
        rightParen(json)
      }
      if (tokenKind.startsWith("rightSquare")) return {
        rightSquare(json)
      }
      if (tokenKind.startsWith("semicolon")) return {
        semicolon(json)
      }
      if (tokenKind.startsWith("shebang")) return {
        shebang(json)
      }
      if (tokenKind.startsWith("singleQuote")) return {
        singleQuote(json)
      }
      if (tokenKind.startsWith("stringQuote")) return {
        stringQuote(json)
      }
      if (tokenKind.startsWith("stringSegment")) return {
        stringSegment(json)
      }
      if (tokenKind.startsWith("unknown")) return {
        unknown(json)
      }
      if (tokenKind.startsWith("wildcard")) return {
        wildcard(json)
      }
      throw new UnsupportedOperationException(s"TokenKind '$tokenKind' is not a known Swift TokenKind!")
    }

    throw new UnsupportedOperationException(
      "Invalid SwiftSyntax json element. 'nodeType' and 'tokenKind' cannot be empty at the same time!"
    )
  }

  sealed trait SwiftNode {
    def json: Value

    def startOffset: Option[Int] = Try(json("range")("startOffset").num.toInt).toOption

    def endOffset: Option[Int] = Try(json("range")("endOffset").num.toInt).toOption

    def startLine: Option[Int] = Try(json("range")("startLine").num.toInt).toOption

    def startColumn: Option[Int] = Try(json("range")("startColumn").num.toInt).toOption

    def endLine: Option[Int] = Try(json("range")("endLine").num.toInt).toOption

    def endColumn: Option[Int] = Try(json("range")("endColumn").num.toInt).toOption

    override def toString: String = this.getClass.getSimpleName.stripSuffix("$")
  }

  sealed trait SwiftToken extends SwiftNode

  // MARK: tokens:
  case class arrow(json: Value) extends SwiftToken

  case class atSign(json: Value) extends SwiftToken

  case class backslash(json: Value) extends SwiftToken

  case class backtick(json: Value) extends SwiftToken

  case class binaryOperator(json: Value) extends SwiftToken

  case class colon(json: Value) extends SwiftToken

  case class comma(json: Value) extends SwiftToken

  case class dollarIdentifier(json: Value) extends SwiftToken

  case class ellipsis(json: Value) extends SwiftToken

  case class endOfFile(json: Value) extends SwiftToken

  case class equal(json: Value) extends SwiftToken

  case class exclamationMark(json: Value) extends SwiftToken

  case class floatLiteral(json: Value) extends SwiftToken

  case class identifier(json: Value) extends SwiftToken

  case class infixQuestionMark(json: Value) extends SwiftToken

  case class integerLiteral(json: Value) extends SwiftToken

  case class keyword(json: Value) extends SwiftToken

  case class leftAngle(json: Value) extends SwiftToken

  case class leftBrace(json: Value) extends SwiftToken

  case class leftParen(json: Value) extends SwiftToken

  case class leftSquare(json: Value) extends SwiftToken

  case class multilineStringQuote(json: Value) extends SwiftToken

  case class period(json: Value) extends SwiftToken

  case class postfixOperator(json: Value) extends SwiftToken

  case class postfixQuestionMark(json: Value) extends SwiftToken

  case class pound(json: Value) extends SwiftToken

  case class poundAvailable(json: Value) extends SwiftToken

  case class poundElse(json: Value) extends SwiftToken

  case class poundElseif(json: Value) extends SwiftToken

  case class poundEndif(json: Value) extends SwiftToken

  case class poundIf(json: Value) extends SwiftToken

  case class poundSourceLocation(json: Value) extends SwiftToken

  case class poundUnavailable(json: Value) extends SwiftToken

  case class prefixAmpersand(json: Value) extends SwiftToken

  case class prefixOperator(json: Value) extends SwiftToken

  case class rawStringPoundDelimiter(json: Value) extends SwiftToken

  case class regexLiteralPattern(json: Value) extends SwiftToken

  case class regexPoundDelimiter(json: Value) extends SwiftToken

  case class regexSlash(json: Value) extends SwiftToken

  case class rightAngle(json: Value) extends SwiftToken

  case class rightBrace(json: Value) extends SwiftToken

  case class rightParen(json: Value) extends SwiftToken

  case class rightSquare(json: Value) extends SwiftToken

  case class semicolon(json: Value) extends SwiftToken

  case class shebang(json: Value) extends SwiftToken

  case class singleQuote(json: Value) extends SwiftToken

  case class stringQuote(json: Value) extends SwiftToken

  case class stringSegment(json: Value) extends SwiftToken

  case class unknown(json: Value) extends SwiftToken

  case class wildcard(json: Value) extends SwiftToken

  // MARK: base nodes:
  sealed trait Syntax extends SwiftNode

  sealed trait TypeSyntax extends SwiftNode

  sealed trait ExprSyntax extends SwiftNode

  sealed trait StmtSyntax extends SwiftNode

  sealed trait SyntaxCollection extends SwiftNode

  sealed trait DeclSyntax extends SwiftNode

  sealed trait PatternSyntax extends SwiftNode

  // MARK: marker traits:
  sealed trait Braced

  sealed trait DeclGroup

  sealed trait EffectSpecifiers

  sealed trait FreestandingMacroExpansion

  sealed trait NamedDecl

  /// Represents a layout node that is missing in the source file.
  ///
  /// See the types conforming to this protocol for examples of where missing nodes can occur.

  sealed trait MissingNode

  sealed trait Parenthesized

  sealed trait WithAttributes

  sealed trait WithCodeBlock

  /// Syntax nodes that have generic parameters.
  ///
  /// For example, functions or nominal types like `class` or `struct` can have generic parameters and have a generic where clause that restricts these generic parameters.

  sealed trait WithGenericParameters

  sealed trait WithModifiers

  sealed trait WithOptionalCodeBlock

  sealed trait WithStatements

  sealed trait WithTrailingComma

  // MARK: syntax nodes:

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftBrace`: `{`
    *   - `accessors`: (``AccessorDeclListSyntax`` | ``CodeBlockItemListSyntax``)
    *   - `rightBrace`: `}`
    *
    * ### Contained in
    *
    *   - ``PatternBindingSyntax``.``PatternBindingSyntax/accessorBlock``
    *   - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/accessorBlock``
    */
  case class AccessorBlockSyntax(json: Value) extends Syntax with Braced {
    def leftBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def accessors: AccessorDeclListSyntax | CodeBlockItemListSyntax = json("children").arr.toList
      .find(_("name").str == "accessors")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AccessorDeclListSyntax | CodeBlockItemListSyntax]

    def rightBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``AccessorDeclSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``AccessorBlockSyntax``.``AccessorBlockSyntax/accessors``
    */
  case class AccessorDeclListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[AccessorDeclSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[AccessorDeclSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifier`: ``DeclModifierSyntax``?
    *   - `accessorSpecifier`: (`get` | `set` | `didSet` | `willSet` | `unsafeAddress` | `addressWithOwner` |
    *     `addressWithNativeOwner` | `unsafeMutableAddress` | `mutableAddressWithOwner` |
    *     `mutableAddressWithNativeOwner` | `_read` | `_modify` | `init`)
    *   - `parameters`: ``AccessorParametersSyntax``?
    *   - `effectSpecifiers`: ``AccessorEffectSpecifiersSyntax``?
    *   - `body`: ``CodeBlockSyntax``?
    *
    * ### Contained in
    *
    *   - ``AccessorDeclListSyntax``
    */
  case class AccessorDeclSyntax(json: Value) extends DeclSyntax with WithOptionalCodeBlock with WithAttributes {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifier: Option[DeclModifierSyntax] = json("children").arr.toList
      .find(_("name").str == "modifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[DeclModifierSyntax])

    def accessorSpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "accessorSpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def parameters: Option[AccessorParametersSyntax] = json("children").arr.toList
      .find(_("name").str == "parameters")
      .map(createSwiftNode)
      .map(_.asInstanceOf[AccessorParametersSyntax])

    def effectSpecifiers: Option[AccessorEffectSpecifiersSyntax] = json("children").arr.toList
      .find(_("name").str == "effectSpecifiers")
      .map(createSwiftNode)
      .map(_.asInstanceOf[AccessorEffectSpecifiersSyntax])

    def body: Option[CodeBlockSyntax] = json("children").arr.toList
      .find(_("name").str == "body")
      .map(createSwiftNode)
      .map(_.asInstanceOf[CodeBlockSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `asyncSpecifier`: `async`?
    *   - `throwsClause`: ``ThrowsClauseSyntax``?
    *
    * ### Contained in
    *
    *   - ``AccessorDeclSyntax``.``AccessorDeclSyntax/effectSpecifiers``
    */
  case class AccessorEffectSpecifiersSyntax(json: Value) extends Syntax with EffectSpecifiers {
    def asyncSpecifier: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "asyncSpecifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def throwsClause: Option[ThrowsClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "throwsClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ThrowsClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `name`: `<identifier>`
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``AccessorDeclSyntax``.``AccessorDeclSyntax/parameters``
    */
  case class AccessorParametersSyntax(json: Value) extends Syntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `actorKeyword`: `actor`
    *   - `name`: `<identifier>`
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `inheritanceClause`: ``InheritanceClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `memberBlock`: ``MemberBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class ActorDeclSyntax(json: Value)
      extends DeclSyntax
      with DeclGroup
      with NamedDecl
      with WithAttributes
      with WithGenericParameters
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def actorKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "actorKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def inheritanceClause: Option[InheritanceClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritanceClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InheritanceClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def memberBlock: MemberBlockSyntax = json("children").arr.toList
      .find(_("name").str == "memberBlock")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MemberBlockSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``ArrayElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``ArrayExprSyntax``.``ArrayExprSyntax/elements``
    */
  case class ArrayElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ArrayElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ArrayElementSyntax])
  }

  /** ### Documentation
    *
    * An element inside an array literal.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``ArrayElementListSyntax``
    */
  case class ArrayElementSyntax(json: Value) extends Syntax with WithTrailingComma {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * An array literal.
    *
    * ### Children
    *
    *   - `leftSquare`: `[`
    *   - `elements`: ``ArrayElementListSyntax``
    *   - `rightSquare`: `]`
    *
    * ### Nowhere contained in
    */
  case class ArrayExprSyntax(json: Value) extends ExprSyntax {
    def leftSquare: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftSquare").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def elements: ArrayElementListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ArrayElementListSyntax]

    def rightSquare: SwiftToken = json("children").arr.toList
      .find(_("name").str == "rightSquare")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftSquare`: `[`
    *   - `element`: ``TypeSyntax``
    *   - `rightSquare`: `]`
    *
    * ### Nowhere contained in
    */
  case class ArrayTypeSyntax(json: Value) extends TypeSyntax {
    def leftSquare: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftSquare").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def element: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "element").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def rightSquare: SwiftToken = json("children").arr.toList
      .find(_("name").str == "rightSquare")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * The arrow when a type is used at a position that syntactically expectes an expression.
    *
    * ### Examples
    *
    * This represents the arrow in
    *
    * {{{
    * let array = [(Int) -> Int]()
    * }}}
    *
    * ### Children
    *
    *   - `effectSpecifiers`: ``TypeEffectSpecifiersSyntax``?
    *   - `arrow`: `->`
    *
    * ### Nowhere contained in
    */
  case class ArrowExprSyntax(json: Value) extends ExprSyntax {
    def effectSpecifiers: Option[TypeEffectSpecifiersSyntax] = json("children").arr.toList
      .find(_("name").str == "effectSpecifiers")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeEffectSpecifiersSyntax])

    def arrow: SwiftToken =
      json("children").arr.toList.find(_("name").str == "arrow").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * The cast of an expressison to a different type.
    *
    * ### Examples
    *
    * {{{
    * dog as Animal
    * }}}
    *
    * {{{
    * myPet as? Dog
    * }}}
    *
    *   - Note: This node is only generated after operators are folded using the `SwiftOperators` library. Beforehand,
    *     the parser does not know the precedences of operators and thus represents `is` by an
    *     ``UnresolvedAsExprSyntax``.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `asKeyword`: `as`
    *   - `questionOrExclamationMark`: (`?` | `!`)?
    *   - `type`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class AsExprSyntax(json: Value) extends ExprSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def asKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "asKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def questionOrExclamationMark: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "questionOrExclamationMark")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `equal`: `=`
    *
    * ### Nowhere contained in
    */
  case class AssignmentExprSyntax(json: Value) extends ExprSyntax {
    def equal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "equal").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * An `associatedtype` declaration
    *
    * An example of an associatedtype declaration is
    *
    * {{{
    * associatedtype Item
    * }}}
    *
    * An associated type declaration may contain a type initializer clause which represents a default type assignment
    * for the associated type.
    *
    * {{{
    * associatedtype Item = Int
    * }}}
    *
    * An associated type declaration may be declared with an inheritance clause which specifies the required
    * conformances.
    *
    * {{{
    * associatedtype Iterator: IteratorProtocol
    * }}}
    *
    * A generic where clause may be present, here is an example which shows an associated type containing an inheritance
    * clauses and a generic where clause.
    *
    * {{{
    * associatedtype Iterator: IteratorProtocol where Iterator.Element == Item
    * }}}
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `associatedtypeKeyword`: `associatedtype`
    *   - `name`: `<identifier>`
    *   - `inheritanceClause`: ``InheritanceClauseSyntax``?
    *   - `initializer`: ``TypeInitializerClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *
    * ### Nowhere contained in
    */
  case class AssociatedTypeDeclSyntax(json: Value)
      extends DeclSyntax
      with NamedDecl
      with WithAttributes
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def associatedtypeKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "associatedtypeKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def inheritanceClause: Option[InheritanceClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritanceClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InheritanceClauseSyntax])

    def initializer: Option[TypeInitializerClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "initializer")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeInitializerClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])
  }

  /** ### Documentation
    *
    * A list of attributes that can be attached to a declaration.
    *
    * An element in this collection can either be an attribute itself or an ``IfConfigDeclSyntax`` that contains
    * attributes. This is because attributes can be added conditional on compilcation conditions, for example.
    *
    * {{{
    * #if !DISABLE_DEPRECATIONS
    * @available(*, deprecated)
    * #endif
    * func myFunction() {}
    * }}}
    *
    * ### Children
    *
    * (``AttributeSyntax`` | ``IfConfigDeclSyntax``) `*`
    *
    * ### Contained in
    *
    *   - ``AccessorDeclSyntax``.``AccessorDeclSyntax/attributes``
    *   - ``ActorDeclSyntax``.``ActorDeclSyntax/attributes``
    *   - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/attributes``
    *   - ``AttributedTypeSyntax``.``AttributedTypeSyntax/attributes``
    *   - ``ClassDeclSyntax``.``ClassDeclSyntax/attributes``
    *   - ``ClosureParameterSyntax``.``ClosureParameterSyntax/attributes``
    *   - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/attributes``
    *   - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/attributes``
    *   - ``EditorPlaceholderDeclSyntax``.``EditorPlaceholderDeclSyntax/attributes``
    *   - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/attributes``
    *   - ``EnumDeclSyntax``.``EnumDeclSyntax/attributes``
    *   - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/attributes``
    *   - ``FunctionDeclSyntax``.``FunctionDeclSyntax/attributes``
    *   - ``FunctionParameterSyntax``.``FunctionParameterSyntax/attributes``
    *   - ``GenericParameterSyntax``.``GenericParameterSyntax/attributes``
    *   - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
    *   - ``ImportDeclSyntax``.``ImportDeclSyntax/attributes``
    *   - ``InitializerDeclSyntax``.``InitializerDeclSyntax/attributes``
    *   - ``MacroDeclSyntax``.``MacroDeclSyntax/attributes``
    *   - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/attributes``
    *   - ``MissingDeclSyntax``.``MissingDeclSyntax/attributes``
    *   - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/attributes``
    *   - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/attributes``
    *   - ``StructDeclSyntax``.``StructDeclSyntax/attributes``
    *   - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/attributes``
    *   - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/attributes``
    *   - ``VariableDeclSyntax``.``VariableDeclSyntax/attributes``
    */
  case class AttributeListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[AttributeSyntax | IfConfigDeclSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[AttributeSyntax | IfConfigDeclSyntax])
  }

  /** ### Documentation
    *
    * An `@` attribute.
    *
    * ### Children
    *
    *   - `atSign`: `@`
    *   - `attributeName`: ``TypeSyntax``
    *   - `leftParen`: `(`?
    *   - `arguments`: (``LabeledExprListSyntax`` | ``TokenSyntax`` | ``StringLiteralExprSyntax`` |
    *     ``AvailabilityArgumentListSyntax`` | ``SpecializeAttributeArgumentListSyntax`` |
    *     ``ObjCSelectorPieceListSyntax`` | ``ImplementsAttributeArgumentsSyntax`` |
    *     ``DifferentiableAttributeArgumentsSyntax`` | ``DerivativeAttributeArgumentsSyntax`` |
    *     ``BackDeployedAttributeArgumentsSyntax`` | ``ConventionAttributeArgumentsSyntax`` |
    *     ``ConventionWitnessMethodAttributeArgumentsSyntax`` | ``OpaqueReturnTypeOfAttributeArgumentsSyntax`` |
    *     ``ExposeAttributeArgumentsSyntax`` | ``OriginallyDefinedInAttributeArgumentsSyntax`` |
    *     ``UnderscorePrivateAttributeArgumentsSyntax`` | ``DynamicReplacementAttributeArgumentsSyntax`` |
    *     ``UnavailableFromAsyncAttributeArgumentsSyntax`` | ``EffectsAttributeArgumentListSyntax`` |
    *     ``DocumentationAttributeArgumentListSyntax``)?
    *   - `rightParen`: `)`?
    *
    * ### Contained in
    *
    *   - ``AttributeListSyntax``
    *   - ``SwitchCaseSyntax``.``SwitchCaseSyntax/attribute``
    */
  case class AttributeSyntax(json: Value) extends Syntax {
    def atSign: SwiftToken =
      json("children").arr.toList.find(_("name").str == "atSign").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def attributeName: TypeSyntax = json("children").arr.toList
      .find(_("name").str == "attributeName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TypeSyntax]

    def leftParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "leftParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def arguments: Option[
      LabeledExprListSyntax | TokenSyntax | StringLiteralExprSyntax | AvailabilityArgumentListSyntax |
        SpecializeAttributeArgumentListSyntax | ObjCSelectorPieceListSyntax | ImplementsAttributeArgumentsSyntax |
        DifferentiableAttributeArgumentsSyntax | DerivativeAttributeArgumentsSyntax |
        BackDeployedAttributeArgumentsSyntax | ConventionAttributeArgumentsSyntax |
        ConventionWitnessMethodAttributeArgumentsSyntax | OpaqueReturnTypeOfAttributeArgumentsSyntax |
        ExposeAttributeArgumentsSyntax | OriginallyDefinedInAttributeArgumentsSyntax |
        UnderscorePrivateAttributeArgumentsSyntax | DynamicReplacementAttributeArgumentsSyntax |
        UnavailableFromAsyncAttributeArgumentsSyntax | EffectsAttributeArgumentListSyntax |
        DocumentationAttributeArgumentListSyntax
    ] = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .map(
        _.asInstanceOf[
          LabeledExprListSyntax | TokenSyntax | StringLiteralExprSyntax | AvailabilityArgumentListSyntax |
            SpecializeAttributeArgumentListSyntax | ObjCSelectorPieceListSyntax | ImplementsAttributeArgumentsSyntax |
            DifferentiableAttributeArgumentsSyntax | DerivativeAttributeArgumentsSyntax |
            BackDeployedAttributeArgumentsSyntax | ConventionAttributeArgumentsSyntax |
            ConventionWitnessMethodAttributeArgumentsSyntax | OpaqueReturnTypeOfAttributeArgumentsSyntax |
            ExposeAttributeArgumentsSyntax | OriginallyDefinedInAttributeArgumentsSyntax |
            UnderscorePrivateAttributeArgumentsSyntax | DynamicReplacementAttributeArgumentsSyntax |
            UnavailableFromAsyncAttributeArgumentsSyntax | EffectsAttributeArgumentListSyntax |
            DocumentationAttributeArgumentListSyntax
        ]
      )

    def rightParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "rightParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `specifiers`: ``TypeSpecifierListSyntax``
    *   - `attributes`: ``AttributeListSyntax``
    *   - `baseType`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class AttributedTypeSyntax(json: Value) extends TypeSyntax with WithAttributes {
    def specifiers: TypeSpecifierListSyntax = json("children").arr.toList
      .find(_("name").str == "specifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TypeSpecifierListSyntax]

    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def baseType: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "baseType").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``AvailabilityArgumentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    *   - ``AvailabilityConditionSyntax``.``AvailabilityConditionSyntax/availabilityArguments``
    *   - ``SpecializeAvailabilityArgumentSyntax``.``SpecializeAvailabilityArgumentSyntax/availabilityArguments``
    */
  case class AvailabilityArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[AvailabilityArgumentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[AvailabilityArgumentSyntax])
  }

  /** ### Documentation
    *
    * A single argument to an `@available` argument like `*`, `iOS 10.1`, or `message: "This has been deprecated"`.
    *
    * ### Children
    *
    *   - `argument`: ((`<binaryOperator>` | `<identifier>`) | ``PlatformVersionSyntax`` |
    *     ``AvailabilityLabeledArgumentSyntax``)
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``AvailabilityArgumentListSyntax``
    */
  case class AvailabilityArgumentSyntax(json: Value) extends Syntax with WithTrailingComma {
    def argument: SwiftToken | PlatformVersionSyntax | AvailabilityLabeledArgumentSyntax = json("children").arr.toList
      .find(_("name").str == "argument")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken | PlatformVersionSyntax | AvailabilityLabeledArgumentSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `availabilityKeyword`: (`#available` | `#unavailable`)
    *   - `leftParen`: `(`
    *   - `availabilityArguments`: ``AvailabilityArgumentListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``ConditionElementSyntax``.``ConditionElementSyntax/condition``
    */
  case class AvailabilityConditionSyntax(json: Value) extends Syntax {
    def availabilityKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "availabilityKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def availabilityArguments: AvailabilityArgumentListSyntax = json("children").arr.toList
      .find(_("name").str == "availabilityArguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AvailabilityArgumentListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * An argument to an `@available` attribute that consists of a label and a value, e.g. `message: "This has been
    * deprecated"`.
    *
    * ### Children
    *
    *   - `label`: (`message` | `renamed` | `introduced` | `obsoleted` | `deprecated`)
    *   - `colon`: `:`
    *   - `value`: (``SimpleStringLiteralExprSyntax`` | ``VersionTupleSyntax``)
    *
    * ### Contained in
    *
    *   - ``AvailabilityArgumentSyntax``.``AvailabilityArgumentSyntax/argument``
    */
  case class AvailabilityLabeledArgumentSyntax(json: Value) extends Syntax {
    def label: SwiftToken =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: SimpleStringLiteralExprSyntax | VersionTupleSyntax = json("children").arr.toList
      .find(_("name").str == "value")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SimpleStringLiteralExprSyntax | VersionTupleSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `awaitKeyword`: `await`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class AwaitExprSyntax(json: Value) extends ExprSyntax {
    def awaitKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "awaitKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * A collection of arguments for the `@backDeployed` attribute
    *
    * ### Children
    *
    *   - `beforeLabel`: `before`
    *   - `colon`: `:`
    *   - `platforms`: ``PlatformVersionItemListSyntax``
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class BackDeployedAttributeArgumentsSyntax(json: Value) extends Syntax {
    def beforeLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "beforeLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def platforms: PlatformVersionItemListSyntax = json("children").arr.toList
      .find(_("name").str == "platforms")
      .map(createSwiftNode)
      .head
      .asInstanceOf[PlatformVersionItemListSyntax]
  }

  /** ### Documentation
    *
    * An operator like `+` or `-`.
    *
    * This node represents the binary operator itself. It can occur inside a ``SequenceExprSyntax`` after parsing and
    * will be the `operator` child of an ``InfixOperatorExprSyntax`` after folding operator using the `SwiftOperators`
    * library.
    *
    * ### Children
    *
    *   - `operator`: `<binaryOperator>`
    *
    * ### Nowhere contained in
    */
  case class BinaryOperatorExprSyntax(json: Value) extends ExprSyntax {
    def operator: SwiftToken =
      json("children").arr.toList.find(_("name").str == "operator").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `literal`: (`true` | `false`)
    *
    * ### Nowhere contained in
    */
  case class BooleanLiteralExprSyntax(json: Value) extends ExprSyntax {
    def literal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "literal").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `borrowKeyword`: `_borrow`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class BorrowExprSyntax(json: Value) extends ExprSyntax {
    def borrowKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "borrowKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `breakKeyword`: `break`
    *   - `label`: `<identifier>`?
    *
    * ### Nowhere contained in
    */
  case class BreakStmtSyntax(json: Value) extends StmtSyntax {
    def breakKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "breakKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def label: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `canImportKeyword`: `canImport`
    *   - `leftParen`: `(`
    *   - `importPath`: `<identifier>`
    *   - `versionInfo`: ``CanImportVersionInfoSyntax``?
    *   - `rightParen`: `)`
    *
    * ### Nowhere contained in
    */
  case class CanImportExprSyntax(json: Value) extends ExprSyntax {
    def canImportKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "canImportKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def importPath: SwiftToken =
      json("children").arr.toList.find(_("name").str == "importPath").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def versionInfo: Option[CanImportVersionInfoSyntax] = json("children").arr.toList
      .find(_("name").str == "versionInfo")
      .map(createSwiftNode)
      .map(_.asInstanceOf[CanImportVersionInfoSyntax])

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `comma`: `,`
    *   - `label`: (`_version` | `_underlyingVersion`)
    *   - `colon`: `:`
    *   - `version`: ``VersionTupleSyntax``
    *
    * ### Contained in
    *
    *   - ``CanImportExprSyntax``.``CanImportExprSyntax/versionInfo``
    */
  case class CanImportVersionInfoSyntax(json: Value) extends ExprSyntax {
    def comma: SwiftToken =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def label: SwiftToken =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def version: VersionTupleSyntax = json("children").arr.toList
      .find(_("name").str == "version")
      .map(createSwiftNode)
      .head
      .asInstanceOf[VersionTupleSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``CatchClauseSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``DoStmtSyntax``.``DoStmtSyntax/catchClauses``
    */
  case class CatchClauseListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[CatchClauseSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[CatchClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `catchKeyword`: `catch`
    *   - `catchItems`: ``CatchItemListSyntax``
    *   - `body`: ``CodeBlockSyntax``
    *
    * ### Contained in
    *
    *   - ``CatchClauseListSyntax``
    */
  case class CatchClauseSyntax(json: Value) extends Syntax with WithCodeBlock {
    def catchKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "catchKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def catchItems: CatchItemListSyntax = json("children").arr.toList
      .find(_("name").str == "catchItems")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CatchItemListSyntax]

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``CatchItemSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``CatchClauseSyntax``.``CatchClauseSyntax/catchItems``
    */
  case class CatchItemListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[CatchItemSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[CatchItemSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `pattern`: ``PatternSyntax``?
    *   - `whereClause`: ``WhereClauseSyntax``?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``CatchItemListSyntax``
    */
  case class CatchItemSyntax(json: Value) extends Syntax with WithTrailingComma {
    def pattern: Option[PatternSyntax] = json("children").arr.toList
      .find(_("name").str == "pattern")
      .map(createSwiftNode)
      .map(_.asInstanceOf[PatternSyntax])

    def whereClause: Option[WhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "whereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[WhereClauseSyntax])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A `class` declaration
    *
    * An example of a class declaration is
    *
    * {{{
    * class SomeClass {
    *   let someMember: String
    *
    *   init(someMember: String) {
    *     self.someMember = someMember
    *   }
    *
    *   func foo() {
    *     print(someMember)
    *   }
    *
    *   static func bar() -> Int {
    *     return 1
    *   }
    * }
    * }}}
    *
    * A class declaration may be declared without any members.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `classKeyword`: `class`
    *   - `name`: `<identifier>`
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `inheritanceClause`: ``InheritanceClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `memberBlock`: ``MemberBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class ClassDeclSyntax(json: Value)
      extends DeclSyntax
      with DeclGroup
      with NamedDecl
      with WithAttributes
      with WithGenericParameters
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def classKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "classKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def inheritanceClause: Option[InheritanceClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritanceClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InheritanceClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def memberBlock: MemberBlockSyntax = json("children").arr.toList
      .find(_("name").str == "memberBlock")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MemberBlockSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `classKeyword`: `class`
    *
    * ### Nowhere contained in
    */
  case class ClassRestrictionTypeSyntax(json: Value) extends TypeSyntax {
    def classKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "classKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftSquare`: `[`
    *   - `items`: ``ClosureCaptureListSyntax``
    *   - `rightSquare`: `]`
    *
    * ### Contained in
    *
    *   - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/capture``
    */
  case class ClosureCaptureClauseSyntax(json: Value) extends Syntax {
    def leftSquare: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftSquare").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def items: ClosureCaptureListSyntax = json("children").arr.toList
      .find(_("name").str == "items")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ClosureCaptureListSyntax]

    def rightSquare: SwiftToken = json("children").arr.toList
      .find(_("name").str == "rightSquare")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``ClosureCaptureSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``ClosureCaptureClauseSyntax``.``ClosureCaptureClauseSyntax/items``
    */
  case class ClosureCaptureListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ClosureCaptureSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ClosureCaptureSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `specifier`: (`weak` | `unowned`)
    *   - `leftParen`: `(`?
    *   - `detail`: (`safe` | `unsafe`)?
    *   - `rightParen`: `)`?
    *
    * ### Contained in
    *
    *   - ``ClosureCaptureSyntax``.``ClosureCaptureSyntax/specifier``
    */
  case class ClosureCaptureSpecifierSyntax(json: Value) extends Syntax {
    def specifier: SwiftToken =
      json("children").arr.toList.find(_("name").str == "specifier").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def leftParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "leftParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def detail: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "detail").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def rightParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "rightParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `specifier`: ``ClosureCaptureSpecifierSyntax``?
    *   - `name`: `<identifier>`?
    *   - `equal`: `=`?
    *   - `expression`: ``ExprSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``ClosureCaptureListSyntax``
    */
  case class ClosureCaptureSyntax(json: Value) extends Syntax with WithTrailingComma {
    def specifier: Option[ClosureCaptureSpecifierSyntax] = json("children").arr.toList
      .find(_("name").str == "specifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ClosureCaptureSpecifierSyntax])

    def name: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def equal: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "equal").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftBrace`: `{`
    *   - `signature`: ``ClosureSignatureSyntax``?
    *   - `statements`: ``CodeBlockItemListSyntax``
    *   - `rightBrace`: `}`
    *
    * ### Contained in
    *
    *   - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/trailingClosure``
    *   - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/trailingClosure``
    *   - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/trailingClosure``
    *   - ``MultipleTrailingClosureElementSyntax``.``MultipleTrailingClosureElementSyntax/closure``
    *   - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/trailingClosure``
    */
  case class ClosureExprSyntax(json: Value) extends ExprSyntax with Braced with WithStatements {
    def leftBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def signature: Option[ClosureSignatureSyntax] = json("children").arr.toList
      .find(_("name").str == "signature")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ClosureSignatureSyntax])

    def statements: CodeBlockItemListSyntax = json("children").arr.toList
      .find(_("name").str == "statements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CodeBlockItemListSyntax]

    def rightBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `parameters`: ``ClosureParameterListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/parameterClause``
    */
  case class ClosureParameterClauseSyntax(json: Value) extends Syntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def parameters: ClosureParameterListSyntax = json("children").arr.toList
      .find(_("name").str == "parameters")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ClosureParameterListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``ClosureParameterSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``ClosureParameterClauseSyntax``.``ClosureParameterClauseSyntax/parameters``
    */
  case class ClosureParameterListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ClosureParameterSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ClosureParameterSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `firstName`: (`<identifier>` | `_`)
    *   - `secondName`: (`<identifier>` | `_`)?
    *   - `colon`: `:`?
    *   - `type`: ``TypeSyntax``?
    *   - `ellipsis`: `...`?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``ClosureParameterListSyntax``
    */
  case class ClosureParameterSyntax(json: Value)
      extends Syntax
      with WithTrailingComma
      with WithAttributes
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def firstName: SwiftToken =
      json("children").arr.toList.find(_("name").str == "firstName").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def secondName: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "secondName")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def `type`: Option[TypeSyntax] =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).map(_.asInstanceOf[TypeSyntax])

    def ellipsis: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "ellipsis").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A list of closure parameters that are not parenthesized and don't have type annotations.
    *
    * If the closure parameters are parenthesized, they can also carry type annotations. In that case, the closure
    * parameters are represented by ``ClosureParameterListSyntax``.
    *
    * ### Examples
    *
    * }}} let closure = { a, b in return a + b } }}}
    *
    * ### Children
    *
    * ``ClosureShorthandParameterSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/parameterClause``
    */
  case class ClosureShorthandParameterListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ClosureShorthandParameterSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ClosureShorthandParameterSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `name`: (`<identifier>` | `_`)
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``ClosureShorthandParameterListSyntax``
    */
  case class ClosureShorthandParameterSyntax(json: Value) extends Syntax with WithTrailingComma {
    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `capture`: ``ClosureCaptureClauseSyntax``?
    *   - `parameterClause`: (``ClosureShorthandParameterListSyntax`` | ``ClosureParameterClauseSyntax``)?
    *   - `effectSpecifiers`: ``TypeEffectSpecifiersSyntax``?
    *   - `returnClause`: ``ReturnClauseSyntax``?
    *   - `inKeyword`: `in`
    *
    * ### Contained in
    *
    *   - ``ClosureExprSyntax``.``ClosureExprSyntax/signature``
    */
  case class ClosureSignatureSyntax(json: Value) extends Syntax with WithAttributes {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def capture: Option[ClosureCaptureClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "capture")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ClosureCaptureClauseSyntax])

    def parameterClause: Option[ClosureShorthandParameterListSyntax | ClosureParameterClauseSyntax] =
      json("children").arr.toList
        .find(_("name").str == "parameterClause")
        .map(createSwiftNode)
        .map(_.asInstanceOf[ClosureShorthandParameterListSyntax | ClosureParameterClauseSyntax])

    def effectSpecifiers: Option[TypeEffectSpecifiersSyntax] = json("children").arr.toList
      .find(_("name").str == "effectSpecifiers")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeEffectSpecifiersSyntax])

    def returnClause: Option[ReturnClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "returnClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ReturnClauseSyntax])

    def inKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "inKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``CodeBlockItemSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``AccessorBlockSyntax``.``AccessorBlockSyntax/accessors``
    *   - ``ClosureExprSyntax``.``ClosureExprSyntax/statements``
    *   - ``CodeBlockSyntax``.``CodeBlockSyntax/statements``
    *   - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
    *   - ``SourceFileSyntax``.``SourceFileSyntax/statements``
    *   - ``SwitchCaseSyntax``.``SwitchCaseSyntax/statements``
    */
  case class CodeBlockItemListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[CodeBlockItemSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[CodeBlockItemSyntax])
  }

  /** ### Documentation
    *
    * A CodeBlockItem is any Syntax node that appears on its own line inside a CodeBlock.
    *
    * ### Children
    *
    *   - `item`: (``DeclSyntax`` | ``StmtSyntax`` | ``ExprSyntax``)
    *   - `semicolon`: `;`?
    *
    * ### Contained in
    *
    *   - ``CodeBlockItemListSyntax``
    */
  case class CodeBlockItemSyntax(json: Value) extends Syntax {
    def item: DeclSyntax | StmtSyntax | ExprSyntax = json("children").arr.toList
      .find(_("name").str == "item")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclSyntax | StmtSyntax | ExprSyntax]

    def semicolon: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "semicolon")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftBrace`: `{`
    *   - `statements`: ``CodeBlockItemListSyntax``
    *   - `rightBrace`: `}`
    *
    * ### Contained in
    *
    *   - ``AccessorDeclSyntax``.``AccessorDeclSyntax/body``
    *   - ``CatchClauseSyntax``.``CatchClauseSyntax/body``
    *   - ``DeferStmtSyntax``.``DeferStmtSyntax/body``
    *   - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/body``
    *   - ``DoStmtSyntax``.``DoStmtSyntax/body``
    *   - ``ForStmtSyntax``.``ForStmtSyntax/body``
    *   - ``FunctionDeclSyntax``.``FunctionDeclSyntax/body``
    *   - ``GuardStmtSyntax``.``GuardStmtSyntax/body``
    *   - ``IfExprSyntax``.``IfExprSyntax/body``
    *   - ``IfExprSyntax``.``IfExprSyntax/elseBody``
    *   - ``InitializerDeclSyntax``.``InitializerDeclSyntax/body``
    *   - ``RepeatStmtSyntax``.``RepeatStmtSyntax/body``
    *   - ``WhileStmtSyntax``.``WhileStmtSyntax/body``
    */
  case class CodeBlockSyntax(json: Value) extends Syntax with Braced with WithStatements {
    def leftBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def statements: CodeBlockItemListSyntax = json("children").arr.toList
      .find(_("name").str == "statements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CodeBlockItemListSyntax]

    def rightBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``CompositionTypeElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``CompositionTypeSyntax``.``CompositionTypeSyntax/elements``
    */
  case class CompositionTypeElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[CompositionTypeElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[CompositionTypeElementSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `type`: ``TypeSyntax``
    *   - `ampersand`: ``TokenSyntax``?
    *
    * ### Contained in
    *
    *   - ``CompositionTypeElementListSyntax``
    */
  case class CompositionTypeElementSyntax(json: Value) extends Syntax {
    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def ampersand: Option[TokenSyntax] = json("children").arr.toList
      .find(_("name").str == "ampersand")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TokenSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `elements`: ``CompositionTypeElementListSyntax``
    *
    * ### Nowhere contained in
    */
  case class CompositionTypeSyntax(json: Value) extends TypeSyntax {
    def elements: CompositionTypeElementListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CompositionTypeElementListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``ConditionElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``GuardStmtSyntax``.``GuardStmtSyntax/conditions``
    *   - ``IfExprSyntax``.``IfExprSyntax/conditions``
    *   - ``WhileStmtSyntax``.``WhileStmtSyntax/conditions``
    */
  case class ConditionElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ConditionElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ConditionElementSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `condition`: (``ExprSyntax`` | ``AvailabilityConditionSyntax`` | ``MatchingPatternConditionSyntax`` |
    *     ``OptionalBindingConditionSyntax``)
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``ConditionElementListSyntax``
    */
  case class ConditionElementSyntax(json: Value) extends Syntax with WithTrailingComma {
    def condition: ExprSyntax | AvailabilityConditionSyntax | MatchingPatternConditionSyntax |
      OptionalBindingConditionSyntax = json("children").arr.toList
      .find(_("name").str == "condition")
      .map(createSwiftNode)
      .head
      .asInstanceOf[
        ExprSyntax | AvailabilityConditionSyntax | MatchingPatternConditionSyntax | OptionalBindingConditionSyntax
      ]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftType`: ``TypeSyntax``
    *   - `colon`: `:`
    *   - `rightType`: ``TypeSyntax``
    *
    * ### Contained in
    *
    *   - ``GenericRequirementSyntax``.``GenericRequirementSyntax/requirement``
    */
  case class ConformanceRequirementSyntax(json: Value) extends Syntax {
    def leftType: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "leftType").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def rightType: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "rightType").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `consumeKeyword`: (`_move` | `consume`)
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class ConsumeExprSyntax(json: Value) extends ExprSyntax {
    def consumeKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "consumeKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `continueKeyword`: `continue`
    *   - `label`: `<identifier>`?
    *
    * ### Nowhere contained in
    */
  case class ContinueStmtSyntax(json: Value) extends StmtSyntax {
    def continueKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "continueKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def label: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * The arguments for the '@convention(...)'.
    *
    * ### Children
    *
    *   - `conventionLabel`: `<identifier>`
    *   - `comma`: `,`?
    *   - `cTypeLabel`: `cType`?
    *   - `colon`: `:`?
    *   - `cTypeString`: ``StringLiteralExprSyntax``?
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class ConventionAttributeArgumentsSyntax(json: Value) extends Syntax {
    def conventionLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "conventionLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def comma: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def cTypeLabel: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "cTypeLabel")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def cTypeString: Option[StringLiteralExprSyntax] = json("children").arr.toList
      .find(_("name").str == "cTypeString")
      .map(createSwiftNode)
      .map(_.asInstanceOf[StringLiteralExprSyntax])
  }

  /** ### Documentation
    *
    * The arguments for the '@convention(witness_method: ...)'.
    *
    * ### Children
    *
    *   - `witnessMethodLabel`: `witness_method`
    *   - `colon`: `:`
    *   - `protocolName`: `<identifier>`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class ConventionWitnessMethodAttributeArgumentsSyntax(json: Value) extends Syntax {
    def witnessMethodLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "witnessMethodLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def protocolName: SwiftToken = json("children").arr.toList
      .find(_("name").str == "protocolName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `copyKeyword`: `copy`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class CopyExprSyntax(json: Value) extends ExprSyntax {
    def copyKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "copyKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `detail`: `<identifier>`
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``DeclModifierSyntax``.``DeclModifierSyntax/detail``
    */
  case class DeclModifierDetailSyntax(json: Value) extends Syntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def detail: SwiftToken =
      json("children").arr.toList.find(_("name").str == "detail").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``DeclModifierSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``ActorDeclSyntax``.``ActorDeclSyntax/modifiers``
    *   - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/modifiers``
    *   - ``ClassDeclSyntax``.``ClassDeclSyntax/modifiers``
    *   - ``ClosureParameterSyntax``.``ClosureParameterSyntax/modifiers``
    *   - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/modifiers``
    *   - ``EditorPlaceholderDeclSyntax``.``EditorPlaceholderDeclSyntax/modifiers``
    *   - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/modifiers``
    *   - ``EnumCaseParameterSyntax``.``EnumCaseParameterSyntax/modifiers``
    *   - ``EnumDeclSyntax``.``EnumDeclSyntax/modifiers``
    *   - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/modifiers``
    *   - ``FunctionDeclSyntax``.``FunctionDeclSyntax/modifiers``
    *   - ``FunctionParameterSyntax``.``FunctionParameterSyntax/modifiers``
    *   - ``ImportDeclSyntax``.``ImportDeclSyntax/modifiers``
    *   - ``InitializerDeclSyntax``.``InitializerDeclSyntax/modifiers``
    *   - ``MacroDeclSyntax``.``MacroDeclSyntax/modifiers``
    *   - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/modifiers``
    *   - ``MissingDeclSyntax``.``MissingDeclSyntax/modifiers``
    *   - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/modifiers``
    *   - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/modifiers``
    *   - ``StructDeclSyntax``.``StructDeclSyntax/modifiers``
    *   - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/modifiers``
    *   - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/modifiers``
    *   - ``VariableDeclSyntax``.``VariableDeclSyntax/modifiers``
    */
  case class DeclModifierListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[DeclModifierSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[DeclModifierSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `name`: (`__consuming` | `__setter_access` | `_const` | `_local` | `actor` | `async` | `borrowing` | `class` |
    *     `consuming` | `convenience` | `distributed` | `dynamic` | `fileprivate` | `final` | `indirect` | `infix` |
    *     `internal` | `isolated` | `lazy` | `mutating` | `nonisolated` | `nonmutating` | `open` | `optional` |
    *     `override` | `package` | `postfix` | `prefix` | `private` | `public` | `reasync` | `_resultDependsOnSelf` |
    *     `required` | `static` | `transferring` | `unowned` | `weak`)
    *   - `detail`: ``DeclModifierDetailSyntax``?
    *
    * ### Contained in
    *
    *   - ``AccessorDeclSyntax``.``AccessorDeclSyntax/modifier``
    *   - ``DeclModifierListSyntax``
    */
  case class DeclModifierSyntax(json: Value) extends Syntax {
    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def detail: Option[DeclModifierDetailSyntax] = json("children").arr.toList
      .find(_("name").str == "detail")
      .map(createSwiftNode)
      .map(_.asInstanceOf[DeclModifierDetailSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``DeclNameArgumentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``DeclNameArgumentsSyntax``.``DeclNameArgumentsSyntax/arguments``
    */
  case class DeclNameArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[DeclNameArgumentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[DeclNameArgumentSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `name`: ``TokenSyntax``
    *   - `colon`: `:`
    *
    * ### Contained in
    *
    *   - ``DeclNameArgumentListSyntax``
    */
  case class DeclNameArgumentSyntax(json: Value) extends Syntax {
    def name: TokenSyntax =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[TokenSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `arguments`: ``DeclNameArgumentListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``DeclReferenceExprSyntax``.``DeclReferenceExprSyntax/argumentNames``
    */
  case class DeclNameArgumentsSyntax(json: Value) extends Syntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: DeclNameArgumentListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclNameArgumentListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `baseName`: (`<identifier>` | `self` | `Self` | `init` | `deinit` | `subscript` | `<dollarIdentifier>` |
    *     `<binaryOperator>` | `<integerLiteral>`)
    *   - `argumentNames`: ``DeclNameArgumentsSyntax``?
    *
    * ### Contained in
    *
    *   - ``DynamicReplacementAttributeArgumentsSyntax``.``DynamicReplacementAttributeArgumentsSyntax/declName``
    *   - ``ImplementsAttributeArgumentsSyntax``.``ImplementsAttributeArgumentsSyntax/declName``
    *   - ``KeyPathPropertyComponentSyntax``.``KeyPathPropertyComponentSyntax/declName``
    *   - ``MemberAccessExprSyntax``.``MemberAccessExprSyntax/declName``
    *   - ``SpecializeTargetFunctionArgumentSyntax``.``SpecializeTargetFunctionArgumentSyntax/declName``
    */
  case class DeclReferenceExprSyntax(json: Value) extends ExprSyntax {
    def baseName: SwiftToken =
      json("children").arr.toList.find(_("name").str == "baseName").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def argumentNames: Option[DeclNameArgumentsSyntax] = json("children").arr.toList
      .find(_("name").str == "argumentNames")
      .map(createSwiftNode)
      .map(_.asInstanceOf[DeclNameArgumentsSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `deferKeyword`: `defer`
    *   - `body`: ``CodeBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class DeferStmtSyntax(json: Value) extends StmtSyntax with WithCodeBlock {
    def deferKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "deferKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]
  }

  /** ### Documentation
    *
    * A `deint` declaration
    *
    * An example of a deinitializer is
    *
    * {{{
    * deinit {
    * }
    * }}}
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `deinitKeyword`: `deinit`
    *   - `effectSpecifiers`: ``DeinitializerEffectSpecifiersSyntax``?
    *   - `body`: ``CodeBlockSyntax``?
    *
    * ### Nowhere contained in
    */
  case class DeinitializerDeclSyntax(json: Value)
      extends DeclSyntax
      with WithAttributes
      with WithModifiers
      with WithOptionalCodeBlock {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def deinitKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "deinitKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def effectSpecifiers: Option[DeinitializerEffectSpecifiersSyntax] = json("children").arr.toList
      .find(_("name").str == "effectSpecifiers")
      .map(createSwiftNode)
      .map(_.asInstanceOf[DeinitializerEffectSpecifiersSyntax])

    def body: Option[CodeBlockSyntax] = json("children").arr.toList
      .find(_("name").str == "body")
      .map(createSwiftNode)
      .map(_.asInstanceOf[CodeBlockSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `asyncSpecifier`: `async`?
    *
    * ### Contained in
    *
    *   - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/effectSpecifiers``
    */
  case class DeinitializerEffectSpecifiersSyntax(json: Value) extends Syntax {
    def asyncSpecifier: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "asyncSpecifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * The arguments for the '@derivative(of:)' and '@transpose(of:)' attributes: the 'of:' label, the original
    * declaration name, and an optional differentiability parameter list.
    *
    * ### Children
    *
    *   - `ofLabel`: `of`
    *   - `colon`: `:`
    *   - `originalDeclName`: ``ExprSyntax``
    *   - `period`: `.`?
    *   - `accessorSpecifier`: (`get` | `set`)?
    *   - `comma`: `,`?
    *   - `arguments`: ``DifferentiabilityWithRespectToArgumentSyntax``?
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class DerivativeAttributeArgumentsSyntax(json: Value) extends Syntax {
    def ofLabel: SwiftToken =
      json("children").arr.toList.find(_("name").str == "ofLabel").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def originalDeclName: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "originalDeclName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]

    def period: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "period").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def accessorSpecifier: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "accessorSpecifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def comma: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def arguments: Option[DifferentiabilityWithRespectToArgumentSyntax] = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .map(_.asInstanceOf[DifferentiabilityWithRespectToArgumentSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``DesignatedTypeSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``OperatorPrecedenceAndTypesSyntax``.``OperatorPrecedenceAndTypesSyntax/designatedTypes``
    */
  case class DesignatedTypeListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[DesignatedTypeSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[DesignatedTypeSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leadingComma`: `,`
    *   - `name`: ``TokenSyntax``
    *
    * ### Contained in
    *
    *   - ``DesignatedTypeListSyntax``
    */
  case class DesignatedTypeSyntax(json: Value) extends Syntax {
    def leadingComma: SwiftToken = json("children").arr.toList
      .find(_("name").str == "leadingComma")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: TokenSyntax =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[TokenSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``DictionaryElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``DictionaryExprSyntax``.``DictionaryExprSyntax/content``
    */
  case class DictionaryElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[DictionaryElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[DictionaryElementSyntax])
  }

  /** ### Documentation
    *
    * An element inside a dictionary literal.
    *
    * ### Children
    *
    *   - `key`: ``ExprSyntax``
    *   - `colon`: `:`
    *   - `value`: ``ExprSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``DictionaryElementListSyntax``
    */
  case class DictionaryElementSyntax(json: Value) extends Syntax with WithTrailingComma {
    def key: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "key").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "value").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A dictionary literal
    *
    * ### Children
    *
    *   - `leftSquare`: `[`
    *   - `content`: (`:` | ``DictionaryElementListSyntax``)
    *   - `rightSquare`: `]`
    *
    * ### Nowhere contained in
    */
  case class DictionaryExprSyntax(json: Value) extends ExprSyntax {
    def leftSquare: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftSquare").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def content: SwiftToken | DictionaryElementListSyntax = json("children").arr.toList
      .find(_("name").str == "content")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken | DictionaryElementListSyntax]

    def rightSquare: SwiftToken = json("children").arr.toList
      .find(_("name").str == "rightSquare")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftSquare`: `[`
    *   - `key`: ``TypeSyntax``
    *   - `colon`: `:`
    *   - `value`: ``TypeSyntax``
    *   - `rightSquare`: `]`
    *
    * ### Nowhere contained in
    */
  case class DictionaryTypeSyntax(json: Value) extends TypeSyntax {
    def leftSquare: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftSquare").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def key: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "key").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "value").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def rightSquare: SwiftToken = json("children").arr.toList
      .find(_("name").str == "rightSquare")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``DifferentiabilityArgumentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``DifferentiabilityArgumentsSyntax``.``DifferentiabilityArgumentsSyntax/arguments``
    */
  case class DifferentiabilityArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[DifferentiabilityArgumentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[DifferentiabilityArgumentSyntax])
  }

  /** ### Documentation
    *
    * A differentiability argument: either the "self" identifier, a function parameter name, or a function parameter
    * index.
    *
    * ### Children
    *
    *   - `argument`: (`<identifier>` | `<integerLiteral>` | `self`)
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``DifferentiabilityArgumentListSyntax``
    *   - ``DifferentiabilityWithRespectToArgumentSyntax``.``DifferentiabilityWithRespectToArgumentSyntax/arguments``
    */
  case class DifferentiabilityArgumentSyntax(json: Value) extends Syntax with WithTrailingComma {
    def argument: SwiftToken =
      json("children").arr.toList.find(_("name").str == "argument").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * The differentiability arguments.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `arguments`: ``DifferentiabilityArgumentListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``DifferentiabilityWithRespectToArgumentSyntax``.``DifferentiabilityWithRespectToArgumentSyntax/arguments``
    */
  case class DifferentiabilityArgumentsSyntax(json: Value) extends Syntax {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: DifferentiabilityArgumentListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DifferentiabilityArgumentListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A clause containing differentiability parameters.
    *
    * ### Children
    *
    *   - `wrtLabel`: `wrt`
    *   - `colon`: `:`
    *   - `arguments`: (``DifferentiabilityArgumentSyntax`` | ``DifferentiabilityArgumentsSyntax``)
    *
    * ### Contained in
    *
    *   - ``DerivativeAttributeArgumentsSyntax``.``DerivativeAttributeArgumentsSyntax/arguments``
    *   - ``DifferentiableAttributeArgumentsSyntax``.``DifferentiableAttributeArgumentsSyntax/arguments``
    */
  case class DifferentiabilityWithRespectToArgumentSyntax(json: Value) extends Syntax {
    def wrtLabel: SwiftToken =
      json("children").arr.toList.find(_("name").str == "wrtLabel").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: DifferentiabilityArgumentSyntax | DifferentiabilityArgumentsSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DifferentiabilityArgumentSyntax | DifferentiabilityArgumentsSyntax]
  }

  /** ### Documentation
    *
    * The arguments for the `@differentiable` attribute: an optional differentiability kind, an optional
    * differentiability parameter clause, and an optional 'where' clause.
    *
    * ### Children
    *
    *   - `kindSpecifier`: (`_forward` | `reverse` | `_linear`)?
    *   - `kindSpecifierComma`: `,`?
    *   - `arguments`: ``DifferentiabilityWithRespectToArgumentSyntax``?
    *   - `argumentsComma`: `,`?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class DifferentiableAttributeArgumentsSyntax(json: Value) extends Syntax {
    def kindSpecifier: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "kindSpecifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def kindSpecifierComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "kindSpecifierComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def arguments: Option[DifferentiabilityWithRespectToArgumentSyntax] = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .map(_.asInstanceOf[DifferentiabilityWithRespectToArgumentSyntax])

    def argumentsComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "argumentsComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])
  }

  /** ### Documentation
    *
    * A `_` that discards a value inside an assignment.
    *
    * ### Examples
    *
    * {{{
    * _ = 42
    * }}}
    *
    * {{{
    * if case .foo(_) = myValue
    * }}}
    *
    * ### Children
    *
    *   - `wildcard`: `_`
    *
    * ### Nowhere contained in
    */
  case class DiscardAssignmentExprSyntax(json: Value) extends ExprSyntax {
    def wildcard: SwiftToken =
      json("children").arr.toList.find(_("name").str == "wildcard").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `discardKeyword`: `discard`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class DiscardStmtSyntax(json: Value) extends StmtSyntax {
    def discardKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "discardKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * A `do` block with one of more optional `catch` clauses.
    *
    * This represents do blocks in both expression and statement postitions (where the latter are wrapped in
    * ExpressionStmtSyntax).
    *
    * ### Examples
    *
    * {{{
    * do {
    *   let x = 0
    *   print(x)
    * }
    * }}}
    *
    * {{{
    * let x = do {
    *   try someThrowingFn()
    * } catch {
    *   defaultValue
    * }
    * }}}
    *
    * ### Children
    *
    *   - `doKeyword`: `do`
    *   - `body`: ``CodeBlockSyntax``
    *   - `catchClauses`: ``CatchClauseListSyntax``
    *
    * ### Nowhere contained in
    */
  case class DoExprSyntax(json: Value) extends ExprSyntax with WithCodeBlock {
    def doKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "doKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]

    def catchClauses: CatchClauseListSyntax = json("children").arr.toList
      .find(_("name").str == "catchClauses")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CatchClauseListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `doKeyword`: `do`
    *   - `throwsClause`: ``ThrowsClauseSyntax``?
    *   - `body`: ``CodeBlockSyntax``
    *   - `catchClauses`: ``CatchClauseListSyntax``
    *
    * ### Nowhere contained in
    */
  case class DoStmtSyntax(json: Value) extends StmtSyntax with WithCodeBlock {
    def doKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "doKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def throwsClause: Option[ThrowsClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "throwsClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ThrowsClauseSyntax])

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]

    def catchClauses: CatchClauseListSyntax = json("children").arr.toList
      .find(_("name").str == "catchClauses")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CatchClauseListSyntax]
  }

  /** ### Documentation
    *
    * The arguments of the '@_documentation' attribute
    *
    * ### Children
    *
    * ``DocumentationAttributeArgumentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class DocumentationAttributeArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[DocumentationAttributeArgumentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[DocumentationAttributeArgumentSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `label`: (`visibility` | `metadata`)
    *   - `colon`: `:`
    *   - `value`: ((`<identifier>` | `private` | `fileprivate` | `internal` | `public` | `open`) |
    *     ``StringLiteralExprSyntax``)
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``DocumentationAttributeArgumentListSyntax``
    */
  case class DocumentationAttributeArgumentSyntax(json: Value) extends Syntax with WithTrailingComma {
    def label: SwiftToken =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: SwiftToken | StringLiteralExprSyntax = json("children").arr.toList
      .find(_("name").str == "value")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken | StringLiteralExprSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * The arguments for the '@_dynamicReplacement' attribute
    *
    * ### Children
    *
    *   - `forLabel`: `for`
    *   - `colon`: `:`
    *   - `declName`: ``DeclReferenceExprSyntax``
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class DynamicReplacementAttributeArgumentsSyntax(json: Value) extends Syntax {
    def forLabel: SwiftToken =
      json("children").arr.toList.find(_("name").str == "forLabel").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def declName: DeclReferenceExprSyntax = json("children").arr.toList
      .find(_("name").str == "declName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclReferenceExprSyntax]
  }

  /** ### Documentation
    *
    * An editor placeholder, e.g. `<#declaration#>` that is used in a position that expects a declaration.
    *
    *   - Warning: This ``EditorPlaceholderDeclSyntax`` node is not generated by the parser anymore. Placeholders are
    *     represented by a ``MissingDeclSyntax``.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class EditorPlaceholderDeclSyntax(json: Value) extends DeclSyntax with WithAttributes with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    *   - Warning: This ``EditorPlaceholderExprSyntax`` node is not generated by the parser anymore. Placeholders are
    *     represented by a ``DeclReferenceExprSyntax``.
    *
    * ### Children
    *
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class EditorPlaceholderExprSyntax(json: Value) extends ExprSyntax {
    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * The arguments of the '@_effects' attribute. These will be parsed during the SIL stage.
    *
    * ### Children
    *
    * ``TokenSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class EffectsAttributeArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[TokenSyntax] = json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[TokenSyntax])
  }

  /** ### Documentation
    *
    * A `case` declaration of a Swift `enum`. It can have 1 or more `EnumCaseElement`s inside, each declaring a
    * different case of the enum.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `caseKeyword`: `case`
    *   - `elements`: ``EnumCaseElementListSyntax``
    *
    * ### Nowhere contained in
    */
  case class EnumCaseDeclSyntax(json: Value) extends DeclSyntax with WithAttributes with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def caseKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "caseKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def elements: EnumCaseElementListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[EnumCaseElementListSyntax]
  }

  /** ### Documentation
    *
    * A collection of 0 or more ``EnumCaseElementSyntax``s.
    *
    * ### Children
    *
    * ``EnumCaseElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/elements``
    */
  case class EnumCaseElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[EnumCaseElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[EnumCaseElementSyntax])
  }

  /** ### Documentation
    *
    * An element of an enum case, containing the name of the case and, optionally, either associated values or an
    * assignment to a raw value.
    *
    * ### Children
    *
    *   - `name`: `<identifier>`
    *   - `parameterClause`: ``EnumCaseParameterClauseSyntax``?
    *   - `rawValue`: ``InitializerClauseSyntax``?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``EnumCaseElementListSyntax``
    */
  case class EnumCaseElementSyntax(json: Value) extends Syntax with WithTrailingComma {
    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def parameterClause: Option[EnumCaseParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "parameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[EnumCaseParameterClauseSyntax])

    def rawValue: Option[InitializerClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "rawValue")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InitializerClauseSyntax])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `parameters`: ``EnumCaseParameterListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``EnumCaseElementSyntax``.``EnumCaseElementSyntax/parameterClause``
    */
  case class EnumCaseParameterClauseSyntax(json: Value) extends Syntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def parameters: EnumCaseParameterListSyntax = json("children").arr.toList
      .find(_("name").str == "parameters")
      .map(createSwiftNode)
      .head
      .asInstanceOf[EnumCaseParameterListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``EnumCaseParameterSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``EnumCaseParameterClauseSyntax``.``EnumCaseParameterClauseSyntax/parameters``
    */
  case class EnumCaseParameterListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[EnumCaseParameterSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[EnumCaseParameterSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `firstName`: (`<identifier>` | `_`)?
    *   - `secondName`: (`<identifier>` | `_`)?
    *   - `colon`: `:`?
    *   - `type`: ``TypeSyntax``
    *   - `defaultValue`: ``InitializerClauseSyntax``?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``EnumCaseParameterListSyntax``
    */
  case class EnumCaseParameterSyntax(json: Value) extends Syntax with WithTrailingComma with WithModifiers {
    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def firstName: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "firstName")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def secondName: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "secondName")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def defaultValue: Option[InitializerClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "defaultValue")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InitializerClauseSyntax])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A Swift `enum` declaration.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `enumKeyword`: `enum`
    *   - `name`: `<identifier>`
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `inheritanceClause`: ``InheritanceClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `memberBlock`: ``MemberBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class EnumDeclSyntax(json: Value)
      extends DeclSyntax
      with DeclGroup
      with NamedDecl
      with WithAttributes
      with WithGenericParameters
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def enumKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "enumKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def inheritanceClause: Option[InheritanceClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritanceClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InheritanceClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def memberBlock: MemberBlockSyntax = json("children").arr.toList
      .find(_("name").str == "memberBlock")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MemberBlockSyntax]
  }

  /** ### Documentation
    *
    * The arguments for the '@_expose' attribute
    *
    * ### Children
    *
    *   - `language`: ``TokenSyntax``
    *   - `comma`: `,`?
    *   - `cxxName`: ``StringLiteralExprSyntax``?
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class ExposeAttributeArgumentsSyntax(json: Value) extends Syntax {
    def language: TokenSyntax =
      json("children").arr.toList.find(_("name").str == "language").map(createSwiftNode).head.asInstanceOf[TokenSyntax]

    def comma: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def cxxName: Option[StringLiteralExprSyntax] = json("children").arr.toList
      .find(_("name").str == "cxxName")
      .map(createSwiftNode)
      .map(_.asInstanceOf[StringLiteralExprSyntax])
  }

  /** ### Documentation
    *
    * A list of expressions connected by operators. This list is contained by a ``SequenceExprSyntax``.
    *
    * ### Children
    *
    * ``ExprSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``SequenceExprSyntax``.``SequenceExprSyntax/elements``
    */
  case class ExprListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ExprSyntax] = json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ExprSyntax])
  }

  /** ### Documentation
    *
    * A pattern that contains an ``ExprSyntaxProtocol``.
    *
    * ### Examples
    *
    * Patterns can be used in switch cases like the following example:
    * {{{
    * switch raw.kind {
    *   case .expressionPattern:
    *     return true
    *   default:
    *     return false
    * }
    * }}}
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class ExpressionPatternSyntax(json: Value) extends PatternSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * An interpolated expression inside a string literal.
    *
    *   - SeeAlso: ``StringSegmentSyntax``
    *
    * ### Children
    *
    *   - `backslash`: `\`
    *   - `pounds`: `<rawStringPoundDelimiter>`?
    *   - `leftParen`: `(`
    *   - `expressions`: ``LabeledExprListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``StringLiteralSegmentListSyntax``
    */
  case class ExpressionSegmentSyntax(json: Value) extends Syntax with Parenthesized {
    def backslash: SwiftToken =
      json("children").arr.toList.find(_("name").str == "backslash").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def pounds: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "pounds").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def expressions: LabeledExprListSyntax = json("children").arr.toList
      .find(_("name").str == "expressions")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LabeledExprListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class ExpressionStmtSyntax(json: Value) extends StmtSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `extensionKeyword`: `extension`
    *   - `extendedType`: ``TypeSyntax``
    *   - `inheritanceClause`: ``InheritanceClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `memberBlock`: ``MemberBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class ExtensionDeclSyntax(json: Value) extends DeclSyntax with DeclGroup with WithAttributes with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def extensionKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "extensionKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def extendedType: TypeSyntax = json("children").arr.toList
      .find(_("name").str == "extendedType")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TypeSyntax]

    def inheritanceClause: Option[InheritanceClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritanceClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InheritanceClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def memberBlock: MemberBlockSyntax = json("children").arr.toList
      .find(_("name").str == "memberBlock")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MemberBlockSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `fallthroughKeyword`: `fallthrough`
    *
    * ### Nowhere contained in
    */
  case class FallThroughStmtSyntax(json: Value) extends StmtSyntax {
    def fallthroughKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "fallthroughKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `literal`: `<floatLiteral>`
    *
    * ### Nowhere contained in
    */
  case class FloatLiteralExprSyntax(json: Value) extends ExprSyntax {
    def literal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "literal").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `forKeyword`: `for`
    *   - `tryKeyword`: `try`?
    *   - `awaitKeyword`: `await`?
    *   - `caseKeyword`: `case`?
    *   - `pattern`: ``PatternSyntax``
    *   - `typeAnnotation`: ``TypeAnnotationSyntax``?
    *   - `inKeyword`: `in`
    *   - `sequence`: ``ExprSyntax``
    *   - `whereClause`: ``WhereClauseSyntax``?
    *   - `body`: ``CodeBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class ForStmtSyntax(json: Value) extends StmtSyntax with WithCodeBlock {
    def forKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "forKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def tryKeyword: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "tryKeyword")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def awaitKeyword: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "awaitKeyword")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def caseKeyword: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "caseKeyword")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]

    def typeAnnotation: Option[TypeAnnotationSyntax] = json("children").arr.toList
      .find(_("name").str == "typeAnnotation")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeAnnotationSyntax])

    def inKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "inKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def sequence: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "sequence").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def whereClause: Option[WhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "whereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[WhereClauseSyntax])

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `exclamationMark`: `!`
    *
    * ### Nowhere contained in
    */
  case class ForceUnwrapExprSyntax(json: Value) extends ExprSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def exclamationMark: SwiftToken = json("children").arr.toList
      .find(_("name").str == "exclamationMark")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `calledExpression`: ``ExprSyntax``
    *   - `leftParen`: `(`?
    *   - `arguments`: ``LabeledExprListSyntax``
    *   - `rightParen`: `)`?
    *   - `trailingClosure`: ``ClosureExprSyntax``?
    *   - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
    *
    * ### Nowhere contained in
    */
  case class FunctionCallExprSyntax(json: Value) extends ExprSyntax {
    def calledExpression: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "calledExpression")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]

    def leftParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "leftParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def arguments: LabeledExprListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LabeledExprListSyntax]

    def rightParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "rightParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def trailingClosure: Option[ClosureExprSyntax] = json("children").arr.toList
      .find(_("name").str == "trailingClosure")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ClosureExprSyntax])

    def additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = json("children").arr.toList
      .find(_("name").str == "additionalTrailingClosures")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MultipleTrailingClosureElementListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `funcKeyword`: `func`
    *   - `name`: (`<identifier>` | `<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `signature`: ``FunctionSignatureSyntax``
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `body`: ``CodeBlockSyntax``?
    *
    * ### Nowhere contained in
    */
  case class FunctionDeclSyntax(json: Value)
      extends DeclSyntax
      with NamedDecl
      with WithAttributes
      with WithGenericParameters
      with WithModifiers
      with WithOptionalCodeBlock {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def funcKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "funcKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def signature: FunctionSignatureSyntax = json("children").arr.toList
      .find(_("name").str == "signature")
      .map(createSwiftNode)
      .head
      .asInstanceOf[FunctionSignatureSyntax]

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def body: Option[CodeBlockSyntax] = json("children").arr.toList
      .find(_("name").str == "body")
      .map(createSwiftNode)
      .map(_.asInstanceOf[CodeBlockSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `asyncSpecifier`: (`async` | `reasync`)?
    *   - `throwsClause`: ``ThrowsClauseSyntax``?
    *
    * ### Contained in
    *
    *   - ``FunctionSignatureSyntax``.``FunctionSignatureSyntax/effectSpecifiers``
    */
  case class FunctionEffectSpecifiersSyntax(json: Value) extends Syntax with EffectSpecifiers {
    def asyncSpecifier: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "asyncSpecifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def throwsClause: Option[ThrowsClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "throwsClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ThrowsClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `parameters`: ``FunctionParameterListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``FunctionSignatureSyntax``.``FunctionSignatureSyntax/parameterClause``
    *   - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/parameterClause``
    */
  case class FunctionParameterClauseSyntax(json: Value) extends Syntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def parameters: FunctionParameterListSyntax = json("children").arr.toList
      .find(_("name").str == "parameters")
      .map(createSwiftNode)
      .head
      .asInstanceOf[FunctionParameterListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``FunctionParameterSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``FunctionParameterClauseSyntax``.``FunctionParameterClauseSyntax/parameters``
    */
  case class FunctionParameterListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[FunctionParameterSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[FunctionParameterSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `firstName`: (`<identifier>` | `_`)
    *   - `secondName`: (`<identifier>` | `_`)?
    *   - `colon`: `:`
    *   - `type`: ``TypeSyntax``
    *   - `ellipsis`: `...`?
    *   - `defaultValue`: ``InitializerClauseSyntax``?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``FunctionParameterListSyntax``
    */
  case class FunctionParameterSyntax(json: Value)
      extends Syntax
      with WithTrailingComma
      with WithAttributes
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def firstName: SwiftToken =
      json("children").arr.toList.find(_("name").str == "firstName").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def secondName: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "secondName")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def ellipsis: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "ellipsis").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def defaultValue: Option[InitializerClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "defaultValue")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InitializerClauseSyntax])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `parameterClause`: ``FunctionParameterClauseSyntax``
    *   - `effectSpecifiers`: ``FunctionEffectSpecifiersSyntax``?
    *   - `returnClause`: ``ReturnClauseSyntax``?
    *
    * ### Contained in
    *
    *   - ``FunctionDeclSyntax``.``FunctionDeclSyntax/signature``
    *   - ``InitializerDeclSyntax``.``InitializerDeclSyntax/signature``
    *   - ``MacroDeclSyntax``.``MacroDeclSyntax/signature``
    */
  case class FunctionSignatureSyntax(json: Value) extends Syntax {
    def parameterClause: FunctionParameterClauseSyntax = json("children").arr.toList
      .find(_("name").str == "parameterClause")
      .map(createSwiftNode)
      .head
      .asInstanceOf[FunctionParameterClauseSyntax]

    def effectSpecifiers: Option[FunctionEffectSpecifiersSyntax] = json("children").arr.toList
      .find(_("name").str == "effectSpecifiers")
      .map(createSwiftNode)
      .map(_.asInstanceOf[FunctionEffectSpecifiersSyntax])

    def returnClause: Option[ReturnClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "returnClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ReturnClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `parameters`: ``TupleTypeElementListSyntax``
    *   - `rightParen`: `)`
    *   - `effectSpecifiers`: ``TypeEffectSpecifiersSyntax``?
    *   - `returnClause`: ``ReturnClauseSyntax``
    *
    * ### Nowhere contained in
    */
  case class FunctionTypeSyntax(json: Value) extends TypeSyntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def parameters: TupleTypeElementListSyntax = json("children").arr.toList
      .find(_("name").str == "parameters")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TupleTypeElementListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def effectSpecifiers: Option[TypeEffectSpecifiersSyntax] = json("children").arr.toList
      .find(_("name").str == "effectSpecifiers")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeEffectSpecifiersSyntax])

    def returnClause: ReturnClauseSyntax = json("children").arr.toList
      .find(_("name").str == "returnClause")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ReturnClauseSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftAngle`: `<`
    *   - `arguments`: ``GenericArgumentListSyntax``
    *   - `rightAngle`: `>`
    *
    * ### Contained in
    *
    *   - ``GenericSpecializationExprSyntax``.``GenericSpecializationExprSyntax/genericArgumentClause``
    *   - ``IdentifierTypeSyntax``.``IdentifierTypeSyntax/genericArgumentClause``
    *   - ``KeyPathPropertyComponentSyntax``.``KeyPathPropertyComponentSyntax/genericArgumentClause``
    *   - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/genericArgumentClause``
    *   - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/genericArgumentClause``
    *   - ``MemberTypeSyntax``.``MemberTypeSyntax/genericArgumentClause``
    */
  case class GenericArgumentClauseSyntax(json: Value) extends Syntax {
    def leftAngle: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftAngle").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: GenericArgumentListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[GenericArgumentListSyntax]

    def rightAngle: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightAngle").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``GenericArgumentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``GenericArgumentClauseSyntax``.``GenericArgumentClauseSyntax/arguments``
    */
  case class GenericArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[GenericArgumentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[GenericArgumentSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `argument`: ``TypeSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``GenericArgumentListSyntax``
    */
  case class GenericArgumentSyntax(json: Value) extends Syntax with WithTrailingComma {
    def argument: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "argument").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * The parameter clause that defines the generic parameters.
    *
    * ### Children
    *
    *   - `leftAngle`: `<`
    *   - `parameters`: ``GenericParameterListSyntax``
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `rightAngle`: `>`
    *
    * ### Contained in
    *
    *   - ``ActorDeclSyntax``.``ActorDeclSyntax/genericParameterClause``
    *   - ``ClassDeclSyntax``.``ClassDeclSyntax/genericParameterClause``
    *   - ``EnumDeclSyntax``.``EnumDeclSyntax/genericParameterClause``
    *   - ``FunctionDeclSyntax``.``FunctionDeclSyntax/genericParameterClause``
    *   - ``InitializerDeclSyntax``.``InitializerDeclSyntax/genericParameterClause``
    *   - ``MacroDeclSyntax``.``MacroDeclSyntax/genericParameterClause``
    *   - ``NamedOpaqueReturnTypeSyntax``.``NamedOpaqueReturnTypeSyntax/genericParameterClause``
    *   - ``StructDeclSyntax``.``StructDeclSyntax/genericParameterClause``
    *   - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/genericParameterClause``
    *   - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/genericParameterClause``
    */
  case class GenericParameterClauseSyntax(json: Value) extends Syntax {
    def leftAngle: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftAngle").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def parameters: GenericParameterListSyntax = json("children").arr.toList
      .find(_("name").str == "parameters")
      .map(createSwiftNode)
      .head
      .asInstanceOf[GenericParameterListSyntax]

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def rightAngle: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightAngle").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``GenericParameterSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``GenericParameterClauseSyntax``.``GenericParameterClauseSyntax/parameters``
    */
  case class GenericParameterListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[GenericParameterSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[GenericParameterSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `eachKeyword`: `each`?
    *   - `name`: `<identifier>`
    *   - `colon`: `:`?
    *   - `inheritedType`: ``TypeSyntax``?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``GenericParameterListSyntax``
    */
  case class GenericParameterSyntax(json: Value) extends Syntax with WithTrailingComma with WithAttributes {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def eachKeyword: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "eachKeyword")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def inheritedType: Option[TypeSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritedType")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeSyntax])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``GenericRequirementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``GenericWhereClauseSyntax``.``GenericWhereClauseSyntax/requirements``
    */
  case class GenericRequirementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[GenericRequirementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[GenericRequirementSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `requirement`: (``SameTypeRequirementSyntax`` | ``ConformanceRequirementSyntax`` |
    *     ``LayoutRequirementSyntax``)
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``GenericRequirementListSyntax``
    */
  case class GenericRequirementSyntax(json: Value) extends Syntax with WithTrailingComma {
    def requirement: SameTypeRequirementSyntax | ConformanceRequirementSyntax | LayoutRequirementSyntax =
      json("children").arr.toList
        .find(_("name").str == "requirement")
        .map(createSwiftNode)
        .head
        .asInstanceOf[SameTypeRequirementSyntax | ConformanceRequirementSyntax | LayoutRequirementSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `genericArgumentClause`: ``GenericArgumentClauseSyntax``
    *
    * ### Nowhere contained in
    */
  case class GenericSpecializationExprSyntax(json: Value) extends ExprSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def genericArgumentClause: GenericArgumentClauseSyntax = json("children").arr.toList
      .find(_("name").str == "genericArgumentClause")
      .map(createSwiftNode)
      .head
      .asInstanceOf[GenericArgumentClauseSyntax]
  }

  /** ### Documentation
    *
    * A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
    *
    * ### Children
    *
    *   - `whereKeyword`: `where`
    *   - `requirements`: ``GenericRequirementListSyntax``
    *
    * ### Contained in
    *
    *   - ``ActorDeclSyntax``.``ActorDeclSyntax/genericWhereClause``
    *   - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/genericWhereClause``
    *   - ``ClassDeclSyntax``.``ClassDeclSyntax/genericWhereClause``
    *   - ``DifferentiableAttributeArgumentsSyntax``.``DifferentiableAttributeArgumentsSyntax/genericWhereClause``
    *   - ``EnumDeclSyntax``.``EnumDeclSyntax/genericWhereClause``
    *   - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/genericWhereClause``
    *   - ``FunctionDeclSyntax``.``FunctionDeclSyntax/genericWhereClause``
    *   - ``GenericParameterClauseSyntax``.``GenericParameterClauseSyntax/genericWhereClause``
    *   - ``InitializerDeclSyntax``.``InitializerDeclSyntax/genericWhereClause``
    *   - ``MacroDeclSyntax``.``MacroDeclSyntax/genericWhereClause``
    *   - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/genericWhereClause``
    *   - ``SpecializeAttributeArgumentListSyntax``
    *   - ``StructDeclSyntax``.``StructDeclSyntax/genericWhereClause``
    *   - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/genericWhereClause``
    *   - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/genericWhereClause``
    */
  case class GenericWhereClauseSyntax(json: Value) extends Syntax {
    def whereKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "whereKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def requirements: GenericRequirementListSyntax = json("children").arr.toList
      .find(_("name").str == "requirements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[GenericRequirementListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `guardKeyword`: `guard`
    *   - `conditions`: ``ConditionElementListSyntax``
    *   - `elseKeyword`: `else`
    *   - `body`: ``CodeBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class GuardStmtSyntax(json: Value) extends StmtSyntax with WithCodeBlock {
    def guardKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "guardKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def conditions: ConditionElementListSyntax = json("children").arr.toList
      .find(_("name").str == "conditions")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ConditionElementListSyntax]

    def elseKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "elseKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]
  }

  /** ### Documentation
    *
    * A pattern that contains a ``TokenSyntax``.
    *
    * ### Examples
    *
    * ``IdentifierPatternSyntax`` can be used in simplple variable declarations. For example `a` in the exmaple:
    *
    * {{{
    * let a = 1
    * }}}
    *
    * ### Children
    *
    *   - `identifier`: (`<identifier>` | `self` | `init` | `deinit` | `subscript`)
    *
    * ### Nowhere contained in
    */
  case class IdentifierPatternSyntax(json: Value) extends PatternSyntax {
    def identifier: SwiftToken =
      json("children").arr.toList.find(_("name").str == "identifier").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `name`: (`<identifier>` | `Self` | `Any` | `_`)
    *   - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
    *
    * ### Nowhere contained in
    */
  case class IdentifierTypeSyntax(json: Value) extends TypeSyntax {
    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericArgumentClause: Option[GenericArgumentClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericArgumentClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericArgumentClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``IfConfigClauseSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``IfConfigDeclSyntax``.``IfConfigDeclSyntax/clauses``
    */
  case class IfConfigClauseListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[IfConfigClauseSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[IfConfigClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `poundKeyword`: (`#if` | `#elseif` | `#else`)
    *   - `condition`: ``ExprSyntax``?
    *   - `elements`: (``CodeBlockItemListSyntax`` | ``SwitchCaseListSyntax`` | ``MemberBlockItemListSyntax`` |
    *     ``ExprSyntax`` | ``AttributeListSyntax``)?
    *
    * ### Contained in
    *
    *   - ``IfConfigClauseListSyntax``
    */
  case class IfConfigClauseSyntax(json: Value) extends Syntax {
    def poundKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "poundKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def condition: Option[ExprSyntax] = json("children").arr.toList
      .find(_("name").str == "condition")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ExprSyntax])

    def elements: Option[
      CodeBlockItemListSyntax | SwitchCaseListSyntax | MemberBlockItemListSyntax | ExprSyntax | AttributeListSyntax
    ] = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .map(
        _.asInstanceOf[
          CodeBlockItemListSyntax | SwitchCaseListSyntax | MemberBlockItemListSyntax | ExprSyntax | AttributeListSyntax
        ]
      )
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `clauses`: ``IfConfigClauseListSyntax``
    *   - `poundEndif`: `#endif`
    *
    * ### Contained in
    *
    *   - ``AttributeListSyntax``
    *   - ``PostfixIfConfigExprSyntax``.``PostfixIfConfigExprSyntax/config``
    *   - ``SwitchCaseListSyntax``
    */
  case class IfConfigDeclSyntax(json: Value) extends DeclSyntax {
    def clauses: IfConfigClauseListSyntax = json("children").arr.toList
      .find(_("name").str == "clauses")
      .map(createSwiftNode)
      .head
      .asInstanceOf[IfConfigClauseListSyntax]

    def poundEndif: SwiftToken =
      json("children").arr.toList.find(_("name").str == "poundEndif").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `ifKeyword`: `if`
    *   - `conditions`: ``ConditionElementListSyntax``
    *   - `body`: ``CodeBlockSyntax``
    *   - `elseKeyword`: `else`?
    *   - `elseBody`: (``IfExprSyntax`` | ``CodeBlockSyntax``)?
    *
    * ### Contained in
    *
    *   - ``IfExprSyntax``.``IfExprSyntax/elseBody``
    */
  case class IfExprSyntax(json: Value) extends ExprSyntax with WithCodeBlock {
    def ifKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "ifKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def conditions: ConditionElementListSyntax = json("children").arr.toList
      .find(_("name").str == "conditions")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ConditionElementListSyntax]

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]

    def elseKeyword: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "elseKeyword")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def elseBody: Option[IfExprSyntax | CodeBlockSyntax] = json("children").arr.toList
      .find(_("name").str == "elseBody")
      .map(createSwiftNode)
      .map(_.asInstanceOf[IfExprSyntax | CodeBlockSyntax])
  }

  /** ### Documentation
    *
    * The arguments for the `@_implements` attribute of the form `Type, methodName(arg1Label:arg2Label:)`
    *
    * ### Children
    *
    *   - `type`: ``TypeSyntax``
    *   - `comma`: `,`
    *   - `declName`: ``DeclReferenceExprSyntax``
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class ImplementsAttributeArgumentsSyntax(json: Value) extends Syntax {
    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def comma: SwiftToken =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def declName: DeclReferenceExprSyntax = json("children").arr.toList
      .find(_("name").str == "declName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclReferenceExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `wrappedType`: ``TypeSyntax``
    *   - `exclamationMark`: `!`
    *
    * ### Nowhere contained in
    */
  case class ImplicitlyUnwrappedOptionalTypeSyntax(json: Value) extends TypeSyntax {
    def wrappedType: TypeSyntax = json("children").arr.toList
      .find(_("name").str == "wrappedType")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TypeSyntax]

    def exclamationMark: SwiftToken = json("children").arr.toList
      .find(_("name").str == "exclamationMark")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * An `import` declaration
    *
    * An example of an import declaration is
    *
    * {{{
    * import Foundation
    * }}}
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `importKeyword`: `import`
    *   - `importKindSpecifier`: (`typealias` | `struct` | `class` | `enum` | `protocol` | `var` | `let` | `func` |
    *     `inout`)?
    *   - `path`: ``ImportPathComponentListSyntax``
    *
    * ### Nowhere contained in
    */
  case class ImportDeclSyntax(json: Value) extends DeclSyntax with WithAttributes with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def importKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "importKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def importKindSpecifier: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "importKindSpecifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def path: ImportPathComponentListSyntax = json("children").arr.toList
      .find(_("name").str == "path")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ImportPathComponentListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``ImportPathComponentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``ImportDeclSyntax``.``ImportDeclSyntax/path``
    */
  case class ImportPathComponentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ImportPathComponentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ImportPathComponentSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `name`: (`<identifier>` | `<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
    *   - `trailingPeriod`: `.`?
    *
    * ### Contained in
    *
    *   - ``ImportPathComponentListSyntax``
    */
  case class ImportPathComponentSyntax(json: Value) extends Syntax {
    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def trailingPeriod: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingPeriod")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * An expression prefixed with `&` to pass an argument to an `inout` parameter.
    *
    * ### Children
    *
    *   - `ampersand`: `&`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class InOutExprSyntax(json: Value) extends ExprSyntax {
    def ampersand: SwiftToken =
      json("children").arr.toList.find(_("name").str == "ampersand").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * An infix operator call like `1 + 2`.
    *
    *   - Note: This node is only generated after operators are folded using the `SwiftOperators` library. Beforehand,
    *     the parser does not know the precedences of operators and thus the operator is just a
    *     ``BinaryOperatorExprSyntax`` in a ``SequenceExprSyntax``.
    *
    * ### Children
    *
    *   - `leftOperand`: ``ExprSyntax``
    *   - `operator`: ``ExprSyntax``
    *   - `rightOperand`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class InfixOperatorExprSyntax(json: Value) extends ExprSyntax {
    def leftOperand: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "leftOperand")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]

    def operator: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "operator").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def rightOperand: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "rightOperand")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `colon`: `:`
    *   - `inheritedTypes`: ``InheritedTypeListSyntax``
    *
    * ### Contained in
    *
    *   - ``ActorDeclSyntax``.``ActorDeclSyntax/inheritanceClause``
    *   - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/inheritanceClause``
    *   - ``ClassDeclSyntax``.``ClassDeclSyntax/inheritanceClause``
    *   - ``EnumDeclSyntax``.``EnumDeclSyntax/inheritanceClause``
    *   - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/inheritanceClause``
    *   - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/inheritanceClause``
    *   - ``StructDeclSyntax``.``StructDeclSyntax/inheritanceClause``
    */
  case class InheritanceClauseSyntax(json: Value) extends Syntax {
    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def inheritedTypes: InheritedTypeListSyntax = json("children").arr.toList
      .find(_("name").str == "inheritedTypes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[InheritedTypeListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``InheritedTypeSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``InheritanceClauseSyntax``.``InheritanceClauseSyntax/inheritedTypes``
    */
  case class InheritedTypeListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[InheritedTypeSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[InheritedTypeSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `type`: ``TypeSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``InheritedTypeListSyntax``
    */
  case class InheritedTypeSyntax(json: Value) extends Syntax with WithTrailingComma {
    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `equal`: `=`
    *   - `value`: ``ExprSyntax``
    *
    * ### Contained in
    *
    *   - ``EnumCaseElementSyntax``.``EnumCaseElementSyntax/rawValue``
    *   - ``EnumCaseParameterSyntax``.``EnumCaseParameterSyntax/defaultValue``
    *   - ``FunctionParameterSyntax``.``FunctionParameterSyntax/defaultValue``
    *   - ``MacroDeclSyntax``.``MacroDeclSyntax/definition``
    *   - ``MatchingPatternConditionSyntax``.``MatchingPatternConditionSyntax/initializer``
    *   - ``OptionalBindingConditionSyntax``.``OptionalBindingConditionSyntax/initializer``
    *   - ``PatternBindingSyntax``.``PatternBindingSyntax/initializer``
    */
  case class InitializerClauseSyntax(json: Value) extends Syntax {
    def equal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "equal").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "value").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * An `init` declaration
    *
    * An example of an initializer is
    *
    * {{{
    * init(someParameter: Int) {
    * }
    * }}}
    *
    * The body is optional because this node also represents initializer requirements inside protocols.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `initKeyword`: `init`
    *   - `optionalMark`: (`?` | `!`)?
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `signature`: ``FunctionSignatureSyntax``
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `body`: ``CodeBlockSyntax``?
    *
    * ### Nowhere contained in
    */
  case class InitializerDeclSyntax(json: Value)
      extends DeclSyntax
      with WithAttributes
      with WithGenericParameters
      with WithModifiers
      with WithOptionalCodeBlock {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def initKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "initKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def optionalMark: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "optionalMark")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def signature: FunctionSignatureSyntax = json("children").arr.toList
      .find(_("name").str == "signature")
      .map(createSwiftNode)
      .head
      .asInstanceOf[FunctionSignatureSyntax]

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def body: Option[CodeBlockSyntax] = json("children").arr.toList
      .find(_("name").str == "body")
      .map(createSwiftNode)
      .map(_.asInstanceOf[CodeBlockSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `literal`: `<integerLiteral>`
    *
    * ### Nowhere contained in
    */
  case class IntegerLiteralExprSyntax(json: Value) extends ExprSyntax {
    def literal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "literal").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * Checks if an expression is of a given type.
    *
    * An example of an `is` expression is
    *
    * {{{
    * value is Double
    * }}}
    *
    *   - Note: This node is only generated after operators are folded using the `SwiftOperators` library. Beforehand,
    *     the parser does not know the precedences of operators and thus represents `is` by an `UnresolvedIsExpr`.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `isKeyword`: `is`
    *   - `type`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class IsExprSyntax(json: Value) extends ExprSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def isKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "isKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `isKeyword`: `is`
    *   - `type`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class IsTypePatternSyntax(json: Value) extends PatternSyntax {
    def isKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "isKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * The components of a key path
    *
    * ### Children
    *
    * ``KeyPathComponentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``KeyPathExprSyntax``.``KeyPathExprSyntax/components``
    */
  case class KeyPathComponentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[KeyPathComponentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[KeyPathComponentSyntax])
  }

  /** ### Documentation
    *
    * A single key path component
    *
    * ### Children
    *
    *   - `period`: `.`?
    *   - `component`: (``KeyPathPropertyComponentSyntax`` | ``KeyPathSubscriptComponentSyntax`` |
    *     ``KeyPathOptionalComponentSyntax``)
    *
    * ### Contained in
    *
    *   - ``KeyPathComponentListSyntax``
    */
  case class KeyPathComponentSyntax(json: Value) extends Syntax {
    def period: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "period").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def component: KeyPathPropertyComponentSyntax | KeyPathSubscriptComponentSyntax | KeyPathOptionalComponentSyntax =
      json("children").arr.toList
        .find(_("name").str == "component")
        .map(createSwiftNode)
        .head
        .asInstanceOf[KeyPathPropertyComponentSyntax | KeyPathSubscriptComponentSyntax | KeyPathOptionalComponentSyntax]
  }

  /** ### Documentation
    *
    * A key path.
    *
    * ### Examples
    *
    * {{{
    * \a.b[2].a
    * }}}
    *
    * ### Children
    *
    *   - `backslash`: `\`
    *   - `root`: ``TypeSyntax``?
    *   - `components`: ``KeyPathComponentListSyntax``
    *
    * ### Nowhere contained in
    */
  case class KeyPathExprSyntax(json: Value) extends ExprSyntax {
    def backslash: SwiftToken =
      json("children").arr.toList.find(_("name").str == "backslash").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def root: Option[TypeSyntax] =
      json("children").arr.toList.find(_("name").str == "root").map(createSwiftNode).map(_.asInstanceOf[TypeSyntax])

    def components: KeyPathComponentListSyntax = json("children").arr.toList
      .find(_("name").str == "components")
      .map(createSwiftNode)
      .head
      .asInstanceOf[KeyPathComponentListSyntax]
  }

  /** ### Documentation
    *
    * A key path component like `?` or `!`.
    *
    * ### Children
    *
    *   - `questionOrExclamationMark`: (`?` | `!`)
    *
    * ### Contained in
    *
    *   - ``KeyPathComponentSyntax``.``KeyPathComponentSyntax/component``
    */
  case class KeyPathOptionalComponentSyntax(json: Value) extends Syntax {
    def questionOrExclamationMark: SwiftToken = json("children").arr.toList
      .find(_("name").str == "questionOrExclamationMark")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A key path component like `.property` or `.1`.
    *
    * ### Children
    *
    *   - `declName`: ``DeclReferenceExprSyntax``
    *   - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
    *
    * ### Contained in
    *
    *   - ``KeyPathComponentSyntax``.``KeyPathComponentSyntax/component``
    */
  case class KeyPathPropertyComponentSyntax(json: Value) extends Syntax {
    def declName: DeclReferenceExprSyntax = json("children").arr.toList
      .find(_("name").str == "declName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclReferenceExprSyntax]

    def genericArgumentClause: Option[GenericArgumentClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericArgumentClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericArgumentClauseSyntax])
  }

  /** ### Documentation
    *
    * A key path component like `.[17]`
    *
    * ### Children
    *
    *   - `leftSquare`: `[`
    *   - `arguments`: ``LabeledExprListSyntax``
    *   - `rightSquare`: `]`
    *
    * ### Contained in
    *
    *   - ``KeyPathComponentSyntax``.``KeyPathComponentSyntax/component``
    */
  case class KeyPathSubscriptComponentSyntax(json: Value) extends Syntax {
    def leftSquare: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftSquare").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: LabeledExprListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LabeledExprListSyntax]

    def rightSquare: SwiftToken = json("children").arr.toList
      .find(_("name").str == "rightSquare")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``LabeledExprSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    *   - ``ExpressionSegmentSyntax``.``ExpressionSegmentSyntax/expressions``
    *   - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/arguments``
    *   - ``KeyPathSubscriptComponentSyntax``.``KeyPathSubscriptComponentSyntax/arguments``
    *   - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/arguments``
    *   - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/arguments``
    *   - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/arguments``
    *   - ``TupleExprSyntax``.``TupleExprSyntax/elements``
    */
  case class LabeledExprListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[LabeledExprSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[LabeledExprSyntax])
  }

  /** ### Documentation
    *
    * An expression that is prefixed by a label.
    *
    * For example, labeled expressions occur in
    *   - Function calls, where the label is the parameter label.
    *   - Tuples, where the label is the name of the tuple element.
    *
    * ### Children
    *
    *   - `label`: (`<identifier>` | `_`)?
    *   - `colon`: `:`?
    *   - `expression`: ``ExprSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``LabeledExprListSyntax``
    */
  case class LabeledExprSyntax(json: Value) extends Syntax with WithTrailingComma {
    def label: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A labeled argument for the `@_specialize` attribute like `exported: true`
    *
    * ### Children
    *
    *   - `label`: (`target` | `availability` | `exported` | `kind` | `spi` | `spiModule`)
    *   - `colon`: `:`
    *   - `value`: ``TokenSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``SpecializeAttributeArgumentListSyntax``
    */
  case class LabeledSpecializeArgumentSyntax(json: Value) extends Syntax with WithTrailingComma {
    def label: SwiftToken =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: TokenSyntax =
      json("children").arr.toList.find(_("name").str == "value").map(createSwiftNode).head.asInstanceOf[TokenSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `label`: `<identifier>`
    *   - `colon`: `:`
    *   - `statement`: ``StmtSyntax``
    *
    * ### Nowhere contained in
    */
  case class LabeledStmtSyntax(json: Value) extends StmtSyntax {
    def label: SwiftToken =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def statement: StmtSyntax =
      json("children").arr.toList.find(_("name").str == "statement").map(createSwiftNode).head.asInstanceOf[StmtSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `type`: ``TypeSyntax``
    *   - `colon`: `:`
    *   - `layoutSpecifier`: (`_Trivial` | `_TrivialAtMost` | `_UnknownLayout` | `_RefCountedObject` |
    *     `_NativeRefCountedObject` | `_Class` | `_NativeClass` | `_BridgeObject` | `_TrivialStride`)
    *   - `leftParen`: `(`?
    *   - `size`: `<integerLiteral>`?
    *   - `comma`: `,`?
    *   - `alignment`: `<integerLiteral>`?
    *   - `rightParen`: `)`?
    *
    * ### Contained in
    *
    *   - ``GenericRequirementSyntax``.``GenericRequirementSyntax/requirement``
    */
  case class LayoutRequirementSyntax(json: Value) extends Syntax {
    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def layoutSpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "layoutSpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def leftParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "leftParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def size: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "size").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def comma: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def alignment: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "alignment")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def rightParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "rightParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * `LifetimeSpecifierArgumentSyntax` `*`
    *
    * ### Nowhere contained in
    */
  case class LifetimeSpecifierArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[LifetimeSpecifierArgumentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[LifetimeSpecifierArgumentSyntax])
  }

  /** ### Documentation
    *
    * A single argument that can be added to a lifetime specifier like `borrow`, `mutate`, `consume` or `copy`.
    *
    * ### Example `data` in `func foo(data: Array<Item>) -> borrow(data) ComplexReferenceType`
    *
    * ### Children
    *
    *   - `parameter`: (`<identifier>` | `self` | `<integerLiteral>`)
    *   - `trailingComma`: `,`?
    *
    * ### Nowhere contained in
    */
  case class LifetimeSpecifierArgumentSyntax(json: Value) extends Syntax with WithTrailingComma {
    def parameter: SwiftToken =
      json("children").arr.toList.find(_("name").str == "parameter").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * An optional argument passed to a type parameter.
    *
    * ### Example `borrow(data)` in `func foo(data: Array<Item>) -> borrow(data) ComplexReferenceType`
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `arguments`: `LifetimeSpecifierArgumentListSyntax`
    *   - `rightParen`: `)`
    *
    * ### Nowhere contained in
    */
  case class LifetimeSpecifierArgumentsSyntax(json: Value) extends Syntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: LifetimeSpecifierArgumentListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LifetimeSpecifierArgumentListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A specifier that specifies function parameter on whose lifetime a type depends
    *
    * ### Children
    *
    *   - `specifier`: (`_copy` | `_consume` | `_borrow` | `_mutate`)
    *   - `arguments`: `LifetimeSpecifierArgumentsSyntax`
    *
    * ### Contained in
    *
    *   - ``TypeSpecifierListSyntax``
    */
  case class LifetimeTypeSpecifierSyntax(json: Value) extends Syntax {
    def specifier: SwiftToken =
      json("children").arr.toList.find(_("name").str == "specifier").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: LifetimeSpecifierArgumentsSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LifetimeSpecifierArgumentsSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `macroKeyword`: `macro`
    *   - `name`: `<identifier>`
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `signature`: ``FunctionSignatureSyntax``
    *   - `definition`: ``InitializerClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *
    * ### Nowhere contained in
    */
  case class MacroDeclSyntax(json: Value)
      extends DeclSyntax
      with NamedDecl
      with WithAttributes
      with WithGenericParameters
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def macroKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "macroKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def signature: FunctionSignatureSyntax = json("children").arr.toList
      .find(_("name").str == "signature")
      .map(createSwiftNode)
      .head
      .asInstanceOf[FunctionSignatureSyntax]

    def definition: Option[InitializerClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "definition")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InitializerClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])
  }

  /** ### Documentation
    *
    * The expansion of a freestanding macro in a position that expects a declaration.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `pound`: `#`
    *   - `macroName`: `<identifier>`
    *   - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
    *   - `leftParen`: `(`?
    *   - `arguments`: ``LabeledExprListSyntax``
    *   - `rightParen`: `)`?
    *   - `trailingClosure`: ``ClosureExprSyntax``?
    *   - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
    *
    * ### Nowhere contained in
    */
  case class MacroExpansionDeclSyntax(json: Value)
      extends DeclSyntax
      with FreestandingMacroExpansion
      with WithAttributes
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def pound: SwiftToken =
      json("children").arr.toList.find(_("name").str == "pound").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def macroName: SwiftToken =
      json("children").arr.toList.find(_("name").str == "macroName").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericArgumentClause: Option[GenericArgumentClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericArgumentClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericArgumentClauseSyntax])

    def leftParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "leftParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def arguments: LabeledExprListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LabeledExprListSyntax]

    def rightParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "rightParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def trailingClosure: Option[ClosureExprSyntax] = json("children").arr.toList
      .find(_("name").str == "trailingClosure")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ClosureExprSyntax])

    def additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = json("children").arr.toList
      .find(_("name").str == "additionalTrailingClosures")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MultipleTrailingClosureElementListSyntax]
  }

  /** ### Documentation
    *
    * The expansion of a freestanding macro in a position that expects an expression.
    *
    * ### Children
    *
    *   - `pound`: `#`
    *   - `macroName`: `<identifier>`
    *   - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
    *   - `leftParen`: `(`?
    *   - `arguments`: ``LabeledExprListSyntax``
    *   - `rightParen`: `)`?
    *   - `trailingClosure`: ``ClosureExprSyntax``?
    *   - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
    *
    * ### Nowhere contained in
    */
  case class MacroExpansionExprSyntax(json: Value) extends ExprSyntax with FreestandingMacroExpansion {
    def pound: SwiftToken =
      json("children").arr.toList.find(_("name").str == "pound").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def macroName: SwiftToken =
      json("children").arr.toList.find(_("name").str == "macroName").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericArgumentClause: Option[GenericArgumentClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericArgumentClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericArgumentClauseSyntax])

    def leftParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "leftParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def arguments: LabeledExprListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LabeledExprListSyntax]

    def rightParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "rightParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def trailingClosure: Option[ClosureExprSyntax] = json("children").arr.toList
      .find(_("name").str == "trailingClosure")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ClosureExprSyntax])

    def additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = json("children").arr.toList
      .find(_("name").str == "additionalTrailingClosures")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MultipleTrailingClosureElementListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `caseKeyword`: `case`
    *   - `pattern`: ``PatternSyntax``
    *   - `typeAnnotation`: ``TypeAnnotationSyntax``?
    *   - `initializer`: ``InitializerClauseSyntax``
    *
    * ### Contained in
    *
    *   - ``ConditionElementSyntax``.``ConditionElementSyntax/condition``
    */
  case class MatchingPatternConditionSyntax(json: Value) extends Syntax {
    def caseKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "caseKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]

    def typeAnnotation: Option[TypeAnnotationSyntax] = json("children").arr.toList
      .find(_("name").str == "typeAnnotation")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeAnnotationSyntax])

    def initializer: InitializerClauseSyntax = json("children").arr.toList
      .find(_("name").str == "initializer")
      .map(createSwiftNode)
      .head
      .asInstanceOf[InitializerClauseSyntax]
  }

  /** ### Documentation
    *
    * An expression that access a member like a function or a property.
    *
    * ### Children
    *
    *   - `base`: ``ExprSyntax``?
    *   - `period`: `.`
    *   - `declName`: ``DeclReferenceExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class MemberAccessExprSyntax(json: Value) extends ExprSyntax {
    def base: Option[ExprSyntax] =
      json("children").arr.toList.find(_("name").str == "base").map(createSwiftNode).map(_.asInstanceOf[ExprSyntax])

    def period: SwiftToken =
      json("children").arr.toList.find(_("name").str == "period").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def declName: DeclReferenceExprSyntax = json("children").arr.toList
      .find(_("name").str == "declName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclReferenceExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``MemberBlockItemSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
    *   - ``MemberBlockSyntax``.``MemberBlockSyntax/members``
    */
  case class MemberBlockItemListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[MemberBlockItemSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[MemberBlockItemSyntax])
  }

  /** ### Documentation
    *
    * A member declaration of a type consisting of a declaration and an optional semicolon;
    *
    * ### Children
    *
    *   - `decl`: ``DeclSyntax``
    *   - `semicolon`: `;`?
    *
    * ### Contained in
    *
    *   - ``MemberBlockItemListSyntax``
    */
  case class MemberBlockItemSyntax(json: Value) extends Syntax {
    def decl: DeclSyntax =
      json("children").arr.toList.find(_("name").str == "decl").map(createSwiftNode).head.asInstanceOf[DeclSyntax]

    def semicolon: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "semicolon")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftBrace`: `{`
    *   - `members`: ``MemberBlockItemListSyntax``
    *   - `rightBrace`: `}`
    *
    * ### Contained in
    *
    *   - ``ActorDeclSyntax``.``ActorDeclSyntax/memberBlock``
    *   - ``ClassDeclSyntax``.``ClassDeclSyntax/memberBlock``
    *   - ``EnumDeclSyntax``.``EnumDeclSyntax/memberBlock``
    *   - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/memberBlock``
    *   - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/memberBlock``
    *   - ``StructDeclSyntax``.``StructDeclSyntax/memberBlock``
    */
  case class MemberBlockSyntax(json: Value) extends Syntax with Braced {
    def leftBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def members: MemberBlockItemListSyntax = json("children").arr.toList
      .find(_("name").str == "members")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MemberBlockItemListSyntax]

    def rightBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `baseType`: ``TypeSyntax``
    *   - `period`: `.`
    *   - `name`: (`<identifier>` | `self`)
    *   - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
    *
    * ### Nowhere contained in
    */
  case class MemberTypeSyntax(json: Value) extends TypeSyntax {
    def baseType: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "baseType").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def period: SwiftToken =
      json("children").arr.toList.find(_("name").str == "period").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericArgumentClause: Option[GenericArgumentClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericArgumentClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericArgumentClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `baseType`: ``TypeSyntax``
    *   - `period`: `.`
    *   - `metatypeSpecifier`: (`Type` | `Protocol`)
    *
    * ### Nowhere contained in
    */
  case class MetatypeTypeSyntax(json: Value) extends TypeSyntax {
    def baseType: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "baseType").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def period: SwiftToken =
      json("children").arr.toList.find(_("name").str == "period").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def metatypeSpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "metatypeSpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * In case the source code is missing a declaration, this node stands in place of the missing declaration.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class MissingDeclSyntax(json: Value) extends DeclSyntax with MissingNode with WithAttributes with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * In case the source code is missing an expression, this node stands in place of the missing expression.
    *
    * ### Children
    *
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class MissingExprSyntax(json: Value) extends ExprSyntax with MissingNode {
    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * In case the source code is missing a pattern, this node stands in place of the missing pattern.
    *
    * ### Children
    *
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class MissingPatternSyntax(json: Value) extends PatternSyntax with MissingNode {
    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * In case the source code is missing a statement, this node stands in place of the missing statement.
    *
    * ### Children
    *
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class MissingStmtSyntax(json: Value) extends StmtSyntax with MissingNode {
    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * In case the source code is missing a syntax node, this node stands in place of the missing node.
    *
    * ### Children
    *
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class MissingSyntax(json: Value) extends Syntax with MissingNode {
    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * In case the source code is missing a type, this node stands in place of the missing type.
    *
    * ### Children
    *
    *   - `placeholder`: `<identifier>`
    *
    * ### Nowhere contained in
    */
  case class MissingTypeSyntax(json: Value) extends TypeSyntax with MissingNode {
    def placeholder: SwiftToken = json("children").arr.toList
      .find(_("name").str == "placeholder")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``MultipleTrailingClosureElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/additionalTrailingClosures``
    *   - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/additionalTrailingClosures``
    *   - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/additionalTrailingClosures``
    *   - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/additionalTrailingClosures``
    */
  case class MultipleTrailingClosureElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[MultipleTrailingClosureElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[MultipleTrailingClosureElementSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `label`: (`<identifier>` | `_`)
    *   - `colon`: `:`
    *   - `closure`: ``ClosureExprSyntax``
    *
    * ### Contained in
    *
    *   - ``MultipleTrailingClosureElementListSyntax``
    */
  case class MultipleTrailingClosureElementSyntax(json: Value) extends Syntax {
    def label: SwiftToken =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def closure: ClosureExprSyntax = json("children").arr.toList
      .find(_("name").str == "closure")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ClosureExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``
    *   - `type`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class NamedOpaqueReturnTypeSyntax(json: Value) extends TypeSyntax {
    def genericParameterClause: GenericParameterClauseSyntax = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .head
      .asInstanceOf[GenericParameterClauseSyntax]

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `nilKeyword`: `nil`
    *
    * ### Nowhere contained in
    */
  case class NilLiteralExprSyntax(json: Value) extends ExprSyntax {
    def nilKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "nilKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``ObjCSelectorPieceSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class ObjCSelectorPieceListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[ObjCSelectorPieceSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[ObjCSelectorPieceSyntax])
  }

  /** ### Documentation
    *
    * A piece of an Objective-C selector. Either consisting of just an identifier for a nullary selector, an identifier
    * and a colon for a labeled argument or just a colon for an unlabeled argument
    *
    * ### Children
    *
    *   - `name`: ``TokenSyntax``?
    *   - `colon`: `:`?
    *
    * ### Contained in
    *
    *   - ``ObjCSelectorPieceListSyntax``
    */
  case class ObjCSelectorPieceSyntax(json: Value) extends Syntax {
    def name: Option[TokenSyntax] =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).map(_.asInstanceOf[TokenSyntax])

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * The arguments for the '@_opaqueReturnTypeOf()'.
    *
    * ### Children
    *
    *   - `mangledName`: ``StringLiteralExprSyntax``
    *   - `comma`: `,`
    *   - `ordinal`: `<integerLiteral>`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class OpaqueReturnTypeOfAttributeArgumentsSyntax(json: Value) extends Syntax {
    def mangledName: StringLiteralExprSyntax = json("children").arr.toList
      .find(_("name").str == "mangledName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[StringLiteralExprSyntax]

    def comma: SwiftToken =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def ordinal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "ordinal").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A Swift `operator` declaration.
    *
    * ### Children
    *
    *   - `fixitySpecifier`: (`prefix` | `postfix` | `infix`)
    *   - `operatorKeyword`: `operator`
    *   - `name`: (`<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
    *   - `operatorPrecedenceAndTypes`: ``OperatorPrecedenceAndTypesSyntax``?
    *
    * ### Nowhere contained in
    */
  case class OperatorDeclSyntax(json: Value) extends DeclSyntax with NamedDecl {
    def fixitySpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "fixitySpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def operatorKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "operatorKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def operatorPrecedenceAndTypes: Option[OperatorPrecedenceAndTypesSyntax] = json("children").arr.toList
      .find(_("name").str == "operatorPrecedenceAndTypes")
      .map(createSwiftNode)
      .map(_.asInstanceOf[OperatorPrecedenceAndTypesSyntax])
  }

  /** ### Documentation
    *
    * A clause to specify precedence group in infix operator declarations, and designated types in any operator
    * declaration.
    *
    * ### Children
    *
    *   - `colon`: `:`
    *   - `precedenceGroup`: `<identifier>`
    *   - `designatedTypes`: ``DesignatedTypeListSyntax``
    *
    * ### Contained in
    *
    *   - ``OperatorDeclSyntax``.``OperatorDeclSyntax/operatorPrecedenceAndTypes``
    */
  case class OperatorPrecedenceAndTypesSyntax(json: Value) extends Syntax {
    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def precedenceGroup: SwiftToken = json("children").arr.toList
      .find(_("name").str == "precedenceGroup")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def designatedTypes: DesignatedTypeListSyntax = json("children").arr.toList
      .find(_("name").str == "designatedTypes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DesignatedTypeListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `bindingSpecifier`: (`let` | `var` | `inout` | `_mutating` | `_borrowing` | `_consuming`)
    *   - `pattern`: ``PatternSyntax``
    *   - `typeAnnotation`: ``TypeAnnotationSyntax``?
    *   - `initializer`: ``InitializerClauseSyntax``?
    *
    * ### Contained in
    *
    *   - ``ConditionElementSyntax``.``ConditionElementSyntax/condition``
    */
  case class OptionalBindingConditionSyntax(json: Value) extends Syntax {
    def bindingSpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "bindingSpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]

    def typeAnnotation: Option[TypeAnnotationSyntax] = json("children").arr.toList
      .find(_("name").str == "typeAnnotation")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeAnnotationSyntax])

    def initializer: Option[InitializerClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "initializer")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InitializerClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `questionMark`: `?`
    *
    * ### Nowhere contained in
    */
  case class OptionalChainingExprSyntax(json: Value) extends ExprSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def questionMark: SwiftToken = json("children").arr.toList
      .find(_("name").str == "questionMark")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `wrappedType`: ``TypeSyntax``
    *   - `questionMark`: `?`
    *
    * ### Nowhere contained in
    */
  case class OptionalTypeSyntax(json: Value) extends TypeSyntax {
    def wrappedType: TypeSyntax = json("children").arr.toList
      .find(_("name").str == "wrappedType")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TypeSyntax]

    def questionMark: SwiftToken = json("children").arr.toList
      .find(_("name").str == "questionMark")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * The arguments for the '@_originallyDefinedIn' attribute
    *
    * ### Children
    *
    *   - `moduleLabel`: `module`
    *   - `colon`: `:`
    *   - `moduleName`: ``StringLiteralExprSyntax``
    *   - `comma`: `,`
    *   - `platforms`: ``PlatformVersionItemListSyntax``
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class OriginallyDefinedInAttributeArgumentsSyntax(json: Value) extends Syntax {
    def moduleLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "moduleLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def moduleName: StringLiteralExprSyntax = json("children").arr.toList
      .find(_("name").str == "moduleName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[StringLiteralExprSyntax]

    def comma: SwiftToken =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def platforms: PlatformVersionItemListSyntax = json("children").arr.toList
      .find(_("name").str == "platforms")
      .map(createSwiftNode)
      .head
      .asInstanceOf[PlatformVersionItemListSyntax]
  }

  /** ### Documentation
    *
    * A pack element expression spelled with `each`.
    *
    * ### Children
    *
    *   - `eachKeyword`: `each`
    *   - `pack`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class PackElementExprSyntax(json: Value) extends ExprSyntax {
    def eachKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "eachKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def pack: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "pack").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `eachKeyword`: `each`
    *   - `pack`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class PackElementTypeSyntax(json: Value) extends TypeSyntax {
    def eachKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "eachKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def pack: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "pack").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * A pack expansion expression spelled with `repeat`.
    *
    * ### Children
    *
    *   - `repeatKeyword`: `repeat`
    *   - `repetitionPattern`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class PackExpansionExprSyntax(json: Value) extends ExprSyntax {
    def repeatKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "repeatKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def repetitionPattern: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "repetitionPattern")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `repeatKeyword`: `repeat`
    *   - `repetitionPattern`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class PackExpansionTypeSyntax(json: Value) extends TypeSyntax {
    def repeatKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "repeatKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def repetitionPattern: TypeSyntax = json("children").arr.toList
      .find(_("name").str == "repetitionPattern")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``PatternBindingSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``VariableDeclSyntax``.``VariableDeclSyntax/bindings``
    */
  case class PatternBindingListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[PatternBindingSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[PatternBindingSyntax])
  }

  /** ### Documentation
    *
    * Defines variables inside a variable declaration.
    *
    * ### Children
    *
    *   - `pattern`: ``PatternSyntax``
    *   - `typeAnnotation`: ``TypeAnnotationSyntax``?
    *   - `initializer`: ``InitializerClauseSyntax``?
    *   - `accessorBlock`: ``AccessorBlockSyntax``?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``PatternBindingListSyntax``
    */
  case class PatternBindingSyntax(json: Value) extends Syntax with WithTrailingComma {
    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]

    def typeAnnotation: Option[TypeAnnotationSyntax] = json("children").arr.toList
      .find(_("name").str == "typeAnnotation")
      .map(createSwiftNode)
      .map(_.asInstanceOf[TypeAnnotationSyntax])

    def initializer: Option[InitializerClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "initializer")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InitializerClauseSyntax])

    def accessorBlock: Option[AccessorBlockSyntax] = json("children").arr.toList
      .find(_("name").str == "accessorBlock")
      .map(createSwiftNode)
      .map(_.asInstanceOf[AccessorBlockSyntax])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `pattern`: ``PatternSyntax``
    *
    * ### Nowhere contained in
    */
  case class PatternExprSyntax(json: Value) extends ExprSyntax {
    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``PlatformVersionItemSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``BackDeployedAttributeArgumentsSyntax``.``BackDeployedAttributeArgumentsSyntax/platforms``
    *   - ``OriginallyDefinedInAttributeArgumentsSyntax``.``OriginallyDefinedInAttributeArgumentsSyntax/platforms``
    */
  case class PlatformVersionItemListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[PlatformVersionItemSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[PlatformVersionItemSyntax])
  }

  /** ### Documentation
    *
    * A single platform/version pair in an attribute, e.g. `iOS 10.1`.
    *
    * ### Children
    *
    *   - `platformVersion`: ``PlatformVersionSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``PlatformVersionItemListSyntax``
    */
  case class PlatformVersionItemSyntax(json: Value) extends Syntax with WithTrailingComma {
    def platformVersion: PlatformVersionSyntax = json("children").arr.toList
      .find(_("name").str == "platformVersion")
      .map(createSwiftNode)
      .head
      .asInstanceOf[PlatformVersionSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * An argument to `@available` that restricts the availability on a certain platform to a version, e.g. `iOS 10` or
    * `swift 3.4`.
    *
    * ### Children
    *
    *   - `platform`: `<identifier>`
    *   - `version`: ``VersionTupleSyntax``?
    *
    * ### Contained in
    *
    *   - ``AvailabilityArgumentSyntax``.``AvailabilityArgumentSyntax/argument``
    *   - ``PlatformVersionItemSyntax``.``PlatformVersionItemSyntax/platformVersion``
    */
  case class PlatformVersionSyntax(json: Value) extends Syntax {
    def platform: SwiftToken =
      json("children").arr.toList.find(_("name").str == "platform").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def version: Option[VersionTupleSyntax] = json("children").arr.toList
      .find(_("name").str == "version")
      .map(createSwiftNode)
      .map(_.asInstanceOf[VersionTupleSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `base`: ``ExprSyntax``?
    *   - `config`: ``IfConfigDeclSyntax``
    *
    * ### Nowhere contained in
    */
  case class PostfixIfConfigExprSyntax(json: Value) extends ExprSyntax {
    def base: Option[ExprSyntax] =
      json("children").arr.toList.find(_("name").str == "base").map(createSwiftNode).map(_.asInstanceOf[ExprSyntax])

    def config: IfConfigDeclSyntax = json("children").arr.toList
      .find(_("name").str == "config")
      .map(createSwiftNode)
      .head
      .asInstanceOf[IfConfigDeclSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `operator`: `<postfixOperator>`
    *
    * ### Nowhere contained in
    */
  case class PostfixOperatorExprSyntax(json: Value) extends ExprSyntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def operator: SwiftToken =
      json("children").arr.toList.find(_("name").str == "operator").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `fileLabel`: `file`
    *   - `fileColon`: `:`
    *   - `fileName`: ``SimpleStringLiteralExprSyntax``
    *   - `comma`: `,`
    *   - `lineLabel`: `line`
    *   - `lineColon`: `:`
    *   - `lineNumber`: `<integerLiteral>`
    *
    * ### Contained in
    *
    *   - ``PoundSourceLocationSyntax``.``PoundSourceLocationSyntax/arguments``
    */
  case class PoundSourceLocationArgumentsSyntax(json: Value) extends Syntax {
    def fileLabel: SwiftToken =
      json("children").arr.toList.find(_("name").str == "fileLabel").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def fileColon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "fileColon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def fileName: SimpleStringLiteralExprSyntax = json("children").arr.toList
      .find(_("name").str == "fileName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SimpleStringLiteralExprSyntax]

    def comma: SwiftToken =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def lineLabel: SwiftToken =
      json("children").arr.toList.find(_("name").str == "lineLabel").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def lineColon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "lineColon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def lineNumber: SwiftToken =
      json("children").arr.toList.find(_("name").str == "lineNumber").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `poundSourceLocation`: `#sourceLocation`
    *   - `leftParen`: `(`
    *   - `arguments`: ``PoundSourceLocationArgumentsSyntax``?
    *   - `rightParen`: `)`
    *
    * ### Nowhere contained in
    */
  case class PoundSourceLocationSyntax(json: Value) extends DeclSyntax with Parenthesized {
    def poundSourceLocation: SwiftToken = json("children").arr.toList
      .find(_("name").str == "poundSourceLocation")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: Option[PoundSourceLocationArgumentsSyntax] = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .map(_.asInstanceOf[PoundSourceLocationArgumentsSyntax])

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * Specifies the precedence of an operator when used in an operation that includes optional chaining.
    *
    * ### Children
    *
    *   - `assignmentLabel`: `assignment`
    *   - `colon`: `:`
    *   - `value`: (`true` | `false`)
    *
    * ### Contained in
    *
    *   - ``PrecedenceGroupAttributeListSyntax``
    */
  case class PrecedenceGroupAssignmentSyntax(json: Value) extends Syntax {
    def assignmentLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "assignmentLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: SwiftToken =
      json("children").arr.toList.find(_("name").str == "value").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * Specifies how a sequence of operators with the same precedence level are grouped together in the absence of
    * grouping parentheses.
    *
    * ### Children
    *
    *   - `associativityLabel`: `associativity`
    *   - `colon`: `:`
    *   - `value`: (`left` | `right` | `none`)
    *
    * ### Contained in
    *
    *   - ``PrecedenceGroupAttributeListSyntax``
    */
  case class PrecedenceGroupAssociativitySyntax(json: Value) extends Syntax {
    def associativityLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "associativityLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: SwiftToken =
      json("children").arr.toList.find(_("name").str == "value").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * (``PrecedenceGroupRelationSyntax`` | ``PrecedenceGroupAssignmentSyntax`` | ``PrecedenceGroupAssociativitySyntax``)
    * `*`
    *
    * ### Contained in
    *
    *   - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/groupAttributes``
    */
  case class PrecedenceGroupAttributeListSyntax(json: Value) extends SyntaxCollection {
    def children
      : Seq[PrecedenceGroupRelationSyntax | PrecedenceGroupAssignmentSyntax | PrecedenceGroupAssociativitySyntax] =
      json("children").arr.toList
        .map(createSwiftNode)
        .map(
          _.asInstanceOf[
            PrecedenceGroupRelationSyntax | PrecedenceGroupAssignmentSyntax | PrecedenceGroupAssociativitySyntax
          ]
        )
  }

  /** ### Documentation
    *
    * A Swift `precedencegroup` declaration.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `precedencegroupKeyword`: `precedencegroup`
    *   - `name`: `<identifier>`
    *   - `leftBrace`: `{`
    *   - `groupAttributes`: ``PrecedenceGroupAttributeListSyntax``
    *   - `rightBrace`: `}`
    *
    * ### Nowhere contained in
    */
  case class PrecedenceGroupDeclSyntax(json: Value)
      extends DeclSyntax
      with Braced
      with NamedDecl
      with WithAttributes
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def precedencegroupKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "precedencegroupKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def leftBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def groupAttributes: PrecedenceGroupAttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "groupAttributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[PrecedenceGroupAttributeListSyntax]

    def rightBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``PrecedenceGroupNameSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``PrecedenceGroupRelationSyntax``.``PrecedenceGroupRelationSyntax/precedenceGroups``
    */
  case class PrecedenceGroupNameListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[PrecedenceGroupNameSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[PrecedenceGroupNameSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `name`: `<identifier>`
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``PrecedenceGroupNameListSyntax``
    */
  case class PrecedenceGroupNameSyntax(json: Value) extends Syntax with WithTrailingComma {
    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * Specify the new precedence group's relation to existing precedence groups.
    *
    * ### Children
    *
    *   - `higherThanOrLowerThanLabel`: (`higherThan` | `lowerThan`)
    *   - `colon`: `:`
    *   - `precedenceGroups`: ``PrecedenceGroupNameListSyntax``
    *
    * ### Contained in
    *
    *   - ``PrecedenceGroupAttributeListSyntax``
    */
  case class PrecedenceGroupRelationSyntax(json: Value) extends Syntax {
    def higherThanOrLowerThanLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "higherThanOrLowerThanLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def precedenceGroups: PrecedenceGroupNameListSyntax = json("children").arr.toList
      .find(_("name").str == "precedenceGroups")
      .map(createSwiftNode)
      .head
      .asInstanceOf[PrecedenceGroupNameListSyntax]
  }

  /** ### Documentation
    *
    * A prefix operator applied to a value.
    *
    * ### Examples
    *
    * {{{
    * -x
    * }}}
    *
    * {{{
    * !true
    * }}}
    *
    * ### Children
    *
    *   - `operator`: `<prefixOperator>`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class PrefixOperatorExprSyntax(json: Value) extends ExprSyntax {
    def operator: SwiftToken =
      json("children").arr.toList.find(_("name").str == "operator").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftAngle`: `<`
    *   - `primaryAssociatedTypes`: ``PrimaryAssociatedTypeListSyntax``
    *   - `rightAngle`: `>`
    *
    * ### Contained in
    *
    *   - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/primaryAssociatedTypeClause``
    */
  case class PrimaryAssociatedTypeClauseSyntax(json: Value) extends Syntax {
    def leftAngle: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftAngle").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def primaryAssociatedTypes: PrimaryAssociatedTypeListSyntax = json("children").arr.toList
      .find(_("name").str == "primaryAssociatedTypes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[PrimaryAssociatedTypeListSyntax]

    def rightAngle: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightAngle").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``PrimaryAssociatedTypeSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``PrimaryAssociatedTypeClauseSyntax``.``PrimaryAssociatedTypeClauseSyntax/primaryAssociatedTypes``
    */
  case class PrimaryAssociatedTypeListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[PrimaryAssociatedTypeSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[PrimaryAssociatedTypeSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `name`: `<identifier>`
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``PrimaryAssociatedTypeListSyntax``
    */
  case class PrimaryAssociatedTypeSyntax(json: Value) extends Syntax with WithTrailingComma {
    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A `protocol` declaration
    *
    * An example of a protocol declaration is
    *
    * {{{
    * protocol Example {
    *   var isValid: Bool { get }
    * }
    * }}}
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `protocolKeyword`: `protocol`
    *   - `name`: `<identifier>`
    *   - `primaryAssociatedTypeClause`: ``PrimaryAssociatedTypeClauseSyntax``?
    *   - `inheritanceClause`: ``InheritanceClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `memberBlock`: ``MemberBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class ProtocolDeclSyntax(json: Value)
      extends DeclSyntax
      with DeclGroup
      with NamedDecl
      with WithAttributes
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def protocolKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "protocolKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def primaryAssociatedTypeClause: Option[PrimaryAssociatedTypeClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "primaryAssociatedTypeClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[PrimaryAssociatedTypeClauseSyntax])

    def inheritanceClause: Option[InheritanceClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritanceClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InheritanceClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def memberBlock: MemberBlockSyntax = json("children").arr.toList
      .find(_("name").str == "memberBlock")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MemberBlockSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `openingPounds`: `<regexPoundDelimiter>`?
    *   - `openingSlash`: `/`
    *   - `regex`: `<regexLiteralPattern>`
    *   - `closingSlash`: `/`
    *   - `closingPounds`: `<regexPoundDelimiter>`?
    *
    * ### Nowhere contained in
    */
  case class RegexLiteralExprSyntax(json: Value) extends ExprSyntax {
    def openingPounds: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "openingPounds")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def openingSlash: SwiftToken = json("children").arr.toList
      .find(_("name").str == "openingSlash")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def regex: SwiftToken =
      json("children").arr.toList.find(_("name").str == "regex").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def closingSlash: SwiftToken = json("children").arr.toList
      .find(_("name").str == "closingSlash")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def closingPounds: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "closingPounds")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `repeatKeyword`: `repeat`
    *   - `body`: ``CodeBlockSyntax``
    *   - `whileKeyword`: `while`
    *   - `condition`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class RepeatStmtSyntax(json: Value) extends StmtSyntax with WithCodeBlock {
    def repeatKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "repeatKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]

    def whileKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "whileKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def condition: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "condition").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `arrow`: `->`
    *   - `type`: ``TypeSyntax``
    *
    * ### Contained in
    *
    *   - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/returnClause``
    *   - ``FunctionSignatureSyntax``.``FunctionSignatureSyntax/returnClause``
    *   - ``FunctionTypeSyntax``.``FunctionTypeSyntax/returnClause``
    *   - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/returnClause``
    */
  case class ReturnClauseSyntax(json: Value) extends Syntax {
    def arrow: SwiftToken =
      json("children").arr.toList.find(_("name").str == "arrow").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `returnKeyword`: `return`
    *   - `expression`: ``ExprSyntax``?
    *
    * ### Nowhere contained in
    */
  case class ReturnStmtSyntax(json: Value) extends StmtSyntax {
    def returnKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "returnKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: Option[ExprSyntax] = json("children").arr.toList
      .find(_("name").str == "expression")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ExprSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftType`: ``TypeSyntax``
    *   - `equal`: (`<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
    *   - `rightType`: ``TypeSyntax``
    *
    * ### Contained in
    *
    *   - ``GenericRequirementSyntax``.``GenericRequirementSyntax/requirement``
    */
  case class SameTypeRequirementSyntax(json: Value) extends Syntax {
    def leftType: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "leftType").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def equal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "equal").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def rightType: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "rightType").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * A flat list of expressions before operator folding using the `SwiftOperators` library.
    *
    * ### Examples
    *
    * {{{
    * 1 + 2 + 3
    * }}}
    *
    * ### Children
    *
    *   - `elements`: ``ExprListSyntax``
    *
    * ### Nowhere contained in
    */
  case class SequenceExprSyntax(json: Value) extends ExprSyntax {
    def elements: ExprListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprListSyntax]
  }

  /** ### Documentation
    *
    * A simple string that can’t contain string interpolation and cannot have raw string delimiters.
    *
    * ### Children
    *
    *   - `openingQuote`: (`"` | `"""`)
    *   - `segments`: ``SimpleStringLiteralSegmentListSyntax``
    *   - `closingQuote`: (`"` | `"""`)
    *
    * ### Contained in
    *
    *   - ``AvailabilityLabeledArgumentSyntax``.``AvailabilityLabeledArgumentSyntax/value``
    *   - ``PoundSourceLocationArgumentsSyntax``.``PoundSourceLocationArgumentsSyntax/fileName``
    */
  case class SimpleStringLiteralExprSyntax(json: Value) extends ExprSyntax {
    def openingQuote: SwiftToken = json("children").arr.toList
      .find(_("name").str == "openingQuote")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def segments: SimpleStringLiteralSegmentListSyntax = json("children").arr.toList
      .find(_("name").str == "segments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SimpleStringLiteralSegmentListSyntax]

    def closingQuote: SwiftToken = json("children").arr.toList
      .find(_("name").str == "closingQuote")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * String literal segments that only can contain non string interpolated or extended escaped strings
    *
    * ### Children
    *
    * ``StringSegmentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``SimpleStringLiteralExprSyntax``.``SimpleStringLiteralExprSyntax/segments``
    */
  case class SimpleStringLiteralSegmentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[StringSegmentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[StringSegmentSyntax])
  }

  /** ### Documentation
    *
    * A specifier that can be attached to a type to eg. mark a parameter as `inout` or `consuming`
    *
    * ### Children
    *
    *   - `specifier`: (`inout` | `__shared` | `__owned` | `isolated` | `_const` | `borrowing` | `consuming` |
    *     `transferring` | `_resultDependsOn`)
    *
    * ### Contained in
    *
    *   - ``TypeSpecifierListSyntax``
    */
  case class SimpleTypeSpecifierSyntax(json: Value) extends Syntax {
    def specifier: SwiftToken =
      json("children").arr.toList.find(_("name").str == "specifier").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `someOrAnySpecifier`: (`some` | `any`)
    *   - `constraint`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class SomeOrAnyTypeSyntax(json: Value) extends TypeSyntax {
    def someOrAnySpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "someOrAnySpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def constraint: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "constraint").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `shebang`: `<shebang>`?
    *   - `statements`: ``CodeBlockItemListSyntax``
    *   - `endOfFileToken`: ``
    *
    * ### Nowhere contained in
    */
  case class SourceFileSyntax(json: Value) extends Syntax with WithStatements {
    def shebang: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "shebang").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def statements: CodeBlockItemListSyntax = json("children").arr.toList
      .find(_("name").str == "statements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CodeBlockItemListSyntax]

    def endOfFileToken: SwiftToken = json("children").arr.toList
      .find(_("name").str == "endOfFileToken")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A collection of arguments for the `@_specialize` attribute
    *
    * ### Children
    *
    * (``LabeledSpecializeArgumentSyntax`` | ``SpecializeAvailabilityArgumentSyntax`` |
    * ``SpecializeTargetFunctionArgumentSyntax`` | ``GenericWhereClauseSyntax``) `*`
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class SpecializeAttributeArgumentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[
      LabeledSpecializeArgumentSyntax | SpecializeAvailabilityArgumentSyntax | SpecializeTargetFunctionArgumentSyntax |
        GenericWhereClauseSyntax
    ] = json("children").arr.toList
      .map(createSwiftNode)
      .map(
        _.asInstanceOf[
          LabeledSpecializeArgumentSyntax | SpecializeAvailabilityArgumentSyntax |
            SpecializeTargetFunctionArgumentSyntax | GenericWhereClauseSyntax
        ]
      )
  }

  /** ### Documentation
    *
    * The availability argument for the _specialize attribute
    *
    * ### Children
    *
    *   - `availabilityLabel`: `availability`
    *   - `colon`: `:`
    *   - `availabilityArguments`: ``AvailabilityArgumentListSyntax``
    *   - `semicolon`: `;`
    *
    * ### Contained in
    *
    *   - ``SpecializeAttributeArgumentListSyntax``
    */
  case class SpecializeAvailabilityArgumentSyntax(json: Value) extends Syntax {
    def availabilityLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "availabilityLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def availabilityArguments: AvailabilityArgumentListSyntax = json("children").arr.toList
      .find(_("name").str == "availabilityArguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AvailabilityArgumentListSyntax]

    def semicolon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "semicolon").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A labeled argument for the `@_specialize` attribute with a function decl value like `target: myFunc(_:)`
    *
    * ### Children
    *
    *   - `targetLabel`: `target`
    *   - `colon`: `:`
    *   - `declName`: ``DeclReferenceExprSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``SpecializeAttributeArgumentListSyntax``
    */
  case class SpecializeTargetFunctionArgumentSyntax(json: Value) extends Syntax with WithTrailingComma {
    def targetLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "targetLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def declName: DeclReferenceExprSyntax = json("children").arr.toList
      .find(_("name").str == "declName")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclReferenceExprSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A string literal.
    *
    * ### Examples
    *
    * {{{
    * "Hello \(userName())!"
    * }}}
    *
    * ### Children
    *
    *   - `openingPounds`: `<rawStringPoundDelimiter>`?
    *   - `openingQuote`: (`"` | `"""` | `'`)
    *   - `segments`: ``StringLiteralSegmentListSyntax``
    *   - `closingQuote`: (`"` | `"""` | `'`)
    *   - `closingPounds`: `<rawStringPoundDelimiter>`?
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    *   - ``ConventionAttributeArgumentsSyntax``.``ConventionAttributeArgumentsSyntax/cTypeString``
    *   - ``DocumentationAttributeArgumentSyntax``.``DocumentationAttributeArgumentSyntax/value``
    *   - ``ExposeAttributeArgumentsSyntax``.``ExposeAttributeArgumentsSyntax/cxxName``
    *   - ``OpaqueReturnTypeOfAttributeArgumentsSyntax``.``OpaqueReturnTypeOfAttributeArgumentsSyntax/mangledName``
    *   - ``OriginallyDefinedInAttributeArgumentsSyntax``.``OriginallyDefinedInAttributeArgumentsSyntax/moduleName``
    *   - ``UnavailableFromAsyncAttributeArgumentsSyntax``.``UnavailableFromAsyncAttributeArgumentsSyntax/message``
    *   - ``UnderscorePrivateAttributeArgumentsSyntax``.``UnderscorePrivateAttributeArgumentsSyntax/filename``
    */
  case class StringLiteralExprSyntax(json: Value) extends ExprSyntax {
    def openingPounds: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "openingPounds")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def openingQuote: SwiftToken = json("children").arr.toList
      .find(_("name").str == "openingQuote")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def segments: StringLiteralSegmentListSyntax = json("children").arr.toList
      .find(_("name").str == "segments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[StringLiteralSegmentListSyntax]

    def closingQuote: SwiftToken = json("children").arr.toList
      .find(_("name").str == "closingQuote")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def closingPounds: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "closingPounds")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * (``StringSegmentSyntax`` | ``ExpressionSegmentSyntax``) `*`
    *
    * ### Contained in
    *
    *   - ``StringLiteralExprSyntax``.``StringLiteralExprSyntax/segments``
    */
  case class StringLiteralSegmentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[StringSegmentSyntax | ExpressionSegmentSyntax] = json("children").arr.toList
      .map(createSwiftNode)
      .map(_.asInstanceOf[StringSegmentSyntax | ExpressionSegmentSyntax])
  }

  /** ### Documentation
    *
    * A literal segment inside a string segment.
    *
    *   - SeeAlso: ``ExpressionSegmentSyntax``
    *
    * ### Children
    *
    *   - `content`: `<stringSegment>`
    *
    * ### Contained in
    *
    *   - ``SimpleStringLiteralSegmentListSyntax``
    *   - ``StringLiteralSegmentListSyntax``
    */
  case class StringSegmentSyntax(json: Value) extends Syntax {
    def content: SwiftToken =
      json("children").arr.toList.find(_("name").str == "content").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A `struct` declaration
    *
    * An example of a struct declaration is
    *
    * {{{
    * struct SomeStruct {
    *   let someMember: String
    *   var anotherMember: Int
    *
    *   func foo() {
    *     print(someMember)
    *   }
    *
    *   mutating func bar() {
    *     anotherMember = 42
    *   }
    * }
    * }}}
    *
    * A struct declaration may be declared without any members.
    *
    * {{{
    * struct EmptyStruct {
    *
    * }
    * }}}
    *
    * A struct declaration may include a type inheritance clause listing one or more protocols the struct conforms to.
    *
    * The example below uses Hashable and Equatable protocols whose members are automatically synthesized by the
    * compiler if the struct contains stored members that are themselves `Hashable` and `Equatable`.
    *
    * {{{
    * struct AdvancedStruct: Hashable, Equatable {
    *   let someMember: String
    *   var anotherMember: Int
    * }
    * }}}
    *
    * A struct declaration may include a generic parameter clause as well as a generic where clause.
    *
    * {{{
    * struct Stack<Element> {
    *   var items: [Element] = []
    *
    *   mutating func push(_ item: Element) {
    *     items.append(item)
    *   }
    *
    *   mutating func pop() -> Element {
    *     return items.removeLast()
    *   }
    * }
    * }}}
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `structKeyword`: `struct`
    *   - `name`: `<identifier>`
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `inheritanceClause`: ``InheritanceClauseSyntax``?
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `memberBlock`: ``MemberBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class StructDeclSyntax(json: Value)
      extends DeclSyntax
      with DeclGroup
      with NamedDecl
      with WithAttributes
      with WithGenericParameters
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def structKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "structKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def inheritanceClause: Option[InheritanceClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "inheritanceClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[InheritanceClauseSyntax])

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def memberBlock: MemberBlockSyntax = json("children").arr.toList
      .find(_("name").str == "memberBlock")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MemberBlockSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `calledExpression`: ``ExprSyntax``
    *   - `leftSquare`: `[`
    *   - `arguments`: ``LabeledExprListSyntax``
    *   - `rightSquare`: `]`
    *   - `trailingClosure`: ``ClosureExprSyntax``?
    *   - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
    *
    * ### Nowhere contained in
    */
  case class SubscriptCallExprSyntax(json: Value) extends ExprSyntax {
    def calledExpression: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "calledExpression")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]

    def leftSquare: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftSquare").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def arguments: LabeledExprListSyntax = json("children").arr.toList
      .find(_("name").str == "arguments")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LabeledExprListSyntax]

    def rightSquare: SwiftToken = json("children").arr.toList
      .find(_("name").str == "rightSquare")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def trailingClosure: Option[ClosureExprSyntax] = json("children").arr.toList
      .find(_("name").str == "trailingClosure")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ClosureExprSyntax])

    def additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = json("children").arr.toList
      .find(_("name").str == "additionalTrailingClosures")
      .map(createSwiftNode)
      .head
      .asInstanceOf[MultipleTrailingClosureElementListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `subscriptKeyword`: `subscript`
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `parameterClause`: ``FunctionParameterClauseSyntax``
    *   - `returnClause`: ``ReturnClauseSyntax``
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *   - `accessorBlock`: ``AccessorBlockSyntax``?
    *
    * ### Nowhere contained in
    */
  case class SubscriptDeclSyntax(json: Value)
      extends DeclSyntax
      with WithAttributes
      with WithGenericParameters
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def subscriptKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "subscriptKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def parameterClause: FunctionParameterClauseSyntax = json("children").arr.toList
      .find(_("name").str == "parameterClause")
      .map(createSwiftNode)
      .head
      .asInstanceOf[FunctionParameterClauseSyntax]

    def returnClause: ReturnClauseSyntax = json("children").arr.toList
      .find(_("name").str == "returnClause")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ReturnClauseSyntax]

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])

    def accessorBlock: Option[AccessorBlockSyntax] = json("children").arr.toList
      .find(_("name").str == "accessorBlock")
      .map(createSwiftNode)
      .map(_.asInstanceOf[AccessorBlockSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `superKeyword`: `super`
    *
    * ### Nowhere contained in
    */
  case class SuperExprSyntax(json: Value) extends ExprSyntax {
    def superKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "superKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `withoutTilde`: `<prefixOperator>`
    *   - `type`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class SuppressedTypeSyntax(json: Value) extends TypeSyntax {
    def withoutTilde: SwiftToken = json("children").arr.toList
      .find(_("name").str == "withoutTilde")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``SwitchCaseItemSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``SwitchCaseLabelSyntax``.``SwitchCaseLabelSyntax/caseItems``
    */
  case class SwitchCaseItemListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[SwitchCaseItemSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[SwitchCaseItemSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `pattern`: ``PatternSyntax``
    *   - `whereClause`: ``WhereClauseSyntax``?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``SwitchCaseItemListSyntax``
    */
  case class SwitchCaseItemSyntax(json: Value) extends Syntax with WithTrailingComma {
    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]

    def whereClause: Option[WhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "whereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[WhereClauseSyntax])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `caseKeyword`: `case`
    *   - `caseItems`: ``SwitchCaseItemListSyntax``
    *   - `colon`: `:`
    *
    * ### Contained in
    *
    *   - ``SwitchCaseSyntax``.``SwitchCaseSyntax/label``
    */
  case class SwitchCaseLabelSyntax(json: Value) extends Syntax {
    def caseKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "caseKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def caseItems: SwitchCaseItemListSyntax = json("children").arr.toList
      .find(_("name").str == "caseItems")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwitchCaseItemListSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * (``SwitchCaseSyntax`` | ``IfConfigDeclSyntax``) `*`
    *
    * ### Contained in
    *
    *   - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
    *   - ``SwitchExprSyntax``.``SwitchExprSyntax/cases``
    */
  case class SwitchCaseListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[SwitchCaseSyntax | IfConfigDeclSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[SwitchCaseSyntax | IfConfigDeclSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attribute`: ``AttributeSyntax``?
    *   - `label`: (``SwitchDefaultLabelSyntax`` | ``SwitchCaseLabelSyntax``)
    *   - `statements`: ``CodeBlockItemListSyntax``
    *
    * ### Contained in
    *
    *   - ``SwitchCaseListSyntax``
    */
  case class SwitchCaseSyntax(json: Value) extends Syntax with WithStatements {
    def attribute: Option[AttributeSyntax] = json("children").arr.toList
      .find(_("name").str == "attribute")
      .map(createSwiftNode)
      .map(_.asInstanceOf[AttributeSyntax])

    def label: SwitchDefaultLabelSyntax | SwitchCaseLabelSyntax = json("children").arr.toList
      .find(_("name").str == "label")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwitchDefaultLabelSyntax | SwitchCaseLabelSyntax]

    def statements: CodeBlockItemListSyntax = json("children").arr.toList
      .find(_("name").str == "statements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[CodeBlockItemListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `defaultKeyword`: `default`
    *   - `colon`: `:`
    *
    * ### Contained in
    *
    *   - ``SwitchCaseSyntax``.``SwitchCaseSyntax/label``
    */
  case class SwitchDefaultLabelSyntax(json: Value) extends Syntax {
    def defaultKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "defaultKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A `switch` expression.
    *
    * ### Examples
    *
    * This represents the switch expression in
    *
    * {{{
    * switch self.foo {
    * }
    * }}}
    *
    * A switch ecpression may be declared without any cases.
    *
    * ### Children
    *
    *   - `switchKeyword`: `switch`
    *   - `subject`: ``ExprSyntax``
    *   - `leftBrace`: `{`
    *   - `cases`: ``SwitchCaseListSyntax``
    *   - `rightBrace`: `}`
    *
    * ### Nowhere contained in
    */
  case class SwitchExprSyntax(json: Value) extends ExprSyntax with Braced {
    def switchKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "switchKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def subject: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "subject").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def leftBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def cases: SwitchCaseListSyntax = json("children").arr.toList
      .find(_("name").str == "cases")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwitchCaseListSyntax]

    def rightBrace: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightBrace").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * The ternary operator with operator precedences resolved.
    *
    * ### Examples
    *
    * {{{
    * a ? 1 : 0
    * }}}
    *
    *   - Note: This node is only generated after operators are folded using the `SwiftOperators` library. Beforehand,
    *     the parser does not know the precedences of operators and thus represents the `?` and `:` by an
    *     ``UnresolvedTernaryExprSyntax``.
    *
    * ### Children
    *
    *   - `condition`: ``ExprSyntax``
    *   - `questionMark`: `?`
    *   - `thenExpression`: ``ExprSyntax``
    *   - `colon`: `:`
    *   - `elseExpression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class TernaryExprSyntax(json: Value) extends ExprSyntax {
    def condition: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "condition").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def questionMark: SwiftToken = json("children").arr.toList
      .find(_("name").str == "questionMark")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def thenExpression: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "thenExpression")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def elseExpression: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "elseExpression")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * A statement used to indicate the produced value from an if/switch expression.
    *
    * Written as:
    * {{{
    * then <expr>
    * }}}
    *
    * ### Children
    *
    *   - `thenKeyword`: `then`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class ThenStmtSyntax(json: Value) extends StmtSyntax {
    def thenKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "thenKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `throwKeyword`: `throw`
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class ThrowStmtSyntax(json: Value) extends StmtSyntax {
    def throwKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "throwKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `throwsSpecifier`: (`throws` | `rethrows`)
    *   - `leftParen`: `(`?
    *   - `type`: ``TypeSyntax``?
    *   - `rightParen`: `)`?
    *
    * ### Contained in
    *
    *   - ``AccessorEffectSpecifiersSyntax``.``AccessorEffectSpecifiersSyntax/throwsClause``
    *   - ``DoStmtSyntax``.``DoStmtSyntax/throwsClause``
    *   - ``FunctionEffectSpecifiersSyntax``.``FunctionEffectSpecifiersSyntax/throwsClause``
    *   - ``TypeEffectSpecifiersSyntax``.``TypeEffectSpecifiersSyntax/throwsClause``
    */
  case class ThrowsClauseSyntax(json: Value) extends Syntax {
    def throwsSpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "throwsSpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def leftParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "leftParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def `type`: Option[TypeSyntax] =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).map(_.asInstanceOf[TypeSyntax])

    def rightParen: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "rightParen")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * An expression prefixed with `try`.
    *
    * ### Examples
    *
    * {{{
    * try foo()
    * }}}
    *
    * {{{
    * try? foo()
    * }}}
    *
    * {{{
    * try! foo()
    * }}}
    *
    * ### Children
    *
    *   - `tryKeyword`: `try`
    *   - `questionOrExclamationMark`: (`?` | `!`)?
    *   - `expression`: ``ExprSyntax``
    *
    * ### Nowhere contained in
    */
  case class TryExprSyntax(json: Value) extends ExprSyntax {
    def tryKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "tryKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def questionOrExclamationMark: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "questionOrExclamationMark")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `elements`: ``LabeledExprListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Nowhere contained in
    */
  case class TupleExprSyntax(json: Value) extends ExprSyntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def elements: LabeledExprListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[LabeledExprListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A list of ``TuplePatternElementSyntax``.
    *
    * ### Children
    *
    * ``TuplePatternElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``TuplePatternSyntax``.``TuplePatternSyntax/elements``
    */
  case class TuplePatternElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[TuplePatternElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[TuplePatternElementSyntax])
  }

  /** ### Documentation
    *
    * An element that represents a single tuple value in ``TuplePatternElementListSyntax``.
    *
    * ### Children
    *
    *   - `label`: `<identifier>`?
    *   - `colon`: `:`?
    *   - `pattern`: ``PatternSyntax``
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``TuplePatternElementListSyntax``
    */
  case class TuplePatternElementSyntax(json: Value) extends Syntax with WithTrailingComma {
    def label: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "label").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * A pattern that contains a list of other pattern.
    *
    * ### Examples
    *
    * ``TuplePatternSyntax`` can be used in more complex variable declarations. For example `(x, y)` in the example:
    *
    * {{{
    * let (x, y) = (1, 2)
    * }}}
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `elements`: ``TuplePatternElementListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Nowhere contained in
    */
  case class TuplePatternSyntax(json: Value) extends PatternSyntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def elements: TuplePatternElementListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TuplePatternElementListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``TupleTypeElementSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``FunctionTypeSyntax``.``FunctionTypeSyntax/parameters``
    *   - ``TupleTypeSyntax``.``TupleTypeSyntax/elements``
    */
  case class TupleTypeElementListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[TupleTypeElementSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[TupleTypeElementSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `inoutKeyword`: `inout`?
    *   - `firstName`: (`<identifier>` | `_`)?
    *   - `secondName`: (`<identifier>` | `_`)?
    *   - `colon`: `:`?
    *   - `type`: ``TypeSyntax``
    *   - `ellipsis`: `...`?
    *   - `trailingComma`: `,`?
    *
    * ### Contained in
    *
    *   - ``TupleTypeElementListSyntax``
    */
  case class TupleTypeElementSyntax(json: Value) extends Syntax with WithTrailingComma {
    def inoutKeyword: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "inoutKeyword")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def firstName: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "firstName")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def secondName: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "secondName")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def colon: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]

    def ellipsis: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "ellipsis").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])

    def trailingComma: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "trailingComma")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `elements`: ``TupleTypeElementListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Nowhere contained in
    */
  case class TupleTypeSyntax(json: Value) extends TypeSyntax with Parenthesized {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def elements: TupleTypeElementListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TupleTypeElementListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `typealiasKeyword`: `typealias`
    *   - `name`: `<identifier>`
    *   - `genericParameterClause`: ``GenericParameterClauseSyntax``?
    *   - `initializer`: ``TypeInitializerClauseSyntax``
    *   - `genericWhereClause`: ``GenericWhereClauseSyntax``?
    *
    * ### Nowhere contained in
    */
  case class TypeAliasDeclSyntax(json: Value)
      extends DeclSyntax
      with NamedDecl
      with WithAttributes
      with WithGenericParameters
      with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def typealiasKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "typealiasKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def name: SwiftToken =
      json("children").arr.toList.find(_("name").str == "name").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def genericParameterClause: Option[GenericParameterClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericParameterClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericParameterClauseSyntax])

    def initializer: TypeInitializerClauseSyntax = json("children").arr.toList
      .find(_("name").str == "initializer")
      .map(createSwiftNode)
      .head
      .asInstanceOf[TypeInitializerClauseSyntax]

    def genericWhereClause: Option[GenericWhereClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "genericWhereClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[GenericWhereClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `colon`: `:`
    *   - `type`: ``TypeSyntax``
    *
    * ### Contained in
    *
    *   - ``ForStmtSyntax``.``ForStmtSyntax/typeAnnotation``
    *   - ``MatchingPatternConditionSyntax``.``MatchingPatternConditionSyntax/typeAnnotation``
    *   - ``OptionalBindingConditionSyntax``.``OptionalBindingConditionSyntax/typeAnnotation``
    *   - ``PatternBindingSyntax``.``PatternBindingSyntax/typeAnnotation``
    */
  case class TypeAnnotationSyntax(json: Value) extends Syntax {
    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `asyncSpecifier`: `async`?
    *   - `throwsClause`: ``ThrowsClauseSyntax``?
    *
    * ### Contained in
    *
    *   - ``ArrowExprSyntax``.``ArrowExprSyntax/effectSpecifiers``
    *   - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/effectSpecifiers``
    *   - ``FunctionTypeSyntax``.``FunctionTypeSyntax/effectSpecifiers``
    */
  case class TypeEffectSpecifiersSyntax(json: Value) extends Syntax with EffectSpecifiers {
    def asyncSpecifier: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "asyncSpecifier")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])

    def throwsClause: Option[ThrowsClauseSyntax] = json("children").arr.toList
      .find(_("name").str == "throwsClause")
      .map(createSwiftNode)
      .map(_.asInstanceOf[ThrowsClauseSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `type`: ``TypeSyntax``
    *
    * ### Nowhere contained in
    */
  case class TypeExprSyntax(json: Value) extends ExprSyntax {
    def `type`: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "type").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `equal`: `=`
    *   - `value`: ``TypeSyntax``
    *
    * ### Contained in
    *
    *   - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/initializer``
    *   - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/initializer``
    */
  case class TypeInitializerClauseSyntax(json: Value) extends Syntax {
    def equal: SwiftToken =
      json("children").arr.toList.find(_("name").str == "equal").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def value: TypeSyntax =
      json("children").arr.toList.find(_("name").str == "value").map(createSwiftNode).head.asInstanceOf[TypeSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * (``SimpleTypeSpecifierSyntax`` | `LifetimeTypeSpecifierSyntax`) `*`
    *
    * ### Contained in
    *
    *   - ``AttributedTypeSyntax``.``AttributedTypeSyntax/specifiers``
    */
  case class TypeSpecifierListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[SimpleTypeSpecifierSyntax | LifetimeTypeSpecifierSyntax] = json("children").arr.toList
      .map(createSwiftNode)
      .map(_.asInstanceOf[SimpleTypeSpecifierSyntax | LifetimeTypeSpecifierSyntax])
  }

  /** ### Documentation
    *
    * The arguments for the '@_unavailableFromAsync' attribute
    *
    * ### Children
    *
    *   - `messageLabel`: `message`
    *   - `colon`: `:`
    *   - `message`: ``StringLiteralExprSyntax``
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class UnavailableFromAsyncAttributeArgumentsSyntax(json: Value) extends Syntax {
    def messageLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "messageLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def message: StringLiteralExprSyntax = json("children").arr.toList
      .find(_("name").str == "message")
      .map(createSwiftNode)
      .head
      .asInstanceOf[StringLiteralExprSyntax]
  }

  /** ### Documentation
    *
    * The arguments for the '@_private' attribute
    *
    * ### Children
    *
    *   - `sourceFileLabel`: `sourceFile`
    *   - `colon`: `:`
    *   - `filename`: ``StringLiteralExprSyntax``
    *
    * ### Contained in
    *
    *   - ``AttributeSyntax``.``AttributeSyntax/arguments``
    */
  case class UnderscorePrivateAttributeArgumentsSyntax(json: Value) extends Syntax {
    def sourceFileLabel: SwiftToken = json("children").arr.toList
      .find(_("name").str == "sourceFileLabel")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def filename: StringLiteralExprSyntax = json("children").arr.toList
      .find(_("name").str == "filename")
      .map(createSwiftNode)
      .head
      .asInstanceOf[StringLiteralExprSyntax]
  }

  /** ### Documentation
    *
    * A collection of syntax nodes that occurred in the source code but could not be used to form a valid syntax tree.
    *
    * ### Children
    *
    * ``Syntax`` `*`
    *
    * ### Nowhere contained in
    */
  case class UnexpectedNodesSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[Syntax] = json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[Syntax])
  }

  /** ### Documentation
    *
    * The `as` keyword without any operands.
    *
    *   - Note: The parser does not know the precedences of operators and thus represents `as` by an
    *     ``UnresolvedAsExprSyntax``. After operator folding using the `SwiftOperators` library, this gets translated to
    *     an ``AsExprSyntax``.
    *
    * ### Children
    *
    *   - `asKeyword`: `as`
    *   - `questionOrExclamationMark`: (`?` | `!`)?
    *
    * ### Nowhere contained in
    */
  case class UnresolvedAsExprSyntax(json: Value) extends ExprSyntax {
    def asKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "asKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def questionOrExclamationMark: Option[SwiftToken] = json("children").arr.toList
      .find(_("name").str == "questionOrExclamationMark")
      .map(createSwiftNode)
      .map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * The `is` keyword without any operands.
    *
    *   - Note: The parser does not know the precedences of operators and thus represents `is` by an
    *     ``UnresolvedIsExprSyntax``. After operator folding using the `SwiftOperators` library, this gets translated to
    *     an ``IsExprSyntax``.
    *
    * ### Children
    *
    *   - `isKeyword`: `is`
    *
    * ### Nowhere contained in
    */
  case class UnresolvedIsExprSyntax(json: Value) extends ExprSyntax {
    def isKeyword: SwiftToken =
      json("children").arr.toList.find(_("name").str == "isKeyword").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * The middle section of a ternary operator between `?` and `:`.
    *
    *   - Note: The parser does not know the precedences of operators and thus represents the middle section of a
    *     ternary operator by an ``UnresolvedTernaryExprSyntax``. After operator folding using the `SwiftOperators`
    *     library, this gets translated to an ``TernaryExprSyntax``.
    *
    * ### Children
    *
    *   - `questionMark`: `?`
    *   - `thenExpression`: ``ExprSyntax``
    *   - `colon`: `:`
    *
    * ### Nowhere contained in
    */
  case class UnresolvedTernaryExprSyntax(json: Value) extends ExprSyntax {
    def questionMark: SwiftToken = json("children").arr.toList
      .find(_("name").str == "questionMark")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def thenExpression: ExprSyntax = json("children").arr.toList
      .find(_("name").str == "thenExpression")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ExprSyntax]

    def colon: SwiftToken =
      json("children").arr.toList.find(_("name").str == "colon").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `bindingSpecifier`: (`let` | `var` | `inout` | `_mutating` | `_borrowing` | `_consuming`)
    *   - `pattern`: ``PatternSyntax``
    *
    * ### Nowhere contained in
    */
  case class ValueBindingPatternSyntax(json: Value) extends PatternSyntax {
    def bindingSpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "bindingSpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def pattern: PatternSyntax =
      json("children").arr.toList.find(_("name").str == "pattern").map(createSwiftNode).head.asInstanceOf[PatternSyntax]
  }

  /** ### Documentation
    *
    * Declaration of one or more variables
    *
    * The core of a variable declaration consists of a binding specifier (`let` or `var`), followed by any number of
    * pattern bindings, which define the variables.
    *
    * ### Children
    *
    *   - `attributes`: ``AttributeListSyntax``
    *   - `modifiers`: ``DeclModifierListSyntax``
    *   - `bindingSpecifier`: (`let` | `var` | `inout` | `_mutating` | `_borrowing` | `_consuming`)
    *   - `bindings`: ``PatternBindingListSyntax``
    *
    * ### Nowhere contained in
    */
  case class VariableDeclSyntax(json: Value) extends DeclSyntax with WithAttributes with WithModifiers {
    def attributes: AttributeListSyntax = json("children").arr.toList
      .find(_("name").str == "attributes")
      .map(createSwiftNode)
      .head
      .asInstanceOf[AttributeListSyntax]

    def modifiers: DeclModifierListSyntax = json("children").arr.toList
      .find(_("name").str == "modifiers")
      .map(createSwiftNode)
      .head
      .asInstanceOf[DeclModifierListSyntax]

    def bindingSpecifier: SwiftToken = json("children").arr.toList
      .find(_("name").str == "bindingSpecifier")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def bindings: PatternBindingListSyntax = json("children").arr.toList
      .find(_("name").str == "bindings")
      .map(createSwiftNode)
      .head
      .asInstanceOf[PatternBindingListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``VersionComponentSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``VersionTupleSyntax``.``VersionTupleSyntax/components``
    */
  case class VersionComponentListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[VersionComponentSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[VersionComponentSyntax])
  }

  /** ### Documentation
    *
    * An element to represent a single component in a version, like `.1`.
    *
    * ### Children
    *
    *   - `period`: `.`
    *   - `number`: `<integerLiteral>`
    *
    * ### Contained in
    *
    *   - ``VersionComponentListSyntax``
    */
  case class VersionComponentSyntax(json: Value) extends Syntax {
    def period: SwiftToken =
      json("children").arr.toList.find(_("name").str == "period").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def number: SwiftToken =
      json("children").arr.toList.find(_("name").str == "number").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * A version number like `1.2.0`. Only the first version component is required. There might be an arbitrary number of
    * following components.
    *
    * ### Children
    *
    *   - `major`: `<integerLiteral>`
    *   - `components`: ``VersionComponentListSyntax``
    *
    * ### Contained in
    *
    *   - ``AvailabilityLabeledArgumentSyntax``.``AvailabilityLabeledArgumentSyntax/value``
    *   - ``CanImportVersionInfoSyntax``.``CanImportVersionInfoSyntax/version``
    *   - ``PlatformVersionSyntax``.``PlatformVersionSyntax/version``
    */
  case class VersionTupleSyntax(json: Value) extends Syntax {
    def major: SwiftToken =
      json("children").arr.toList.find(_("name").str == "major").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def components: VersionComponentListSyntax = json("children").arr.toList
      .find(_("name").str == "components")
      .map(createSwiftNode)
      .head
      .asInstanceOf[VersionComponentListSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `whereKeyword`: `where`
    *   - `condition`: ``ExprSyntax``
    *
    * ### Contained in
    *
    *   - ``CatchItemSyntax``.``CatchItemSyntax/whereClause``
    *   - ``ForStmtSyntax``.``ForStmtSyntax/whereClause``
    *   - ``SwitchCaseItemSyntax``.``SwitchCaseItemSyntax/whereClause``
    */
  case class WhereClauseSyntax(json: Value) extends Syntax {
    def whereKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "whereKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def condition: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "condition").map(createSwiftNode).head.asInstanceOf[ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `whileKeyword`: `while`
    *   - `conditions`: ``ConditionElementListSyntax``
    *   - `body`: ``CodeBlockSyntax``
    *
    * ### Nowhere contained in
    */
  case class WhileStmtSyntax(json: Value) extends StmtSyntax with WithCodeBlock {
    def whileKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "whileKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def conditions: ConditionElementListSyntax = json("children").arr.toList
      .find(_("name").str == "conditions")
      .map(createSwiftNode)
      .head
      .asInstanceOf[ConditionElementListSyntax]

    def body: CodeBlockSyntax =
      json("children").arr.toList.find(_("name").str == "body").map(createSwiftNode).head.asInstanceOf[CodeBlockSyntax]
  }

  /** ### Documentation
    *
    * A pattern that represent a wildcard.
    *
    * ### Examples
    *
    * ``WildcardPatternSyntax`` matches and ignores any value. For example `_` in the example:
    *
    * {{{
    * for _ in 1...3 {
    *   // ...
    * }
    * }}}
    *
    * ### Children
    *
    *   - `wildcard`: `_`
    *
    * ### Nowhere contained in
    */
  case class WildcardPatternSyntax(json: Value) extends PatternSyntax {
    def wildcard: SwiftToken =
      json("children").arr.toList.find(_("name").str == "wildcard").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `yieldKeyword`: `yield`
    *   - `yieldedExpressions`: (``YieldedExpressionsClauseSyntax`` | ``ExprSyntax``)
    *
    * ### Nowhere contained in
    */
  case class YieldStmtSyntax(json: Value) extends StmtSyntax {
    def yieldKeyword: SwiftToken = json("children").arr.toList
      .find(_("name").str == "yieldKeyword")
      .map(createSwiftNode)
      .head
      .asInstanceOf[SwiftToken]

    def yieldedExpressions: YieldedExpressionsClauseSyntax | ExprSyntax = json("children").arr.toList
      .find(_("name").str == "yieldedExpressions")
      .map(createSwiftNode)
      .head
      .asInstanceOf[YieldedExpressionsClauseSyntax | ExprSyntax]
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    * ``YieldedExpressionSyntax`` `*`
    *
    * ### Contained in
    *
    *   - ``YieldedExpressionsClauseSyntax``.``YieldedExpressionsClauseSyntax/elements``
    */
  case class YieldedExpressionListSyntax(json: Value) extends SyntaxCollection {
    def children: Seq[YieldedExpressionSyntax] =
      json("children").arr.toList.map(createSwiftNode).map(_.asInstanceOf[YieldedExpressionSyntax])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `expression`: ``ExprSyntax``
    *   - `comma`: `,`?
    *
    * ### Contained in
    *
    *   - ``YieldedExpressionListSyntax``
    */
  case class YieldedExpressionSyntax(json: Value) extends Syntax {
    def expression: ExprSyntax =
      json("children").arr.toList.find(_("name").str == "expression").map(createSwiftNode).head.asInstanceOf[ExprSyntax]

    def comma: Option[SwiftToken] =
      json("children").arr.toList.find(_("name").str == "comma").map(createSwiftNode).map(_.asInstanceOf[SwiftToken])
  }

  /** ### Documentation
    *
    * No documentation available.
    *
    * ### Children
    *
    *   - `leftParen`: `(`
    *   - `elements`: ``YieldedExpressionListSyntax``
    *   - `rightParen`: `)`
    *
    * ### Contained in
    *
    *   - ``YieldStmtSyntax``.``YieldStmtSyntax/yieldedExpressions``
    */
  case class YieldedExpressionsClauseSyntax(json: Value) extends Syntax {
    def leftParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "leftParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]

    def elements: YieldedExpressionListSyntax = json("children").arr.toList
      .find(_("name").str == "elements")
      .map(createSwiftNode)
      .head
      .asInstanceOf[YieldedExpressionListSyntax]

    def rightParen: SwiftToken =
      json("children").arr.toList.find(_("name").str == "rightParen").map(createSwiftNode).head.asInstanceOf[SwiftToken]
  }

  case class TokenSyntax(json: Value) extends Syntax

}
