/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import io.joern.x2cpg.utils.dependency.DependencyResolverParams;
import io.joern.x2cpg.utils.dependency.DependencyResolverParams$;
import io.joern.x2cpg.utils.dependency.GradleConfigKeys$;
import io.joern.x2cpg.utils.dependency.GradleDependencies$;
import io.joern.x2cpg.utils.dependency.MavenDependencies$;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.Seq;

public final class DependencyResolver$ {
    public static final DependencyResolver$ MODULE$ = new DependencyResolver$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String defaultGradleProjectName;
    private static final String defaultGradleConfigurationName;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        defaultGradleProjectName = "app";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        defaultGradleConfigurationName = "releaseCompileClasspath";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    private Logger logger() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/x2cpg/src/main/scala/io/joern/x2cpg/utils/dependency/DependencyResolver.scala: 18");
        }
        return logger;
    }

    private String defaultGradleProjectName() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/x2cpg/src/main/scala/io/joern/x2cpg/utils/dependency/DependencyResolver.scala: 19");
        }
        return defaultGradleProjectName;
    }

    private String defaultGradleConfigurationName() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/x2cpg/src/main/scala/io/joern/x2cpg/utils/dependency/DependencyResolver.scala: 20");
        }
        return defaultGradleConfigurationName;
    }

    public Option<Seq<String>> getDependencies(Path projectDir, DependencyResolverParams params) {
        Some some;
        if (this.isMavenBuild(projectDir)) {
            this.logger().info("resolving Maven dependencies at {}", (Object)projectDir);
            some = new Some(MavenDependencies$.MODULE$.get(projectDir));
        } else if (this.isGradleBuild(projectDir)) {
            Some some2;
            this.logger().info("resolving Gradle dependencies at {}", (Object)projectDir);
            String gradleProjectName = (String)params.forGradle().getOrElse((Object)GradleConfigKeys$.MODULE$.ProjectName(), (Function0 & Serializable)() -> MODULE$.defaultGradleProjectName());
            String gradleConfiguration = (String)params.forGradle().getOrElse((Object)GradleConfigKeys$.MODULE$.ConfigurationName(), (Function0 & Serializable)() -> MODULE$.defaultGradleConfigurationName());
            Option<Seq<String>> option = GradleDependencies$.MODULE$.get(projectDir, gradleProjectName, gradleConfiguration);
            if (option instanceof Some) {
                Some some3 = (Some)option;
                Seq deps = (Seq)some3.value();
                some2 = new Some((Object)deps);
            } else if (None$.MODULE$.equals(option)) {
                this.logger().warn(new StringBuilder(61).append("Could not download Gradle dependencies for project at path `").append(projectDir).append("`").toString());
                some2 = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            some = some2;
        } else {
            this.logger().warn(new StringBuilder(54).append("Could not find a supported build tool setup at path `").append(projectDir).append("`").toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public DependencyResolverParams getDependencies$default$2() {
        return new DependencyResolverParams(DependencyResolverParams$.MODULE$.$lessinit$greater$default$1(), DependencyResolverParams$.MODULE$.$lessinit$greater$default$2());
    }

    public boolean isMavenBuild(Path codeDir) {
        return Files.exists(codeDir.resolve("pom.xml"), new LinkOption[0]);
    }

    public boolean isGradleBuild(Path codeDir) {
        return Files.walk(codeDir, new FileVisitOption[0]).anyMatch(file -> ((Object)file).toString().endsWith(".gradle") || ((Object)file).toString().endsWith(".gradle.kts"));
    }

    private DependencyResolver$() {
    }
}

