/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import better.files.File$;
import io.joern.x2cpg.utils.dependency.Constants$;
import io.joern.x2cpg.utils.dependency.GradleDepsInitScript;
import io.joern.x2cpg.utils.dependency.GradleDepsInitScript$;
import io.joern.x2cpg.utils.dependency.GradleProjectInfo;
import io.joern.x2cpg.utils.dependency.GradleProjectInfo$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class GradleDependencies$
implements Serializable {
    private static final Logger logger;
    private static final String initScriptPrefix;
    private static final String taskNamePrefix;
    private static final String tempDirPrefix;
    public static final GradleDependencies$ MODULE$;

    private GradleDependencies$() {
    }

    static {
        MODULE$ = new GradleDependencies$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        initScriptPrefix = "x2cpg.init.gradle";
        taskNamePrefix = "x2cpgCopyDeps";
        tempDirPrefix = "x2cpgDependencies";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GradleDependencies$.class);
    }

    private String gradle5OrLaterAndroidInitScript(String taskName, String destination, String gradleProjectName, String gradleConfigurationName) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1750).append("\n       |allprojects {\n       |  afterEvaluate { project ->\n       |    def taskName = \"").append(taskName).append("\"\n       |    def destinationDir = \"").append(destination).append("\"\n       |    def gradleProjectName = \"").append(gradleProjectName).append("\"\n       |    def gradleConfigurationName = \"").append(gradleConfigurationName).append("\"\n       |\n       |    if (project.name.equals(gradleProjectName)) {\n       |      def compileDepsCopyTaskName = taskName + \"_compileDeps\"\n       |      tasks.register(compileDepsCopyTaskName, Copy) {\n       |        def selectedConfig = project.configurations.find { it.name.equals(gradleConfigurationName) }\n       |        def componentIds = []\n       |        if (selectedConfig != null) {\n       |          componentIds = selectedConfig.incoming.resolutionResult.allDependencies.collect { it.selected.id }\n       |        }\n       |        def result = dependencies.createArtifactResolutionQuery()\n       |                                 .forComponents(componentIds)\n       |                                 .withArtifacts(JvmLibrary, SourcesArtifact)\n       |                                 .execute()\n       |        duplicatesStrategy = 'include'\n       |        into destinationDir\n       |        from result.resolvedComponents.collect { it.getArtifacts(SourcesArtifact).collect { it.file } }\n       |      }\n       |      def androidDepsCopyTaskName = taskName + \"_androidDeps\"\n       |      tasks.register(androidDepsCopyTaskName, Copy) {\n       |        duplicatesStrategy = 'include'\n       |        into destinationDir\n       |        from project.configurations.find { it.name.equals(\"androidApis\") }\n       |      }\n       |      tasks.register(taskName, Copy) {\n       |        dependsOn androidDepsCopyTaskName\n       |        dependsOn compileDepsCopyTaskName\n       |      }\n       |    }\n       |  }\n       |}\n       |").toString()));
    }

    private String gradle5OrLaterInitScript(String taskName, String destination) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n     |allprojects {\n     |  apply plugin: 'java'\n     |  task ").append(taskName).append("(type: Copy) {\n     |    into \"").append(destination).append("\"\n     |    from configurations.default\n     |  }\n     |}\n     |").toString()));
    }

    private GradleDepsInitScript makeInitScript(Path destinationDir, boolean forAndroid, String gradleProjectName, String gradleConfigurationName) {
        String taskName = new StringBuilder(1).append(taskNamePrefix).append("_").append(Random$.MODULE$.alphanumeric().take(8).toList().mkString()).toString();
        String content = forAndroid ? this.gradle5OrLaterAndroidInitScript(taskName, destinationDir.toString(), gradleProjectName, gradleConfigurationName) : this.gradle5OrLaterInitScript(taskName, destinationDir.toString());
        return GradleDepsInitScript$.MODULE$.apply(content, taskName, destinationDir);
    }

    public ProjectConnection makeConnection(File projectDir) {
        return GradleConnector.newConnector().forProjectDirectory(projectDir).connect();
    }

    private Option<GradleProjectInfo> getGradleProjectInfo(Path projectDir, String projectName) {
        Option option;
        Try try_ = Try$.MODULE$.apply(() -> this.getGradleProjectInfo$$anonfun$1(projectDir));
        if (try_ instanceof Success) {
            ProjectConnection gradleConnection = (ProjectConnection)((Success)try_).value();
            option = (Option)Using$.MODULE$.resource((Object)gradleConnection, (Function1 & Serializable)connection -> {
                None$ none$;
                block9: {
                    try {
                        boolean bl;
                        BuildEnvironment buildEnv = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
                        GradleProject project = (GradleProject)connection.getModel(GradleProject.class);
                        Option<String> option = this.runGradleTask((ProjectConnection)connection, Constants$.MODULE$.gradlePropertiesTaskName());
                        if (option instanceof Some) {
                            String out = (String)((Some)option).value();
                            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(out), '\n'));
                            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1.startsWith(Constants$.MODULE$.gradleAndroidPropertyPrefix())));
                            bl = ArrayOps$.MODULE$.nonEmpty$extension(object2);
                        } else if (None$.MODULE$.equals(option)) {
                            bl = false;
                        } else {
                            throw new MatchError(option);
                        }
                        boolean hasAndroidPrefixGradleProperty = bl;
                        GradleProjectInfo info = GradleProjectInfo$.MODULE$.apply(buildEnv.getGradle().getGradleVersion(), (scala.collection.immutable.Seq<String>)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala((Set)project.getTasks()).asScala().map((Function1 & Serializable)_$2 -> _$2.getName())).toSeq(), hasAndroidPrefixGradleProperty);
                        if (hasAndroidPrefixGradleProperty) {
                            List validProjectNames = (List)((IterableOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{project.getName()}))).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(project.getChildren().getAll()).asScala().map((Function1 & Serializable)_$3 -> _$3.getName()));
                            logger.debug(new StringBuilder(23).append("Found Gradle projects: ").append(validProjectNames.mkString(",")).toString());
                            if (!validProjectNames.contains((Object)projectName)) {
                                String validProjectNamesStr = validProjectNames.mkString(",");
                                logger.warn(new StringBuilder(81).append("The provided Gradle project name `").append(projectName).append("` is is not part of the valid project names: `").append(validProjectNamesStr).append("`").toString());
                                none$ = None$.MODULE$;
                            } else {
                                none$ = Some$.MODULE$.apply((Object)info);
                            }
                            break block9;
                        }
                        none$ = Some$.MODULE$.apply((Object)info);
                    }
                    catch (Throwable t) {
                        logger.warn(new StringBuilder(53).append("Caught exception while trying use Gradle connection: ").append(t.getMessage()).toString());
                        logger.debug("Full exception: ", t);
                        none$ = None$.MODULE$;
                    }
                }
                return none$;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        } else if (try_ instanceof Failure) {
            Throwable t = ((Failure)try_).exception();
            logger.warn(new StringBuilder(64).append("Caught exception while trying fetch Gradle project information: ").append(t.getMessage()).toString());
            logger.debug("Full exception: ", t);
            option = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return option;
    }

    private Option<String> runGradleTask(ProjectConnection connection, String taskName) {
        return (Option)Using$.MODULE$.resource((Object)new ByteArrayOutputStream(), (Function1 & Serializable)out -> {
            Some some;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.runGradleTask$$anonfun$1$$anonfun$1(connection, taskName, (ByteArrayOutputStream)out);
                return BoxedUnit.UNIT;
            });
            if (try_ instanceof Success) {
                some = Some$.MODULE$.apply((Object)out.toString());
            } else if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                logger.warn(new StringBuilder(54).append("Caught exception while executing Gradle task named `").append(taskName).append("`:").toString(), (Object)ex.getMessage());
                logger.debug("Full exception: ", ex);
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            return some;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Seq<String>> runGradleTask(ProjectConnection connection, GradleDepsInitScript initScript, String initScriptPath) {
        return (Option)Using$.MODULE$.resources((Object)new ByteArrayOutputStream(), this::runGradleTask$$anonfun$2, (Function2 & Serializable)(x$1, x$2) -> {
            Some some;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ByteArrayOutputStream stdoutStream = (ByteArrayOutputStream)tuple2._1();
            ByteArrayOutputStream stderrStream = (ByteArrayOutputStream)tuple2._2();
            logger.info(new StringBuilder(27).append("Executing gradle task '").append(initScript.taskName()).append("'...").toString());
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.runGradleTask$$anonfun$3$$anonfun$1(connection, initScript, initScriptPath, stdoutStream, stderrStream);
                return BoxedUnit.UNIT;
            });
            if (try_ instanceof Success) {
                Buffer result = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(Files.list(initScript.destinationDir()).collect(Collectors.toList())).asScala().map((Function1 & Serializable)_$4 -> _$4.toAbsolutePath().toString());
                logger.info(new StringBuilder(29).append("Resolved `").append(result.size()).append("` dependency files.").toString());
                some = Some$.MODULE$.apply((Object)result);
                return some;
            } else {
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Throwable ex = ((Failure)try_).exception();
                logger.warn(new StringBuilder(46).append("Caught exception while executing Gradle task: ").append(ex.getMessage()).toString());
                logger.debug(new StringBuilder(31).append("Gradle task execution stdout: \n").append(stdoutStream).toString());
                logger.debug(new StringBuilder(31).append("Gradle task execution stderr: \n").append(stderrStream).toString());
                some = None$.MODULE$;
            }
            return some;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Path> extractClassesJarFromAar(better.files.File aar) {
        None$ none$;
        String newPath = aar.path().toString().replaceFirst(new StringBuilder(1).append(Constants$.MODULE$.aarFileExtension()).append("$").toString(), "jar");
        String aarUnzipDirSuffix = ".unzipped";
        better.files.File outDir = File$.MODULE$.apply(new StringBuilder(0).append(aar.path().toString()).append(aarUnzipDirSuffix).toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        Function1 & Serializable intersect = (Function1 & Serializable)_$5 -> {
            String string = _$5.getName();
            String string2 = Constants$.MODULE$.jarInsideAarFileName();
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        aar.unzipTo(outDir, (Function1)intersect, aar.unzipTo$default$3(outDir, (Function1)intersect));
        better.files.File outFile = File$.MODULE$.apply(newPath, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        List classesJarEntries = outDir.listRecursively(outDir.listRecursively$default$1()).filter((Function1 & Serializable)_$6 -> {
            String string = _$6.path().getFileName().toString();
            String string2 = Constants$.MODULE$.jarInsideAarFileName();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).toList();
        if (classesJarEntries.size() != 1) {
            logger.warn(new StringBuilder(52).append("Found aar file without `classes.jar` inside at path ").append(aar.path()).toString());
            outDir.delete(outDir.delete$default$1(), outDir.delete$default$2());
            none$ = None$.MODULE$;
        } else {
            better.files.File classesJar = (better.files.File)classesJarEntries.toList().head();
            logger.trace(new StringBuilder(43).append("Copying `classes.jar` for aar at `").append(aar.path().toString()).append("` into `").append(newPath).append("`").toString());
            boolean bl = classesJar.copyTo$default$2();
            classesJar.copyTo(outFile, bl, classesJar.copyTo$default$3(outFile, bl));
            outDir.delete(outDir.delete$default$1(), outDir.delete$default$2());
            aar.delete(aar.delete$default$1(), aar.delete$default$2());
            none$ = Some$.MODULE$.apply((Object)outFile.path());
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Seq<String>> get(Path projectDir, String projectName, String configurationName) {
        None$ none$;
        logger.info(new StringBuilder(68).append("Fetching Gradle project information at path `").append(projectDir).append("` with project name `").append(projectName).append("`.").toString());
        Option<GradleProjectInfo> option = this.getGradleProjectInfo(projectDir, projectName);
        if (option instanceof Some) {
            GradleProjectInfo gradleProjectInfo = (GradleProjectInfo)((Some)option).value();
            GradleProjectInfo projectInfo = gradleProjectInfo;
            if (BoxesRunTime.unboxToInt((Object)projectInfo.gradleVersionMajorMinor()._1()) < 5) {
                logger.warn(new StringBuilder(29).append("Unsupported Gradle version `").append(projectInfo.gradleVersion()).append("`").toString());
                none$ = None$.MODULE$;
                return none$;
            } else {
                GradleProjectInfo projectInfo2 = gradleProjectInfo;
                Try try_ = Try$.MODULE$.apply(this::get$$anonfun$1);
                if (try_ instanceof Success) {
                    better.files.File destinationDir = (better.files.File)((Success)try_).value();
                    Try try_2 = Try$.MODULE$.apply(this::get$$anonfun$2);
                    if (try_2 instanceof Success) {
                        better.files.File initScriptFile = (better.files.File)((Success)try_2).value();
                        GradleDepsInitScript initScript = this.makeInitScript(destinationDir.path(), projectInfo2.hasAndroidSubproject(), projectName, configurationName);
                        initScriptFile.write(initScript.contents(), initScriptFile.write$default$2(initScript.contents()), initScriptFile.write$default$3(initScript.contents()));
                        logger.info(new StringBuilder(76).append("Downloading dependencies for configuration `").append(configurationName).append("` of project `").append(projectName).append("` at `").append(projectDir).append("` into `").append(destinationDir).append("`...").toString());
                        Try try_3 = Try$.MODULE$.apply(() -> this.get$$anonfun$3(projectDir));
                        if (try_3 instanceof Success) {
                            ProjectConnection connection = (ProjectConnection)((Success)try_3).value();
                            none$ = (Option)Using$.MODULE$.resource((Object)connection, (Function1 & Serializable)c -> {
                                None$ none$;
                                Option<Seq<String>> option = this.runGradleTask((ProjectConnection)c, initScript, initScriptFile.pathAsString());
                                if (option instanceof Some) {
                                    Seq deps = (Seq)((Some)option).value();
                                    none$ = Some$.MODULE$.apply(deps.map((Function1 & Serializable)d -> {
                                        String string;
                                        if (!d.endsWith(Constants$.MODULE$.aarFileExtension())) {
                                            string = d;
                                        } else {
                                            Option<Path> option = this.extractClassesJarFromAar(File$.MODULE$.apply(d, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
                                            if (option instanceof Some) {
                                                Path path = (Path)((Some)option).value();
                                                string = path.toString();
                                            } else if (None$.MODULE$.equals(option)) {
                                                string = d;
                                            } else {
                                                throw new MatchError(option);
                                            }
                                        }
                                        return string;
                                    }));
                                } else if (None$.MODULE$.equals(option)) {
                                    none$ = None$.MODULE$;
                                } else {
                                    throw new MatchError(option);
                                }
                                return none$;
                            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                            return none$;
                        } else {
                            if (!(try_3 instanceof Failure)) throw new MatchError((Object)try_3);
                            Throwable ex = ((Failure)try_3).exception();
                            logger.warn(new StringBuilder(64).append("Caught exception while trying to establish a Gradle connection: ").append(ex.getMessage()).toString());
                            logger.debug("Full exception: ", ex);
                            none$ = None$.MODULE$;
                        }
                        return none$;
                    } else {
                        if (!(try_2 instanceof Failure)) throw new MatchError((Object)try_2);
                        Throwable ex = ((Failure)try_2).exception();
                        logger.warn(new StringBuilder(56).append("Could not create temporary file for Gradle init script: ").append(ex.getMessage()).toString());
                        logger.debug("Full exception: ", ex);
                        none$ = None$.MODULE$;
                    }
                    return none$;
                } else {
                    if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                    Throwable ex = ((Failure)try_).exception();
                    logger.warn(new StringBuilder(66).append("Could not create temporary directory for saving dependency files: ").append(ex.getMessage()).toString());
                    logger.debug("Full exception: ", ex);
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            logger.warn("Could not fetch Gradle project information");
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final ProjectConnection getGradleProjectInfo$$anonfun$1(Path projectDir$1) {
        return this.makeConnection(projectDir$1.toFile());
    }

    private final void runGradleTask$$anonfun$1$$anonfun$1(ProjectConnection connection$2, String taskName$2, ByteArrayOutputStream out$1) {
        ((BuildLauncher)connection$2.newBuild().forTasks(new String[]{taskName$2}).setStandardOutput((OutputStream)out$1)).run();
    }

    private final ByteArrayOutputStream runGradleTask$$anonfun$2() {
        return new ByteArrayOutputStream();
    }

    private final void runGradleTask$$anonfun$3$$anonfun$1(ProjectConnection connection$4, GradleDepsInitScript initScript$2, String initScriptPath$2, ByteArrayOutputStream stdoutStream$1, ByteArrayOutputStream stderrStream$1) {
        ((BuildLauncher)connection$4.newBuild().forTasks(new String[]{initScript$2.taskName()}).withArguments(new String[]{"--init-script", initScriptPath$2}).setStandardOutput((OutputStream)stdoutStream$1).setStandardError((OutputStream)stderrStream$1)).run();
    }

    private final better.files.File get$$anonfun$1() {
        Option option = File$.MODULE$.newTemporaryDirectory$default$2();
        better.files.File file = File$.MODULE$.newTemporaryDirectory(tempDirPrefix, option, File$.MODULE$.newTemporaryDirectory$default$3(tempDirPrefix, option));
        return file.deleteOnExit(file.deleteOnExit$default$1(), file.deleteOnExit$default$2());
    }

    private final better.files.File get$$anonfun$2() {
        String string = File$.MODULE$.newTemporaryFile$default$2();
        Option option = File$.MODULE$.newTemporaryFile$default$3();
        better.files.File file = File$.MODULE$.newTemporaryFile(initScriptPrefix, string, option, File$.MODULE$.newTemporaryFile$default$4(initScriptPrefix, string, option));
        return file.deleteOnExit(file.deleteOnExit$default$1(), file.deleteOnExit$default$2());
    }

    private final ProjectConnection get$$anonfun$3(Path projectDir$2) {
        return this.makeConnection(projectDir$2.toFile());
    }
}

