/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.testfixtures;

import io.joern.x2cpg.testfixtures.Code2CpgFixture;
import io.joern.x2cpg.testfixtures.LanguageFrontend;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Cpg$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import overflowdb.Graph;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.function.JProcedure1;

public class TestCpg
extends Cpg {
    private final LanguageFrontend frontend;
    private final Code2CpgFixture fixture;
    private Option<Graph> _graph;
    private final ArrayBuffer<Tuple2<String, Path>> codeFileNamePairs;
    private int fileNameCounter;

    public TestCpg(LanguageFrontend frontend, Code2CpgFixture fixture) {
        this.frontend = frontend;
        this.fixture = fixture;
        super(Cpg$.MODULE$.$lessinit$greater$default$1());
        this._graph = Option$.MODULE$.empty();
        this.codeFileNamePairs = ArrayBuffer$.MODULE$.empty();
        this.fileNameCounter = 0;
    }

    /*
     * WARNING - void declaration
     */
    public TestCpg moreCode(String code) {
        void var2_2;
        TestCpg result = this.moreCode(code, new StringBuilder(4).append("Test").append(this.fileNameCounter).append(this.frontend.fileSuffix()).toString());
        ++this.fileNameCounter;
        return var2_2;
    }

    public TestCpg moreCode(String code, String fileName) {
        this.checkGraphEmpty();
        this.codeFileNamePairs.append((Object)Tuple2$.MODULE$.apply((Object)code, (Object)Paths.get(fileName, new String[0])));
        return this;
    }

    private void checkGraphEmpty() {
        if (this._graph.isDefined()) {
            throw new RuntimeException("Modifying test data is not allowed after accessing graph.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Path codeToFileSystem() {
        void var1_1;
        Path tmpDir = Files.createTempDirectory("x2cpgTestTmpDir", new FileAttribute[0]);
        this.codeFileNamePairs.foreach((Function1 & Serializable)x$1 -> {
            Path fileName;
            String code;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                code = (String)tuple2._1();
                fileName = (Path)tuple2._2();
                if (fileName.getParent() != null) {
                    Files.createDirectories(tmpDir.resolve(fileName.getParent()), new FileAttribute[0]);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            byte[] codeAsBytes = code.getBytes(StandardCharsets.UTF_8);
            return Files.write(tmpDir.resolve(Paths.get(fileName.toString(), new String[0])), codeAsBytes, new OpenOption[0]);
        });
        return var1_1;
    }

    private void deleteDir(Path dir) {
        Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(_$1 -> Files.delete(_$1));
    }

    public Graph graph() {
        if (this._graph.isEmpty()) {
            Path codeDir = this.codeToFileSystem();
            try {
                this._graph = Some$.MODULE$.apply((Object)this.frontend.execute(codeDir.toFile()).graph());
                this.fixture.applyPasses(this);
            }
            finally {
                this.deleteDir(codeDir);
            }
        }
        return (Graph)this._graph.get();
    }

    public void close() {
        this._graph.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.close());
    }
}

