/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.passes.callgraph;

import io.joern.x2cpg.Defines$;
import io.joern.x2cpg.passes.callgraph.DynamicCallLinker$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.TypeDecl;
import io.shiftleft.codepropertygraph.generated.traversal.MethodTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.TypeDeclTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.TypeTraversalExtGen$;
import io.shiftleft.passes.CpgPass;
import io.shiftleft.passes.CpgPass$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.AstNodeTraversal$;
import java.io.Serializable;
import overflowdb.BatchedUpdate;
import overflowdb.NodeDb;
import overflowdb.NodeOrDetachedNode;
import overflowdb.NodeRef;
import overflowdb.traversal.Traversal;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DynamicCallLinker
extends CpgPass {
    private final Cpg cpg;
    private final Map<String, LinkedHashSet<String>> validM;
    private final Map<String, LinkedHashSet<String>> subclassCache;
    private final Map<String, LinkedHashSet<String>> superclassCache;
    private final Map<String, TypeDecl> typeMap;
    private final Map<String, Method> methodMap;

    public DynamicCallLinker(Cpg cpg) {
        this.cpg = cpg;
        super(cpg, CpgPass$.MODULE$.$lessinit$greater$default$2(), CpgPass$.MODULE$.$lessinit$greater$default$3());
        this.validM = (Map)Map$.MODULE$.empty();
        this.subclassCache = (Map)Map$.MODULE$.empty();
        this.superclassCache = (Map)Map$.MODULE$.empty();
        this.typeMap = (Map)Map$.MODULE$.empty();
        this.methodMap = (Map)Map$.MODULE$.empty();
    }

    private void initMaps() {
        package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl().foreach((Function1 & Serializable)typeDecl -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)typeDecl.fullName());
            return (Map)this.typeMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, typeDecl));
        });
        ((IterableOnceOps)package$.MODULE$.toNodeTypeStarters(this.cpg).method().filter((Function1 & Serializable)m -> !m.name().startsWith("<operator>"))).foreach((Function1 & Serializable)method -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)method.fullName());
            return (Map)this.methodMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, method));
        });
    }

    public void run(BatchedUpdate.DiffGraphBuilder dstGraph) {
        if (!package$.MODULE$.toNodeTypeStarters(this.cpg).call().exists((Function1 & Serializable)_$1 -> {
            String string = _$1.dispatchType();
            String string2 = "DYNAMIC_DISPATCH";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            return;
        }
        this.initMaps();
        package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl().foreach((Function1)(JProcedure1 & Serializable)typeDecl -> typeDecl._methodViaAstOut().foreach((Function1 & Serializable)method -> {
            String methodName = method.fullName();
            LinkedHashSet candidates = (LinkedHashSet)this.allSubclasses(typeDecl.fullName()).flatMap((Function1 & Serializable)_$2 -> this.staticLookup((String)_$2, (Method)method));
            return this.validM.put((Object)methodName, (Object)candidates);
        }));
        this.subclassCache.clear();
        ((IterableOnceOps)package$.MODULE$.toNodeTypeStarters(this.cpg).call().filter((Function1 & Serializable)_$3 -> {
            String string = _$3.dispatchType();
            String string2 = "DYNAMIC_DISPATCH";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).foreach((Function1)(JProcedure1 & Serializable)call -> {
            try {
                this.linkDynamicCall((Call)call, dstGraph);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private LinkedHashSet<String> allSubclasses(String typDeclFullName) {
        return this.inheritanceTraversal(typDeclFullName, this.subclassCache, false);
    }

    private LinkedHashSet<String> allSuperClasses(String typDeclFullName) {
        return this.inheritanceTraversal(typDeclFullName, this.superclassCache, true);
    }

    private LinkedHashSet<String> inheritanceTraversal(String typDeclFullName, Map<String, LinkedHashSet<String>> cache, boolean inSuperDirection) {
        Option option = cache.get((Object)typDeclFullName);
        if (option instanceof Some) {
            LinkedHashSet superClasses = (LinkedHashSet)((Some)option).value();
            return superClasses;
        }
        if (None$.MODULE$.equals(option)) {
            LinkedHashSet<TypeDecl> linkedHashSet;
            IterableOnce iterableOnce = package$.MODULE$.toTypeDeclTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl());
            Option option2 = TypeDeclTraversalExtGen$.MODULE$.fullNameExact$extension(iterableOnce, typDeclFullName).headOption();
            if (option2 instanceof Some) {
                TypeDecl curr = (TypeDecl)((Some)option2).value();
                linkedHashSet = this.inheritTraversal(curr, inSuperDirection, this.inheritTraversal$default$3());
            } else if (None$.MODULE$.equals(option2)) {
                linkedHashSet = LinkedHashSet$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option2);
            }
            LinkedHashSet totalSuperclasses = (LinkedHashSet)linkedHashSet.map((Function1 & Serializable)_$4 -> _$4.fullName());
            cache.put((Object)typDeclFullName, (Object)totalSuperclasses);
            return totalSuperclasses;
        }
        throw new MatchError((Object)option);
    }

    private LinkedHashSet<TypeDecl> inheritTraversal(TypeDecl cur, boolean inSuperDirection, LinkedHashSet<TypeDecl> visitedNodes) {
        LinkedHashSet linkedHashSet;
        Traversal traversal;
        if (visitedNodes.contains((Object)cur)) {
            return visitedNodes;
        }
        visitedNodes.addOne((Object)cur);
        if (inSuperDirection) {
            IterableOnce iterableOnce = package$.MODULE$.toTypeDeclTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl());
            traversal = (Traversal)TypeDeclTraversalExtGen$.MODULE$.fullNameExact$extension(iterableOnce, cur.fullName()).flatMap((Function1 & Serializable)_$5 -> {
                IterableOnce iterableOnce = package$.MODULE$.toTypeTraversalExtGen((IterableOnce)_$5.inheritsFromOut());
                return TypeTraversalExtGen$.MODULE$.referencedTypeDecl$extension(iterableOnce);
            });
        } else {
            IterableOnce iterableOnce = package$.MODULE$.toTypeTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typ());
            traversal = (Traversal)TypeTraversalExtGen$.MODULE$.fullNameExact$extension(iterableOnce, cur.fullName()).flatMap((Function1 & Serializable)_$6 -> _$6.inheritsFromIn());
        }
        LinkedHashSet classesToEval = linkedHashSet = (LinkedHashSet)traversal.collectAll(ClassTag$.MODULE$.apply(TypeDecl.class)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)LinkedHashSet$.MODULE$));
        if (classesToEval.isEmpty()) {
            return visitedNodes;
        }
        LinkedHashSet classesToEval2 = linkedHashSet;
        classesToEval2.flatMap((Function1 & Serializable)t -> this.inheritTraversal((TypeDecl)t, inSuperDirection, visitedNodes));
        return visitedNodes;
    }

    private LinkedHashSet<TypeDecl> inheritTraversal$default$3() {
        return LinkedHashSet$.MODULE$.empty();
    }

    private Option<String> staticLookup(String subclass, Method method) {
        Option option = this.typeMap.get((Object)subclass);
        if (option instanceof Some) {
            TypeDecl sc = (TypeDecl)((Some)option).value();
            IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)sc._methodViaAstOut());
            return ((IterableOps)MethodTraversalExtGen$.MODULE$.nameExact$extension(iterableOnce, method.name()).and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)_$7 -> {
                IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)_$7);
                return MethodTraversalExtGen$.MODULE$.signatureExact$extension(iterableOnce, method.signature());
            }})).map((Function1 & Serializable)_$8 -> _$8.fullName())).headOption();
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private boolean resolveCallInSuperClasses(Call call) {
        if (!call.methodFullName().contains(":")) {
            return false;
        }
        Tuple2 tuple2 = DynamicCallLinker.split$1(call.methodFullName(), call.methodFullName().lastIndexOf(":"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fullName = (String)tuple2._1();
        String signature = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fullName, (Object)signature);
        String fullName2 = (String)tuple22._1();
        String signature2 = (String)tuple22._2();
        String typeDeclFullName = fullName2.replace("." + call.name(), "");
        IterableOnce iterableOnce = package$.MODULE$.toTypeDeclTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl());
        Traversal traversal = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)TypeDeclTraversalExtGen$.MODULE$.fullNameExact$extension(iterableOnce, (Seq)this.allSuperClasses(typeDeclFullName).toIndexedSeq()));
        Traversal traversal2 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)AstNodeTraversal$.MODULE$.astChildren$extension(traversal));
        IterableOnce iterableOnce2 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isMethod$extension(traversal2));
        IterableOnce iterableOnce3 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.name$extension(iterableOnce2, call.name()).and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)_$9 -> {
            IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)_$9);
            return MethodTraversalExtGen$.MODULE$.signatureExact$extension(iterableOnce, signature2);
        }})));
        List candidateInheritedMethods = MethodTraversalExtGen$.MODULE$.fullName$extension(iterableOnce3).l();
        if (candidateInheritedMethods.nonEmpty()) {
            this.validM.put((Object)call.methodFullName(), (Object)((SetOps)this.validM.getOrElse((Object)call.methodFullName(), DynamicCallLinker::resolveCallInSuperClasses$$anonfun$1)).$plus$plus((IterableOnce)LinkedHashSet$.MODULE$.from((IterableOnce)candidateInheritedMethods)));
            return true;
        }
        return false;
    }

    private void linkDynamicCall(Call call, BatchedUpdate.DiffGraphBuilder dstGraph) {
        if (call.methodFullName().equals("<empty>") || call.methodFullName().equals(Defines$.MODULE$.DynamicCallUnknownFallName())) {
            return;
        }
        this.resolveCallInSuperClasses(call);
        Option option = this.validM.get((Object)call.methodFullName());
        if (option instanceof Some) {
            LinkedHashSet tgts = (LinkedHashSet)((Some)option).value();
            IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)call.callOut());
            Set callsOut = MethodTraversalExtGen$.MODULE$.fullName$extension(iterableOnce).toSetImmutable();
            Set tgtMs = ((IterableOnceOps)tgts.flatMap((Function1 & Serializable)destMethod -> {
                if (this.cpg.graph().indexManager.isIndexed("FULL_NAME")) {
                    return this.methodFullNameToNode((String)destMethod);
                }
                IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).method());
                return MethodTraversalExtGen$.MODULE$.fullNameExact$extension(iterableOnce, destMethod).headOption();
            })).toSet();
            Tuple2 tuple2 = tgtMs.partition((Function1 & Serializable)_$10 -> _$10.isExternal());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set externalMs = (Set)tuple2._1();
            Set internalMs = (Set)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)externalMs, (Object)internalMs);
            Set externalMs2 = (Set)tuple22._1();
            Set internalMs2 = (Set)tuple22._2();
            (externalMs2.nonEmpty() && internalMs2.nonEmpty() ? internalMs2 : tgtMs).foreach((Function1 & Serializable)tgtM -> {
                if (!callsOut.contains((Object)tgtM.fullName())) {
                    return dstGraph.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)tgtM, "CALL");
                }
                this.fallbackToStaticResolution(call, dstGraph);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.fallbackToStaticResolution(call, dstGraph);
            return;
        }
        throw new MatchError((Object)option);
    }

    private void fallbackToStaticResolution(Call call, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Option option = this.methodMap.get((Object)call.methodFullName());
        if (option instanceof Some) {
            Method tgtM = (Method)((Some)option).value();
            dstGraph.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)tgtM, "CALL");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.printLinkingError(call);
            return;
        }
        throw new MatchError((Object)option);
    }

    private Iterable<NodeRef<? extends NodeDb>> nodesWithFullName(String x) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.cpg.graph().indexManager.lookup("FULL_NAME", (Object)x)).asScala();
    }

    private Option<Method> methodFullNameToNode(String x) {
        return this.nodesWithFullName(x).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(NodeRef x) {
                NodeRef nodeRef = x;
                if (nodeRef instanceof Method) {
                    Method x2 = (Method)nodeRef;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(NodeRef x, Function1 function1) {
                NodeRef nodeRef = x;
                if (nodeRef instanceof Method) {
                    Method x2 = (Method)nodeRef;
                    return x2;
                }
                return function1.apply((Object)x);
            }
        });
    }

    private void printLinkingError(Call call) {
        DynamicCallLinker$.io$joern$x2cpg$passes$callgraph$DynamicCallLinker$$$logger.info("Unable to link dynamic CALL with METHOD_FULL_NAME " + call.methodFullName() + " and context: " + (call.code() + " @ line " + call.lineNumber()));
    }

    private static final Tuple2 split$1(String str, int n) {
        return Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(str), n), (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(str), n + 1));
    }

    private static final LinkedHashSet resolveCallInSuperClasses$$anonfun$1() {
        return LinkedHashSet$.MODULE$.empty();
    }
}

