/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.passes.frontend;

import io.joern.x2cpg.passes.frontend.SBKey;
import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapView;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public class SymbolTable<K extends SBKey> {
    private final Function1 keyFromNode;
    private final TrieMap<K, Set<String>> table;

    public SymbolTable(Function1<AstNode, Option<K>> keyFromNode) {
        this.keyFromNode = keyFromNode;
        this.table = TrieMap$.MODULE$.empty();
    }

    public Function1<AstNode, Option<K>> keyFromNode() {
        return this.keyFromNode;
    }

    public Set<String> apply(K sbKey) {
        return (Set)this.table.apply(sbKey);
    }

    public Set<String> apply(AstNode node) {
        Option option = (Option)this.keyFromNode().apply((Object)node);
        if (option instanceof Some) {
            SBKey key = (SBKey)((Some)option).value();
            return (Set)this.table.apply((Object)key);
        }
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)option);
    }

    public SymbolTable<K> from(IterableOnce<Tuple2<K, Set<String>>> sb) {
        this.table.addAll(sb);
        return this;
    }

    public Set<String> put(K sbKey, Set<String> typeFullNames) {
        if (typeFullNames.nonEmpty()) {
            this.table.put(sbKey, typeFullNames);
            return typeFullNames;
        }
        return Predef$.MODULE$.Set().empty();
    }

    public Set<String> put(K sbKey, String typeFullName) {
        return this.put(sbKey, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{typeFullName}))));
    }

    public Set<String> put(AstNode node, Set<String> typeFullNames) {
        Option option = (Option)this.keyFromNode().apply((Object)node);
        if (option instanceof Some) {
            SBKey key = (SBKey)((Some)option).value();
            return this.put(key, typeFullNames);
        }
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)option);
    }

    public Set<String> append(AstNode node, String typeFullName) {
        return this.append((K)node, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{typeFullName}))));
    }

    public Set<String> append(AstNode node, Set<String> typeFullNames) {
        Option option = (Option)this.keyFromNode().apply((Object)node);
        if (option instanceof Some) {
            SBKey key = (SBKey)((Some)option).value();
            return this.append(key, typeFullNames);
        }
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)option);
    }

    public Set<String> append(K sbKey, Set<String> typeFullNames) {
        Option option = this.table.get(sbKey);
        if (option instanceof Some) {
            Set set;
            Set ts;
            Set set2 = ts = (set = (Set)((Some)option).value());
            Set<String> set3 = typeFullNames;
            if (!(set2 != null ? !set2.equals(set3) : set3 != null)) {
                return ts;
            }
            Set ts2 = set;
            if (typeFullNames.nonEmpty()) {
                return this.put(sbKey, (Set<String>)((Set)ts2.$plus$plus(typeFullNames)));
            }
        }
        if (None$.MODULE$.equals(option) && typeFullNames.nonEmpty()) {
            return this.put(sbKey, typeFullNames);
        }
        return Predef$.MODULE$.Set().empty();
    }

    public boolean contains(K sbKey) {
        return this.table.contains(sbKey);
    }

    public boolean contains(AstNode node) {
        Option option = (Option)this.keyFromNode().apply((Object)node);
        if (option instanceof Some) {
            SBKey key = (SBKey)((Some)option).value();
            return this.contains(key);
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public Set<String> get(K sbKey) {
        return (Set)this.table.getOrElse(sbKey, SymbolTable::get$$anonfun$1);
    }

    public Set<String> get(AstNode node) {
        Option option = (Option)this.keyFromNode().apply((Object)node);
        if (option instanceof Some) {
            SBKey key = (SBKey)((Some)option).value();
            return this.get(key);
        }
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)option);
    }

    public Set<String> remove(K sbKey) {
        return (Set)this.table.remove(sbKey).getOrElse(SymbolTable::remove$$anonfun$1);
    }

    public Set<String> remove(AstNode node) {
        Option option = (Option)this.keyFromNode().apply((Object)node);
        if (option instanceof Some) {
            SBKey key = (SBKey)((Some)option).value();
            return this.remove(key);
        }
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)option);
    }

    public MapView<K, Set<String>> view() {
        return this.table.view();
    }

    public void clear() {
        this.table.clear();
    }

    private static final Set get$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final Set remove$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }
}

