/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.passes.callgraph;

import io.joern.x2cpg.passes.callgraph.DynamicCallLinker$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.TypeDecl;
import io.shiftleft.codepropertygraph.generated.traversal.MethodTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.TypeTraversalExtGen$;
import io.shiftleft.passes.SimpleCpgPass;
import io.shiftleft.passes.SimpleCpgPass$;
import io.shiftleft.semanticcpg.language.package$;
import java.io.Serializable;
import overflowdb.BatchedUpdate;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.NodeOrDetachedNode;
import overflowdb.NodeRef;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DynamicCallLinker
extends SimpleCpgPass {
    private final Cpg cpg;
    private final Map<String, LinkedHashSet<String>> validM;
    private final Map<String, LinkedHashSet<String>> subclassCache;
    private final Map<String, TypeDecl> typeMap;
    private final Map<String, Method> methodMap;

    public DynamicCallLinker(Cpg cpg) {
        this.cpg = cpg;
        super(cpg, SimpleCpgPass$.MODULE$.$lessinit$greater$default$2(), SimpleCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.validM = (Map)Map$.MODULE$.empty();
        this.subclassCache = (Map)Map$.MODULE$.empty();
        this.typeMap = (Map)Map$.MODULE$.empty();
        this.methodMap = (Map)Map$.MODULE$.empty();
    }

    private void initMaps() {
        package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl().foreach((Function1 & Serializable)typeDecl -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)typeDecl.fullName());
            return (Map)this.typeMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, typeDecl));
        });
        ((IterableOnceOps)package$.MODULE$.toNodeTypeStarters(this.cpg).method().filter((Function1 & Serializable)m -> !m.name().startsWith("<operator>"))).foreach((Function1 & Serializable)method -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)method.fullName());
            return (Map)this.methodMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, method));
        });
    }

    public void run(BatchedUpdate.DiffGraphBuilder dstGraph) {
        if (!package$.MODULE$.toNodeTypeStarters(this.cpg).call().exists((Function1 & Serializable)_$1 -> {
            String string = _$1.dispatchType();
            String string2 = "DYNAMIC_DISPATCH";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            return;
        }
        this.initMaps();
        package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl().foreach((Function1)(JProcedure1 & Serializable)typeDecl -> typeDecl._methodViaAstOut().foreach((Function1 & Serializable)method -> {
            String methodName = method.fullName();
            LinkedHashSet candidates = (LinkedHashSet)this.allSubclasses(typeDecl.fullName()).flatMap((Function1 & Serializable)_$2 -> this.staticLookup((String)_$2, (Method)method));
            return this.validM.put((Object)methodName, (Object)candidates);
        }));
        this.subclassCache.clear();
        ((IterableOnceOps)package$.MODULE$.toNodeTypeStarters(this.cpg).call().filter((Function1 & Serializable)_$3 -> {
            String string = _$3.dispatchType();
            String string2 = "DYNAMIC_DISPATCH";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).foreach((Function1)(JProcedure1 & Serializable)call -> this.liftedTree1$1(dstGraph, (Call)call));
    }

    public LinkedHashSet<String> allSubclasses(String typDeclFullName) {
        LinkedHashSet linkedHashSet;
        Option option = this.subclassCache.get((Object)typDeclFullName);
        if (option instanceof Some) {
            LinkedHashSet value;
            linkedHashSet = value = (LinkedHashSet)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            IterableOnce iterableOnce = package$.MODULE$.toTypeTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typ());
            LinkedHashSet directSubclasses = (LinkedHashSet)((IterableOnceOps)((IterableOps)TypeTraversalExtGen$.MODULE$.nameExact$extension(iterableOnce, typDeclFullName).flatMap((Function1 & Serializable)_$4 -> CollectionConverters$.MODULE$.IteratorHasAsScala(_$4.in(new String[]{"INHERITS_FROM"})).asScala())).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Node x) {
                    boolean bl;
                    Node node = x;
                    if (node instanceof TypeDecl) {
                        TypeDecl x2 = (TypeDecl)node;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Node x, Function1 function1) {
                    Object object;
                    Node node = x;
                    if (node instanceof TypeDecl) {
                        TypeDecl x2 = (TypeDecl)node;
                        object = x2.fullName();
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)LinkedHashSet$.MODULE$));
            LinkedHashSet totalSubclasses = directSubclasses.isEmpty() ? (LinkedHashSet)directSubclasses.$plus$plus((IterableOnce)LinkedHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{typDeclFullName}))) : (LinkedHashSet)((SetOps)directSubclasses.flatMap((Function1 & Serializable)t -> this.allSubclasses((String)t))).$plus$plus((IterableOnce)LinkedHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{typDeclFullName})));
            this.subclassCache.put((Object)typDeclFullName, (Object)totalSubclasses);
            linkedHashSet = totalSubclasses;
        } else {
            throw new MatchError((Object)option);
        }
        return linkedHashSet;
    }

    private Option<String> staticLookup(String subclass, Method method) {
        None$ none$;
        Option option = this.typeMap.get((Object)subclass);
        if (option instanceof Some) {
            TypeDecl sc = (TypeDecl)((Some)option).value();
            IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)sc._methodViaAstOut());
            none$ = ((IterableOps)MethodTraversalExtGen$.MODULE$.nameExact$extension(iterableOnce, method.name()).and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)_$5 -> {
                IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)_$5);
                return MethodTraversalExtGen$.MODULE$.signatureExact$extension(iterableOnce, method.signature());
            }})).map((Function1 & Serializable)_$6 -> _$6.fullName())).headOption();
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private void linkDynamicCall(Call call, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Option option = this.validM.get((Object)call.methodFullName());
        if (option instanceof Some) {
            LinkedHashSet tgts = (LinkedHashSet)((Some)option).value();
            IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)call.callOut());
            Set callsOut = MethodTraversalExtGen$.MODULE$.fullName$extension(iterableOnce).toSetImmutable();
            tgts.foreach((Function1 & Serializable)destMethod -> {
                BoxedUnit boxedUnit;
                Option tgtM;
                Option option;
                if (this.cpg.graph().indexManager.isIndexed("FULL_NAME")) {
                    option = this.methodFullNameToNode((String)destMethod);
                } else {
                    IterableOnce iterableOnce = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).method());
                    option = tgtM = MethodTraversalExtGen$.MODULE$.fullNameExact$extension(iterableOnce, destMethod).headOption();
                }
                if (tgtM.isDefined() && !callsOut.contains((Object)((Method)tgtM.get()).fullName())) {
                    boxedUnit = dstGraph.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)tgtM.get(), "CALL");
                } else {
                    this.fallbackToStaticResolution(call, dstGraph);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        } else if (None$.MODULE$.equals(option)) {
            this.fallbackToStaticResolution(call, dstGraph);
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void fallbackToStaticResolution(Call call, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Option option = this.methodMap.get((Object)call.methodFullName());
        if (option instanceof Some) {
            Method tgtM = (Method)((Some)option).value();
            dstGraph.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)tgtM, "CALL");
        } else if (None$.MODULE$.equals(option)) {
            this.printLinkingError(call);
        } else {
            throw new MatchError((Object)option);
        }
    }

    private Iterable<NodeRef<? extends NodeDb>> nodesWithFullName(String x) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.cpg.graph().indexManager.lookup("FULL_NAME", (Object)x)).asScala();
    }

    private Option<Method> methodFullNameToNode(String x) {
        return this.nodesWithFullName(x).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(NodeRef x) {
                boolean bl;
                NodeRef nodeRef = x;
                if (nodeRef instanceof Method) {
                    Method x2 = (Method)nodeRef;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(NodeRef x, Function1 function1) {
                Object object;
                NodeRef nodeRef = x;
                if (nodeRef instanceof Method) {
                    Method x2 = (Method)nodeRef;
                    object = x2;
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        });
    }

    private void printLinkingError(Call call) {
        DynamicCallLinker$.io$joern$x2cpg$passes$callgraph$DynamicCallLinker$$$logger.info(new StringBuilder(64).append("Unable to link dynamic CALL with METHOD_FULL_NAME ").append(call.methodFullName()).append(" and context: ").append(new StringBuilder(8).append(call.code()).append(" @ line ").append(call.lineNumber()).toString()).toString());
    }

    private final void liftedTree1$1(BatchedUpdate.DiffGraphBuilder dstGraph$1, Call call$1) {
        try {
            this.linkDynamicCall(call$1, dstGraph$1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

