/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import better.files.File;
import better.files.File$;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class GradleDependencies$
implements Serializable {
    private static final Logger logger;
    private static final String initScriptName;
    private static final String taskName;
    public static final GradleDependencies$ MODULE$;

    private GradleDependencies$() {
    }

    static {
        MODULE$ = new GradleDependencies$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        initScriptName = "x2cpg.init.gradle";
        taskName = "x2cpgCopyRuntimeLibs";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GradleDependencies$.class);
    }

    private String gradle4OrLaterInitScript(String destination) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n     |allprojects {\n     |  apply plugin: 'java'\n     |  task ").append(taskName).append("(type: Copy) {\n     |    into \"").append(destination).append("\"\n     |    from configurations.default\n     |  }\n     |}\n     |").toString()));
    }

    public Seq<String> downloadRuntimeLibs(Path projectDir) {
        None$ connectionOption;
        None$ none$;
        BoxedUnit boxedUnit;
        Path destinationDir = Files.createTempDirectory("x2cpgRuntimeLibs", new FileAttribute[0]);
        destinationDir.toFile().deleteOnExit();
        logger.info(new StringBuilder(64).append("Attempting to download runtime libs for project at '").append(projectDir).append("' into '").append(destinationDir).append("'...").toString());
        File gradleInitDDir = File$.MODULE$.home().$div(".gradle").$div("init.d");
        try {
            if (!gradleInitDDir.exists(gradleInitDDir.exists$default$1())) {
                logger.info(new StringBuilder(46).append("Creating gradle init script directory at '").append(gradleInitDDir).append("'...").toString());
                gradleInitDDir.createDirectories(gradleInitDDir.createDirectories$default$1(), gradleInitDDir.createDirectories$default$2());
            }
        }
        catch (Throwable t) {
            logger.warn(new StringBuilder(66).append("Caught exception while trying to create init script directory: '").append(t).append("'.").toString());
        }
        try {
            File gradleInitScript = gradleInitDDir.$div(initScriptName);
            boolean bl = gradleInitScript.createFileIfNotExists$default$1();
            gradleInitScript.createFileIfNotExists(bl, gradleInitScript.createFileIfNotExists$default$2(bl), gradleInitScript.createFileIfNotExists$default$3(bl));
            String string = this.gradle4OrLaterInitScript(destinationDir.toString());
            gradleInitScript.write(string, gradleInitScript.write$default$2(string), gradleInitScript.write$default$3(string));
            boxedUnit = gradleInitScript.deleteOnExit(gradleInitScript.deleteOnExit$default$1(), gradleInitScript.deleteOnExit$default$2());
        }
        catch (Throwable t) {
            logger.warn(new StringBuilder(56).append("Caught exception while trying to create init script: '").append(t).append("'.").toString());
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            logger.info(new StringBuilder(61).append("Establishing gradle connection for project directory at '").append(projectDir).append("'...").toString());
            none$ = Some$.MODULE$.apply((Object)GradleConnector.newConnector().forProjectDirectory(projectDir.toFile()).connect());
        }
        catch (Throwable t) {
            logger.warn(new StringBuilder(67).append("Caught exception while trying to establish a Gradle connection: '").append(t).append("'.").toString());
            none$ = connectionOption = None$.MODULE$;
        }
        if (connectionOption.isDefined()) {
            try (ProjectConnection connection = (ProjectConnection)connectionOption.get();){
                try {
                    logger.info(new StringBuilder(27).append("Executing gradle task '").append(taskName).append("'...").toString());
                    connection.newBuild().forTasks(new String[]{taskName}).run();
                }
                catch (Throwable t) {
                    logger.warn(new StringBuilder(49).append("Caught exception while executing Gradle task: '").append(t.getMessage()).append("'.").toString());
                }
            }
        }
        return (Seq)CollectionConverters$.MODULE$.ListHasAsScala(Files.list(destinationDir).collect(Collectors.toList())).asScala().map((Function1 & Serializable)_$1 -> _$1.toAbsolutePath().toString());
    }

    public boolean isGradleBuild(Path codeDir) {
        return Files.walk(codeDir, new FileVisitOption[0]).filter(file -> file.toString().endsWith(".gradle") || file.toString().endsWith(".gradle.kts")).count() > 0L;
    }
}

