/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import io.joern.x2cpg.utils.dependency.DependencyResolverParams;
import io.joern.x2cpg.utils.dependency.DependencyResolverParams$;
import io.joern.x2cpg.utils.dependency.GradleConfigKeys$;
import io.joern.x2cpg.utils.dependency.GradleDependencies$;
import io.joern.x2cpg.utils.dependency.MavenDependencies$;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Seq;
import scala.runtime.ModuleSerializationProxy;

public final class DependencyResolver$
implements Serializable {
    private static final Logger logger;
    private static final String defaultGradleProjectName;
    private static final String defaultGradleConfigurationName;
    public static final DependencyResolver$ MODULE$;

    private DependencyResolver$() {
    }

    static {
        MODULE$ = new DependencyResolver$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        defaultGradleProjectName = "app";
        defaultGradleConfigurationName = "releaseCompileClasspath";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DependencyResolver$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Seq<String>> getDependencies(Path projectDir, DependencyResolverParams params) {
        Some some;
        if (this.isMavenBuild(projectDir)) {
            some = Some$.MODULE$.apply(MavenDependencies$.MODULE$.get(projectDir));
            return some;
        } else if (this.isGradleBuild(projectDir)) {
            String gradleConfiguration;
            String gradleProjectName = (String)params.forGradle().getOrElse((Object)GradleConfigKeys$.MODULE$.ProjectName(), this::$anonfun$1);
            Option<Seq<String>> option = GradleDependencies$.MODULE$.get(projectDir, gradleProjectName, gradleConfiguration = (String)params.forGradle().getOrElse((Object)GradleConfigKeys$.MODULE$.ConfigurationName(), this::$anonfun$2));
            if (option instanceof Some) {
                Seq deps = (Seq)((Some)option).value();
                some = Some$.MODULE$.apply((Object)deps);
                return some;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                logger.warn(new StringBuilder(61).append("Could not download Gradle dependencies for project at path `").append(projectDir).append("`").toString());
                some = None$.MODULE$;
            }
            return some;
        } else {
            logger.warn(new StringBuilder(54).append("Could not find a supported build tool setup at path `").append(projectDir).append("`").toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public DependencyResolverParams getDependencies$default$2() {
        return new DependencyResolverParams(DependencyResolverParams$.MODULE$.$lessinit$greater$default$1(), DependencyResolverParams$.MODULE$.$lessinit$greater$default$2());
    }

    public boolean isMavenBuild(Path codeDir) {
        return Files.exists(codeDir.resolve("pom.xml"), new LinkOption[0]);
    }

    public boolean isGradleBuild(Path codeDir) {
        return Files.walk(codeDir, new FileVisitOption[0]).anyMatch(file -> file.toString().endsWith(".gradle") || file.toString().endsWith(".gradle.kts"));
    }

    private final String $anonfun$1() {
        return defaultGradleProjectName;
    }

    private final String $anonfun$2() {
        return defaultGradleConfigurationName;
    }
}

