/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class HashUtil$
implements Serializable {
    public static final HashUtil$ MODULE$ = new HashUtil$();

    private HashUtil$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HashUtil$.class);
    }

    public String sha256(Path file) {
        return this.sha256((Seq<Path>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{file}))));
    }

    public String sha256(String file) {
        return this.sha256((Seq<Path>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{Path.of(file, new String[0])}))));
    }

    public String sha256(Seq<Path> files) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[4096];
        ((IterableOnceOps)files.filterNot((Function1 & Serializable)p -> this.isDirectory(p.toRealPath(new LinkOption[0])))).foreach((Function1)(JProcedure1 & Serializable)path -> Using$.MODULE$.resource((Object)new DigestInputStream(Files.newInputStream(path, new OpenOption[0]), md), (Function1)(JProcedure1 & Serializable)dis -> {
            while (dis.available() > 0) {
                dis.read(buffer);
            }
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
        Object object = Predef$.MODULE$.byteArrayOps(md.digest());
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)b -> this.sha256$$anonfun$3(BoxesRunTime.unboxToByte((Object)b)), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    private boolean isDirectory(Path path) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return false;
        }
        return Files.isDirectory(path, new LinkOption[0]);
    }

    private final /* synthetic */ String sha256$$anonfun$3(byte b) {
        return String.format("%02x", BoxesRunTime.boxToByte((byte)b));
    }
}

