/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;

public final class TimeUtils$
implements Serializable {
    public static final TimeUtils$ MODULE$ = new TimeUtils$();

    private TimeUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeUtils$.class);
    }

    public <R> Tuple2<R, Object> time(Function0<R> block) {
        long t0 = System.nanoTime();
        Object result = block.apply();
        long t1 = System.nanoTime();
        long elapsed = t1 - t0;
        return Tuple2$.MODULE$.apply(result, (Object)BoxesRunTime.boxToLong((long)elapsed));
    }

    public String pretty(long duration) {
        return this.pretty((Duration)Duration$.MODULE$.fromNanos(duration));
    }

    public <T> Try<T> runWithTimeout(long timeoutMs, Function0<T> f) {
        return Try$.MODULE$.apply(() -> this.runWithTimeout$$anonfun$1(timeoutMs, f));
    }

    private String pretty(Duration duration) {
        Duration duration2 = duration;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration2;
            long nanos = d.toNanos();
            TimeUnit unit = this.chooseUnit(nanos);
            double value = (double)nanos / (double)package$.MODULE$.NANOSECONDS().convert(1L, unit);
            return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.4g %s"), Locale.ROOT, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value), this.abbreviate(unit)}));
        }
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration duration3 = duration2;
        if (!(infinite != null ? !infinite.equals(duration3) : duration3 != null)) {
            return "-\u221e (minus infinity)";
        }
        Duration.Infinite infinite2 = Duration$.MODULE$.Inf();
        Duration duration4 = duration2;
        if (!(infinite2 != null ? !infinite2.equals(duration4) : duration4 != null)) {
            return "\u221e (infinity)";
        }
        return "undefined";
    }

    private TimeUnit chooseUnit(long nanos) {
        FiniteDuration d = new package.DurationLong(package$.MODULE$.DurationLong(nanos)).nanos();
        if (d.toDays() > 0L) {
            return package$.MODULE$.DAYS();
        }
        if (d.toHours() > 0L) {
            return package$.MODULE$.HOURS();
        }
        if (d.toMinutes() > 0L) {
            return package$.MODULE$.MINUTES();
        }
        if (d.toSeconds() > 0L) {
            return package$.MODULE$.SECONDS();
        }
        if (d.toMillis() > 0L) {
            return package$.MODULE$.MILLISECONDS();
        }
        if (d.toMicros() > 0L) {
            return package$.MODULE$.MICROSECONDS();
        }
        return package$.MODULE$.NANOSECONDS();
    }

    private String abbreviate(TimeUnit unit) {
        TimeUnit timeUnit = unit;
        TimeUnit timeUnit2 = package$.MODULE$.NANOSECONDS();
        TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            return "ns";
        }
        TimeUnit timeUnit4 = package$.MODULE$.MICROSECONDS();
        TimeUnit timeUnit5 = timeUnit;
        if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
            return "\u03bcs";
        }
        TimeUnit timeUnit6 = package$.MODULE$.MILLISECONDS();
        TimeUnit timeUnit7 = timeUnit;
        if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
            return "ms";
        }
        TimeUnit timeUnit8 = package$.MODULE$.SECONDS();
        TimeUnit timeUnit9 = timeUnit;
        if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
            return "s";
        }
        TimeUnit timeUnit10 = package$.MODULE$.MINUTES();
        TimeUnit timeUnit11 = timeUnit;
        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
            return "min";
        }
        TimeUnit timeUnit12 = package$.MODULE$.HOURS();
        TimeUnit timeUnit13 = timeUnit;
        if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
            return "h";
        }
        TimeUnit timeUnit14 = package$.MODULE$.DAYS();
        TimeUnit timeUnit15 = timeUnit;
        if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
            return "d";
        }
        throw new MatchError((Object)timeUnit);
    }

    private final Object runWithTimeout$$anonfun$1(long timeoutMs$1, Function0 f$1) {
        return Await$.MODULE$.result((Awaitable)Future$.MODULE$.apply(f$1, ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong(timeoutMs$1)).milliseconds());
    }
}

