/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg;

import better.files.File;
import better.files.File$;
import io.joern.x2cpg.X2CpgConfig;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SourceFiles$
implements Serializable {
    private static final Logger logger;
    public static final SourceFiles$ MODULE$;

    private SourceFiles$() {
    }

    static {
        MODULE$ = new SourceFiles$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SourceFiles$.class);
    }

    private boolean isIgnoredByFileList(String filePath, X2CpgConfig<?> config) {
        boolean isInIgnoredFiles = config.ignoredFiles().exists((Function1 & Serializable)x$1 -> {
            String string = x$1;
            String ignorePath = string;
            File file = File$.MODULE$.apply(ignorePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (file.isDirectory(file.isDirectory$default$1())) {
                return filePath.startsWith(ignorePath);
            }
            String ignorePath2 = string;
            String string2 = filePath;
            String string3 = ignorePath2;
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        });
        if (isInIgnoredFiles) {
            logger.debug("'" + filePath + "' ignored (--exclude)");
            return true;
        }
        return false;
    }

    private boolean isIgnoredByDefault(String filePath, X2CpgConfig<?> config) {
        String relPath = this.toRelativePath(filePath, config.inputPath());
        if (config.defaultIgnoredFilesRegex().exists((Function1 & Serializable)_$1 -> _$1.matches((CharSequence)relPath))) {
            logger.debug("'" + relPath + "' ignored by default");
            return true;
        }
        return false;
    }

    private boolean isIgnoredByRegex(String filePath, X2CpgConfig<?> config) {
        String relPath = this.toRelativePath(filePath, config.inputPath());
        boolean isInIgnoredFilesRegex = config.ignoredFilesRegex().matches((CharSequence)relPath);
        if (isInIgnoredFilesRegex) {
            logger.debug("'" + relPath + "' ignored (--exclude-regex)");
            return true;
        }
        return false;
    }

    private List<String> filterFiles(List<String> files, X2CpgConfig<?> config) {
        return files.filter((Function1 & Serializable)x$1 -> {
            String string = x$1;
            String filePath = string;
            if (this.isIgnoredByDefault(filePath, config)) {
                return false;
            }
            String filePath2 = string;
            if (this.isIgnoredByFileList(filePath2, config)) {
                return false;
            }
            String filePath3 = string;
            return !this.isIgnoredByRegex(filePath3, config);
        });
    }

    public List<String> determine(String inputPath, Set<String> sourceFileExtensions) {
        return this.determine((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{inputPath}))), sourceFileExtensions);
    }

    public List<String> determine(String inputPath, Set<String> sourceFileExtensions, X2CpgConfig<?> config) {
        return this.filterFiles(this.determine((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{inputPath}))), sourceFileExtensions), config);
    }

    public List<String> determine(Set<String> inputPaths, Set<String> sourceFileExtensions) {
        Set inputFiles = (Set)inputPaths.map((Function1 & Serializable)_$2 -> File$.MODULE$.apply(_$2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
        this.assertAllExist((Set<File>)inputFiles);
        Tuple2 tuple2 = inputFiles.partition((Function1 & Serializable)_$3 -> _$3.isDirectory(_$3.isDirectory$default$1()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set dirs = (Set)tuple2._1();
        Set files = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dirs, (Object)files);
        Set dirs2 = (Set)tuple22._1();
        Set files2 = (Set)tuple22._2();
        Set matchingFiles = (Set)((IterableOps)files2.filter((Function1 & Serializable)file -> this.hasSourceFileExtension$1((Set)sourceFileExtensions, (File)file))).map((Function1 & Serializable)_$4 -> _$4.toString());
        Set matchingFilesFromDirs = (Set)((IterableOps)((IterableOps)dirs2.flatMap((Function1 & Serializable)_$5 -> _$5.listRecursively(File.VisitOptions$.MODULE$.follow()))).filter((Function1 & Serializable)file -> this.hasSourceFileExtension$1((Set)sourceFileExtensions, (File)file))).map((Function1 & Serializable)_$6 -> _$6.pathAsString());
        return (List)matchingFiles.$plus$plus((IterableOnce)matchingFilesFromDirs).toList().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private void assertAllExist(Set<File> files) {
        Tuple2 tuple2 = files.partition((Function1 & Serializable)_$7 -> _$7.isReadable());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set existant = (Set)tuple2._1();
        Set nonExistant = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)existant, (Object)nonExistant);
        Set existant2 = (Set)tuple22._1();
        Set nonExistant2 = (Set)tuple22._2();
        Set nonReadable = (Set)existant2.filterNot((Function1 & Serializable)_$8 -> _$8.isReadable());
        if (nonExistant2.nonEmpty() || nonReadable.nonEmpty()) {
            this.logErrorWithPaths("Source input paths do not exist", (Iterable<String>)((Iterable)nonExistant2.map((Function1 & Serializable)_$9 -> _$9.canonicalPath())));
            this.logErrorWithPaths("Source input paths exist, but are not readable", (Iterable<String>)((Iterable)nonReadable.map((Function1 & Serializable)_$10 -> _$10.canonicalPath())));
            throw new FileNotFoundException("Invalid source paths provided");
        }
    }

    private void logErrorWithPaths(String message, Iterable<String> paths) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])paths.toArray(ClassTag$.MODULE$.apply(String.class)));
        Object[] pathsArray = (String[])ArrayOps$.MODULE$.sorted$extension(object, (Ordering)Ordering.String$.MODULE$);
        Object object2 = Predef$.MODULE$.refArrayOps(pathsArray);
        int n = ArrayOps$.MODULE$.lengthCompare$extension(object2, 1);
        int cmp = n;
        if (cmp < 0) {
            return;
        }
        int cmp2 = n;
        if (cmp2 == 0) {
            logger.error(message + ": " + paths.head());
            return;
        }
        int cmp3 = n;
        Object object3 = Predef$.MODULE$.refArrayOps(pathsArray);
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)path -> "- " + path, ClassTag$.MODULE$.apply(String.class)));
        String errorMessage = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$colon$extension(object4, (Object)message, ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        logger.error(errorMessage);
    }

    public String toAbsolutePath(String path, String rootPath) {
        Path path2;
        Path path3 = Paths.get(path, new String[0]);
        Path p = path3;
        if (p.isAbsolute()) {
            path2 = p;
        } else if (rootPath.endsWith(path)) {
            path2 = Paths.get(rootPath, new String[0]);
        } else {
            Path p2 = path3;
            path2 = Paths.get(rootPath, p2.toString());
        }
        Path absolutePath = path2;
        return absolutePath.normalize().toString();
    }

    public String toRelativePath(String path, String rootPath) {
        if (path.startsWith(rootPath)) {
            Path projectPath;
            Path absolutePath = Paths.get(path, new String[0]).toAbsolutePath();
            if (absolutePath.compareTo(projectPath = Paths.get(rootPath, new String[0]).toAbsolutePath()) == 0) {
                return absolutePath.getFileName().toString();
            }
            return projectPath.relativize(absolutePath).toString();
        }
        return path;
    }

    private final boolean hasSourceFileExtension$1(Set sourceFileExtensions$1, File file) {
        return file.extension().exists((Function1 & Serializable)elem -> sourceFileExtensions$1.contains(elem));
    }
}

