/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg;

import better.files.File$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.layers.Base;
import io.joern.x2cpg.layers.CallGraph;
import io.joern.x2cpg.layers.ControlFlow;
import io.joern.x2cpg.layers.TypeRelations;
import io.shiftleft.codepropertygraph.Cpg$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.semanticcpg.layers.LayerCreator;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext$;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.Config;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;

public final class X2Cpg$
implements Serializable {
    private static final Logger logger;
    public static final X2Cpg$ MODULE$;

    private X2Cpg$() {
    }

    static {
        MODULE$ = new X2Cpg$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(X2Cpg$.class);
    }

    public <R extends X2CpgConfig<R>> Option<R> parseCommandLine(String[] args, OParser<?, R> frontendSpecific, R initialConf) {
        OParser<?, R> parser = this.commandLineParser(frontendSpecific);
        return OParser$.MODULE$.parse(parser, (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), initialConf);
    }

    private <R extends X2CpgConfig<R>> OParser<?, R> commandLineParser(OParser<?, R> frontendSpecific) {
        OParserBuilder builder = OParser$.MODULE$.builder();
        return OParser$.MODULE$.sequence(builder.arg("input-dir", Read$.MODULE$.stringRead()).text("source directory").action((Function2 & Serializable)(x, c) -> c.withInputPath((String)x)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.opt("output", Read$.MODULE$.stringRead()).abbr("o").text("output filename").action((Function2 & Serializable)(x, c) -> c.withOutputPath((String)x)), builder.opt("exclude", Read$.MODULE$.immutableSeqRead(Read$.MODULE$.stringRead())).valueName("<file1>,<file2>,...").action((Function2 & Serializable)(x, c) -> {
            c.ignoredFiles_$eq((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)c.ignoredFiles().$plus$plus((IterableOnce)x.map((Function1 & Serializable)ignore -> c.createPathForIgnore((String)ignore)))));
            return c;
        }).text("files or folders to exclude during CPG generation (paths relative to <input-dir> or absolute paths)"), builder.opt("exclude-regex", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            c.ignoredFilesRegex_$eq(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(x)));
            return c;
        }).text("a regex specifying files to exclude during CPG generation (paths relative to <input-dir> are matched)"), builder.help("help").text("display this help message"), frontendSpecific}));
    }

    public Cpg newEmptyCpg(Option<String> optionalOutputPath) {
        Config odbConfig = (Config)optionalOutputPath.map((Function1 & Serializable)outputPath -> {
            better.files.File outFile = File$.MODULE$.apply(outputPath, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            String string = outputPath;
            String string2 = "";
            if ((string == null ? string2 != null : !string.equals(string2)) && outFile.exists(outFile.exists$default$1())) {
                logger.info("Output file exists, removing: " + outputPath);
                outFile.delete(outFile.delete$default$1(), outFile.delete$default$2());
            }
            return Config.withDefaults().withStorageLocation(outputPath);
        }).getOrElse(this::$anonfun$2);
        return Cpg$.MODULE$.withConfig(odbConfig);
    }

    public Option<String> newEmptyCpg$default$1() {
        return None$.MODULE$;
    }

    public <T extends X2CpgConfig<?>> Try<Cpg> withNewEmptyCpg(String outPath, T config, Function2<Cpg, T, BoxedUnit> applyPasses) {
        String string = outPath;
        String string2 = "";
        None$ outputPath = (string == null ? string2 != null : !string.equals(string2)) ? Some$.MODULE$.apply((Object)outPath) : None$.MODULE$;
        return Try$.MODULE$.apply(() -> this.withNewEmptyCpg$$anonfun$1(config, applyPasses, (Option)outputPath));
    }

    public <T extends X2CpgConfig<?>> Try<?> withErrorsToConsole(T config, Function1<T, Try<?>> f) {
        Try try_ = (Try)f.apply(config);
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            exception.printStackTrace();
            return Failure$.MODULE$.apply(exception);
        }
        if (try_ instanceof Success) {
            Object v = ((Success)try_).value();
            return Success$.MODULE$.apply(v);
        }
        throw new MatchError((Object)try_);
    }

    public void applyDefaultOverlays(Cpg cpg) {
        LayerCreatorContext context = new LayerCreatorContext(cpg, LayerCreatorContext$.MODULE$.$lessinit$greater$default$2());
        this.defaultOverlayCreators().foreach((Function1)(JProcedure1 & Serializable)creator -> creator.run(context, creator.run$default$2()));
    }

    public List<LayerCreator> defaultOverlayCreators() {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LayerCreator[]{new Base(), new ControlFlow(), new TypeRelations(), new CallGraph()}));
    }

    public File writeCodeToFile(String sourceCode, String tmpDirPrefix, String suffix) {
        File tmpDir = Files.createTempDirectory(tmpDirPrefix, new FileAttribute[0]).toFile();
        tmpDir.deleteOnExit();
        File codeFile = File.createTempFile("Test", suffix, tmpDir);
        codeFile.deleteOnExit();
        new PrintWriter(sourceCode, codeFile){
            {
                this.write(sourceCode$1);
                this.close();
            }
        };
        return tmpDir;
    }

    public String stripQuotes(String str) {
        return str.replaceAll("^(\"|')|(\"|')$", "");
    }

    private final Config $anonfun$2() {
        return Config.withDefaults();
    }

    private final void withNewEmptyCpg$$anonfun$1$$anonfun$1(X2CpgConfig config$3, Function2 applyPasses$2, Cpg cpg$1) {
        applyPasses$2.apply((Object)cpg$1, (Object)config$3);
    }

    private final Cpg withNewEmptyCpg$$anonfun$1(X2CpgConfig config$2, Function2 applyPasses$1, Option outputPath$1) {
        Cpg cpg = this.newEmptyCpg((Option<String>)outputPath$1);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.withNewEmptyCpg$$anonfun$1$$anonfun$1(config$2, applyPasses$1, cpg);
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            return cpg;
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            cpg.close();
            throw exception;
        }
        throw new MatchError((Object)try_);
    }
}

