/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg;

import better.files.File;
import better.files.File$;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class SourceFiles$
implements Serializable {
    private static final Logger logger;
    public static final SourceFiles$ MODULE$;

    private SourceFiles$() {
    }

    static {
        MODULE$ = new SourceFiles$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SourceFiles$.class);
    }

    private boolean isIgnoredByFileList(String filePath, Seq<String> ignoredFiles) {
        boolean isInIgnoredFiles = ignoredFiles.exists((Function1 & Serializable)ignorePath -> {
            File ignorePathFile = File$.MODULE$.apply(ignorePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            File filePathFile = File$.MODULE$.apply(filePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            return ignorePathFile.exists(ignorePathFile.exists$default$1()) && (ignorePathFile.contains(filePathFile, false) || ignorePathFile.isSameFileAs(filePathFile));
        });
        if (isInIgnoredFiles) {
            logger.debug("'" + filePath + "' ignored (--exclude)");
            return true;
        }
        return false;
    }

    private boolean isIgnoredByDefaultRegex(String filePath, String inputPath, Seq<Regex> ignoredDefaultRegex) {
        String relPath = this.toRelativePath(filePath, inputPath);
        if (ignoredDefaultRegex.exists((Function1 & Serializable)_$1 -> _$1.matches((CharSequence)relPath))) {
            logger.debug("'" + relPath + "' ignored by default");
            return true;
        }
        return false;
    }

    private boolean isIgnoredByRegex(String filePath, String inputPath, Regex ignoredFilesRegex) {
        String relPath = this.toRelativePath(filePath, inputPath);
        boolean isInIgnoredFilesRegex = ignoredFilesRegex.matches((CharSequence)relPath);
        if (isInIgnoredFilesRegex) {
            logger.debug("'" + relPath + "' ignored (--exclude-regex)");
            return true;
        }
        return false;
    }

    public boolean filterFile(String file, String inputPath, Option<Seq<Regex>> ignoredDefaultRegex, Option<Regex> ignoredFilesRegex, Option<Seq<String>> ignoredFilesPath) {
        return !ignoredDefaultRegex.exists((Function1 & Serializable)_$2 -> MODULE$.isIgnoredByDefaultRegex(file, inputPath, (Seq<Regex>)_$2)) && !ignoredFilesRegex.exists((Function1 & Serializable)_$3 -> MODULE$.isIgnoredByRegex(file, inputPath, (Regex)_$3)) && !ignoredFilesPath.exists((Function1 & Serializable)_$4 -> MODULE$.isIgnoredByFileList(file, (Seq<String>)_$4));
    }

    public Option<Seq<Regex>> filterFile$default$3() {
        return None$.MODULE$;
    }

    public Option<Regex> filterFile$default$4() {
        return None$.MODULE$;
    }

    public Option<Seq<String>> filterFile$default$5() {
        return None$.MODULE$;
    }

    private List<String> filterFiles(List<String> files, String inputPath, Option<Seq<Regex>> ignoredDefaultRegex, Option<Regex> ignoredFilesRegex, Option<Seq<String>> ignoredFilesPath) {
        return files.filter((Function1 & Serializable)_$5 -> MODULE$.filterFile((String)_$5, inputPath, ignoredDefaultRegex, ignoredFilesRegex, ignoredFilesPath));
    }

    private Option<Seq<Regex>> filterFiles$default$3() {
        return None$.MODULE$;
    }

    private Option<Regex> filterFiles$default$4() {
        return None$.MODULE$;
    }

    private Option<Seq<String>> filterFiles$default$5() {
        return None$.MODULE$;
    }

    public List<String> determine(String inputPath, Set<String> sourceFileExtensions, Option<Seq<Regex>> ignoredDefaultRegex, Option<Regex> ignoredFilesRegex, Option<Seq<String>> ignoredFilesPath, Seq<FileVisitOption> visitOptions) {
        return this.filterFiles(this.determine((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{inputPath}))), sourceFileExtensions, visitOptions), inputPath, ignoredDefaultRegex, ignoredFilesRegex, ignoredFilesPath);
    }

    public Option<Seq<Regex>> determine$default$3() {
        return None$.MODULE$;
    }

    public Option<Regex> determine$default$4() {
        return None$.MODULE$;
    }

    public Option<Seq<String>> determine$default$5() {
        return None$.MODULE$;
    }

    public Seq<FileVisitOption> determine$default$6(String inputPath, Set<String> sourceFileExtensions, Option<Seq<Regex>> ignoredDefaultRegex, Option<Regex> ignoredFilesRegex, Option<Seq<String>> ignoredFilesPath) {
        return File.VisitOptions$.MODULE$.follow();
    }

    public List<String> determine(Set<String> inputPaths, Set<String> sourceFileExtensions, Seq<FileVisitOption> visitOptions) {
        Set inputFiles = (Set)inputPaths.map((Function1 & Serializable)_$6 -> File$.MODULE$.apply(_$6, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
        this.assertAllExist((Set<File>)inputFiles);
        Tuple2 tuple2 = inputFiles.partition((Function1 & Serializable)_$7 -> _$7.isDirectory(_$7.isDirectory$default$1()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set dirs = (Set)tuple2._1();
        Set files = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dirs, (Object)files);
        Set dirs2 = (Set)tuple22._1();
        Set files2 = (Set)tuple22._2();
        Set matchingFiles = (Set)((IterableOps)files2.filter((Function1 & Serializable)file -> this.hasSourceFileExtension$1((Set)sourceFileExtensions, (File)file))).map((Function1 & Serializable)_$8 -> _$8.toString());
        Set matchingFilesFromDirs = (Set)((IterableOps)((IterableOps)dirs2.flatMap((Function1 & Serializable)_$9 -> _$9.listRecursively(visitOptions))).filter((Function1 & Serializable)file -> this.hasSourceFileExtension$1((Set)sourceFileExtensions, (File)file))).map((Function1 & Serializable)_$10 -> _$10.pathAsString());
        return (List)matchingFiles.$plus$plus((IterableOnce)matchingFilesFromDirs).toList().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private void assertAllExist(Set<File> files) {
        Tuple2 tuple2 = files.partition((Function1 & Serializable)_$11 -> _$11.isReadable());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set existant = (Set)tuple2._1();
        Set nonExistant = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)existant, (Object)nonExistant);
        Set existant2 = (Set)tuple22._1();
        Set nonExistant2 = (Set)tuple22._2();
        Set nonReadable = (Set)existant2.filterNot((Function1 & Serializable)_$12 -> _$12.isReadable());
        if (nonExistant2.nonEmpty() || nonReadable.nonEmpty()) {
            this.logErrorWithPaths("Source input paths do not exist", (Iterable<String>)((Iterable)nonExistant2.map((Function1 & Serializable)_$13 -> _$13.canonicalPath())));
            this.logErrorWithPaths("Source input paths exist, but are not readable", (Iterable<String>)((Iterable)nonReadable.map((Function1 & Serializable)_$14 -> _$14.canonicalPath())));
            throw new FileNotFoundException("Invalid source paths provided");
        }
    }

    private void logErrorWithPaths(String message, Iterable<String> paths) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])paths.toArray(ClassTag$.MODULE$.apply(String.class)));
        Object[] pathsArray = (String[])ArrayOps$.MODULE$.sorted$extension(object, (Ordering)Ordering.String$.MODULE$);
        Object object2 = Predef$.MODULE$.refArrayOps(pathsArray);
        int n = ArrayOps$.MODULE$.lengthCompare$extension(object2, 1);
        int cmp = n;
        if (cmp < 0) {
            return;
        }
        int cmp2 = n;
        if (cmp2 == 0) {
            logger.error(message + ": " + paths.head());
            return;
        }
        Object object3 = Predef$.MODULE$.refArrayOps(pathsArray);
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)path -> "- " + path, ClassTag$.MODULE$.apply(String.class)));
        String errorMessage = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$colon$extension(object4, (Object)message, ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        logger.error(errorMessage);
    }

    public String toAbsolutePath(String path, String rootPath) {
        Path path2;
        Path path3 = Paths.get(path, new String[0]);
        Path p = path3;
        if (p.isAbsolute()) {
            path2 = p;
        } else if (rootPath.endsWith(path)) {
            path2 = Paths.get(rootPath, new String[0]);
        } else {
            Path p2 = path3;
            path2 = Paths.get(rootPath, p2.toString());
        }
        Path absolutePath = path2;
        return absolutePath.normalize().toString();
    }

    public String toRelativePath(String path, String rootPath) {
        if (path.startsWith(rootPath)) {
            Path projectPath;
            Path absolutePath = Paths.get(path, new String[0]).toAbsolutePath();
            if (absolutePath.compareTo(projectPath = Paths.get(rootPath, new String[0]).toAbsolutePath()) == 0) {
                return absolutePath.getFileName().toString();
            }
            return projectPath.relativize(absolutePath).toString();
        }
        return path;
    }

    private final boolean hasSourceFileExtension$1(Set sourceFileExtensions$1, File file) {
        return file.extension().exists((Function1 & Serializable)elem -> sourceFileExtensions$1.contains(elem));
    }
}

