/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.astgen;

import better.files.File;
import better.files.File$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.astgen.AstGenConfig;
import io.joern.x2cpg.astgen.AstGenRunner;
import io.joern.x2cpg.astgen.AstGenRunner$;
import io.joern.x2cpg.astgen.AstGenRunner$DefaultAstGenRunnerResult$;
import io.joern.x2cpg.utils.Environment$;
import io.joern.x2cpg.utils.Environment$ArchitectureType$;
import io.joern.x2cpg.utils.Environment$OperatingSystemType$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.LazyBoolean;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public interface AstGenRunnerBase {
    public static void $init$(AstGenRunnerBase $this) {
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$io$joern$x2cpg$astgen$AstGenRunnerBase$$logger_$eq(LoggerFactory.getLogger($this.getClass()));
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$WinX86_$eq("win.exe");
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$WinArm_$eq("win-arm.exe");
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$LinuxX86_$eq("linux");
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$LinuxArm_$eq("linux-arm");
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$MacX86_$eq("macos");
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$MacArm_$eq("macos-arm");
        Object[] objectArray = new Tuple2[6];
        Enumeration.Value value = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)Environment$OperatingSystemType$.MODULE$.Windows());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value, (Object)Environment$ArchitectureType$.MODULE$.X86());
        Enumeration.Value value2 = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)Environment$OperatingSystemType$.MODULE$.Windows());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value2, (Object)Environment$ArchitectureType$.MODULE$.ARMv8());
        Enumeration.Value value3 = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)Environment$OperatingSystemType$.MODULE$.Linux());
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value3, (Object)Environment$ArchitectureType$.MODULE$.X86());
        Enumeration.Value value4 = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)Environment$OperatingSystemType$.MODULE$.Linux());
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value4, (Object)Environment$ArchitectureType$.MODULE$.ARMv8());
        Enumeration.Value value5 = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)Environment$OperatingSystemType$.MODULE$.Mac());
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value5, (Object)Environment$ArchitectureType$.MODULE$.X86());
        Enumeration.Value value6 = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)Environment$OperatingSystemType$.MODULE$.Mac());
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value6, (Object)Environment$ArchitectureType$.MODULE$.ARMv8());
        $this.io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$SupportedBinaries_$eq((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public X2CpgConfig<?> io$joern$x2cpg$astgen$AstGenRunnerBase$$config();

    public Logger io$joern$x2cpg$astgen$AstGenRunnerBase$$logger();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$io$joern$x2cpg$astgen$AstGenRunnerBase$$logger_$eq(Logger var1);

    public String WinX86();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$WinX86_$eq(String var1);

    public String WinArm();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$WinArm_$eq(String var1);

    public String LinuxX86();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$LinuxX86_$eq(String var1);

    public String LinuxArm();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$LinuxArm_$eq(String var1);

    public String MacX86();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$MacX86_$eq(String var1);

    public String MacArm();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$MacArm_$eq(String var1);

    public Set<Tuple2<Enumeration.Value, Enumeration.Value>> SupportedBinaries();

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$SupportedBinaries_$eq(Set var1);

    public static String executableName$(AstGenRunnerBase $this, AstGenRunner.AstGenProgramMetaData metaData) {
        return $this.executableName(metaData);
    }

    default public String executableName(AstGenRunner.AstGenProgramMetaData metaData) {
        Enumeration.Value value = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)Environment$.MODULE$.operatingSystem());
        if (!this.SupportedBinaries().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value, (Object)Environment$.MODULE$.architecture()))) {
            throw new UnsupportedOperationException("No compatible binary of " + metaData.name() + " for your operating system!");
        }
        Enumeration.Value value2 = Environment$.MODULE$.operatingSystem();
        Enumeration.Value value3 = Environment$OperatingSystemType$.MODULE$.Windows();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            return this.executableName(this.WinX86(), this.WinArm(), metaData);
        }
        Enumeration.Value value5 = Environment$OperatingSystemType$.MODULE$.Linux();
        Enumeration.Value value6 = value2;
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            return this.executableName(this.LinuxX86(), this.LinuxArm(), metaData);
        }
        Enumeration.Value value7 = Environment$OperatingSystemType$.MODULE$.Mac();
        Enumeration.Value value8 = value2;
        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
            return this.executableName(this.MacX86(), this.MacArm(), metaData);
        }
        Enumeration.Value value9 = Environment$OperatingSystemType$.MODULE$.Unknown();
        Enumeration.Value value10 = value2;
        if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
            this.io$joern$x2cpg$astgen$AstGenRunnerBase$$logger().warn("Could not detect OS version! Defaulting to 'Linux'.");
            return this.executableName(this.LinuxX86(), this.LinuxArm(), metaData);
        }
        throw new MatchError((Object)value2);
    }

    private String executableName(String x86Suffix, String armSuffix, AstGenRunner.AstGenProgramMetaData metaData) {
        if (metaData.multiArchitectureBuilds()) {
            return metaData.name() + "-" + x86Suffix;
        }
        Enumeration.Value value = Environment$.MODULE$.architecture();
        Enumeration.Value value2 = Environment$ArchitectureType$.MODULE$.X86();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return metaData.name() + "-" + x86Suffix;
        }
        Enumeration.Value value4 = Environment$ArchitectureType$.MODULE$.ARMv8();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return metaData.name() + "-" + armSuffix;
        }
        throw new MatchError((Object)value);
    }

    public static boolean isIgnoredByUserConfig$(AstGenRunnerBase $this, String filePath) {
        return $this.isIgnoredByUserConfig(filePath);
    }

    default public boolean isIgnoredByUserConfig(String filePath) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        LazyBoolean lazyBoolean2 = new LazyBoolean();
        if (this.isInIgnoredFiles$1(lazyBoolean, filePath) || this.isInIgnoredFileRegex$1(lazyBoolean2, filePath)) {
            this.io$joern$x2cpg$astgen$AstGenRunnerBase$$logger().debug("'" + filePath + "' ignored by user configuration");
            return true;
        }
        return false;
    }

    public static List filterFiles$(AstGenRunnerBase $this, List files, File out) {
        return $this.filterFiles((List<String>)files, out);
    }

    default public List<String> filterFiles(List<String> files, File out) {
        return files.filter((Function1 & Serializable)_$2 -> this.fileFilter((String)_$2, out));
    }

    public static boolean fileFilter$(AstGenRunnerBase $this, String file, File out) {
        return $this.fileFilter(file, out);
    }

    default public boolean fileFilter(String file, File out) {
        String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(file), ".json").replace(out.pathAsString(), this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().inputPath());
        String filePath = string;
        return !this.isIgnoredByUserConfig(filePath);
    }

    public List<String> skippedFiles(File var1, List<String> var2);

    public Try<Seq<String>> runAstGenNative(String var1, File var2, String var3, String var4, AstGenRunner.AstGenProgramMetaData var5);

    public static String astGenCommand$(AstGenRunnerBase $this, AstGenRunner.AstGenProgramMetaData metaData) {
        return $this.astGenCommand(metaData);
    }

    default public String astGenCommand(AstGenRunner.AstGenProgramMetaData metaData) {
        Config conf = ConfigFactory.load();
        String astGenVersion = conf.getString(metaData.configPrefix() + "." + metaData.name() + "_version");
        if (AstGenRunner$.MODULE$.hasCompatibleAstGenVersion(astGenVersion, metaData)) {
            return metaData.name();
        }
        return AstGenRunner$.MODULE$.executableDir(metaData) + "/" + this.executableName(metaData);
    }

    public static AstGenRunner.AstGenRunnerResult execute$(AstGenRunnerBase $this, File out) {
        return $this.execute(out);
    }

    default public AstGenRunner.AstGenRunnerResult execute(File out) {
        AstGenRunner.AstGenProgramMetaData metaData = ((AstGenConfig)((Object)this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config())).astGenMetaData();
        File in = File$.MODULE$.apply(this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().inputPath(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.io$joern$x2cpg$astgen$AstGenRunnerBase$$logger().info("Running " + metaData.name() + " on '" + this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().inputPath() + "'");
        Try<Seq<String>> try_ = this.runAstGenNative(this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().inputPath(), out, this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().ignoredFilesRegex().toString(), "", metaData);
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            String string = out.toString();
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}));
            Option option = Option$.MODULE$.apply((Object)this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().ignoredFilesRegex());
            Option option2 = Option$.MODULE$.apply(this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().ignoredFiles());
            Option<Seq<Regex>> option3 = SourceFiles$.MODULE$.determine$default$3();
            List<String> srcFiles = SourceFiles$.MODULE$.determine(string, (Set<String>)set, option3, (Option<Regex>)option, (Option<Seq<String>>)option2, SourceFiles$.MODULE$.determine$default$6(string, (Set<String>)set, option3, (Option<Regex>)option, (Option<Seq<String>>)option2));
            List<String> parsed = this.filterFiles(srcFiles, out);
            List<String> skipped = this.skippedFiles(in, (List<String>)result.toList());
            return AstGenRunner$DefaultAstGenRunnerResult$.MODULE$.apply(parsed, skipped);
        }
        if (try_ instanceof Failure) {
            Throwable f = ((Failure)try_).exception();
            this.io$joern$x2cpg$astgen$AstGenRunnerBase$$logger().error("\t- running " + metaData.name() + " failed!", f);
            return AstGenRunner$DefaultAstGenRunnerResult$.MODULE$.apply(AstGenRunner$DefaultAstGenRunnerResult$.MODULE$.$lessinit$greater$default$1(), AstGenRunner$DefaultAstGenRunnerResult$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(try_);
    }

    private boolean isInIgnoredFiles$lzyINIT1$1(LazyBoolean isInIgnoredFiles$lzy1$1, String filePath$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFiles$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFiles$lzy1$1.initialized() ? isInIgnoredFiles$lzy1$1.value() : isInIgnoredFiles$lzy1$1.initialize(this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().ignoredFiles().exists((Function1 & Serializable)x$1 -> {
                String string = x$1;
                String ignorePath = string;
                File file = File$.MODULE$.apply(ignorePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                if (file.isDirectory(file.isDirectory$default$1())) {
                    return filePath$1.startsWith(ignorePath);
                }
                String ignorePath2 = string;
                String string2 = filePath$1;
                String string3 = ignorePath2;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }));
        }
        return bl;
    }

    private boolean isInIgnoredFiles$1(LazyBoolean isInIgnoredFiles$lzy1$2, String filePath$3) {
        if (isInIgnoredFiles$lzy1$2.initialized()) {
            return isInIgnoredFiles$lzy1$2.value();
        }
        return this.isInIgnoredFiles$lzyINIT1$1(isInIgnoredFiles$lzy1$2, filePath$3);
    }

    private boolean isInIgnoredFileRegex$lzyINIT1$1(LazyBoolean isInIgnoredFileRegex$lzy1$1, String filePath$4) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFileRegex$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFileRegex$lzy1$1.initialized() ? isInIgnoredFileRegex$lzy1$1.value() : isInIgnoredFileRegex$lzy1$1.initialize(this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config().ignoredFilesRegex().matches((CharSequence)filePath$4));
        }
        return bl;
    }

    private boolean isInIgnoredFileRegex$1(LazyBoolean isInIgnoredFileRegex$lzy1$2, String filePath$5) {
        if (isInIgnoredFileRegex$lzy1$2.initialized()) {
            return isInIgnoredFileRegex$lzy1$2.value();
        }
        return this.isInIgnoredFileRegex$lzyINIT1$1(isInIgnoredFileRegex$lzy1$2, filePath$5);
    }
}

