/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg;

import better.files.File$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgConfig$;
import io.joern.x2cpg.X2CpgFrontend;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scopt.OParser;

public abstract class X2CpgMain<T extends X2CpgConfig<T>, X extends X2CpgFrontend<T>> {
    private final OParser<BoxedUnit, T> cmdLineParser;
    private final X frontend;
    private final T defaultConfig;
    private final Logger logger;

    public X2CpgMain(OParser<BoxedUnit, T> cmdLineParser, X frontend, T defaultConfig) {
        this.cmdLineParser = cmdLineParser;
        this.frontend = frontend;
        this.defaultConfig = defaultConfig;
        this.logger = LoggerFactory.getLogger(X2CpgMain.class);
    }

    public OParser<BoxedUnit, T> cmdLineParser() {
        return this.cmdLineParser;
    }

    public X frontend() {
        return this.frontend;
    }

    private void logVersionAndArgs(String[] args) {
        String frontendName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.frontend().getClass().getSimpleName()), "$");
        String joernVersion = (String)Option$.MODULE$.apply((Object)this.frontend().getClass().getPackage().getImplementationVersion()).map((Function1 & Serializable)v -> "v" + v).getOrElse(X2CpgMain::$anonfun$2);
        String logText = "Executing " + frontendName + " (" + joernVersion + ") with arguments: " + Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ");
        this.logger.debug(logText);
    }

    private void logOutputPath(String outputPath) {
        String string = X2CpgConfig$.MODULE$.defaultOutputPath();
        String string2 = outputPath;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logger.info("The resulting CPG will be stored at " + File$.MODULE$.apply(outputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
            return;
        }
    }

    public abstract void run(T var1, X var2);

    public void main(String[] args) {
        this.logVersionAndArgs(args);
        Option<T> option = X2Cpg$.MODULE$.parseCommandLine(args, this.cmdLineParser(), this.defaultConfig);
        if (option instanceof Some) {
            X2CpgConfig config = (X2CpgConfig)((Some)option).value();
            try {
                this.logOutputPath(config.outputPath());
                this.run(config, this.frontend());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)"Error parsing the command line");
            System.exit(1);
            return;
        }
        throw new MatchError(option);
    }

    private static final String $anonfun$2() {
        return "local build";
    }
}

