/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import better.files.File$;
import io.joern.x2cpg.utils.dependency.GradleDepsInitScript;
import io.joern.x2cpg.utils.dependency.GradleDepsInitScript$;
import io.joern.x2cpg.utils.dependency.GradleProjectInfo;
import io.joern.x2cpg.utils.dependency.GradleProjectInfo$;
import io.joern.x2cpg.utils.dependency.ProjectNameInfo;
import io.joern.x2cpg.utils.dependency.ProjectNameInfo$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

public final class GradleDependencies$
implements Serializable {
    private static final String aarFileExtension;
    private static final String gradleAndroidPropertyPrefix;
    private static final String gradlePropertiesTaskName;
    private static final String jarInsideAarFileName;
    private static final String defaultConfigurationName;
    private static final String initScriptPrefix;
    private static final String taskNamePrefix;
    private static final String tempDirPrefix;
    private static final String defaultGradleAppName;
    private static final Logger logger;
    public static final GradleDependencies$ MODULE$;

    private GradleDependencies$() {
    }

    static {
        MODULE$ = new GradleDependencies$();
        aarFileExtension = "aar";
        gradleAndroidPropertyPrefix = "android";
        gradlePropertiesTaskName = "properties";
        jarInsideAarFileName = "classes.jar";
        defaultConfigurationName = "releaseRuntimeClasspath";
        initScriptPrefix = "x2cpg.init.gradle";
        taskNamePrefix = "x2cpgCopyDeps";
        tempDirPrefix = "x2cpgDependencies";
        defaultGradleAppName = "app";
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GradleDependencies$.class);
    }

    /*
     * Unable to fully structure code
     */
    private String getInitScriptContent(String taskName, String destination, GradleProjectInfo projectInfo) {
        projectConfigurationString = ((IterableOnceOps)projectInfo.subprojects().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/String;)())).mkString(", ");
        var6_5 = projectInfo.gradleVersionMajorMinor();
        if (var6_5 == null) ** GOTO lbl-1000
        major = var6_5._1$mcI$sp();
        minor = var6_5._2$mcI$sp();
        if (major >= 5 && minor >= 1) {
            v0 = "tasks.register";
        } else lbl-1000:
        // 2 sources

        {
            v0 = "tasks.create";
        }
        taskCreationFunction = v0;
        androidTaskDefinition = Option$.MODULE$.when(projectInfo.hasAndroidSubproject(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$3(java.lang.String ), ()Ljava/lang/String;)((String)taskCreationFunction));
        dependsOnAndroidTask = Option$.MODULE$.when(projectInfo.hasAndroidSubproject(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(), ()Ljava/lang/String;)());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |allprojects {\n       |  afterEvaluate { project ->\n       |    def taskName = \"" + taskName + "\"\n       |    def destinationDir = \"" + destination.replaceAll("\\\\", "/") + "\"\n       |    def gradleProjectConfigurations = [" + projectConfigurationString + "]\n       |\n       |    if (gradleProjectConfigurations.containsKey(project.name)) {\n       |      def gradleConfigurationNames = gradleProjectConfigurations.get(project.name)\n       |      \n       |      def compileDepsCopyTaskName = taskName + \"_compileDeps\"\n       |      " + taskCreationFunction + "(compileDepsCopyTaskName, Copy) {\n       |\n       |        def selectedConfigs = project.configurations.findAll {\n       |          configuration -> gradleConfigurationNames.contains(configuration.getName())\n       |        }\n       |\n       |        def componentIds = []\n       |        if (!selectedConfigs.isEmpty()) {\n       |          for (selectedConfig in selectedConfigs) {\n       |            componentIds = selectedConfig.incoming.resolutionResult.allDependencies.findAll {\n       |              dep -> dep instanceof org.gradle.api.internal.artifacts.result.DefaultResolvedDependencyResult\n       |            } .collect { it.selected.id }\n       |          }\n       |        }\n       |\n       |        def result = dependencies.createArtifactResolutionQuery()\n       |                                 .forComponents(componentIds)\n       |                                 .withArtifacts(JvmLibrary, SourcesArtifact)\n       |                                 .execute()\n       |        duplicatesStrategy = 'include'\n       |        into destinationDir\n       |        from result.resolvedComponents.collect { it.getArtifacts(SourcesArtifact).collect { it.file } }\n       |      }\n       |      " + androidTaskDefinition.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, getInitScriptContent$$anonfun$1(), ()Ljava/lang/String;)()) + "\n       |      " + taskCreationFunction + "(taskName, Copy) {\n       |        " + dependsOnAndroidTask.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, getInitScriptContent$$anonfun$2(), ()Ljava/lang/String;)()) + " \n       |        dependsOn compileDepsCopyTaskName\n       |      }\n       |    }\n       |  }\n       |}\n       |"));
    }

    private GradleDepsInitScript makeInitScript(Path destinationDir, GradleProjectInfo projectInfo) {
        String taskName = taskNamePrefix + "_" + Random$.MODULE$.alphanumeric().take(8).toList().mkString();
        String content = this.getInitScriptContent(taskName, destinationDir.toString(), projectInfo);
        return GradleDepsInitScript$.MODULE$.apply(content, taskName, destinationDir);
    }

    public ProjectConnection makeConnection(File projectDir) {
        return GradleConnector.newConnector().forProjectDirectory(projectDir).connect();
    }

    private List<String> getConfigurationsWithDependencies(String dependenciesOutput) {
        Regex configurationNameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\S*([rR]elease|[rR]untime)\\S*) -.+$"));
        Iterator lines = CollectionConverters$.MODULE$.IteratorHasAsScala(dependenciesOutput.lines().iterator()).asScala();
        scala.collection.mutable.Set results = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        while (lines.hasNext()) {
            List list;
            Option option;
            String line = (String)lines.next();
            String string = line;
            if (string != null && !(option = configurationNameRegex.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
                String string2 = (String)list.apply(0);
                String string3 = (String)list.apply(1);
                String configurationName = string2;
                if (lines.hasNext()) {
                    String next;
                    String string4 = next = (String)lines.next();
                    String string5 = "No dependencies";
                    if (string4 == null ? string5 != null : !string4.equals(string5)) {
                        results.addOne((Object)configurationName);
                    }
                    lines.takeWhile((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1)));
                    continue;
                }
            }
            lines.takeWhile((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2)));
        }
        return ((IterableOnceOps)results.filterNot((Function1 & Serializable)_$3 -> _$3.toLowerCase().contains("test"))).toList();
    }

    private Option<GradleProjectInfo> getGradleProjectInfo(Path projectDir, Option<String> projectNameOverride, Option<String> configurationNameOverride) {
        Try try_ = Try$.MODULE$.apply(() -> GradleDependencies$.getGradleProjectInfo$$anonfun$1(projectDir));
        if (try_ instanceof Success) {
            ProjectConnection gradleConnection = (ProjectConnection)((Success)try_).value();
            return (Option)Using$.MODULE$.resource((Object)gradleConnection, (Function1 & Serializable)connection -> {
                None$ none$;
                try {
                    List list;
                    BuildEnvironment buildEnv = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
                    GradleProject project = (GradleProject)connection.getModel(GradleProject.class);
                    ProjectNameInfo projectNameInfo2 = ProjectNameInfo$.MODULE$.apply(project.getName(), false);
                    List availableProjectNames = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala((Set)project.getChildren()).asScala().map((Function1 & Serializable)child -> ProjectNameInfo$.MODULE$.apply(child.getName(), true))).toList().$colon$colon((Object)projectNameInfo2);
                    String availableProjectNamesString = availableProjectNames.mkString(" ");
                    logger.debug("Found gradle project names " + availableProjectNames.mkString(" "));
                    if (projectNameOverride.isDefined()) {
                        String overrideName = (String)projectNameOverride.get();
                        Option option = availableProjectNames.find((Function1 & Serializable)_$4 -> {
                            String string = _$4.projectName();
                            String string2 = overrideName;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        });
                        if (option instanceof Some) {
                            ProjectNameInfo projectInfo = (ProjectNameInfo)((Some)option).value();
                            logger.debug("Only fetching dependencies for overridden project name " + overrideName);
                            list = package$.MODULE$.Nil().$colon$colon((Object)projectInfo);
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            logger.warn("Project name override was specified for dependency fetching (" + overrideName + "), but no such project found.");
                            logger.warn("Falling back to fetching dependencies for all available project names: " + availableProjectNamesString);
                            list = availableProjectNames;
                        }
                    } else {
                        Option option = availableProjectNames.find((Function1 & Serializable)_$5 -> {
                            String string = _$5.projectName();
                            String string2 = defaultGradleAppName;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        });
                        if (option instanceof Some) {
                            ProjectNameInfo defaultProjectInfo = (ProjectNameInfo)((Some)option).value();
                            logger.debug("Found project with default name (" + defaultGradleAppName + ")");
                            logger.debug("Fetching dependencies only for default project (" + defaultGradleAppName + ")");
                            list = package$.MODULE$.Nil().$colon$colon((Object)defaultProjectInfo);
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            logger.debug("No project name override or project with default name (" + defaultGradleAppName + ") found.");
                            logger.debug("Fetching dependencies for all available projects: " + availableProjectNamesString);
                            list = availableProjectNames;
                        }
                    }
                    List selectedProjectNames = list;
                    Map selectedConfigurations = selectedProjectNames.flatMap((Function1 & Serializable)projectNameInfo -> {
                        List list;
                        List list2;
                        String dependenciesTaskName = projectNameInfo.makeGradleTaskName("dependencies");
                        Option<String> option = MODULE$.runGradleTask((ProjectConnection)connection, dependenciesTaskName);
                        if (option instanceof Some) {
                            String out = (String)((Some)option).value();
                            List list3 = MODULE$.getConfigurationsWithDependencies(out);
                            Nil$ nil$ = package$.MODULE$.Nil();
                            List list4 = list3;
                            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                                logger.debug("No configurations with dependencies found for project " + projectNameInfo);
                                list2 = package$.MODULE$.Nil();
                            } else {
                                List deps = list3;
                                logger.debug("Found the following configurations with dependencies for project " + projectNameInfo + ": " + deps.mkString(", "));
                                list2 = deps;
                            }
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            logger.warn("Failure executing dependencies task " + dependenciesTaskName);
                            list2 = package$.MODULE$.Nil();
                        }
                        List availableConfigurations = list2;
                        String availableConfigurationsString = availableConfigurations.mkString(", ");
                        if (availableConfigurations.isEmpty()) {
                            list = package$.MODULE$.Nil();
                        } else if (configurationNameOverride.isDefined()) {
                            String overrideName = (String)configurationNameOverride.get();
                            Option option2 = availableConfigurations.find((Function1 & Serializable)_$6 -> {
                                String string = _$6;
                                String string2 = overrideName;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            });
                            if (option2 instanceof Some) {
                                String configurationName = (String)((Some)option2).value();
                                logger.debug("Only fetching dependencies for overridden configuration " + overrideName);
                                list = package$.MODULE$.Nil().$colon$colon((Object)configurationName);
                            } else {
                                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                                logger.warn("Configuration name override was specified for dependency fetching (" + overrideName + "), but no such configuration found for project " + projectNameInfo + ".");
                                logger.warn("Falling back to fetching dependencies for all available configurations: " + availableConfigurationsString);
                                list = availableConfigurations;
                            }
                        } else {
                            Option option3 = availableConfigurations.find((Function1 & Serializable)_$7 -> {
                                String string = _$7;
                                String string2 = defaultConfigurationName;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            });
                            if (option3 instanceof Some) {
                                String defaultConfigurationName = (String)((Some)option3).value();
                                logger.debug("Found default configuration name (" + defaultConfigurationName + ") for project " + projectNameInfo);
                                logger.debug("Fetching dependencies only for default configuration (" + defaultConfigurationName + ") for project " + projectNameInfo);
                                list = package$.MODULE$.Nil().$colon$colon((Object)defaultConfigurationName);
                            } else {
                                if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                                logger.debug("No configuration override or configuration with default name (" + defaultConfigurationName + ") found for project " + projectNameInfo + ".");
                                logger.debug("Fetching dependencies for all available configurations for project " + projectNameInfo + ": " + availableConfigurationsString);
                                list = availableConfigurations;
                            }
                        }
                        List selectedConfigurations = list;
                        return Option$.MODULE$.when(selectedConfigurations.nonEmpty(), () -> GradleDependencies$.$anonfun$8$$anonfun$1(projectNameInfo, selectedConfigurations));
                    }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    boolean includesAndroidProject = selectedProjectNames.exists((Function1 & Serializable)projectNameInfo -> {
                        String propertiesTaskName = projectNameInfo.makeGradleTaskName(gradlePropertiesTaskName);
                        Option<String> option = MODULE$.runGradleTask((ProjectConnection)connection, propertiesTaskName);
                        if (option instanceof Some) {
                            String out = (String)((Some)option).value();
                            return CollectionConverters$.MODULE$.IteratorHasAsScala(out.lines().iterator()).asScala().exists((Function1 & Serializable)_$8 -> _$8.startsWith(gradleAndroidPropertyPrefix));
                        }
                        if (None$.MODULE$.equals(option)) {
                            return false;
                        }
                        throw new MatchError(option);
                    });
                    String gradleVersion = buildEnv.getGradle().getGradleVersion();
                    GradleProjectInfo gradleProjectInfo = GradleProjectInfo$.MODULE$.apply((Map<ProjectNameInfo, List<String>>)selectedConfigurations, gradleVersion, includesAndroidProject);
                    none$ = Option$.MODULE$.apply((Object)gradleProjectInfo);
                    return none$;
                }
                catch (Throwable t) {
                    logger.warn("Caught exception while trying use Gradle connection: " + t.getMessage());
                    logger.debug("Full exception: ", t);
                    none$ = None$.MODULE$;
                }
                return none$;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        if (try_ instanceof Failure) {
            Throwable t = ((Failure)try_).exception();
            logger.warn("Caught exception while trying fetch Gradle project information: " + t.getMessage());
            logger.debug("Full exception: ", t);
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private Option<String> runGradleTask(ProjectConnection connection, String taskName) {
        return (Option)Using$.MODULE$.resource((Object)new ByteArrayOutputStream(), (Function1 & Serializable)out -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                GradleDependencies$.runGradleTask$$anonfun$1$$anonfun$1(connection, taskName, out);
                return BoxedUnit.UNIT;
            });
            if (try_ instanceof Success) {
                return Some$.MODULE$.apply((Object)out.toString());
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                logger.warn("Caught exception while executing Gradle task named `" + taskName + "`:", (Object)ex.getMessage());
                logger.debug("Full exception: ", ex);
                return None$.MODULE$;
            }
            throw new MatchError((Object)try_);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Seq<String>> runGradleTask(ProjectConnection connection, String taskName, Path destinationDir, String initScriptPath) {
        return (Option)Using$.MODULE$.resources((Object)new ByteArrayOutputStream(), GradleDependencies$::runGradleTask$$anonfun$2, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                ByteArrayOutputStream stdoutStream = (ByteArrayOutputStream)tuple2._1();
                ByteArrayOutputStream stderrStream = (ByteArrayOutputStream)tuple2._2();
                logger.debug("Executing gradle task '" + taskName + "'...");
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    GradleDependencies$.runGradleTask$$anonfun$3$$anonfun$1(connection, taskName, initScriptPath, stdoutStream, stderrStream);
                    return BoxedUnit.UNIT;
                });
                if (try_ instanceof Success) {
                    Buffer result = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(Files.list(destinationDir).collect(Collectors.toList())).asScala().map((Function1 & Serializable)_$9 -> _$9.toAbsolutePath().toString());
                    logger.info("Task " + taskName + " resolved `" + result.size() + "` dependency files.");
                    return Some$.MODULE$.apply((Object)result);
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    logger.warn("Caught exception while executing Gradle task: " + ex.getMessage());
                    String androidSdkError = "Define a valid SDK location with an ANDROID_HOME environment variable";
                    if (stderrStream.toString().contains(androidSdkError)) {
                        logger.warn("A missing Android SDK configuration caused gradle dependency fetching failures. Please define a valid SDK location with an ANDROID_HOME environment variable or by setting the sdk.dir path in your project's local properties file");
                    }
                    if (stderrStream.toString().contains("Could not compile initialization script")) {
                        better.files.File file = File$.MODULE$.apply(initScriptPath, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                        String scriptContents = file.contentAsString(file.contentAsString$default$1());
                        logger.debug("########## INITIALIZATION_SCRIPT ##########\n" + scriptContents + "\n###########################################");
                    }
                    logger.debug("Gradle task execution stdout: \n" + stdoutStream);
                    logger.debug("Gradle task execution stderr: \n" + stderrStream);
                    return None$.MODULE$;
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError((Object)tuple2);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Path> extractClassesJarFromAar(better.files.File aar) {
        String newPath = aar.path().toString().replaceFirst(aarFileExtension + "$", "jar");
        String aarUnzipDirSuffix = ".unzipped";
        better.files.File outDir = File$.MODULE$.apply(aar.path().toString() + aarUnzipDirSuffix, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        Function1 & Serializable intersect = (Function1 & Serializable)_$10 -> {
            String string = _$10.getName();
            String string2 = jarInsideAarFileName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        aar.unzipTo(outDir, (Function1)intersect, aar.unzipTo$default$3(outDir, (Function1)intersect));
        better.files.File outFile = File$.MODULE$.apply(newPath, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        List classesJarEntries = outDir.listRecursively(outDir.listRecursively$default$1()).filter((Function1 & Serializable)_$11 -> {
            String string = _$11.path().getFileName().toString();
            String string2 = jarInsideAarFileName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).toList();
        if (classesJarEntries.size() != 1) {
            logger.warn("Found aar file without `classes.jar` inside at path " + aar.path());
            outDir.delete(outDir.delete$default$1(), outDir.delete$default$2());
            return None$.MODULE$;
        }
        better.files.File classesJar = (better.files.File)classesJarEntries.head();
        logger.trace("Copying `classes.jar` for aar at `" + aar.path().toString() + "` into `" + newPath + "`");
        boolean bl = classesJar.copyTo$default$2();
        classesJar.copyTo(outFile, bl, classesJar.copyTo$default$3(outFile, bl));
        outDir.delete(outDir.delete$default$1(), outDir.delete$default$2());
        aar.delete(aar.delete$default$1(), aar.delete$default$2());
        return Some$.MODULE$.apply((Object)outFile.path());
    }

    public Map<String, Seq<String>> get(Path projectDir, Option<String> projectNameOverride, Option<String> configurationNameOverride) {
        logger.info("Fetching Gradle project information at path `" + projectDir + "`.");
        Option<GradleProjectInfo> option = this.getGradleProjectInfo(projectDir, projectNameOverride, configurationNameOverride);
        if (option instanceof Some) {
            GradleProjectInfo gradleProjectInfo = (GradleProjectInfo)((Some)option).value();
            GradleProjectInfo projectInfo = gradleProjectInfo;
            if (projectInfo.gradleVersionMajorMinor()._1$mcI$sp() < 5) {
                logger.warn("Unsupported Gradle version `" + projectInfo.gradleVersion() + "`");
                return Predef$.MODULE$.Map().empty();
            }
            GradleProjectInfo projectInfo2 = gradleProjectInfo;
            Try try_ = Try$.MODULE$.apply(GradleDependencies$::get$$anonfun$1);
            if (try_ instanceof Success) {
                better.files.File destinationDir = (better.files.File)((Success)try_).value();
                Try try_2 = Try$.MODULE$.apply(GradleDependencies$::get$$anonfun$2);
                if (try_2 instanceof Success) {
                    better.files.File initScriptFile = (better.files.File)((Success)try_2).value();
                    GradleDepsInitScript initScript = this.makeInitScript(destinationDir.path(), projectInfo2);
                    initScriptFile.write(initScript.contents(), initScriptFile.write$default$2(initScript.contents()), initScriptFile.write$default$3(initScript.contents()));
                    Try try_3 = Try$.MODULE$.apply(() -> GradleDependencies$.get$$anonfun$3(projectDir));
                    if (try_3 instanceof Success) {
                        ProjectConnection connection = (ProjectConnection)((Success)try_3).value();
                        return (Map)Using$.MODULE$.resource((Object)connection, (Function1 & Serializable)c -> ((IterableOnceOps)projectInfo2.subprojects().keys().flatMap((Function1 & Serializable)projectNameInfo -> {
                            String taskName = projectNameInfo.makeGradleTaskName(initScript.taskName());
                            return MODULE$.runGradleTask((ProjectConnection)c, taskName, initScript.destinationDir(), initScriptFile.pathAsString()).map((Function1 & Serializable)deps -> {
                                Seq depsOutput = (Seq)deps.map((Function1 & Serializable)d -> {
                                    if (!d.endsWith(aarFileExtension)) {
                                        return d;
                                    }
                                    Option<Path> option = MODULE$.extractClassesJarFromAar(File$.MODULE$.apply(d, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
                                    if (option instanceof Some) {
                                        Path path = (Path)((Some)option).value();
                                        return path.toString();
                                    }
                                    if (None$.MODULE$.equals(option)) {
                                        return d;
                                    }
                                    throw new MatchError(option);
                                });
                                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)projectNameInfo.projectName());
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)depsOutput);
                            });
                        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    }
                    if (try_3 instanceof Failure) {
                        Throwable ex = ((Failure)try_3).exception();
                        logger.warn("Caught exception while trying to establish a Gradle connection: " + ex.getMessage());
                        logger.debug("Full exception: ", ex);
                        return Predef$.MODULE$.Map().empty();
                    }
                    throw new MatchError((Object)try_3);
                }
                if (try_2 instanceof Failure) {
                    Throwable ex = ((Failure)try_2).exception();
                    logger.warn("Could not create temporary file for Gradle init script: " + ex.getMessage());
                    logger.debug("Full exception: ", ex);
                    return Predef$.MODULE$.Map().empty();
                }
                throw new MatchError((Object)try_2);
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                logger.warn("Could not create temporary directory for saving dependency files: " + ex.getMessage());
                logger.debug("Full exception: ", ex);
                return Predef$.MODULE$.Map().empty();
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option)) {
            logger.warn("Could not fetch Gradle project information");
            return Predef$.MODULE$.Map().empty();
        }
        throw new MatchError(option);
    }

    private static final /* synthetic */ String $anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            ProjectNameInfo projectNameInfo = (ProjectNameInfo)tuple2._1();
            List configurationNames = (List)tuple2._2();
            String quotedConfigurationNames = configurationNames.map((Function1 & Serializable)name -> "\"" + name + "\"").mkString(", ");
            return "\"" + projectNameInfo.projectName() + "\": [" + quotedConfigurationNames + "]";
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String $anonfun$3(String taskCreationFunction$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |def androidDepsCopyTaskName = taskName + \"_androidDeps\"\n           |      " + taskCreationFunction$1 + "(androidDepsCopyTaskName, Copy) {\n           |        duplicatesStrategy = 'include'\n           |        into destinationDir\n           |        from project.configurations.find { it.name.equals(\"androidApis\") }\n           |      }\n           |"));
    }

    private static final String $anonfun$4() {
        return "dependsOn androidDepsCopyTaskName";
    }

    private static final String getInitScriptContent$$anonfun$1() {
        return "";
    }

    private static final String getInitScriptContent$$anonfun$2() {
        return "";
    }

    private static final ProjectConnection getGradleProjectInfo$$anonfun$1(Path projectDir$1) {
        return MODULE$.makeConnection(projectDir$1.toFile());
    }

    private static final Tuple2 $anonfun$8$$anonfun$1(ProjectNameInfo projectNameInfo$1, List selectedConfigurations$1) {
        ProjectNameInfo projectNameInfo = (ProjectNameInfo)Predef$.MODULE$.ArrowAssoc((Object)projectNameInfo$1);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)projectNameInfo, (Object)selectedConfigurations$1);
    }

    private static final void runGradleTask$$anonfun$1$$anonfun$1(ProjectConnection connection$4, String taskName$2, ByteArrayOutputStream out$1) {
        ((BuildLauncher)connection$4.newBuild().forTasks(new String[]{taskName$2}).setStandardOutput((OutputStream)out$1)).run();
    }

    private static final ByteArrayOutputStream runGradleTask$$anonfun$2() {
        return new ByteArrayOutputStream();
    }

    private static final void runGradleTask$$anonfun$3$$anonfun$1(ProjectConnection connection$6, String taskName$4, String initScriptPath$2, ByteArrayOutputStream stdoutStream$1, ByteArrayOutputStream stderrStream$1) {
        ((BuildLauncher)connection$6.newBuild().forTasks(new String[]{taskName$4}).withArguments(new String[]{"--init-script", initScriptPath$2}).setStandardOutput((OutputStream)stdoutStream$1).setStandardError((OutputStream)stderrStream$1)).run();
    }

    private static final better.files.File get$$anonfun$1() {
        Option option = File$.MODULE$.newTemporaryDirectory$default$2();
        better.files.File file = File$.MODULE$.newTemporaryDirectory(tempDirPrefix, option, File$.MODULE$.newTemporaryDirectory$default$3(tempDirPrefix, option));
        return file.deleteOnExit(file.deleteOnExit$default$1(), file.deleteOnExit$default$2());
    }

    private static final better.files.File get$$anonfun$2() {
        String string = File$.MODULE$.newTemporaryFile$default$2();
        Option option = File$.MODULE$.newTemporaryFile$default$3();
        better.files.File file = File$.MODULE$.newTemporaryFile(initScriptPrefix, string, option, File$.MODULE$.newTemporaryFile$default$4(initScriptPrefix, string, option));
        return file.deleteOnExit(file.deleteOnExit$default$1(), file.deleteOnExit$default$2());
    }

    private static final ProjectConnection get$$anonfun$3(Path projectDir$2) {
        return MODULE$.makeConnection(projectDir$2.toFile());
    }
}

