/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils;

import io.joern.x2cpg.utils.KeyPool;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class IntervalKeyPool
implements KeyPool {
    private final long first;
    private final long last;
    private final AtomicLong cur;
    private boolean valid;

    public IntervalKeyPool(long first, long last) {
        this.first = first;
        this.last = last;
        this.cur = new AtomicLong(first - 1L);
        this.valid = true;
    }

    public long first() {
        return this.first;
    }

    public long last() {
        return this.last;
    }

    @Override
    public long next() {
        if (!this.valid) {
            throw new IllegalStateException("Call to `next` on invalidated IntervalKeyPool.");
        }
        long n = this.cur.incrementAndGet();
        if (n > this.last()) {
            throw new RuntimeException("Pool exhausted");
        }
        return n;
    }

    public Iterator<IntervalKeyPool> split(int numberOfPartitions) {
        this.valid = false;
        if (numberOfPartitions == 0) {
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        long curFirst = this.cur.get();
        long k = (this.last() - curFirst) / (long)numberOfPartitions;
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfPartitions).map((Function1 & Serializable)i -> IntervalKeyPool.split$$anonfun$1(curFirst, k, BoxesRunTime.unboxToInt((Object)i))).iterator();
    }

    private static final /* synthetic */ IntervalKeyPool split$$anonfun$1(long curFirst$1, long k$1, int i) {
        long poolFirst = curFirst$1 + (long)(i - 1) * k$1;
        return new IntervalKeyPool(poolFirst, poolFirst + k$1 - 1L);
    }
}

