/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import io.joern.x2cpg.utils.ExternalCommand$;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class MavenDependencies$
implements Serializable {
    private static final Logger logger;
    private static final String fetchCommand;
    private static final String fetchCommandWithOpts;
    public static final MavenDependencies$ MODULE$;

    private MavenDependencies$() {
    }

    static {
        MODULE$ = new MavenDependencies$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        String MavenCliOpts = "MAVEN_CLI_OPTS";
        fetchCommand = "mvn $" + MavenCliOpts + " --fail-never -B dependency:build-classpath -DincludeScope=compile -Dorg.slf4j.simpleLogger.defaultLogLevel=info -Dorg.slf4j.simpleLogger.logFile=System.out";
        Set optionsToStrip = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-h", "--help", "-q", "--quiet", "-v", "--version"}));
        String mavenOpts = (String)Option$.MODULE$.apply((Object)System.getenv(MavenCliOpts)).getOrElse(MODULE$::$anonfun$1);
        Object object = Predef$.MODULE$.refArrayOps((Object[])mavenOpts.split("\\s"));
        String mavenOptsStripped = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(object, (Function1 & Serializable)elem -> optionsToStrip.contains(elem))).mkString(" ");
        fetchCommandWithOpts = fetchCommand.replace("$" + MavenCliOpts, mavenOptsStripped);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MavenDependencies$.class);
    }

    private void logErrors(String output) {
        logger.warn("Retrieval of compile class path via maven return with error.\nThe compile class path may be missing or partial.\nResults will suffer from poor type information.\nTo fix this issue, please ensure that the below command can be executed successfully from the project root directory:\n" + fetchCommand + "\n\n", (Object)output);
    }

    public Option<Seq<String>> get(Path projectDir) {
        scala.collection.immutable.Seq seq;
        Try try_ = ExternalCommand$.MODULE$.run(fetchCommandWithOpts, projectDir.toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            scala.collection.immutable.Seq lines = (scala.collection.immutable.Seq)((Success)try_).value();
            if (lines.contains((Object)"[INFO] Build failures were ignored.")) {
                this.logErrors(lines.mkString(System.lineSeparator()));
            }
            seq = lines;
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logErrors(exception.getMessage());
            seq = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(exception.getMessage())).toSeq();
        } else {
            throw new MatchError((Object)try_);
        }
        scala.collection.immutable.Seq lines = seq;
        BooleanRef classPathNext = BooleanRef.create((boolean)false);
        List deps = ((IterableOnceOps)((SeqOps)lines.flatMap((Function1 & Serializable)line -> {
            boolean isClassPathNow = classPathNext$1.elem;
            classPathNext$1.elem = line.endsWith("Dependencies classpath:");
            if (isClassPathNow) {
                return Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line), ':'));
            }
            return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        })).distinct()).toList();
        logger.info("got {} Maven dependencies", (Object)BoxesRunTime.boxToInteger((int)deps.size()));
        return Some$.MODULE$.apply((Object)deps);
    }

    private final String $anonfun$1() {
        return "";
    }
}

