/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.avaje.jsonb;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.stream.JsonOutput;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.ServiceRegistry;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.internal.avaje.jsonb.DataBufferJsonOutput;
import java.io.InputStream;
import java.lang.reflect.Type;

public class AvajeJsonbModule
implements Extension,
MessageDecoder,
MessageEncoder {
    private final Jsonb jsonb;

    public AvajeJsonbModule(@NonNull Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public AvajeJsonbModule() {
        this(Jsonb.builder().build());
    }

    public void install(@NonNull Jooby application) throws Exception {
        application.decoder(MediaType.json, (MessageDecoder)this);
        application.encoder(MediaType.json, (MessageEncoder)this);
        ServiceRegistry services = application.getServices();
        services.put(Jsonb.class, (Object)this.jsonb);
    }

    @NonNull
    public Object decode(@NonNull Context ctx, @NonNull Type type) throws Exception {
        Body body = ctx.body();
        if (body.isInMemory()) {
            return this.jsonb.type(type).fromJson(body.bytes());
        }
        try (InputStream stream = body.stream();){
            Object object = this.jsonb.type(type).fromJson(stream);
            return object;
        }
    }

    @NonNull
    public DataBuffer encode(@NonNull Context ctx, @NonNull Object value) {
        ctx.setDefaultResponseType(MediaType.json);
        DataBufferFactory factory = ctx.getBufferFactory();
        DataBuffer buffer = factory.allocateBuffer(4096);
        try (JsonWriter writer = this.jsonb.writer((JsonOutput)new DataBufferJsonOutput(buffer));){
            this.jsonb.toJson(value, writer);
            DataBuffer dataBuffer = buffer;
            return dataBuffer;
        }
    }
}

