/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.email;

import com.typesafe.config.Config;
import io.jooby.SneakyThrows;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;

public class EmailFactory {
    private final Config mail;

    public EmailFactory(Config mail) {
        this.mail = Objects.requireNonNull(mail, "Mail config is required.");
    }

    public SimpleEmail newSimpleEmail() {
        return this.newEmail(new SimpleEmail());
    }

    public HtmlEmail newHtmlEmail() {
        return this.newEmail(new HtmlEmail());
    }

    public MultiPartEmail newMultiPartEmail() {
        return this.newEmail(new MultiPartEmail());
    }

    public ImageHtmlEmail newImageHtmlEmail() {
        return this.newEmail(new ImageHtmlEmail());
    }

    public <T extends Email> T newEmail(T email) {
        this.ifset("username", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setAuthentication(this.mail.getString(p), this.mail.getString("password"))));
        this.ifset("bcc", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setBcc(this.address(this.strList((String)p)))));
        this.ifset("bounceAddress", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setBounceAddress(this.mail.getString(p))));
        this.ifset("cc", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setCc(this.address(this.strList((String)p)))));
        email.setCharset(this.mail.getString("charset"));
        this.ifset("debug", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setDebug(this.mail.getBoolean(p))));
        this.ifset("from", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setFrom(this.mail.getString(p))));
        this.ifset("hostName", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setHostName(this.mail.getString(p))));
        this.ifset("msg", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> {
            if (email instanceof HtmlEmail) {
                ((HtmlEmail)email).setHtmlMsg(this.mail.getString(p));
            } else {
                email.setMsg(this.mail.getString(p));
            }
        }));
        this.ifset("replyTo", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setReplyTo(this.address(this.mail.getStringList(p)))));
        this.ifset("sendPartial", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSendPartial(this.mail.getBoolean(p))));
        this.ifset("smtpPort", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSmtpPort(this.mail.getInt(p))));
        this.ifset("socketConnectionTimeout", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSocketConnectionTimeout((int)this.mail.getDuration(p, TimeUnit.MILLISECONDS))));
        this.ifset("socketTimeout", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSocketTimeout((int)this.mail.getDuration(p, TimeUnit.MILLISECONDS))));
        this.ifset("ssl.checkServerIdentity", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSSLCheckServerIdentity(this.mail.getBoolean(p))));
        this.ifset("ssl.onConnect", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSSLOnConnect(this.mail.getBoolean(p))));
        this.ifset("ssl.smtpPort", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSslSmtpPort(this.mail.getString(p))));
        this.ifset("startTLSEnabled", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setStartTLSEnabled(this.mail.getBoolean(p))));
        this.ifset("startTLSRequired", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setStartTLSRequired(this.mail.getBoolean(p))));
        this.ifset("subject", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setSubject(this.mail.getString(p))));
        this.ifset("to", (SneakyThrows.Consumer<String>)((SneakyThrows.Consumer)p -> email.setTo(this.address(this.strList((String)p)))));
        return email;
    }

    private List<String> strList(String p) {
        Object list = this.mail.getAnyRef(p);
        if (list instanceof String) {
            return Collections.singletonList(list.toString());
        }
        return this.mail.getStringList(p);
    }

    private List<InternetAddress> address(List<String> list) throws AddressException {
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(list.size());
        for (String addr : list) {
            addresses.add(new InternetAddress(addr));
        }
        return addresses;
    }

    private void ifset(String key, SneakyThrows.Consumer<String> setter) {
        if (this.mail.hasPath(key)) {
            setter.accept((Object)key);
        }
    }
}

