/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.cache.HighConcurrencyTemplateCache;
import com.github.jknack.handlebars.cache.NullTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MessageEncoder;
import io.jooby.ServiceRegistry;
import io.jooby.TemplateEngine;
import io.jooby.handlebars.HbsTemplateEngine;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class HandlebarsModule
implements Extension {
    private static final List<String> EXT = Arrays.asList(".hbs", ".hbs.html", ".html");
    private Handlebars handlebars;
    private String templatesPathString;
    private Path templatesPath;

    public HandlebarsModule(@Nonnull Handlebars handlebars) {
        this.handlebars = handlebars;
    }

    public HandlebarsModule(@Nonnull String templatesPath) {
        this.templatesPathString = templatesPath;
    }

    public HandlebarsModule(@Nonnull Path templatesPath) {
        this.templatesPath = templatesPath;
    }

    public HandlebarsModule() {
        this("views");
    }

    public void install(@Nonnull Jooby application) throws Exception {
        if (this.handlebars == null) {
            this.handlebars = HandlebarsModule.create().setTemplatesPath(this.templatesPathString).setTemplatesPath(this.templatesPath).build(application.getEnvironment());
        }
        application.encoder((MessageEncoder)new HbsTemplateEngine(this.handlebars, EXT));
        ServiceRegistry services = application.getServices();
        services.put(Handlebars.class, (Object)this.handlebars);
    }

    @Nonnull
    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private Handlebars handlebars = new Handlebars().setCharset(StandardCharsets.UTF_8);
        private TemplateLoader loader;
        private TemplateCache cache;
        private String templatesPathString = "views";
        private Path templatesPath;

        @Nonnull
        public Builder setTemplateCache(@Nonnull TemplateCache cache) {
            this.cache = cache;
            return this;
        }

        @Nonnull
        public Builder setTemplatesPath(@Nonnull String templatesPathString) {
            this.templatesPathString = templatesPathString;
            return this;
        }

        @Nonnull
        public Builder setTemplatesPath(@Nonnull Path templatesPath) {
            this.templatesPath = templatesPath;
            return this;
        }

        @Nonnull
        public Builder setTemplateLoader(@Nonnull TemplateLoader loader) {
            this.loader = loader;
            return this;
        }

        @Nonnull
        public Handlebars build(@Nonnull Environment env) {
            if (this.loader == null) {
                String templatesPathString = TemplateEngine.normalizePath((String)env.getProperty("templates.path", Optional.ofNullable(this.templatesPathString).orElse("views")));
                this.loader = Builder.defaultTemplateLoader(env, templatesPathString, this.templatesPath);
            }
            this.handlebars.with(new TemplateLoader[]{this.loader});
            if (this.cache == null) {
                this.cache = env.isActive("dev", new String[]{"test"}) ? NullTemplateCache.INSTANCE : new HighConcurrencyTemplateCache();
            }
            this.handlebars.with(this.cache);
            this.loader = null;
            this.cache = null;
            return this.handlebars;
        }

        private static TemplateLoader defaultTemplateLoader(Environment env, String templatePathString, Path templatesPath) {
            Path dir = Optional.ofNullable(templatesPath).orElse(Paths.get(System.getProperty("user.dir"), templatePathString));
            if (Files.exists(dir, new LinkOption[0])) {
                return new FileTemplateLoader(dir.toFile(), "");
            }
            final ClassLoader classLoader = env.getClassLoader();
            return new ClassPathTemplateLoader(templatePathString, ""){

                protected URL getResource(String location) {
                    return classLoader.getResource(location);
                }
            };
        }
    }
}

