/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate.validator;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ErrorHandler;
import io.jooby.StatusCode;
import io.jooby.validation.ValidationResult;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintViolationHandler
implements ErrorHandler {
    private static final String ROOT_VIOLATIONS_PATH = "";
    private final Logger log = LoggerFactory.getLogger(ConstraintViolationHandler.class);
    private final StatusCode statusCode;
    private final String title;
    private final boolean logException;

    public ConstraintViolationHandler(@NonNull StatusCode statusCode, @NonNull String title, boolean logException) {
        this.statusCode = statusCode;
        this.title = title;
        this.logException = logException;
    }

    public void apply(@NonNull Context ctx, @NonNull Throwable cause, @NonNull StatusCode code) {
        if (cause instanceof ConstraintViolationException) {
            ConstraintViolationException ex = (ConstraintViolationException)cause;
            if (this.logException) {
                this.log.error(ErrorHandler.errorMessage((Context)ctx, (StatusCode)code), cause);
            }
            Set violations = ex.getConstraintViolations();
            Map<String, List<ConstraintViolation<?>>> groupedByPath = violations.stream().collect(Collectors.groupingBy(violation -> violation.getPropertyPath().toString()));
            List<ValidationResult.Error> errors = this.collectErrors(groupedByPath);
            ValidationResult result = new ValidationResult(this.title, this.statusCode.value(), errors);
            ctx.setResponseCode(this.statusCode).render((Object)result);
        }
    }

    private List<ValidationResult.Error> collectErrors(Map<String, List<ConstraintViolation<?>>> groupedViolations) {
        ArrayList<ValidationResult.Error> errors = new ArrayList<ValidationResult.Error>();
        for (Map.Entry<String, List<ConstraintViolation<?>>> entry : groupedViolations.entrySet()) {
            String path = entry.getKey();
            if (ROOT_VIOLATIONS_PATH.equals(path)) {
                errors.add(new ValidationResult.Error(null, this.extractMessages(entry.getValue()), ValidationResult.ErrorType.GLOBAL));
                continue;
            }
            errors.add(new ValidationResult.Error(path, this.extractMessages(entry.getValue()), ValidationResult.ErrorType.FIELD));
        }
        return errors;
    }

    private List<String> extractMessages(List<ConstraintViolation<?>> violations) {
        return violations.stream().map(ConstraintViolation::getMessage).toList();
    }
}

