/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate.validator;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ErrorHandler;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.StatusCode;
import io.jooby.hibernate.validator.ConstraintViolationHandler;
import io.jooby.validation.BeanValidator;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class HibernateValidatorModule
implements Extension {
    private static final String CONFIG_ROOT_PATH = "hibernate.validator";
    private Consumer<HibernateValidatorConfiguration> configurer;
    private StatusCode statusCode = StatusCode.UNPROCESSABLE_ENTITY;
    private String title = "Validation failed";
    private boolean disableDefaultViolationHandler = false;
    private boolean logException = false;

    public HibernateValidatorModule doWith(@NonNull Consumer<HibernateValidatorConfiguration> configurer) {
        this.configurer = configurer;
        return this;
    }

    public HibernateValidatorModule statusCode(@NonNull StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HibernateValidatorModule logException() {
        this.logException = true;
        return this;
    }

    public HibernateValidatorModule validationTitle(@NonNull String title) {
        this.title = title;
        return this;
    }

    public HibernateValidatorModule disableViolationHandler() {
        this.disableDefaultViolationHandler = true;
        return this;
    }

    public void install(@NonNull Jooby app) throws Exception {
        Config config = app.getConfig();
        HibernateValidatorConfiguration hbvConfig = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
        if (config.hasPath(CONFIG_ROOT_PATH)) {
            config.getConfig(CONFIG_ROOT_PATH).root().forEach((k, v) -> hbvConfig.addProperty("hibernate.validator." + k, v.unwrapped().toString()));
        }
        if (this.configurer != null) {
            this.configurer.accept(hbvConfig);
        }
        try (ValidatorFactory factory = hbvConfig.buildValidatorFactory();){
            Validator validator = factory.getValidator();
            app.getServices().put(Validator.class, (Object)validator);
            app.getServices().put(BeanValidator.class, (Object)new BeanValidatorImpl(validator));
            if (!this.disableDefaultViolationHandler) {
                app.error(ConstraintViolationException.class, (ErrorHandler)new ConstraintViolationHandler(this.statusCode, this.title, this.logException));
            }
        }
    }

    static class BeanValidatorImpl
    implements BeanValidator {
        private final Validator validator;

        BeanValidatorImpl(Validator validator) {
            this.validator = validator;
        }

        public void validate(Context ctx, Object bean) throws ConstraintViolationException {
            Set violations = this.validator.validate(bean, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
    }
}

