/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.Context;
import io.jooby.Router;
import io.jooby.internal.jetty.JettyContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JettyHandler
extends AbstractHandler {
    private final Router router;
    private final boolean defaultHeaders;
    private final int bufferSize;
    private final long maxRequestSize;

    public JettyHandler(Router router, int bufferSize, long maxRequestSize, boolean defaultHeaders) {
        this.router = router;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
        this.defaultHeaders = defaultHeaders;
    }

    public void handle(String target, Request request, HttpServletRequest servletRequest, HttpServletResponse response) {
        request.setHandled(true);
        response.setContentType("text/plain");
        if (this.defaultHeaders) {
            response.setHeader(HttpHeader.SERVER.asString(), "J");
        }
        JettyContext context = new JettyContext(request, this.router, this.bufferSize, this.maxRequestSize);
        this.router.match((Context)context).execute((Context)context);
    }
}

