/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.Context;
import io.jooby.Sender;
import io.jooby.internal.jetty.JettyContext;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.eclipse.jetty.server.HttpOutput;

public class JettySender
implements Sender {
    private final JettyContext ctx;
    private final HttpOutput sender;

    public JettySender(JettyContext ctx, HttpOutput sender) {
        this.ctx = ctx;
        this.sender = sender;
    }

    public Sender write(@Nonnull byte[] data, @Nonnull Sender.Callback callback) {
        try {
            this.sender.write(data);
            this.sender.flush();
            callback.onComplete((Context)this.ctx, null);
        }
        catch (IOException e) {
            callback.onComplete((Context)this.ctx, (Throwable)e);
        }
        return this;
    }

    public void close() {
        this.ctx.complete(null);
    }
}

