/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.Body;
import io.jooby.ByteRange;
import io.jooby.CompletionListeners;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.Multipart;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.RouterOption;
import io.jooby.Sender;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.WebSocketConfigurer;
import io.jooby.internal.jetty.JettyFileUpload;
import io.jooby.internal.jetty.JettyOutputStream;
import io.jooby.internal.jetty.JettySender;
import io.jooby.internal.jetty.JettyServerSentEmitter;
import io.jooby.internal.jetty.JettyWebSocket;
import io.jooby.internal.jetty.LimitedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.slf4j.Logger;

public class JettyContext
implements DefaultContext {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final int bufferSize;
    private final long maxRequestSize;
    Request request;
    Response response;
    private QueryString query;
    private Formdata form;
    private Multipart multipart;
    private List<FileUpload> files;
    private ValueNode headers;
    private Map<String, String> pathMap = Collections.EMPTY_MAP;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Router router;
    private Route route;
    private MediaType responseType;
    private Map<String, String> cookies;
    private HashMap<String, String> responseCookies;
    private boolean responseStarted;
    private Boolean resetHeadersOnError;
    private String method;
    private String requestPath;
    private CompletionListeners listeners;
    private String remoteAddress;
    private String host;
    private String scheme;
    private int port;

    public JettyContext(Request request, Router router, int bufferSize, long maxRequestSize) {
        this.request = request;
        this.response = request.getResponse();
        this.router = router;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
        this.method = request.getMethod().toUpperCase();
        this.requestPath = request.getRequestURI();
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public Map<String, String> cookieMap() {
        if (this.cookies == null) {
            this.cookies = Collections.emptyMap();
            javax.servlet.http.Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                this.cookies = new LinkedHashMap<String, String>(cookies.length);
                for (javax.servlet.http.Cookie it : cookies) {
                    this.cookies.put(it.getName(), it.getValue());
                }
            }
        }
        return this.cookies;
    }

    @Nonnull
    public Body body() {
        try {
            Object in = this.request.getInputStream();
            long len = this.request.getContentLengthLong();
            if (this.maxRequestSize > 0L) {
                in = new LimitedInputStream((InputStream)in, this.maxRequestSize);
            }
            return Body.of((Context)this, (InputStream)in, (long)len);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public Router getRouter() {
        return this.router;
    }

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    @Nonnull
    public Context setMethod(@Nonnull String method) {
        this.method = method.toUpperCase();
        return this;
    }

    @Nonnull
    public Route getRoute() {
        return this.route;
    }

    @Nonnull
    public Context setRoute(Route route) {
        this.route = route;
        return this;
    }

    @Nonnull
    public String getRequestPath() {
        return this.requestPath;
    }

    @Nonnull
    public Context setRequestPath(@Nonnull String path) {
        this.requestPath = path;
        return this;
    }

    @Nonnull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @Nonnull
    public Context setPathMap(Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    @Nonnull
    public QueryString query() {
        if (this.query == null) {
            this.query = QueryString.create((Context)this, (String)this.request.getQueryString());
        }
        return this.query;
    }

    @Nonnull
    public Formdata form() {
        if (this.form == null) {
            this.form = Formdata.create((Context)this);
            JettyContext.formParam(this.request, this.form);
        }
        return this.form;
    }

    @Nonnull
    public Multipart multipart() {
        if (this.multipart == null) {
            this.multipart = Multipart.create((Context)this);
            this.form = this.multipart;
            this.request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(this.router.getTmpdir().toString(), -1L, this.maxRequestSize, this.bufferSize));
            JettyContext.formParam(this.request, (Formdata)this.multipart);
            String contentType = this.request.getContentType();
            if (contentType != null && MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpFields.valueParameters((String)contentType, null))) {
                try {
                    Collection parts = this.request.getParts();
                    for (Part part : parts) {
                        if (part.getSubmittedFileName() == null) continue;
                        String name = part.getName();
                        this.multipart.put(name, this.register(new JettyFileUpload((MultiPartFormInputStream.MultiPart)part)));
                    }
                }
                catch (IOException | ServletException x) {
                    throw SneakyThrows.propagate((Throwable)x);
                }
            }
        }
        return this.multipart;
    }

    @Nonnull
    public ValueNode header() {
        if (this.headers == null) {
            Enumeration names = this.request.getHeaderNames();
            LinkedHashMap headerMap = new LinkedHashMap();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                headerMap.put(name, Collections.list(this.request.getHeaders(name)));
            }
            this.headers = Value.hash((Context)this, headerMap);
        }
        return this.headers;
    }

    @Nonnull
    public String getHost() {
        return this.host == null ? super.getHost() : this.host;
    }

    @Nonnull
    public Context setHost(@Nonnull String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port > 0 ? this.port : super.getPort();
    }

    @Nonnull
    public Context setPort(int port) {
        this.port = port;
        return this;
    }

    @Nonnull
    public String getRemoteAddress() {
        return this.remoteAddress == null ? this.request.getRemoteAddr() : this.remoteAddress;
    }

    @Nonnull
    public Context setRemoteAddress(@Nonnull String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @Nonnull
    public String getProtocol() {
        return this.request.getProtocol();
    }

    @Nonnull
    public String getScheme() {
        if (this.scheme == null) {
            this.scheme = this.request.isSecure() ? "https" : "http";
        }
        return this.scheme;
    }

    @Nonnull
    public Context setScheme(@Nonnull String scheme) {
        this.scheme = scheme;
        return this;
    }

    public boolean isInIoThread() {
        return false;
    }

    @Nonnull
    public Context dispatch(@Nonnull Runnable action) {
        return this.dispatch(this.router.getWorker(), action);
    }

    @Nonnull
    public Context dispatch(@Nonnull Executor executor, @Nonnull Runnable action) {
        if (this.router.getWorker() == executor) {
            action.run();
        } else {
            this.ifStartAsync();
            executor.execute(action);
        }
        return this;
    }

    @Nonnull
    public Context detach(@Nonnull Route.Handler next) throws Exception {
        this.ifStartAsync();
        next.apply((Context)this);
        return this;
    }

    @Nonnull
    public Context upgrade(@Nonnull WebSocket.Initializer handler) {
        try {
            this.responseStarted = true;
            this.request.setAttribute(JettyContext.class.getName(), (Object)this);
            WebSocketServerFactory wssf = (WebSocketServerFactory)this.request.getContext().getAttribute("___ws_s_f_");
            JettyWebSocket ws = new JettyWebSocket(this);
            handler.init(Context.readOnly((Context)this), (WebSocketConfigurer)ws);
            wssf.acceptWebSocket((req, rsp) -> ws, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
            return this;
        }
        catch (Throwable x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public Context upgrade(@Nonnull ServerSentEmitter.Handler handler) {
        try {
            this.responseStarted = true;
            AsyncContext async = this.request.isAsyncStarted() ? this.request.getAsyncContext() : this.request.startAsync();
            async.setTimeout(0L);
            this.response.flushBuffer();
            handler.handle((ServerSentEmitter)new JettyServerSentEmitter(this));
            return this;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public StatusCode getResponseCode() {
        return StatusCode.valueOf((int)this.response.getStatus());
    }

    @Nonnull
    public Context setResponseCode(int statusCode) {
        this.response.setStatus(statusCode);
        return this;
    }

    @Nonnull
    public MediaType getResponseType() {
        return this.responseType == null ? MediaType.text : this.responseType;
    }

    @Nonnull
    public Context setDefaultResponseType(@Nonnull MediaType contentType) {
        if (this.responseType == null) {
            this.setResponseType(contentType, contentType.getCharset());
        }
        return this;
    }

    @Nonnull
    public Context setResponseType(@Nonnull MediaType contentType, @Nullable Charset charset) {
        this.responseType = contentType;
        this.response.setHeader(HttpHeader.CONTENT_TYPE, contentType.toContentTypeHeader(charset));
        return this;
    }

    @Nonnull
    public Context setResponseType(@Nonnull String contentType) {
        this.responseType = MediaType.valueOf((String)contentType);
        this.response.setHeader(HttpHeader.CONTENT_TYPE, contentType);
        return this;
    }

    @Nonnull
    public Context setResponseHeader(@Nonnull String name, @Nonnull String value) {
        this.response.setHeader(name, value);
        return this;
    }

    @Nonnull
    public Context removeResponseHeader(@Nonnull String name) {
        this.response.setHeader(name, null);
        return this;
    }

    @Nonnull
    public Context removeResponseHeaders() {
        this.response.reset();
        return this;
    }

    @Nullable
    public String getResponseHeader(@Nonnull String name) {
        return this.response.getHeader(name);
    }

    @Nonnull
    public Context setResponseLength(long length) {
        this.response.setContentLengthLong(length);
        return this;
    }

    public long getResponseLength() {
        String lenStr;
        long len = this.response.getContentLength();
        if (len == -1L && (lenStr = this.response.getHeader(HttpHeader.CONTENT_LENGTH.asString())) != null) {
            len = Long.parseLong(lenStr);
        }
        return len;
    }

    @Nonnull
    public Context setResponseCookie(@Nonnull Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new HashMap();
        }
        cookie.setPath(cookie.getPath(this.getContextPath()));
        this.responseCookies.put(cookie.getName(), cookie.toCookieString());
        this.response.setHeader(HttpHeader.SET_COOKIE, null);
        for (String cookieString : this.responseCookies.values()) {
            this.response.addHeader(HttpHeader.SET_COOKIE.asString(), cookieString);
        }
        return this;
    }

    @Nonnull
    public Sender responseSender() {
        this.responseStarted = true;
        this.ifSetChunked();
        this.ifStartAsync();
        return new JettySender(this, this.response.getHttpOutput());
    }

    @Nonnull
    public OutputStream responseStream() {
        this.responseStarted = true;
        try {
            this.ifSetChunked();
            return new JettyOutputStream((OutputStream)this.response.getOutputStream(), this);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.setResponseType(type, charset);
        return new PrintWriter(this.responseStream());
    }

    @Nonnull
    public Context send(StatusCode statusCode) {
        this.response.setStatus(statusCode.value());
        this.send(EMPTY_BUFFER);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull ByteBuffer[] data) {
        if (this.response.getContentLength() <= 0L) {
            this.setResponseLength(BufferUtil.remaining((ByteBuffer[])data));
        }
        this.ifStartAsync();
        HttpOutput out = this.response.getHttpOutput();
        out.setWriteListener(JettyContext.writeListener(this.request.getAsyncContext(), out, data));
        this.responseStarted = true;
        return this;
    }

    @Nonnull
    public Context send(@Nonnull byte[] data) {
        return this.send(ByteBuffer.wrap(data));
    }

    @Nonnull
    public Context send(@Nonnull String data, @Nonnull Charset charset) {
        return this.send(ByteBuffer.wrap(data.getBytes(charset)));
    }

    @Nonnull
    public Context send(@Nonnull ByteBuffer data) {
        try {
            if (this.response.getContentLength() == -1L) {
                this.response.setContentLengthLong((long)data.remaining());
            }
            this.responseStarted = true;
            HttpOutput sender = this.response.getHttpOutput();
            sender.sendContent(data);
            JettyContext jettyContext = this;
            return jettyContext;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        finally {
            this.responseDone();
        }
    }

    @Nonnull
    public Context send(@Nonnull ReadableByteChannel channel) {
        this.responseStarted = true;
        this.ifSetChunked();
        return this.sendStreamInternal(Channels.newInputStream(channel));
    }

    @Nonnull
    public Context send(@Nonnull InputStream in) {
        try {
            if (in instanceof FileInputStream) {
                this.response.setLongContentLength(((FileInputStream)in).getChannel().size());
            }
            return this.sendStreamInternal(in);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private Context sendStreamInternal(@Nonnull InputStream in) {
        try {
            InputStream stream;
            long len = this.response.getContentLength();
            if (len > 0L) {
                stream = ByteRange.parse((String)this.request.getHeader(HttpHeader.RANGE.asString()), (long)len).apply((Context)this).apply(in);
            } else {
                this.response.setHeader(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED.asString());
                stream = in;
            }
            this.responseStarted = true;
            this.response.getHttpOutput().sendContent(stream);
            JettyContext jettyContext = this;
            return jettyContext;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        finally {
            this.responseDone();
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public Context send(@Nonnull FileChannel file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isResponseStarted() {
        return this.responseStarted;
    }

    public boolean getResetHeadersOnError() {
        return this.resetHeadersOnError == null ? this.getRouter().getRouterOptions().contains(RouterOption.RESET_HEADERS_ON_ERROR) : this.resetHeadersOnError.booleanValue();
    }

    public Context setResetHeadersOnError(boolean resetHeadersOnError) {
        this.resetHeadersOnError = resetHeadersOnError;
        return this;
    }

    @Nonnull
    public Context onComplete(@Nonnull Route.Complete task) {
        if (this.listeners == null) {
            this.listeners = new CompletionListeners();
        }
        this.listeners.addListener(task);
        return this;
    }

    public String toString() {
        return this.getMethod() + " " + this.getRequestPath();
    }

    void complete(Throwable x) {
        try {
            Logger log = this.router.getLog();
            if (x != null) {
                if (Server.connectionLost((Throwable)x)) {
                    log.debug("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), x});
                } else {
                    log.error("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), x});
                }
            }
        }
        finally {
            this.responseDone();
        }
    }

    private void clearFiles() {
        if (this.files != null) {
            for (FileUpload file : this.files) {
                try {
                    file.destroy();
                }
                catch (Exception e) {
                    this.router.getLog().debug("file upload destroy resulted in exception", (Throwable)e);
                }
            }
            this.files.clear();
            this.files = null;
        }
    }

    void responseDone() {
        try {
            this.ifSaveSession();
            this.clearFiles();
        }
        finally {
            if (this.request.isAsyncStarted()) {
                this.request.getAsyncContext().complete();
            }
            if (this.listeners != null) {
                this.listeners.run((Context)this);
            }
        }
    }

    private void ifSaveSession() {
        Session session = (Session)this.getAttributes().get("session");
        if (session != null && (session.isNew() || session.isModify())) {
            SessionStore store = this.router.getSessionStore();
            store.saveSession((Context)this, session);
        }
    }

    private void ifStartAsync() {
        if (!this.request.isAsyncStarted()) {
            this.request.startAsync();
        }
    }

    private void ifSetChunked() {
        if (this.response.getContentLength() <= 0L) {
            this.response.setHeader(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED.asString());
        }
    }

    private FileUpload register(FileUpload upload) {
        if (this.files == null) {
            this.files = new ArrayList<FileUpload>();
        }
        this.files.add(upload);
        return upload;
    }

    private static void formParam(Request request, Formdata form) {
        Enumeration names = request.getParameterNames();
        MultiMap query = request.getQueryParameters();
        while (names.hasMoreElements()) {
            String[] values;
            String name = (String)names.nextElement();
            if (query != null && query.containsKey((Object)name) || (values = request.getParameterValues(name)) == null) continue;
            for (String value : values) {
                form.put(name, value);
            }
        }
    }

    private static WriteListener writeListener(final AsyncContext async, final HttpOutput out, final ByteBuffer[] data) {
        return new WriteListener(){
            int i = 0;

            public void onWritePossible() throws IOException {
                while (out.isReady()) {
                    if (this.i < data.length) {
                        out.write(data[this.i++]);
                        continue;
                    }
                    async.complete();
                    return;
                }
            }

            public void onError(Throwable x) {
                async.complete();
            }
        };
    }
}

