/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.FileUpload;
import io.jooby.SneakyThrows;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.eclipse.jetty.http.MultiPartFormInputStream;

public class JettyFileUpload
implements FileUpload {
    private final MultiPartFormInputStream.MultiPart upload;

    public JettyFileUpload(MultiPartFormInputStream.MultiPart upload) {
        this.upload = upload;
    }

    @Nonnull
    public String getName() {
        return this.upload.getName();
    }

    public String getFileName() {
        return this.upload.getSubmittedFileName();
    }

    public byte[] bytes() {
        try {
            byte[] bytes = this.upload.getBytes();
            if (bytes == null) {
                return Files.readAllBytes(this.upload.getFile().toPath());
            }
            return bytes;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public InputStream stream() {
        try {
            return this.upload.getInputStream();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public String getContentType() {
        return this.upload.getContentType();
    }

    public Path path() {
        try {
            if (this.upload.getFile() == null) {
                this.upload.write("jetty" + System.currentTimeMillis() + ".tmp");
            }
            return this.upload.getFile().toPath();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public long getFileSize() {
        return this.upload.getSize();
    }

    public void destroy() {
        try {
            this.upload.cleanUp();
            this.upload.delete();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

