/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.Context;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.ServerSentMessage;
import io.jooby.SneakyThrows;
import io.jooby.internal.jetty.JettyContext;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServerSentEmitter
implements ServerSentEmitter {
    private Logger log = LoggerFactory.getLogger(ServerSentEmitter.class);
    private JettyContext jetty;
    private AtomicBoolean open = new AtomicBoolean(true);
    private String id;
    private SneakyThrows.Runnable closeTask;

    public JettyServerSentEmitter(JettyContext jetty) {
        this.jetty = jetty;
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public ServerSentEmitter setId(String id) {
        this.id = id;
        return this;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    @Nonnull
    public Context getContext() {
        return Context.readOnly((Context)this.jetty);
    }

    @Nonnull
    public ServerSentEmitter send(ServerSentMessage data) {
        block4: {
            if (this.isOpen()) {
                HttpOutput output = this.jetty.response.getHttpOutput();
                try {
                    output.write(data.toByteArray((Context)this.jetty));
                    output.flush();
                }
                catch (Throwable x) {
                    if (Server.connectionLost((Throwable)x) || x instanceof EofException) {
                        this.close();
                    }
                    this.log.error("server-sent-event resulted in exception: id {} {}", new Object[]{this.id, this.jetty.getRequestPath(), x});
                    if (!SneakyThrows.isFatal((Throwable)x)) break block4;
                    throw SneakyThrows.propagate((Throwable)x);
                }
            }
        }
        return this;
    }

    public ServerSentEmitter keepAlive(long timeInMillis) {
        if (this.isOpen()) {
            Scheduler scheduler = this.jetty.request.getHttpChannel().getConnector().getScheduler();
            scheduler.schedule((Runnable)new ServerSentEmitter.KeepAlive((ServerSentEmitter)this, timeInMillis), timeInMillis, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public void onClose(SneakyThrows.Runnable task) {
        this.closeTask = task;
    }

    @Nonnull
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            try {
                if (this.closeTask != null) {
                    this.closeTask.run();
                }
            }
            finally {
                try {
                    this.jetty.response.closeOutput();
                }
                catch (IOException x) {
                    this.log.debug("server-sent event close resulted in exception", (Throwable)x);
                }
            }
        }
    }
}

