/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.Context;
import io.jooby.Server;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import io.jooby.WebSocketConfigurer;
import io.jooby.WebSocketMessage;
import io.jooby.internal.jetty.JettyContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;

public class JettyWebSocket
implements WebSocketListener,
WebSocketConfigurer,
WebSocket,
WriteCallback {
    private static final ConcurrentMap<String, List<WebSocket>> all = new ConcurrentHashMap<String, List<WebSocket>>();
    public static final String WEBSOCKET_SERVER_FACTORY = "___ws_s_f_";
    private final JettyContext ctx;
    private final String key;
    private final String path;
    private Session session;
    private WebSocket.OnConnect onConnectCallback;
    private WebSocket.OnMessage onMessageCallback;
    private WebSocket.OnClose onCloseCallback;
    private WebSocket.OnError onErrorCallback;

    public JettyWebSocket(JettyContext ctx) {
        this.ctx = ctx;
        this.path = ctx.getRequestPath();
        this.key = ctx.getRoute().getPattern();
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketText(String message) {
        if (this.onMessageCallback != null) {
            try {
                this.onMessageCallback.onMessage((WebSocket)this, WebSocketMessage.create((Context)this.getContext(), (String)message));
            }
            catch (Throwable x) {
                this.onWebSocketError(x);
            }
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        if (this.onCloseCallback != null) {
            this.handleClose(WebSocketCloseStatus.valueOf((int)statusCode).orElseGet(() -> new WebSocketCloseStatus(statusCode, reason)));
        }
    }

    public void onWebSocketConnect(Session session) {
        try {
            this.session = session;
            JettyWebSocket.addSession(this);
            if (this.onConnectCallback != null) {
                this.onConnectCallback.onConnect((WebSocket)this);
            }
        }
        catch (Throwable x) {
            this.onWebSocketError(x);
        }
    }

    public void onWebSocketError(Throwable x) {
        if (!this.isTimeout(x)) {
            if (Server.connectionLost((Throwable)x) || SneakyThrows.isFatal((Throwable)x)) {
                this.handleClose(WebSocketCloseStatus.SERVER_ERROR);
            }
            if (this.onErrorCallback == null) {
                if (Server.connectionLost((Throwable)x)) {
                    this.ctx.getRouter().getLog().debug("Websocket resulted in exception: {}", (Object)this.path, (Object)x);
                } else {
                    this.ctx.getRouter().getLog().error("Websocket resulted in exception: {}", (Object)this.path, (Object)x);
                }
            } else {
                this.onErrorCallback.onError((WebSocket)this, x);
            }
            if (SneakyThrows.isFatal((Throwable)x)) {
                throw SneakyThrows.propagate((Throwable)x);
            }
        }
    }

    private boolean isTimeout(Throwable x) {
        if (x instanceof CloseException) {
            Throwable cause = x.getCause();
            return cause instanceof TimeoutException;
        }
        return false;
    }

    @Nonnull
    public WebSocketConfigurer onConnect(@Nonnull WebSocket.OnConnect callback) {
        this.onConnectCallback = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onMessage(@Nonnull WebSocket.OnMessage callback) {
        this.onMessageCallback = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onError(@Nonnull WebSocket.OnError callback) {
        this.onErrorCallback = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onClose(@Nonnull WebSocket.OnClose callback) {
        this.onCloseCallback = callback;
        return this;
    }

    @Nonnull
    public Context getContext() {
        return Context.readOnly((Context)this.ctx);
    }

    @Nonnull
    public List<WebSocket> getSessions() {
        List sessions = (List)all.get(this.key);
        if (sessions == null) {
            return Collections.emptyList();
        }
        ArrayList<WebSocket> result = new ArrayList<WebSocket>(sessions);
        result.remove(this);
        return result;
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Nonnull
    public WebSocket send(@Nonnull String message, boolean broadcast) {
        if (broadcast) {
            for (WebSocket ws : all.getOrDefault(this.key, Collections.emptyList())) {
                ws.send(message, false);
            }
        } else if (this.isOpen()) {
            try {
                RemoteEndpoint remote = this.session.getRemote();
                remote.sendString(message, (WriteCallback)this);
            }
            catch (Throwable x) {
                this.onWebSocketError(x);
            }
        } else {
            this.onWebSocketError(new IllegalStateException("Attempt to send a message on closed web socket"));
        }
        return this;
    }

    @Nonnull
    public WebSocket send(@Nonnull byte[] message, boolean broadcast) {
        return this.send(new String(message, StandardCharsets.UTF_8), broadcast);
    }

    @Nonnull
    public WebSocket render(@Nonnull Object value, boolean broadcast) {
        if (broadcast) {
            for (WebSocket ws : all.getOrDefault(this.key, Collections.emptyList())) {
                ws.render(value, false);
            }
        } else {
            try {
                Context.websocket((Context)this.ctx, (WebSocket)this).render(value);
            }
            catch (Throwable x) {
                this.onWebSocketError(x);
            }
        }
        return this;
    }

    @Nonnull
    public WebSocket close(@Nonnull WebSocketCloseStatus closeStatus) {
        this.handleClose(closeStatus);
        return this;
    }

    public void writeFailed(Throwable x) {
        if (Server.connectionLost((Throwable)x)) {
            this.ctx.getRouter().getLog().debug("Websocket resulted in exception: {}", (Object)this.path, (Object)x);
        } else {
            this.ctx.getRouter().getLog().error("Websocket resulted in exception: {}", (Object)this.path, (Object)x);
        }
    }

    public void writeSuccess() {
    }

    private void handleClose(WebSocketCloseStatus closeStatus) {
        try {
            if (this.onCloseCallback != null) {
                this.onCloseCallback.onClose((WebSocket)this, closeStatus);
            }
        }
        catch (Throwable x) {
            this.onWebSocketError(x);
        }
        finally {
            JettyWebSocket.removeSession(this);
        }
    }

    private static void addSession(JettyWebSocket ws) {
        all.computeIfAbsent(ws.key, k -> new CopyOnWriteArrayList()).add(ws);
    }

    private static void removeSession(JettyWebSocket ws) {
        List sockets = (List)all.get(ws.key);
        if (sockets != null) {
            sockets.remove(ws);
        }
    }
}

