/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.jetty;

import com.typesafe.config.Config;
import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.internal.jetty.JettyHandler;
import java.net.BindException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public class Jetty
extends Server.Base {
    private static final int THREADS = 200;
    private org.eclipse.jetty.server.Server server;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private ServerOptions options = new ServerOptions().setServer("jetty").setWorkerThreads(200);

    @Nonnull
    public Jetty setOptions(@Nonnull ServerOptions options) {
        this.options = options.setWorkerThreads(options.getWorkerThreads(200));
        return this;
    }

    @Nonnull
    public ServerOptions getOptions() {
        return this.options;
    }

    @Nonnull
    public Server start(Jooby application) {
        try {
            System.setProperty("org.eclipse.jetty.util.UrlEncoded.charset", "utf-8");
            System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Long.toString(this.options.getMaxRequestSize()));
            this.applications.add(application);
            this.addShutdownHook();
            QueuedThreadPool executor = new QueuedThreadPool(this.options.getWorkerThreads());
            executor.setName("worker");
            this.fireStart(this.applications, (Executor)executor);
            this.server = new org.eclipse.jetty.server.Server((ThreadPool)executor);
            this.server.setStopAtShutdown(false);
            HttpConfiguration httpConf = new HttpConfiguration();
            httpConf.setOutputBufferSize(this.options.getBufferSize());
            httpConf.setOutputAggregationSize(this.options.getBufferSize());
            httpConf.setSendXPoweredBy(false);
            httpConf.setSendDateHeader(this.options.getDefaultHeaders());
            httpConf.setSendServerVersion(false);
            httpConf.setMultiPartFormDataCompliance(MultiPartFormDataCompliance.RFC7578);
            ServerConnector http = new ServerConnector(this.server);
            http.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(httpConf));
            http.setPort(this.options.getPort());
            http.setHost(this.options.getHost());
            this.server.addConnector((Connector)http);
            if (this.options.isSSLEnabled()) {
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setSslContext(this.options.getSSLContext(application.getEnvironment().getClassLoader()));
                List protocol = this.options.getSsl().getProtocol();
                sslContextFactory.setIncludeProtocols(protocol.toArray(new String[protocol.size()]));
                this.isNotInUse(protocol, "TLSv1", xva$0 -> sslContextFactory.addExcludeProtocols(new String[]{xva$0}));
                this.isNotInUse(protocol, "TLSv1.1", xva$0 -> sslContextFactory.addExcludeProtocols(new String[]{xva$0}));
                SslOptions.ClientAuth clientAuth = Optional.ofNullable(this.options.getSsl()).map(SslOptions::getClientAuth).orElse(SslOptions.ClientAuth.NONE);
                if (clientAuth == SslOptions.ClientAuth.REQUESTED) {
                    sslContextFactory.setWantClientAuth(true);
                } else if (clientAuth == SslOptions.ClientAuth.REQUIRED) {
                    sslContextFactory.setNeedClientAuth(true);
                }
                HttpConfiguration httpsConf = new HttpConfiguration(httpConf);
                httpsConf.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ServerConnector https = new ServerConnector(this.server, (SslContextFactory)sslContextFactory);
                https.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(httpsConf));
                https.setPort(this.options.getSecurePort().intValue());
                https.setHost(this.options.getHost());
                this.server.addConnector((Connector)https);
            }
            ContextHandler context = new ContextHandler();
            JettyHandler handler = new JettyHandler((Router)this.applications.get(0), this.options.getBufferSize(), this.options.getMaxRequestSize(), this.options.getDefaultHeaders());
            if (this.options.getCompressionLevel() != null) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setCompressionLevel(this.options.getCompressionLevel().intValue());
                gzipHandler.setHandler((Handler)handler);
                context.setHandler((Handler)gzipHandler);
            } else {
                context.setHandler((Handler)handler);
            }
            context.setAttribute(DecoratedObjectFactory.ATTR, (Object)new DecoratedObjectFactory());
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            policy.setMaxTextMessageBufferSize(131072);
            policy.setMaxTextMessageSize(131072);
            Config conf = application.getConfig();
            long timeout = conf.hasPath("websocket.idleTimeout") ? conf.getDuration("websocket.idleTimeout", TimeUnit.MINUTES) : 5L;
            policy.setIdleTimeout(TimeUnit.MINUTES.toMillis(timeout));
            WebSocketServerFactory wssf = new WebSocketServerFactory((ServletContext)context.getServletContext(), policy);
            context.setAttribute("___ws_s_f_", (Object)wssf);
            context.addManaged((LifeCycle)wssf);
            this.server.setHandler((Handler)context);
            this.server.start();
            this.fireReady(this.applications);
        }
        catch (Exception x2) {
            BindException x2;
            if (Server.isAddressInUse((Throwable)x2.getCause())) {
                x2 = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)x2);
        }
        return this;
    }

    private void isNotInUse(List<String> protocols, String protocol, Consumer<String> consumer) {
        if (!protocols.contains(protocol)) {
            consumer.accept(protocol);
        }
    }

    @Nonnull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception x) {
                throw SneakyThrows.propagate((Throwable)x);
            }
            finally {
                this.server = null;
            }
        }
        return this;
    }

    static {
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
    }
}

