/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.ByteRange;
import io.jooby.CompletionListeners;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.RouterOption;
import io.jooby.Sender;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.WebSocketConfigurer;
import io.jooby.buffer.DataBuffer;
import io.jooby.internal.jetty.JettyCallbacks;
import io.jooby.internal.jetty.JettyFileUpload;
import io.jooby.internal.jetty.JettyOutputStream;
import io.jooby.internal.jetty.JettySender;
import io.jooby.internal.jetty.JettyServerSentEmitter;
import io.jooby.internal.jetty.JettyWebSocket;
import io.jooby.internal.jetty.LimitedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.websocket.server.ServerWebSocketContainer;
import org.slf4j.Logger;

public class JettyContext
implements DefaultContext,
Callback {
    private final int bufferSize;
    private final long maxRequestSize;
    Request request;
    Response response;
    private QueryString query;
    private Formdata formdata;
    private List<FileUpload> files;
    private ValueNode headers;
    private Map<String, String> pathMap = Collections.EMPTY_MAP;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Router router;
    private Route route;
    private MediaType responseType;
    private Map<String, String> cookies;
    private HashMap<String, String> responseCookies;
    private boolean responseStarted;
    private Boolean resetHeadersOnError;
    private String method;
    private String requestPath;
    private CompletionListeners listeners;
    private String remoteAddress;
    private String host;
    private String scheme;
    private int port;
    private Callback callback;
    private boolean inEventLoop;

    public JettyContext(Invocable.InvocationType invocationType, Request request, Response response, Callback callback, Router router, int bufferSize, long maxRequestSize) {
        this.request = request;
        this.response = response;
        this.router = router;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
        this.method = request.getMethod().toUpperCase();
        this.requestPath = request.getHttpURI().getPath();
        this.callback = callback;
        this.inEventLoop = invocationType == Invocable.InvocationType.NON_BLOCKING;
    }

    @NonNull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @NonNull
    public Map<String, String> cookieMap() {
        if (this.cookies == null) {
            this.cookies = Collections.emptyMap();
            List cookies = Request.getCookies((Request)this.request);
            if (cookies != null) {
                this.cookies = new LinkedHashMap<String, String>(cookies.size());
                for (HttpCookie it : cookies) {
                    this.cookies.put(it.getName(), it.getValue());
                }
            }
        }
        return this.cookies;
    }

    @NonNull
    public Body body() {
        InputStream in = Content.Source.asInputStream((Content.Source)this.request);
        long len = this.request.getLength();
        if (this.maxRequestSize > 0L) {
            in = new LimitedInputStream(in, this.maxRequestSize);
        }
        return Body.of((Context)this, (InputStream)in, (long)len);
    }

    @NonNull
    public Router getRouter() {
        return this.router;
    }

    @NonNull
    public String getMethod() {
        return this.method;
    }

    @NonNull
    public Context setMethod(@NonNull String method) {
        this.method = method.toUpperCase();
        return this;
    }

    @NonNull
    public Route getRoute() {
        return this.route;
    }

    @NonNull
    public Context setRoute(Route route) {
        this.route = route;
        return this;
    }

    @NonNull
    public String getRequestPath() {
        return this.requestPath;
    }

    @NonNull
    public Context setRequestPath(@NonNull String path) {
        this.requestPath = path;
        return this;
    }

    @NonNull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @NonNull
    public Context setPathMap(Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    @NonNull
    public QueryString query() {
        if (this.query == null) {
            this.query = QueryString.create((Context)this, (String)this.request.getHttpURI().getQuery());
        }
        return this.query;
    }

    @NonNull
    public Formdata form() {
        if (this.formdata == null) {
            String boundary;
            this.formdata = Formdata.create((Context)this);
            JettyContext.formParam(this.request, this.formdata);
            String contentType = this.request.getHeaders().get(HttpHeader.CONTENT_TYPE);
            if (contentType != null && MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpField.getValueParameters((String)contentType, null)) && (boundary = MultiPart.extractBoundary((String)contentType)) != null) {
                try {
                    MultiPartFormData.Parser parser = new MultiPartFormData.Parser(boundary);
                    parser.setFilesDirectory(this.getRouter().getTmpdir());
                    parser.setMaxMemoryFileSize((long)this.bufferSize);
                    parser.setMaxLength(this.maxRequestSize);
                    MultiPartFormData.Parts parts = (MultiPartFormData.Parts)parser.parse((Content.Source)this.request).get();
                    for (MultiPart.Part part : parts) {
                        if (part.getFileName() != null) {
                            String name = part.getName();
                            this.formdata.put(name, this.register(new JettyFileUpload(this.router.getTmpdir(), part)));
                            continue;
                        }
                        this.formdata.put(part.getName(), Content.Source.asString((Content.Source)part.getContentSource()));
                    }
                }
                catch (Exception x) {
                    throw SneakyThrows.propagate((Throwable)x);
                }
            }
        }
        return this.formdata;
    }

    @NonNull
    public Value header(@NonNull String name) {
        return Value.create((Context)this, (String)name, (List)this.request.getHeaders().getValuesList(name));
    }

    @NonNull
    public ValueNode header() {
        if (this.headers == null) {
            LinkedHashMap<String, List> headerMap = new LinkedHashMap<String, List>();
            for (HttpField header : this.request.getHeaders()) {
                headerMap.put(header.getName(), header.getValueList());
            }
            this.headers = Value.headers((Context)this, headerMap);
        }
        return this.headers;
    }

    @NonNull
    public String getHost() {
        return this.host == null ? super.getHost() : this.host;
    }

    @NonNull
    public Context setHost(@NonNull String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port > 0 ? this.port : super.getPort();
    }

    @NonNull
    public Context setPort(int port) {
        this.port = port;
        return this;
    }

    @NonNull
    public String getRemoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(Request.getRemoteAddr((Request)this.request)).orElse("").trim();
        }
        return this.remoteAddress;
    }

    @NonNull
    public Context setRemoteAddress(@NonNull String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @NonNull
    public String getProtocol() {
        return this.request.getConnectionMetaData().getProtocol();
    }

    @NonNull
    public List<Certificate> getClientCertificates() {
        Object clientCertificates = this.request.getAttribute("org.eclipse.jetty.server.peerCertificates");
        return clientCertificates == null ? List.of() : List.of((Certificate[])clientCertificates);
    }

    @NonNull
    public String getScheme() {
        if (this.scheme == null) {
            this.scheme = this.request.isSecure() ? "https" : "http";
        }
        return this.scheme;
    }

    @NonNull
    public Context setScheme(@NonNull String scheme) {
        this.scheme = scheme;
        return this;
    }

    public boolean isInIoThread() {
        return this.inEventLoop;
    }

    @NonNull
    public Context dispatch(@NonNull Runnable action) {
        return this.dispatch(this.router.getWorker(), action);
    }

    @NonNull
    public Context dispatch(@NonNull Executor executor, @NonNull Runnable action) {
        if (this.inEventLoop) {
            this.inEventLoop = false;
            executor.execute(action);
        } else {
            action.run();
        }
        return this;
    }

    @NonNull
    public Context detach(@NonNull Route.Handler next) throws Exception {
        next.apply((Context)this);
        return this;
    }

    @NonNull
    public Context upgrade(@NonNull WebSocket.Initializer handler) {
        try {
            this.responseStarted = true;
            this.request.setAttribute(JettyContext.class.getName(), (Object)this);
            ServerWebSocketContainer container = ServerWebSocketContainer.get((org.eclipse.jetty.server.Context)this.request.getContext());
            JettyWebSocket ws = new JettyWebSocket(this);
            handler.init(Context.readOnly((Context)this), (WebSocketConfigurer)ws);
            container.upgrade((rq, rs, cb) -> ws, this.request, this.response, this.callback);
            return this;
        }
        catch (Throwable x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @NonNull
    public Context upgrade(@NonNull ServerSentEmitter.Handler handler) {
        try {
            this.responseStarted = true;
            handler.handle((ServerSentEmitter)new JettyServerSentEmitter(this, this.response));
            return this;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @NonNull
    public StatusCode getResponseCode() {
        return StatusCode.valueOf((int)this.response.getStatus());
    }

    @NonNull
    public Context setResponseCode(int statusCode) {
        this.response.setStatus(statusCode);
        return this;
    }

    @NonNull
    public MediaType getResponseType() {
        return this.responseType == null ? MediaType.text : this.responseType;
    }

    @NonNull
    public Context setDefaultResponseType(@NonNull MediaType contentType) {
        if (this.responseType == null) {
            this.setResponseType(contentType, contentType.getCharset());
        }
        return this;
    }

    @NonNull
    public Context setResponseType(@NonNull MediaType contentType, @Nullable Charset charset) {
        this.responseType = contentType;
        this.response.getHeaders().put(HttpHeader.CONTENT_TYPE, contentType.toContentTypeHeader(charset));
        return this;
    }

    @NonNull
    public Context setResponseType(@NonNull String contentType) {
        this.responseType = MediaType.valueOf((String)contentType);
        this.response.getHeaders().put(HttpHeader.CONTENT_TYPE, contentType);
        return this;
    }

    @NonNull
    public Context setResponseHeader(@NonNull String name, @NonNull String value) {
        this.response.getHeaders().put(name, value);
        return this;
    }

    @NonNull
    public Context removeResponseHeader(@NonNull String name) {
        this.response.getHeaders().remove(name);
        return this;
    }

    @NonNull
    public Context removeResponseHeaders() {
        this.response.reset();
        return this;
    }

    @Nullable
    public String getResponseHeader(@NonNull String name) {
        return this.response.getHeaders().get(name);
    }

    @NonNull
    public Context setResponseLength(long length) {
        this.response.getHeaders().put(HttpHeader.CONTENT_LENGTH, length);
        return this;
    }

    public long getResponseLength() {
        return this.response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
    }

    @NonNull
    public Context setResponseCookie(@NonNull Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new HashMap();
        }
        cookie.setPath(cookie.getPath(this.getContextPath()));
        this.responseCookies.put(cookie.getName(), cookie.toCookieString());
        this.response.getHeaders().remove(HttpHeader.SET_COOKIE);
        for (String cookieString : this.responseCookies.values()) {
            this.response.getHeaders().add(HttpHeader.SET_COOKIE.asString(), cookieString);
        }
        return this;
    }

    @NonNull
    public Sender responseSender() {
        this.responseStarted = true;
        this.ifSetChunked();
        return new JettySender(this, this.response);
    }

    @NonNull
    public OutputStream responseStream() {
        this.responseStarted = true;
        this.ifSetChunked();
        return new JettyOutputStream(Content.Sink.asOutputStream((Content.Sink)this.response), this);
    }

    @NonNull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.setResponseType(type, charset);
        return new PrintWriter(this.responseStream());
    }

    @NonNull
    public Context send(StatusCode statusCode) {
        this.responseStarted = true;
        this.response.setStatus(statusCode.value());
        this.response.write(true, null, (Callback)this);
        return this;
    }

    @NonNull
    public Context send(@NonNull ByteBuffer[] data) {
        long length = this.response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
        if (length <= 0L) {
            this.setResponseLength(BufferUtil.remaining((ByteBuffer[])data));
        }
        this.responseStarted = true;
        JettyCallbacks.fromByteBufferArray(this.response, this, data).send();
        return this;
    }

    @NonNull
    public Context send(@NonNull byte[] data) {
        return this.send(ByteBuffer.wrap(data));
    }

    @NonNull
    public Context send(@NonNull String data, @NonNull Charset charset) {
        return this.send(ByteBuffer.wrap(data.getBytes(charset)));
    }

    @NonNull
    public Context send(@NonNull DataBuffer data) {
        long length = this.response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
        if (length <= 0L) {
            this.setResponseLength(data.readableByteCount());
        }
        this.responseStarted = true;
        JettyCallbacks.fromDataBuffer(this.response, this, data).send(true);
        return this;
    }

    @NonNull
    public Context send(@NonNull ByteBuffer data) {
        long length = this.response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
        if (length <= 0L) {
            this.setResponseLength(BufferUtil.remaining((ByteBuffer[])new ByteBuffer[]{data}));
        }
        this.responseStarted = true;
        this.response.write(true, data, (Callback)this);
        return this;
    }

    @NonNull
    public Context send(@NonNull ReadableByteChannel channel) {
        this.ifSetChunked();
        return this.sendStreamInternal(Channels.newInputStream(channel));
    }

    @NonNull
    public Context send(@NonNull InputStream in) {
        try {
            if (in instanceof FileInputStream) {
                this.setResponseLength(((FileInputStream)in).getChannel().size());
            }
            return this.sendStreamInternal(in);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private Context sendStreamInternal(@NonNull InputStream in) {
        try {
            InputStream stream;
            long len = this.response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
            if (len > 0L) {
                stream = ByteRange.parse((String)this.request.getHeaders().get(HttpHeader.RANGE), (long)len).apply((Context)this).apply(in);
            } else {
                this.response.getHeaders().put(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED.asString());
                stream = in;
            }
            this.responseStarted = true;
            Content.copy((Content.Source)new InputStreamContentSource(stream), (Content.Sink)this.response, (Callback)this);
            return this;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @NonNull
    public Context send(@NonNull FileChannel file) {
        try {
            this.response.getHeaders().put(HttpHeader.CONTENT_LENGTH, file.size());
            return this.sendStreamInternal(Channels.newInputStream(file));
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public boolean isResponseStarted() {
        return this.responseStarted || this.response.isCommitted();
    }

    public boolean getResetHeadersOnError() {
        return this.resetHeadersOnError == null ? this.getRouter().getRouterOptions().contains(RouterOption.RESET_HEADERS_ON_ERROR) : this.resetHeadersOnError.booleanValue();
    }

    @NonNull
    public Context setResetHeadersOnError(boolean resetHeadersOnError) {
        this.resetHeadersOnError = resetHeadersOnError;
        return this;
    }

    @NonNull
    public Context onComplete(@NonNull Route.Complete task) {
        if (this.listeners == null) {
            this.listeners = new CompletionListeners();
        }
        this.listeners.addListener(task);
        return this;
    }

    public String toString() {
        return this.getMethod() + " " + this.getRequestPath();
    }

    private void clearFiles() {
        if (this.files != null) {
            for (FileUpload file : this.files) {
                try {
                    file.close();
                }
                catch (Exception e) {
                    this.router.getLog().debug("file upload destroy resulted in exception", (Throwable)e);
                }
            }
            this.files.clear();
            this.files = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void failed(Throwable x) {
        block15: {
            try {
                if (this.isResponseStarted()) break block15;
                this.sendError(x);
            }
            catch (Throwable throwable) {
                try {
                    this.responseDone();
                    throw throwable;
                }
                catch (Throwable ignored) {
                    Logger log = this.router.getLog();
                    if (x == null) throw throwable;
                    if (Server.connectionLost((Throwable)x)) {
                        log.debug("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), x});
                        throw throwable;
                    } else {
                        log.error("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), x});
                    }
                    throw throwable;
                }
                finally {
                    this.callback.failed(x);
                }
            }
        }
        try {
            this.responseDone();
            return;
        }
        catch (Throwable ignored) {
            Logger log = this.router.getLog();
            if (x == null) return;
            if (Server.connectionLost((Throwable)x)) {
                log.debug("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), x});
                return;
            }
            log.error("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), x});
            return;
        }
        finally {
            this.callback.failed(x);
        }
    }

    public void succeeded() {
        try {
            this.responseDone();
        }
        finally {
            this.callback.succeeded();
        }
    }

    void responseDone() {
        try {
            this.ifSaveSession();
            this.clearFiles();
        }
        finally {
            if (this.listeners != null) {
                this.listeners.run((Context)this);
            }
        }
    }

    private void ifSaveSession() {
        Session session = (Session)this.getAttributes().get("session");
        if (session != null && (session.isNew() || session.isModify())) {
            SessionStore store = this.router.getSessionStore();
            store.saveSession((Context)this, session);
        }
    }

    private void ifSetChunked() {
        long len = this.response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
        if (len <= 0L) {
            this.response.getHeaders().put(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED);
        }
    }

    private FileUpload register(FileUpload upload) {
        if (this.files == null) {
            this.files = new ArrayList<FileUpload>();
        }
        this.files.add(upload);
        return upload;
    }

    private static void formParam(Request request, Formdata form) {
        try {
            Fields params = Request.getParameters((Request)request);
            for (Fields.Field param : params) {
                String name = param.getName();
                List values = param.getValues();
                if (values == null) continue;
                for (String value : values) {
                    form.put(name, value);
                }
            }
        }
        catch (Exception ex) {
            throw SneakyThrows.propagate((Throwable)ex);
        }
    }
}

