/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.FileUpload;
import io.jooby.SneakyThrows;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.io.Content;

public class JettyFileUpload
implements FileUpload {
    private final MultiPart.Part upload;
    private final Path tmpdir;

    public JettyFileUpload(Path tmpdir, MultiPart.Part upload) {
        this.tmpdir = tmpdir;
        this.upload = upload;
    }

    @NonNull
    public String getName() {
        return this.upload.getName();
    }

    @NonNull
    public String getFileName() {
        return this.upload.getFileName();
    }

    @NonNull
    public byte[] bytes() {
        byte[] byArray;
        block8: {
            InputStream in = this.stream();
            try {
                byArray = in.readAllBytes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException x) {
                    throw SneakyThrows.propagate((Throwable)x);
                }
            }
            in.close();
        }
        return byArray;
    }

    @NonNull
    public InputStream stream() {
        try {
            return Content.Source.asInputStream((Content.Source)this.upload.getContentSource());
        }
        catch (Exception c) {
            return null;
        }
    }

    public String getContentType() {
        return this.upload.getHeaders().get(HttpHeader.CONTENT_TYPE);
    }

    @NonNull
    public Path path() {
        try {
            MultiPart.Part part = this.upload;
            if (part instanceof MultiPart.PathPart) {
                MultiPart.PathPart pathPart = (MultiPart.PathPart)part;
                return pathPart.getPath();
            }
            Path path = this.tmpdir.resolve("jetty" + System.currentTimeMillis() + ".tmp");
            this.upload.writeTo(path);
            return path;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public long getFileSize() {
        return this.upload.getLength();
    }

    public void close() {
        this.upload.close();
    }

    public String toString() {
        return this.getFileName();
    }
}

