/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.SneakyThrows;
import io.jooby.internal.jetty.JettyContext;
import java.io.OutputStream;

public class JettyOutputStream
extends OutputStream {
    private JettyContext jetty;
    private OutputStream out;

    public JettyOutputStream(OutputStream out, JettyContext jetty) {
        this.out = out;
        this.jetty = jetty;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.block(() -> this.out.write(b, off, len), false);
    }

    @Override
    public void write(byte[] b) {
        this.block(() -> this.out.write(b), false);
    }

    @Override
    public void write(int b) {
        this.block(() -> this.out.write(b), false);
    }

    @Override
    public void flush() {
        this.block(this.out::flush, false);
    }

    @Override
    public void close() {
        this.block(this.out::close, true);
    }

    private void block(SneakyThrows.Runnable task, boolean complete) {
        try {
            task.run();
            if (complete) {
                this.jetty.succeeded();
            }
        }
        catch (Throwable cause) {
            this.jetty.failed(cause);
        }
    }
}

