/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.ServerSentMessage;
import io.jooby.SneakyThrows;
import io.jooby.internal.jetty.JettyCallbacks;
import io.jooby.internal.jetty.JettyContext;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;

public class JettyServerSentEmitter
implements ServerSentEmitter,
Callback {
    private JettyContext jetty;
    private Response response;
    private AtomicBoolean open = new AtomicBoolean(true);
    private String id;
    private SneakyThrows.Runnable closeTask;

    public JettyServerSentEmitter(JettyContext jetty, Response response) {
        this.jetty = jetty;
        this.response = response;
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public ServerSentEmitter setId(String id) {
        this.id = id;
        return this;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    @NonNull
    public Context getContext() {
        return Context.readOnly((Context)this.jetty);
    }

    @NonNull
    public ServerSentEmitter send(@NonNull ServerSentMessage data) {
        if (this.isOpen()) {
            JettyCallbacks.fromDataBuffer(this.response, this, data.encode((Context)this.jetty)).send(false);
        }
        return this;
    }

    public void failed(Throwable failure) {
        if (Server.connectionLost((Throwable)failure) || failure instanceof EofException) {
            this.close();
        } else {
            this.jetty.failed(failure);
        }
    }

    public ServerSentEmitter keepAlive(long timeInMillis) {
        if (this.isOpen()) {
            Scheduler scheduler = this.jetty.request.getConnectionMetaData().getConnector().getScheduler();
            scheduler.schedule((Runnable)new ServerSentEmitter.KeepAlive((ServerSentEmitter)this, timeInMillis), timeInMillis, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public void onClose(SneakyThrows.Runnable task) {
        this.closeTask = task;
    }

    public void close() {
        if (this.open.compareAndSet(true, false)) {
            try {
                if (this.closeTask != null) {
                    this.closeTask.run();
                }
            }
            finally {
                this.response.write(true, null, (Callback)this.jetty);
            }
        }
    }
}

