/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Server;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import io.jooby.WebSocketConfigurer;
import io.jooby.WebSocketMessage;
import io.jooby.buffer.DataBuffer;
import io.jooby.internal.jetty.JettyContext;
import io.jooby.internal.jetty.WebSocketDataBufferCallback;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StaticException;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.exceptions.CloseException;

public class JettyWebSocket
implements Session.Listener,
WebSocketConfigurer,
WebSocket {
    private static final ConcurrentMap<String, List<JettyWebSocket>> all = new ConcurrentHashMap<String, List<JettyWebSocket>>();
    private final JettyContext ctx;
    private final String key;
    private final String path;
    private Session session;
    private WebSocket.OnConnect onConnectCallback;
    private WebSocket.OnMessage onMessageCallback;
    private AtomicReference<WebSocket.OnClose> onCloseCallback = new AtomicReference();
    private WebSocket.OnError onErrorCallback;
    private AtomicBoolean open = new AtomicBoolean(false);

    public JettyWebSocket(JettyContext ctx) {
        this.ctx = ctx;
        this.path = ctx.getRequestPath();
        this.key = ctx.getRoute().getPattern();
    }

    public void onWebSocketBinary(ByteBuffer payload, Callback callback) {
        if (this.onMessageCallback != null) {
            try {
                this.onMessageCallback.onMessage((WebSocket)this, WebSocketMessage.create((Context)this.getContext(), (byte[])BufferUtil.toArray((ByteBuffer)payload)));
            }
            catch (Throwable x) {
                this.onWebSocketError(x);
            }
        }
    }

    public void onWebSocketText(String message) {
        if (this.onMessageCallback != null) {
            try {
                this.onMessageCallback.onMessage((WebSocket)this, WebSocketMessage.create((Context)this.getContext(), (String)message));
            }
            catch (Throwable x) {
                this.onWebSocketError(x);
            }
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.handleClose(WebSocketCloseStatus.valueOf((int)statusCode).orElseGet(() -> new WebSocketCloseStatus(statusCode, reason)));
    }

    public void onWebSocketOpen(Session session) {
        try {
            this.open.set(true);
            this.session = session;
            JettyWebSocket.addSession(this);
            this.demand();
            if (this.onConnectCallback != null) {
                this.onConnectCallback.onConnect((WebSocket)this);
            }
        }
        catch (Throwable x) {
            this.onWebSocketError(x);
        }
        finally {
            this.demand();
        }
    }

    public void onWebSocketError(Throwable x) {
        if (!this.isTimeout(x)) {
            if (this.isOpen() && (this.connectionLost(x) || SneakyThrows.isFatal((Throwable)x))) {
                this.handleClose(WebSocketCloseStatus.SERVER_ERROR);
            }
            if (this.onErrorCallback == null) {
                if (this.connectionLost(x)) {
                    this.ctx.getRouter().getLog().debug("Websocket resulted in exception: {}", (Object)this.path, (Object)x);
                } else {
                    this.ctx.getRouter().getLog().error("Websocket resulted in exception: {}", (Object)this.path, (Object)x);
                }
            } else if (!this.connectionLost(x)) {
                this.onErrorCallback.onError((WebSocket)this, x);
            }
            if (SneakyThrows.isFatal((Throwable)x)) {
                throw SneakyThrows.propagate((Throwable)x);
            }
        }
    }

    private boolean connectionLost(Throwable x) {
        return Server.connectionLost((Throwable)x) || x instanceof StaticException && x.getMessage().equals("Closed");
    }

    private boolean isTimeout(Throwable x) {
        if (x instanceof CloseException) {
            Throwable cause = x.getCause();
            return cause instanceof TimeoutException;
        }
        return false;
    }

    @NonNull
    public WebSocketConfigurer onConnect(@NonNull WebSocket.OnConnect callback) {
        this.onConnectCallback = callback;
        return this;
    }

    @NonNull
    public WebSocketConfigurer onMessage(@NonNull WebSocket.OnMessage callback) {
        this.onMessageCallback = callback;
        return this;
    }

    @NonNull
    public WebSocketConfigurer onError(@NonNull WebSocket.OnError callback) {
        this.onErrorCallback = callback;
        return this;
    }

    @NonNull
    public WebSocketConfigurer onClose(@NonNull WebSocket.OnClose callback) {
        this.onCloseCallback.set(callback);
        return this;
    }

    @NonNull
    public Context getContext() {
        return Context.readOnly((Context)this.ctx);
    }

    private void demand() {
        try {
            this.session.demand();
        }
        catch (ReadPendingException cause) {
            this.ctx.getRouter().getLog().debug("Websocket resulted in exception: {}", (Object)this.path, (Object)cause);
        }
    }

    @NonNull
    public List<WebSocket> getSessions() {
        List sessions = (List)all.get(this.key);
        if (sessions == null) {
            return Collections.emptyList();
        }
        ArrayList<WebSocket> result = new ArrayList<WebSocket>(sessions);
        result.remove(this);
        return result;
    }

    public boolean isOpen() {
        return this.open.get() && this.session.isOpen();
    }

    public void forEach(SneakyThrows.Consumer<WebSocket> callback) {
        for (JettyWebSocket ws : all.getOrDefault(this.key, Collections.emptyList())) {
            try {
                callback.accept((Object)ws);
            }
            catch (Exception cause) {
                this.ctx.getRouter().getLog().debug("Broadcast of: {} resulted in exception", (Object)ws.path, (Object)cause);
            }
        }
    }

    @NonNull
    public WebSocket sendBinary(@NonNull String message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage((remote, writeCallback) -> remote.sendBinary(ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8)), writeCallback), new WriteCallbackAdaptor(this, callback));
    }

    @NonNull
    public WebSocket send(@NonNull String message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage((remote, writeCallback) -> remote.sendText(message, writeCallback), new WriteCallbackAdaptor(this, callback));
    }

    @NonNull
    public WebSocket send(@NonNull ByteBuffer message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage((remote, writeCallback) -> remote.sendText(StandardCharsets.UTF_8.decode(message).toString(), writeCallback), new WriteCallbackAdaptor(this, callback));
    }

    @NonNull
    public WebSocket send(@NonNull byte[] message, @NonNull WebSocket.WriteCallback callback) {
        return this.send(new String(message, StandardCharsets.UTF_8), callback);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull ByteBuffer message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage((remote, writeCallback) -> remote.sendBinary(message, writeCallback), new WriteCallbackAdaptor(this, callback));
    }

    @NonNull
    public WebSocket send(@NonNull DataBuffer message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage((remote, writeCallback) -> remote.sendText(message.toString(StandardCharsets.UTF_8), writeCallback), new WriteCallbackAdaptor(this, callback));
    }

    @NonNull
    public WebSocket sendBinary(@NonNull DataBuffer message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage((remote, writeCallback) -> new WebSocketDataBufferCallback((Callback)writeCallback, message, (SneakyThrows.Consumer2<ByteBuffer, Callback>)((SneakyThrows.Consumer2)(arg_0, arg_1) -> ((Session)remote).sendBinary(arg_0, arg_1))).send(), new WriteCallbackAdaptor(this, callback));
    }

    private WebSocket sendMessage(BiConsumer<Session, Callback> writer, Callback callback) {
        if (this.isOpen()) {
            try {
                writer.accept(this.session, callback);
            }
            catch (Throwable x) {
                this.onWebSocketError(x);
            }
        } else {
            this.onWebSocketError(new IllegalStateException("Attempt to send a message on closed web socket"));
        }
        return this;
    }

    @NonNull
    public WebSocket render(@NonNull Object value, @NonNull WebSocket.WriteCallback callback) {
        return this.renderMessage(value, false, callback);
    }

    @NonNull
    public WebSocket renderBinary(@NonNull Object value, @NonNull WebSocket.WriteCallback callback) {
        return this.renderMessage(value, true, callback);
    }

    private WebSocket renderMessage(Object value, boolean binary, WebSocket.WriteCallback callback) {
        try {
            Context.websocket((Context)this.ctx, (WebSocket)this, (boolean)binary, (WebSocket.WriteCallback)callback).render(value);
        }
        catch (Throwable x) {
            this.onWebSocketError(x);
        }
        return this;
    }

    @NonNull
    public WebSocket close(@NonNull WebSocketCloseStatus closeStatus) {
        this.handleClose(closeStatus);
        return this;
    }

    private void handleClose(WebSocketCloseStatus closeStatus) {
        WebSocket.OnClose callback = this.onCloseCallback.getAndSet(null);
        Throwable cause = null;
        try {
            if (this.isOpen()) {
                this.open.set(false);
                this.session.close(closeStatus.getCode(), closeStatus.getReason(), Callback.NOOP);
            }
        }
        catch (Throwable x) {
            cause = x;
        }
        if (callback != null) {
            try {
                callback.onClose((WebSocket)this, closeStatus);
            }
            catch (Throwable x) {
                if (cause != null) {
                    x.addSuppressed(cause);
                }
                cause = x;
            }
        }
        JettyWebSocket.removeSession(this);
        if (cause != null) {
            this.onWebSocketError(cause);
        }
    }

    private static void addSession(JettyWebSocket ws) {
        all.computeIfAbsent(ws.key, k -> new CopyOnWriteArrayList()).add(ws);
    }

    private static void removeSession(JettyWebSocket ws) {
        List sockets = (List)all.get(ws.key);
        if (sockets != null) {
            sockets.remove(ws);
        }
    }

    private static class WriteCallbackAdaptor
    implements Callback {
        private JettyWebSocket ws;
        private WebSocket.WriteCallback callback;

        public WriteCallbackAdaptor(JettyWebSocket ws, WebSocket.WriteCallback callback) {
            this.ws = ws;
            this.callback = callback;
        }

        public void fail(Throwable cause) {
            try {
                if (Server.connectionLost((Throwable)cause)) {
                    this.ws.ctx.getRouter().getLog().debug("WebSocket {} send method resulted in exception", (Object)this.ws.getContext().getRequestPath(), (Object)cause);
                } else {
                    this.ws.ctx.getRouter().getLog().error("WebSocket {} send method resulted in exception", (Object)this.ws.getContext().getRequestPath(), (Object)cause);
                }
            }
            finally {
                this.callback.operationComplete((WebSocket)this.ws, cause);
            }
        }

        public void succeed() {
            try {
                this.callback.operationComplete((WebSocket)this.ws, null);
            }
            finally {
                this.ws.demand();
            }
        }
    }
}

