/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.buffer.DataBuffer;
import java.nio.ByteBuffer;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class JettyCallbacks {
    public static DataBufferCallback fromDataBuffer(Response response, Callback cb, DataBuffer buffer) {
        return new DataBufferCallback(response, cb, buffer);
    }

    public static ByteBufferArrayCallback fromByteBufferArray(Response response, Callback cb, ByteBuffer[] buffer) {
        return new ByteBufferArrayCallback(response, cb, buffer);
    }

    public static class DataBufferCallback
    implements Callback {
        private final Response response;
        private final Callback cb;
        private final DataBuffer.ByteBufferIterator it;
        private boolean closeOnLast;

        public DataBufferCallback(Response response, Callback cb, DataBuffer buffer) {
            this.response = response;
            this.cb = cb;
            this.it = buffer.readableByteBuffers();
        }

        public void send(boolean closeOnLast) {
            this.closeOnLast = closeOnLast;
            if (this.it.hasNext()) {
                ByteBuffer buffer = (ByteBuffer)this.it.next();
                if (this.it.hasNext()) {
                    this.response.write(false, buffer, (Callback)this);
                } else {
                    this.sendLast(closeOnLast, buffer);
                }
            } else {
                this.sendLast(closeOnLast, null);
            }
        }

        private void sendLast(boolean last, ByteBuffer buffer) {
            try {
                this.response.write(last, buffer, this.cb);
            }
            finally {
                this.it.close();
            }
        }

        public void succeeded() {
            this.send(this.closeOnLast);
        }

        public void failed(Throwable x) {
            try {
                this.cb.failed(x);
            }
            finally {
                this.it.close();
            }
        }
    }

    public static class ByteBufferArrayCallback
    implements Callback {
        private Response response;
        private Callback callback;
        private int index;
        private ByteBuffer[] buffers;

        public ByteBufferArrayCallback(Response response, Callback callback, ByteBuffer[] buffers) {
            this.response = response;
            this.callback = callback;
            this.buffers = buffers;
        }

        public void send() {
            if (this.index == this.buffers.length - 1) {
                this.response.write(true, this.buffers[this.index], this.callback);
            } else {
                this.response.write(false, this.buffers[this.index++], (Callback)this);
            }
        }

        public void succeeded() {
            this.send();
        }

        public void failed(Throwable x) {
            this.callback.failed(x);
        }
    }
}

