/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.Context;
import io.jooby.Router;
import io.jooby.internal.jetty.JettyContext;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;

public class JettyHandler
extends Handler.Abstract {
    private final Router router;
    private final boolean defaultHeaders;
    private final int bufferSize;
    private final long maxRequestSize;

    public JettyHandler(Invocable.InvocationType invocationType, Router router, int bufferSize, long maxRequestSize, boolean defaultHeaders) {
        super(invocationType);
        this.router = router;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
        this.defaultHeaders = defaultHeaders;
    }

    public boolean handle(Request request, Response response, Callback callback) {
        HttpFields.Mutable responseHeaders = response.getHeaders();
        responseHeaders.put(HttpHeader.CONTENT_TYPE, "text/plain");
        if (this.defaultHeaders) {
            responseHeaders.put(HttpHeader.SERVER.asString(), "J");
        }
        JettyContext context = new JettyContext(this.getInvocationType(), request, response, callback, this.router, this.bufferSize, this.maxRequestSize);
        this.router.match((Context)context).execute((Context)context);
        return true;
    }
}

