/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Sender;
import io.jooby.buffer.DataBuffer;
import io.jooby.internal.jetty.JettyCallbacks;
import io.jooby.internal.jetty.JettyContext;
import java.nio.ByteBuffer;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class JettySender
implements Sender {
    private final JettyContext ctx;
    private final Response response;

    public JettySender(JettyContext ctx, Response response) {
        this.ctx = ctx;
        this.response = response;
    }

    public Sender write(@NonNull byte[] data, @NonNull Sender.Callback callback) {
        this.response.write(false, ByteBuffer.wrap(data), JettySender.toJettyCallback(this.ctx, callback));
        return this;
    }

    @NonNull
    public Sender write(@NonNull DataBuffer data, @NonNull Sender.Callback callback) {
        JettyCallbacks.fromDataBuffer(this.response, JettySender.toJettyCallback(this.ctx, callback), data).send(false);
        return this;
    }

    private static Callback toJettyCallback(final JettyContext ctx, final Sender.Callback callback) {
        return new Callback(){

            public void succeeded() {
                callback.onComplete((Context)ctx, null);
            }

            public void failed(Throwable x) {
                callback.onComplete((Context)ctx, x);
            }
        };
    }

    public void close() {
        this.response.write(false, null, (Callback)this.ctx);
    }
}

