/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.jetty;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.ExecutionMode;
import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.internal.jetty.JettyHandler;
import io.jooby.internal.jetty.JettyHttpExpectAndContinueHandler;
import io.jooby.internal.jetty.http2.JettyHttp2Configurer;
import java.net.BindException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeHandler;

public class JettyServer
extends Server.Base {
    private static final int THREADS = 200;
    private org.eclipse.jetty.server.Server server;
    private ThreadPool threadPool;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private ServerOptions options = new ServerOptions().setServer("jetty").setWorkerThreads(200);
    private Consumer<HttpConfiguration> httpConfigurer;
    private DataBufferFactory bufferFactory;

    public JettyServer(@NonNull DataBufferFactory bufferFactory, @NonNull ThreadPool threadPool) {
        this.bufferFactory = bufferFactory;
        this.threadPool = threadPool;
    }

    public JettyServer() {
    }

    @NonNull
    public JettyServer setOptions(@NonNull ServerOptions options) {
        this.options = options.setWorkerThreads(options.getWorkerThreads(200));
        return this;
    }

    @NonNull
    public ServerOptions getOptions() {
        return this.options;
    }

    @NonNull
    public String getName() {
        return "jetty";
    }

    public JettyServer configure(Consumer<HttpConfiguration> configurer) {
        this.httpConfigurer = configurer;
        return this;
    }

    @NonNull
    public Server start(@NonNull Jooby application) {
        try {
            boolean compress;
            System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Long.toString(this.options.getMaxRequestSize()));
            this.applications.add(application);
            this.addShutdownHook();
            if (this.threadPool == null) {
                this.threadPool = new QueuedThreadPool(this.options.getWorkerThreads());
                ((QueuedThreadPool)this.threadPool).setName("worker");
            }
            this.fireStart(this.applications, (Executor)this.threadPool);
            int acceptors = 1;
            int selectors = this.options.getIoThreads();
            this.server = new org.eclipse.jetty.server.Server(this.threadPool);
            this.server.setStopAtShutdown(false);
            JettyHttp2Configurer http2 = this.options.isHttp2() == Boolean.TRUE ? new JettyHttp2Configurer() : null;
            HttpConfiguration httpConf = new HttpConfiguration();
            httpConf.setUriCompliance(UriCompliance.LEGACY);
            httpConf.setOutputBufferSize(this.options.getBufferSize());
            httpConf.setOutputAggregationSize(this.options.getBufferSize());
            httpConf.setSendXPoweredBy(false);
            httpConf.setSendDateHeader(this.options.getDefaultHeaders());
            httpConf.setSendServerVersion(false);
            if (this.httpConfigurer != null) {
                this.httpConfigurer.accept(httpConf);
            }
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            connectionFactories.add(new HttpConnectionFactory(httpConf));
            if (http2 != null) {
                connectionFactories.addAll(http2.configure(httpConf));
            }
            if (!this.options.isHttpsOnly()) {
                ServerConnector http = new ServerConnector(this.server, acceptors, selectors, connectionFactories.toArray(new ConnectionFactory[0]));
                http.setPort(this.options.getPort());
                http.setHost(this.options.getHost());
                this.server.addConnector((Connector)http);
            }
            if (this.options.isSSLEnabled()) {
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setSslContext(this.options.getSSLContext(application.getEnvironment().getClassLoader()));
                List protocol = this.options.getSsl().getProtocol();
                sslContextFactory.setIncludeProtocols(protocol.toArray(new String[0]));
                this.isNotInUse(protocol, "TLSv1", xva$0 -> sslContextFactory.addExcludeProtocols(new String[]{xva$0}));
                this.isNotInUse(protocol, "TLSv1.1", xva$0 -> sslContextFactory.addExcludeProtocols(new String[]{xva$0}));
                SslOptions.ClientAuth clientAuth = Optional.ofNullable(this.options.getSsl()).map(SslOptions::getClientAuth).orElse(SslOptions.ClientAuth.NONE);
                if (clientAuth == SslOptions.ClientAuth.REQUESTED) {
                    sslContextFactory.setWantClientAuth(true);
                } else if (clientAuth == SslOptions.ClientAuth.REQUIRED) {
                    sslContextFactory.setNeedClientAuth(true);
                }
                HttpConfiguration httpsConf = new HttpConfiguration(httpConf);
                httpsConf.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ArrayList<Object> secureConnectionFactories = new ArrayList<Object>();
                if (http2 == null) {
                    secureConnectionFactories.add(new SslConnectionFactory(sslContextFactory, "http/1.1"));
                } else {
                    secureConnectionFactories.add(new SslConnectionFactory(sslContextFactory, "alpn"));
                    secureConnectionFactories.addAll(http2.configure(httpsConf));
                }
                secureConnectionFactories.add(new HttpConnectionFactory(httpsConf));
                ServerConnector secureConnector = new ServerConnector(this.server, acceptors, selectors, secureConnectionFactories.toArray(new ConnectionFactory[0]));
                secureConnector.setPort(this.options.getSecurePort().intValue());
                secureConnector.setHost(this.options.getHost());
                this.server.addConnector((Connector)secureConnector);
            } else if (this.options.isHttpsOnly()) {
                throw new IllegalArgumentException("Server configured for httpsOnly, but ssl options not set");
            }
            ContextHandler context = new ContextHandler();
            boolean webSockets = application.getRoutes().stream().anyMatch(it -> it.getMethod().equals("WS"));
            boolean gzip = this.options.getCompressionLevel() != null;
            boolean bl = compress = gzip || webSockets;
            if (compress) {
                int compressionLevel = Optional.ofNullable(this.options.getCompressionLevel()).orElse(6);
                DeflaterPool deflater = this.newDeflater(compressionLevel);
                this.server.addBean((Object)deflater, true);
            }
            Invocable.InvocationType invocationType = application.getExecutionMode() == ExecutionMode.EVENT_LOOP ? Invocable.InvocationType.NON_BLOCKING : Invocable.InvocationType.BLOCKING;
            Object handler = new JettyHandler(invocationType, (Router)this.applications.get(0), this.options.getBufferSize(), this.options.getMaxRequestSize(), this.options.getDefaultHeaders());
            if (this.options.isExpectContinue() == Boolean.TRUE) {
                handler = new JettyHttpExpectAndContinueHandler((Handler)handler);
            }
            context.setHandler((Handler)handler);
            if (gzip) {
                GzipHandler gzipHandler = new GzipHandler();
                context.insertHandler((Handler.Singleton)gzipHandler);
            }
            if (webSockets) {
                Config conf = application.getConfig();
                int maxSize = conf.hasPath("websocket.maxSize") ? conf.getBytes("websocket.maxSize").intValue() : 131072;
                context.setAttribute(DecoratedObjectFactory.ATTR, (Object)new DecoratedObjectFactory());
                long timeout = conf.hasPath("websocket.idleTimeout") ? conf.getDuration("websocket.idleTimeout", TimeUnit.MILLISECONDS) : TimeUnit.MINUTES.toMillis(5L);
                WebSocketUpgradeHandler.from((org.eclipse.jetty.server.Server)this.server, (ContextHandler)context, container -> {
                    container.setMaxTextMessageSize((long)maxSize);
                    container.setIdleTimeout(Duration.ofMillis(timeout));
                });
            }
            this.server.setHandler((Handler)context);
            this.server.start();
            this.fireReady(this.applications);
        }
        catch (Exception x2) {
            BindException x2;
            if (Server.isAddressInUse((Throwable)x2.getCause())) {
                x2 = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)x2);
        }
        return this;
    }

    @NonNull
    public List<String> getLoggerOff() {
        return List.of("org.eclipse.jetty.server.Server", "org.eclipse.jetty.server.handler.ContextHandler", "org.eclipse.jetty.server.AbstractConnector", "org.eclipse.jetty.server.Server");
    }

    private DeflaterPool newDeflater(int compressionLevel) {
        ThreadPool.SizedThreadPool threads = (ThreadPool.SizedThreadPool)this.server.getBean(ThreadPool.SizedThreadPool.class);
        int capacity = threads == null ? 1024 : threads.getMaxThreads();
        return new DeflaterPool(capacity, compressionLevel, true);
    }

    private void isNotInUse(List<String> protocols, String protocol, Consumer<String> consumer) {
        if (!protocols.contains(protocol)) {
            consumer.accept(protocol);
        }
    }

    @NonNull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        this.applications.clear();
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception x) {
                throw SneakyThrows.propagate((Throwable)x);
            }
            finally {
                this.server = null;
            }
        }
        return this;
    }
}

