/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.mutiny;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ReactiveSupport;
import io.jooby.Reified;
import io.jooby.ResultHandler;
import io.jooby.Route;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.io.Serializable;
import java.lang.reflect.Type;
import org.slf4j.Logger;

public class Mutiny
implements ResultHandler {
    private static final Route.Filter MUTINY = new Route.Filter(){

        private void after(Context ctx, Object value, Throwable failure) {
            Route.After after = ctx.getRoute().getAfter();
            if (after != null) {
                try {
                    after.apply(ctx, value, failure);
                }
                catch (Exception unexpected) {
                    Logger log = ctx.getRouter().getLog();
                    log.debug("After invocation resulted in exception", (Throwable)unexpected);
                }
            }
        }

        @NonNull
        public Route.Handler apply(@NonNull Route.Handler next) {
            return (Route.Handler & Serializable)ctx -> {
                Object result = next.apply(ctx);
                if (ctx.isResponseStarted()) {
                    return ctx;
                }
                if (result instanceof Uni) {
                    Uni uni = (Uni)result;
                    uni.subscribe().with(value -> {
                        this.after(ctx, value, null);
                        ctx.render(value);
                    }, failure -> {
                        this.after(ctx, null, (Throwable)failure);
                        ctx.sendError((Throwable)failure);
                    });
                    return ctx;
                }
                if (result instanceof Multi) {
                    Multi multi = (Multi)result;
                    multi.subscribe(ReactiveSupport.newSubscriber((Context)ctx));
                    return ctx;
                }
                return result;
            };
        }

        public void setRoute(Route route) {
            route.setNonBlocking(true);
        }
    };

    public static Route.Filter mutiny() {
        return MUTINY;
    }

    public boolean matches(@NonNull Type type) {
        Class raw = Reified.get((Type)type).getRawType();
        return Uni.class.isAssignableFrom(raw) || Multi.class.isAssignableFrom(raw);
    }

    @NonNull
    public Route.Filter create() {
        return MUTINY;
    }

    public boolean isReactive() {
        return true;
    }
}

