/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.pebble;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ModelAndView;
import io.jooby.TemplateEngine;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

class PebbleTemplateEngine
implements TemplateEngine {
    private final List<String> extensions;
    private final PebbleEngine engine;

    PebbleTemplateEngine(PebbleEngine.Builder builder, List<String> extensions) {
        this.engine = builder.build();
        this.extensions = Collections.unmodifiableList(extensions);
    }

    @NonNull
    public List<String> extensions() {
        return this.extensions;
    }

    public String render(Context ctx, ModelAndView modelAndView) throws Exception {
        PebbleTemplate template = this.engine.getTemplate(modelAndView.getView());
        StringWriter writer = new StringWriter();
        HashMap model = new HashMap(ctx.getAttributes());
        model.putAll(modelAndView.getModel());
        Locale locale = modelAndView.getLocale();
        if (locale == null) {
            locale = ctx.locale();
        }
        template.evaluate((Writer)writer, model, locale);
        return ((Object)writer).toString();
    }
}

