/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.pebble;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MessageEncoder;
import io.jooby.ServiceRegistry;
import io.jooby.pebble.PebbleTemplateEngine;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.attributes.methodaccess.BlacklistMethodAccessValidator;
import io.pebbletemplates.pebble.attributes.methodaccess.MethodAccessValidator;
import io.pebbletemplates.pebble.attributes.methodaccess.NoOpMethodAccessValidator;
import io.pebbletemplates.pebble.cache.CacheKey;
import io.pebbletemplates.pebble.cache.PebbleCache;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.pebble.loader.DelegatingLoader;
import io.pebbletemplates.pebble.loader.FileLoader;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;

public class PebbleModule
implements Extension {
    private static final List<String> EXT = Arrays.asList(".peb", ".pebble", ".html");
    private PebbleEngine.Builder builder;
    private String templatesPath;

    private static String stripLeadingSlash(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("/")) {
            return value.substring(1);
        }
        return value;
    }

    public PebbleModule(@NonNull PebbleEngine.Builder builder) {
        this.builder = builder;
    }

    public PebbleModule(@NonNull String templatesPath) {
        this.templatesPath = templatesPath;
    }

    public PebbleModule() {
        this("views");
    }

    public void install(@NonNull Jooby application) throws Exception {
        if (this.builder == null) {
            this.builder = PebbleModule.create().setTemplatesPath(this.templatesPath).build(application.getEnvironment());
        }
        application.encoder((MessageEncoder)new PebbleTemplateEngine(this.builder, EXT));
        ServiceRegistry services = application.getServices();
        services.put(PebbleEngine.Builder.class, (Object)this.builder);
    }

    @NonNull
    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private Loader<?> loader;
        private ExecutorService executorService;
        private Locale defaultLocale;
        private PebbleCache<CacheKey, Object> tagCache;
        private PebbleCache<Object, PebbleTemplate> templateCache;
        private String templatesPath = "views";

        @NonNull
        public Builder setTemplateCache(@NonNull PebbleCache<Object, PebbleTemplate> cache) {
            this.templateCache = cache;
            return this;
        }

        @NonNull
        public Builder setTagCache(@NonNull PebbleCache<CacheKey, Object> tagCache) {
            this.tagCache = tagCache;
            return this;
        }

        @NonNull
        public Builder setTemplatesPath(@NonNull String templatesPath) {
            this.templatesPath = templatesPath;
            return this;
        }

        @NonNull
        public Builder setExecutorService(@NonNull ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @NonNull
        public Builder setDefaultLocale(@NonNull Locale defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        @NonNull
        public Builder setTemplateLoader(@NonNull Loader<?> loader) {
            this.loader = loader;
            return this;
        }

        @NonNull
        public PebbleEngine.Builder build(@NonNull Environment env) {
            Config conf;
            PebbleEngine.Builder builder = new PebbleEngine.Builder();
            if (env.isActive("dev", new String[]{"test"})) {
                builder.cacheActive(false);
            }
            if ((conf = env.getConfig()).hasPath("pebble.cacheActive")) {
                builder.cacheActive(conf.getBoolean("pebble.cacheActive"));
            }
            if (conf.hasPath("pebble.strictVariables")) {
                builder.strictVariables(conf.getBoolean("pebble.strictVariables"));
            }
            if (conf.hasPath("pebble.allowUnsafeMethods")) {
                if (conf.getBoolean("pebble.allowUnsafeMethods")) {
                    builder.methodAccessValidator((MethodAccessValidator)new NoOpMethodAccessValidator());
                } else {
                    builder.methodAccessValidator((MethodAccessValidator)new BlacklistMethodAccessValidator());
                }
            }
            if (conf.hasPath("pebble.literalDecimalTreatedAsInteger")) {
                builder.literalDecimalTreatedAsInteger(conf.getBoolean("pebble.literalDecimalTreatedAsInteger"));
            }
            if (conf.hasPath("pebble.greedyMatchMethod")) {
                builder.greedyMatchMethod(conf.getBoolean("pebble.greedyMatchMethod"));
            }
            if (this.tagCache != null) {
                builder.tagCache(this.tagCache);
            }
            if (this.templateCache != null) {
                builder.templateCache(this.templateCache);
            }
            if (this.loader != null) {
                builder.loader(this.loader);
            } else {
                String extension = null;
                if (conf.hasPath("pebble.extension")) {
                    extension = conf.getString("pebble.extension");
                }
                builder.loader((Loader)this.getDefaultLoader(this.templatesPath, extension));
            }
            if (this.executorService != null) {
                builder.executorService(this.executorService);
            }
            if (this.defaultLocale != null) {
                builder.defaultLocale(this.defaultLocale);
            }
            return builder;
        }

        DelegatingLoader getDefaultLoader(String templatesPath, String extension) {
            ArrayList<Object> loaders = new ArrayList<Object>();
            ClasspathLoader cLoader = new ClasspathLoader();
            if (templatesPath == null) {
                templatesPath = "views";
            }
            cLoader.setPrefix(PebbleModule.stripLeadingSlash(templatesPath));
            cLoader.setSuffix(extension);
            loaders.add(cLoader);
            FileLoader fLoader = new FileLoader();
            Path dir = Paths.get(System.getProperty("user.dir"), templatesPath);
            if (Files.exists(dir, new LinkOption[0])) {
                fLoader.setPrefix(dir.normalize().toString());
                fLoader.setSuffix(extension);
                loaders.add(fLoader);
            }
            return new DelegatingLoader(loaders);
        }
    }
}

